/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.sql.ast;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.AstVisitor;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Expression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Node;

public class FieldReference
extends Expression {
    private final int fieldIndex;

    public FieldReference(int fieldIndex) {
        super(null);
        Preconditions.checkArgument((fieldIndex >= 0 ? 1 : 0) != 0, (Object)"fieldIndex must be >= 0");
        this.fieldIndex = fieldIndex;
    }

    public int getFieldIndex() {
        return this.fieldIndex;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitFieldReference(this, context);
    }

    public List<Node> getChildren() {
        return ImmutableList.of();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FieldReference that = (FieldReference)o;
        return this.fieldIndex == that.fieldIndex;
    }

    @Override
    public int hashCode() {
        return this.fieldIndex;
    }

    @Override
    public boolean shallowEquals(Node other) {
        if (!FieldReference.sameClass(this, other)) {
            return false;
        }
        return this.fieldIndex == ((FieldReference)other).fieldIndex;
    }
}

