/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.analyzer.predicate;

import java.util.List;
import java.util.Set;
import org.apache.iotdb.db.queryengine.plan.relational.analyzer.predicate.PredicatePushIntoScanChecker;
import org.apache.iotdb.db.queryengine.plan.relational.analyzer.predicate.PredicateVisitor;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.BetweenPredicate;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.ComparisonExpression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Expression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.IfExpression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.InListExpression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.InPredicate;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.IsNotNullPredicate;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.IsNullPredicate;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.LikePredicate;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Literal;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.LogicalExpression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.NotExpression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.NullIfExpression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.SearchedCaseExpression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.SimpleCaseExpression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.SymbolReference;

public class PredicateCombineIntoTableScanChecker
extends PredicateVisitor<Boolean, Void> {
    private final Set<String> measurementColumns;

    public static boolean check(Set<String> measurementColumns, Expression expression) {
        return (Boolean)new PredicateCombineIntoTableScanChecker(measurementColumns).process(expression);
    }

    public PredicateCombineIntoTableScanChecker(Set<String> measurementColumns) {
        this.measurementColumns = measurementColumns;
    }

    @Override
    public Boolean visitExpression(Expression expression, Void context) {
        return Boolean.FALSE;
    }

    @Override
    protected Boolean visitNotExpression(NotExpression node, Void context) {
        return Boolean.FALSE;
    }

    @Override
    protected Boolean visitIsNullPredicate(IsNullPredicate node, Void context) {
        return Boolean.FALSE;
    }

    @Override
    protected Boolean visitInPredicate(InPredicate node, Void context) {
        return this.isMeasurementColumn(node.getValue()) && PredicateCombineIntoTableScanChecker.isInListAllLiteral(node) != false;
    }

    public static Boolean isInListAllLiteral(InPredicate node) {
        if (node.getValueList() instanceof InListExpression) {
            List<Expression> values = ((InListExpression)node.getValueList()).getValues();
            for (Expression value : values) {
                if (value instanceof Literal) continue;
                return Boolean.FALSE;
            }
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    @Override
    protected Boolean visitLikePredicate(LikePredicate node, Void context) {
        return this.isMeasurementColumn(node.getValue()) && PredicatePushIntoScanChecker.isLiteral(node.getPattern()) && node.getEscape().map(PredicatePushIntoScanChecker::isLiteral).orElse(true) != false;
    }

    @Override
    protected Boolean visitLogicalExpression(LogicalExpression node, Void context) {
        List<Expression> children = node.getTerms();
        for (Expression child : children) {
            Boolean result = (Boolean)this.process(child, context);
            if (result == null) {
                throw new IllegalStateException("Should never return null in PredicateCombineIntoTableScanChecker.");
            }
            if (result.booleanValue()) continue;
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @Override
    protected Boolean visitComparisonExpression(ComparisonExpression node, Void context) {
        return this.isMeasurementColumn(node.getLeft()) && PredicatePushIntoScanChecker.isLiteral(node.getRight()) || this.isMeasurementColumn(node.getRight()) && PredicatePushIntoScanChecker.isLiteral(node.getLeft());
    }

    @Override
    protected Boolean visitBetweenPredicate(BetweenPredicate node, Void context) {
        return this.isMeasurementColumn(node.getValue()) && PredicatePushIntoScanChecker.isLiteral(node.getMin()) && PredicatePushIntoScanChecker.isLiteral(node.getMax());
    }

    @Override
    protected Boolean visitIsNotNullPredicate(IsNotNullPredicate node, Void context) {
        return this.isMeasurementColumn(node.getValue());
    }

    @Override
    protected Boolean visitSimpleCaseExpression(SimpleCaseExpression node, Void context) {
        return Boolean.FALSE;
    }

    @Override
    protected Boolean visitSearchedCaseExpression(SearchedCaseExpression node, Void context) {
        return Boolean.FALSE;
    }

    @Override
    protected Boolean visitIfExpression(IfExpression node, Void context) {
        return Boolean.FALSE;
    }

    @Override
    protected Boolean visitNullIfExpression(NullIfExpression node, Void context) {
        return Boolean.FALSE;
    }

    private boolean isMeasurementColumn(Expression expression) {
        return PredicatePushIntoScanChecker.isSymbolReference(expression) && this.measurementColumns.contains(((SymbolReference)expression).getName());
    }
}

