/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.operator.process.function;

import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.iotdb.commons.udf.utils.UDFDataTypeTransformer;
import org.apache.iotdb.db.queryengine.execution.operator.process.function.partition.PartitionState;
import org.apache.iotdb.db.queryengine.execution.operator.process.function.partition.Slice;
import org.apache.iotdb.db.queryengine.execution.operator.process.join.merge.MergeSortComparator;
import org.apache.iotdb.db.queryengine.plan.relational.planner.SortOrder;
import org.apache.iotdb.db.utils.datastructure.SortKey;
import org.apache.iotdb.udf.api.type.Type;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.read.common.block.TsBlock;

public class PartitionRecognizer {
    private SortKey partitionKey = null;
    private final Comparator<SortKey> partitionComparator;
    private final List<Integer> requiredChannels;
    private final List<Integer> passThroughChannels;
    private final List<Type> inputDataTypes;
    private TsBlock currentTsBlock = null;
    private boolean noMoreData = false;
    private int currentIndex = 0;
    private PartitionState state = PartitionState.INIT_STATE;

    public PartitionRecognizer(List<Integer> partitionChannels, List<Integer> requiredChannels, List<Integer> passThroughChannels, List<TSDataType> inputDataTypes) {
        this.partitionComparator = partitionChannels.isEmpty() ? (o1, o2) -> 0 : MergeSortComparator.getComparatorForTable(partitionChannels.stream().map(i -> SortOrder.ASC_NULLS_FIRST).collect(Collectors.toList()), partitionChannels, partitionChannels.stream().map(inputDataTypes::get).collect(Collectors.toList()));
        this.requiredChannels = requiredChannels;
        this.passThroughChannels = passThroughChannels;
        this.inputDataTypes = UDFDataTypeTransformer.transformToUDFDataTypeList(inputDataTypes);
    }

    public void addTsBlock(TsBlock tsBlock) {
        if (this.noMoreData) {
            throw new IllegalArgumentException("The partition handler is finished, cannot add more data.");
        }
        this.currentTsBlock = tsBlock;
    }

    public void noMoreData() {
        this.noMoreData = true;
    }

    public PartitionState nextState() {
        this.updateState();
        return this.state;
    }

    private void updateState() {
        switch (this.state.getStateType()) {
            case INIT: {
                this.state = this.handleInitState();
                break;
            }
            case ITERATING: 
            case NEW_PARTITION: {
                this.state = this.handleIteratingOrNewPartitionState();
                break;
            }
            case NEED_MORE_DATA: {
                this.state = this.handleNeedMoreDataState();
                break;
            }
            case FINISHED: {
                return;
            }
        }
        if (PartitionState.NEED_MORE_DATA_STATE.equals(this.state)) {
            this.currentIndex = 0;
            this.currentTsBlock = null;
        }
    }

    private PartitionState handleInitState() {
        if (this.currentTsBlock == null || this.currentTsBlock.isEmpty()) {
            return PartitionState.INIT_STATE;
        }
        this.partitionKey = new SortKey(this.currentTsBlock, this.currentIndex);
        int endPartitionIndex = this.findNextDifferentRowIndex();
        Slice slice = this.getSlice(this.currentIndex, endPartitionIndex);
        this.currentIndex = endPartitionIndex;
        return PartitionState.newPartitionState(slice);
    }

    private PartitionState handleNeedMoreDataState() {
        if (this.noMoreData) {
            return PartitionState.FINISHED_STATE;
        }
        if (this.currentTsBlock == null || this.currentTsBlock.isEmpty()) {
            return PartitionState.NEED_MORE_DATA_STATE;
        }
        int endPartitionIndex = this.findNextDifferentRowIndex();
        if (endPartitionIndex != 0) {
            Slice slice = this.getSlice(this.currentIndex, endPartitionIndex);
            this.currentIndex = endPartitionIndex;
            return PartitionState.iteratingState(slice);
        }
        endPartitionIndex = this.findNextDifferentRowIndex();
        Slice slice = this.getSlice(this.currentIndex, endPartitionIndex);
        this.currentIndex = endPartitionIndex;
        return PartitionState.newPartitionState(slice);
    }

    private PartitionState handleIteratingOrNewPartitionState() {
        if (this.currentIndex >= this.currentTsBlock.getPositionCount()) {
            return PartitionState.NEED_MORE_DATA_STATE;
        }
        int endPartitionIndex = this.findNextDifferentRowIndex();
        Slice slice = this.getSlice(this.currentIndex, endPartitionIndex);
        this.currentIndex = endPartitionIndex;
        return PartitionState.newPartitionState(slice);
    }

    private int findNextDifferentRowIndex() {
        SortKey compareKey = new SortKey(this.currentTsBlock, this.currentIndex);
        while (compareKey.rowIndex < this.currentTsBlock.getPositionCount()) {
            if (this.partitionComparator.compare(this.partitionKey, compareKey) != 0) {
                this.partitionKey = compareKey;
                return compareKey.rowIndex;
            }
            ++compareKey.rowIndex;
        }
        return compareKey.rowIndex;
    }

    private Slice getSlice(int startPartitionIndex, int endPartitionIndex) {
        return new Slice(startPartitionIndex, endPartitionIndex, this.currentTsBlock.getValueColumns(), this.requiredChannels, this.passThroughChannels, this.inputDataTypes);
    }
}

