/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.schema.filter;

import java.util.Objects;
import org.apache.iotdb.commons.schema.filter.SchemaFilter;
import org.apache.iotdb.commons.schema.filter.impl.DataTypeFilter;
import org.apache.iotdb.commons.schema.filter.impl.PathContainsFilter;
import org.apache.iotdb.commons.schema.filter.impl.TagFilter;
import org.apache.iotdb.commons.schema.filter.impl.TemplateFilter;
import org.apache.iotdb.commons.schema.filter.impl.ViewTypeFilter;
import org.apache.iotdb.commons.schema.filter.impl.multichildren.AndFilter;
import org.apache.iotdb.commons.schema.filter.impl.multichildren.OrFilter;
import org.apache.iotdb.commons.schema.filter.impl.singlechild.AttributeFilter;
import org.apache.iotdb.commons.schema.filter.impl.singlechild.IdFilter;
import org.apache.iotdb.commons.schema.filter.impl.singlechild.NotFilter;
import org.apache.iotdb.commons.schema.filter.impl.values.ComparisonFilter;
import org.apache.iotdb.commons.schema.filter.impl.values.InFilter;
import org.apache.iotdb.commons.schema.filter.impl.values.LikeFilter;
import org.apache.iotdb.commons.schema.filter.impl.values.PreciseFilter;

public abstract class SchemaFilterVisitor<C> {
    public Boolean process(SchemaFilter filter, C context) {
        if (filter == null) {
            return this.visitNode(null, context);
        }
        return filter.accept(this, context);
    }

    protected abstract Boolean visitNode(SchemaFilter var1, C var2);

    public Boolean visitFilter(SchemaFilter filter, C context) {
        return this.visitNode(filter, context);
    }

    public Boolean visitTagFilter(TagFilter tagFilter, C context) {
        return this.visitFilter(tagFilter, context);
    }

    public Boolean visitPathContainsFilter(PathContainsFilter pathContainsFilter, C context) {
        return this.visitFilter(pathContainsFilter, context);
    }

    public Boolean visitDataTypeFilter(DataTypeFilter dataTypeFilter, C context) {
        return this.visitFilter(dataTypeFilter, context);
    }

    public Boolean visitViewTypeFilter(ViewTypeFilter viewTypeFilter, C context) {
        return this.visitFilter(viewTypeFilter, context);
    }

    public Boolean visitTemplateFilter(TemplateFilter templateFilter, C context) {
        return this.visitFilter(templateFilter, context);
    }

    public Boolean visitAndFilter(AndFilter andFilter, C context) {
        Boolean result = Boolean.TRUE;
        for (SchemaFilter child : andFilter.getChildren()) {
            Boolean childResult = child.accept(this, context);
            if (Boolean.FALSE.equals(childResult)) {
                return Boolean.FALSE;
            }
            if (!Objects.isNull(childResult)) continue;
            result = null;
        }
        return result;
    }

    public final Boolean visitOrFilter(OrFilter orFilter, C context) {
        Boolean result = Boolean.FALSE;
        for (SchemaFilter child : orFilter.getChildren()) {
            Boolean childResult = child.accept(this, context);
            if (Boolean.TRUE.equals(childResult)) {
                return Boolean.TRUE;
            }
            if (!Objects.isNull(childResult)) continue;
            result = null;
        }
        return result;
    }

    public final Boolean visitNotFilter(NotFilter notFilter, C context) {
        Boolean result = notFilter.getChild().accept(this, context);
        if (Boolean.TRUE.equals(result)) {
            return Boolean.FALSE;
        }
        if (Boolean.FALSE.equals(result)) {
            return Boolean.TRUE;
        }
        return result;
    }

    public Boolean visitIdFilter(IdFilter filter, C context) {
        return this.visitFilter(filter, context);
    }

    public Boolean visitAttributeFilter(AttributeFilter filter, C context) {
        return this.visitFilter(filter, context);
    }

    public Boolean visitPreciseFilter(PreciseFilter filter, C context) {
        return this.visitFilter(filter, context);
    }

    public Boolean visitComparisonFilter(ComparisonFilter filter, C context) {
        return this.visitFilter(filter, context);
    }

    public Boolean visitInFilter(InFilter filter, C context) {
        return this.visitFilter(filter, context);
    }

    public Boolean visitLikeFilter(LikeFilter filter, C context) {
        return this.visitFilter(filter, context);
    }
}

