/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.subscription.event.batch;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.iotdb.commons.pipe.event.EnrichedEvent;
import org.apache.iotdb.db.pipe.connector.payload.evolvable.batch.PipeTabletEventTsFileBatch;
import org.apache.iotdb.db.subscription.broker.SubscriptionPrefetchingTsFileQueue;
import org.apache.iotdb.db.subscription.event.SubscriptionEvent;
import org.apache.iotdb.db.subscription.event.batch.SubscriptionPipeEventBatch;
import org.apache.iotdb.db.subscription.event.pipe.SubscriptionPipeTsFileBatchEvents;
import org.apache.iotdb.pipe.api.event.dml.insertion.TabletInsertionEvent;
import org.apache.iotdb.pipe.api.event.dml.insertion.TsFileInsertionEvent;
import org.apache.iotdb.rpc.subscription.payload.poll.SubscriptionCommitContext;
import org.apache.tsfile.utils.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubscriptionPipeTsFileEventBatch
extends SubscriptionPipeEventBatch {
    private static final Logger LOGGER = LoggerFactory.getLogger(SubscriptionPipeTsFileEventBatch.class);
    private final PipeTabletEventTsFileBatch batch;

    public SubscriptionPipeTsFileEventBatch(int regionId, SubscriptionPrefetchingTsFileQueue prefetchingQueue, int maxDelayInMs, long maxBatchSizeInBytes) {
        super(regionId, prefetchingQueue, maxDelayInMs, maxBatchSizeInBytes);
        this.batch = new PipeTabletEventTsFileBatch(maxDelayInMs, maxBatchSizeInBytes);
    }

    @Override
    public synchronized void ack() {
        this.batch.decreaseEventsReferenceCount(this.getClass().getName(), true);
    }

    @Override
    public synchronized void cleanUp() {
        this.batch.close();
        this.enrichedEvents.clear();
    }

    @Override
    protected void onTabletInsertionEvent(TabletInsertionEvent event) {
        try {
            this.batch.onEvent(event);
        }
        catch (Exception exception) {
            // empty catch block
        }
        ((EnrichedEvent)event).decreaseReferenceCount(SubscriptionPipeTsFileEventBatch.class.getName(), false);
    }

    @Override
    protected void onTsFileInsertionEvent(TsFileInsertionEvent event) {
        LOGGER.warn("SubscriptionPipeTsFileEventBatch {} ignore TsFileInsertionEvent {} when batching.", (Object)this, (Object)event);
    }

    @Override
    protected List<SubscriptionEvent> generateSubscriptionEvents() throws Exception {
        if (this.batch.isEmpty()) {
            return null;
        }
        ArrayList<SubscriptionEvent> events = new ArrayList<SubscriptionEvent>();
        List<Pair<String, File>> dbTsFilePairs = this.batch.sealTsFiles();
        AtomicInteger referenceCount = new AtomicInteger(dbTsFilePairs.size());
        for (Pair<String, File> tsFile : dbTsFilePairs) {
            SubscriptionCommitContext commitContext = this.prefetchingQueue.generateSubscriptionCommitContext();
            events.add(new SubscriptionEvent(new SubscriptionPipeTsFileBatchEvents(this, referenceCount), (File)tsFile.right, commitContext));
        }
        return events;
    }

    @Override
    protected boolean shouldEmit() {
        return this.batch.shouldEmit();
    }

    public String toString() {
        return "SubscriptionPipeTsFileEventBatch" + this.coreReportMessage();
    }

    @Override
    protected Map<String, String> coreReportMessage() {
        Map<String, String> coreReportMessage = super.coreReportMessage();
        coreReportMessage.put("batch", this.batch.toString());
        return coreReportMessage;
    }
}

