/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.subscription.broker;

import com.codahale.metrics.Clock;
import com.codahale.metrics.Meter;
import com.codahale.metrics.MovingAverages;
import org.apache.iotdb.db.pipe.resource.PipeDataNodeResourceManager;
import org.apache.iotdb.db.subscription.agent.SubscriptionAgent;
import org.apache.iotdb.db.subscription.broker.SubscriptionPrefetchingQueue;
import org.apache.iotdb.metrics.core.utils.IoTDBMovingAverage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubscriptionPrefetchingQueueStates {
    private static final Logger LOGGER = LoggerFactory.getLogger(SubscriptionPrefetchingQueueStates.class);
    private static final double EPSILON = 1.0E-6;
    private static final double PREFETCH_MEMORY_THRESHOLD = 0.6;
    private static final double MISSING_RATE_THRESHOLD = 0.9;
    private static final int PREFETCHED_EVENT_COUNT_CONTROL_PARAMETER = 100;
    private final SubscriptionPrefetchingQueue prefetchingQueue;
    private volatile long lastPollRequestTimestamp;
    private final Meter pollRequestMeter;
    private final Meter missingPrefechMeter;

    public SubscriptionPrefetchingQueueStates(SubscriptionPrefetchingQueue prefetchingQueue) {
        this.prefetchingQueue = prefetchingQueue;
        this.lastPollRequestTimestamp = -1L;
        this.pollRequestMeter = new Meter((MovingAverages)new IoTDBMovingAverage(), Clock.defaultClock());
        this.missingPrefechMeter = new Meter((MovingAverages)new IoTDBMovingAverage(), Clock.defaultClock());
    }

    public void markPollRequest() {
        this.lastPollRequestTimestamp = System.currentTimeMillis();
        this.pollRequestMeter.mark();
    }

    public void markMissingPrefetch() {
        this.missingPrefechMeter.mark();
    }

    public boolean shouldPrefetch() {
        if (!this.isMemoryEnough()) {
            return false;
        }
        if (this.missingRate() > 0.9) {
            return true;
        }
        if (this.hasTooManyPrefetchedEvents()) {
            return false;
        }
        return (double)(System.currentTimeMillis() - this.lastPollRequestTimestamp) * this.pollRate() > 1000.0;
    }

    private boolean isMemoryEnough() {
        return (double)PipeDataNodeResourceManager.memory().getTotalMemorySizeInBytes() * 0.6 > (double)PipeDataNodeResourceManager.memory().getUsedMemorySizeInBytes();
    }

    private double pollRate() {
        return this.pollRequestMeter.getOneMinuteRate();
    }

    private double missingRate() {
        if (SubscriptionPrefetchingQueueStates.isApproximatelyZero(this.pollRate())) {
            return 0.0;
        }
        return this.missingPrefechMeter.getOneMinuteRate() / this.pollRate();
    }

    private boolean hasTooManyPrefetchedEvents() {
        return this.prefetchingQueue.getPrefetchedEventCount() * SubscriptionAgent.broker().getPrefetchingQueueCount() > 100;
    }

    private static boolean isApproximatelyZero(double value) {
        return Math.abs(value) < 1.0E-6;
    }

    public String toString() {
        return "PollPrefetchStates{lastPollRequestTimestamp=" + this.lastPollRequestTimestamp + ", pollRate=" + this.pollRate() + ", missingRate=" + this.missingRate() + "}";
    }
}

