/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.writer;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.executor.fast.element.AlignedPageElement;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.executor.fast.element.ChunkMetadataElement;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.writer.AbstractCrossCompactionWriter;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.writer.flushcontroller.AbstractCompactionFlushController;
import org.apache.iotdb.db.storageengine.dataregion.compaction.io.CompactionTsFileWriter;
import org.apache.iotdb.db.storageengine.dataregion.read.control.FileReaderManager;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResource;
import org.apache.tsfile.block.column.Column;
import org.apache.tsfile.file.header.PageHeader;
import org.apache.tsfile.file.metadata.ChunkMetadata;
import org.apache.tsfile.read.TsFileSequenceReader;
import org.apache.tsfile.read.common.Chunk;
import org.apache.tsfile.read.common.block.TsBlock;
import org.apache.tsfile.read.common.block.column.TimeColumn;
import org.apache.tsfile.write.chunk.AlignedChunkWriterImpl;
import org.apache.tsfile.write.chunk.IChunkWriter;

public class ReadPointCrossCompactionWriter
extends AbstractCrossCompactionWriter {
    public ReadPointCrossCompactionWriter(List<TsFileResource> targetResources, List<TsFileResource> seqFileResources) throws IOException {
        super(targetResources, seqFileResources);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(TsBlock tsBlock, int subTaskId) throws IOException {
        TimeColumn timestamps = (TimeColumn)tsBlock.getTimeColumn();
        Column[] columns = tsBlock.getValueColumns();
        int batchSize = tsBlock.getPositionCount();
        this.checkTimeAndMayFlushChunkToCurrentFile(timestamps.getStartTime(), subTaskId);
        AlignedChunkWriterImpl chunkWriter = (AlignedChunkWriterImpl)this.chunkWriters[subTaskId];
        chunkWriter.write(timestamps, columns, batchSize);
        ReadPointCrossCompactionWriter readPointCrossCompactionWriter = this;
        synchronized (readPointCrossCompactionWriter) {
            TsFileResource resource = (TsFileResource)this.targetResources.get(this.seqFileIndexArray[subTaskId]);
            resource.updateStartTime(this.deviceId, timestamps.getStartTime());
            resource.updateEndTime(this.deviceId, timestamps.getEndTime());
        }
        int n = subTaskId;
        this.chunkPointNumArray[n] = this.chunkPointNumArray[n] + timestamps.getTimes().length;
        this.checkChunkSizeAndMayOpenANewChunk((CompactionTsFileWriter)((Object)this.targetFileWriters.get(this.seqFileIndexArray[subTaskId])), (IChunkWriter)chunkWriter, subTaskId);
        this.isDeviceExistedInTargetFiles[this.seqFileIndexArray[subTaskId]] = true;
        this.isEmptyFile[this.seqFileIndexArray[subTaskId]] = false;
        this.lastTime[subTaskId] = timestamps.getEndTime();
    }

    @Override
    protected TsFileSequenceReader getFileReader(TsFileResource resource) throws IOException {
        return FileReaderManager.getInstance().get(resource.getTsFilePath(), true);
    }

    @Override
    public boolean flushNonAlignedChunk(Chunk chunk, ChunkMetadata chunkMetadata, int subTaskId) {
        throw new UnsupportedOperationException("Does not support this method in ReadPointCrossCompactionWriter");
    }

    @Override
    public boolean flushAlignedChunk(ChunkMetadataElement chunkMetadataElement, int subTaskId) {
        throw new UnsupportedOperationException("Does not support this method in ReadPointCrossCompactionWriter");
    }

    @Override
    public boolean flushBatchedValueChunk(ChunkMetadataElement chunkMetadataElement, int subTaskId, AbstractCompactionFlushController flushController) {
        throw new UnsupportedOperationException("Does not support this method in ReadPointCrossCompactionWriter");
    }

    @Override
    public boolean flushNonAlignedPage(ByteBuffer compressedPageData, PageHeader pageHeader, int subTaskId) {
        throw new UnsupportedOperationException("Does not support this method in ReadPointCrossCompactionWriter");
    }

    @Override
    public boolean flushAlignedPage(AlignedPageElement alignedPageElement, int subTaskId) {
        throw new UnsupportedOperationException("Does not support this method in ReadPointCrossCompactionWriter");
    }

    @Override
    public boolean flushBatchedValuePage(AlignedPageElement alignedPageElement, int subTaskId, AbstractCompactionFlushController flushController) {
        throw new UnsupportedOperationException("Does not support this method in ReadPointCrossCompactionWriter");
    }
}

