/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.executor.fast;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.path.PatternTreeMap;
import org.apache.iotdb.db.exception.WriteProcessException;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.task.subtask.FastCompactionTaskSummary;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.CompactionPathUtils;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.executor.ModifiedStatus;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.executor.fast.SeriesCompactionExecutor;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.executor.fast.element.ChunkMetadataElement;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.executor.fast.element.FileElement;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.executor.fast.element.NonAlignedPageElement;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.executor.fast.element.PageElement;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.executor.fast.reader.CompactionChunkReader;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.writer.AbstractCompactionWriter;
import org.apache.iotdb.db.storageengine.dataregion.modification.ModEntry;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResource;
import org.apache.iotdb.db.utils.ModificationUtils;
import org.apache.iotdb.db.utils.datastructure.PatternTreeMapFactory;
import org.apache.tsfile.exception.write.PageException;
import org.apache.tsfile.file.header.ChunkHeader;
import org.apache.tsfile.file.header.PageHeader;
import org.apache.tsfile.file.metadata.ChunkMetadata;
import org.apache.tsfile.file.metadata.IChunkMetadata;
import org.apache.tsfile.file.metadata.IDeviceID;
import org.apache.tsfile.file.metadata.enums.CompressionType;
import org.apache.tsfile.file.metadata.enums.TSEncoding;
import org.apache.tsfile.read.TsFileSequenceReader;
import org.apache.tsfile.read.common.Chunk;
import org.apache.tsfile.utils.Pair;
import org.apache.tsfile.write.chunk.ChunkWriterImpl;
import org.apache.tsfile.write.chunk.IChunkWriter;
import org.apache.tsfile.write.schema.IMeasurementSchema;
import org.apache.tsfile.write.schema.MeasurementSchema;

public class FastNonAlignedSeriesCompactionExecutor
extends SeriesCompactionExecutor {
    private boolean hasStartMeasurement = false;
    private CompressionType seriesCompressionType = null;
    private TSEncoding seriesTSEncoding = null;
    private Map<TsFileResource, Pair<Long, Long>> timeseriesMetadataOffsetMap;
    private final List<TsFileResource> sortResources;

    public FastNonAlignedSeriesCompactionExecutor(AbstractCompactionWriter compactionWriter, Map<TsFileResource, TsFileSequenceReader> readerCacheMap, Map<String, PatternTreeMap<ModEntry, PatternTreeMapFactory.ModsSerializer>> modificationCacheMap, List<TsFileResource> sortedSourceFiles, IDeviceID deviceId, int subTaskId, FastCompactionTaskSummary summary) {
        super(compactionWriter, readerCacheMap, modificationCacheMap, deviceId, false, subTaskId, summary);
        this.sortResources = sortedSourceFiles;
    }

    @Override
    public void execute() throws PageException, IllegalPathException, IOException, WriteProcessException {
        this.compactFiles();
        if (this.hasStartMeasurement) {
            this.compactionWriter.endMeasurement(this.subTaskId);
        }
    }

    public void setNewMeasurement(Map<TsFileResource, Pair<Long, Long>> timeseriesMetadataOffsetMap) {
        this.timeseriesMetadataOffsetMap = timeseriesMetadataOffsetMap;
        this.sortResources.forEach(x -> this.fileList.add(new FileElement((TsFileResource)x)));
        this.hasStartMeasurement = false;
    }

    @Override
    protected void compactFiles() throws PageException, IOException, WriteProcessException, IllegalPathException {
        while (!this.fileList.isEmpty()) {
            List<FileElement> overlappedFiles = this.findOverlapFiles((FileElement)this.fileList.get(0));
            this.deserializeFileIntoChunkMetadataQueue(overlappedFiles);
            this.compactChunks();
        }
    }

    @Override
    void deserializeFileIntoChunkMetadataQueue(List<FileElement> fileElements) throws IOException, IllegalPathException {
        for (FileElement fileElement : fileElements) {
            TsFileResource resource = fileElement.resource;
            Pair<Long, Long> timeseriesMetadataOffset = this.timeseriesMetadataOffsetMap.get(resource);
            if (timeseriesMetadataOffset == null) {
                this.removeFile(fileElement);
                continue;
            }
            List iChunkMetadataList = ((TsFileSequenceReader)this.readerCacheMap.get(resource)).getChunkMetadataListByTimeseriesMetadataOffset(((Long)timeseriesMetadataOffset.left).longValue(), ((Long)timeseriesMetadataOffset.right).longValue());
            if (!iChunkMetadataList.isEmpty()) {
                ModificationUtils.modifyChunkMetaData(iChunkMetadataList, this.getModificationsFromCache(resource, CompactionPathUtils.getPath(this.deviceId, ((IChunkMetadata)iChunkMetadataList.get(0)).getMeasurementUid())));
                if (iChunkMetadataList.isEmpty()) {
                    this.removeFile(fileElement);
                }
            }
            for (int i = 0; i < iChunkMetadataList.size(); ++i) {
                IChunkMetadata chunkMetadata = (IChunkMetadata)iChunkMetadataList.get(i);
                this.chunkMetadataQueue.add(new ChunkMetadataElement(chunkMetadata, i == iChunkMetadataList.size() - 1, fileElement));
            }
        }
    }

    @Override
    protected void deserializeChunkIntoPageQueue(ChunkMetadataElement chunkMetadataElement) throws IOException {
        this.updateSummary(chunkMetadataElement, SeriesCompactionExecutor.ChunkStatus.DESERIALIZE_CHUNK);
        Chunk chunk = chunkMetadataElement.chunk;
        CompactionChunkReader chunkReader = new CompactionChunkReader(chunk);
        List<Pair<PageHeader, ByteBuffer>> pages = chunkReader.readPageDataWithoutUncompressing();
        for (int i = 0; i < pages.size(); ++i) {
            boolean isLastPage = i == pages.size() - 1;
            this.pageQueue.add(new NonAlignedPageElement((PageHeader)pages.get((int)i).left, (ByteBuffer)pages.get((int)i).right, chunkReader, chunkMetadataElement, isLastPage));
        }
        chunkMetadataElement.clearChunks();
    }

    @Override
    void readChunk(ChunkMetadataElement chunkMetadataElement) throws IOException {
        this.updateSummary(chunkMetadataElement, SeriesCompactionExecutor.ChunkStatus.READ_IN);
        chunkMetadataElement.chunk = ((TsFileSequenceReader)this.readerCacheMap.get(chunkMetadataElement.fileElement.resource)).readMemChunk((ChunkMetadata)chunkMetadataElement.chunkMetadata);
        if (!this.hasStartMeasurement) {
            ChunkHeader header = chunkMetadataElement.chunk.getHeader();
            MeasurementSchema schema = new MeasurementSchema(header.getMeasurementID(), header.getDataType(), header.getEncodingType(), header.getCompressionType());
            this.compactionWriter.startMeasurement(schema.getMeasurementName(), (IChunkWriter)new ChunkWriterImpl((IMeasurementSchema)schema, true), this.subTaskId);
            this.hasStartMeasurement = true;
            this.seriesCompressionType = header.getCompressionType();
            this.seriesTSEncoding = header.getEncodingType();
            chunkMetadataElement.needForceDecodingPage = false;
        } else {
            ChunkHeader header = chunkMetadataElement.chunk.getHeader();
            chunkMetadataElement.needForceDecodingPage = header.getCompressionType() != this.seriesCompressionType || header.getEncodingType() != this.seriesTSEncoding;
        }
    }

    @Override
    protected boolean flushChunkToCompactionWriter(ChunkMetadataElement chunkMetadataElement) throws IOException {
        return this.compactionWriter.flushNonAlignedChunk(chunkMetadataElement.chunk, (ChunkMetadata)chunkMetadataElement.chunkMetadata, this.subTaskId);
    }

    @Override
    protected boolean flushPageToCompactionWriter(PageElement pageElement) throws PageException, IOException {
        NonAlignedPageElement nonAlignedPageElement = (NonAlignedPageElement)pageElement;
        return this.compactionWriter.flushNonAlignedPage(nonAlignedPageElement.getPageData(), nonAlignedPageElement.getPageHeader(), this.subTaskId);
    }

    @Override
    protected ModifiedStatus isPageModified(PageElement pageElement) {
        long startTime = pageElement.getStartTime();
        long endTime = pageElement.getEndTime();
        return this.checkIsModified(startTime, endTime, pageElement.getChunkMetadataElement().chunkMetadata.getDeleteIntervalList());
    }
}

