/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.executor.batch;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.path.PatternTreeMap;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.exception.WriteProcessException;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.task.subtask.FastCompactionTaskSummary;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.executor.ModifiedStatus;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.executor.batch.utils.AlignedSeriesBatchCompactionUtils;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.executor.batch.utils.BatchCompactionPlan;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.executor.batch.utils.CompactChunkPlan;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.executor.batch.utils.FirstBatchCompactionAlignedChunkWriter;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.executor.batch.utils.FollowingBatchCompactionAlignedChunkWriter;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.executor.fast.FastAlignedSeriesCompactionExecutor;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.executor.fast.element.AlignedPageElement;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.executor.fast.element.ChunkMetadataElement;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.executor.fast.element.PageElement;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.writer.AbstractCompactionWriter;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.writer.flushcontroller.FollowedBatchedCompactionFlushController;
import org.apache.iotdb.db.storageengine.dataregion.modification.ModEntry;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResource;
import org.apache.iotdb.db.utils.datastructure.PatternTreeMapFactory;
import org.apache.tsfile.exception.write.PageException;
import org.apache.tsfile.file.metadata.AlignedChunkMetadata;
import org.apache.tsfile.file.metadata.ChunkMetadata;
import org.apache.tsfile.file.metadata.IChunkMetadata;
import org.apache.tsfile.file.metadata.IDeviceID;
import org.apache.tsfile.read.TsFileSequenceReader;
import org.apache.tsfile.read.common.Chunk;
import org.apache.tsfile.read.common.TimeRange;
import org.apache.tsfile.utils.Pair;
import org.apache.tsfile.write.chunk.IChunkWriter;
import org.apache.tsfile.write.schema.IMeasurementSchema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BatchedFastAlignedSeriesCompactionExecutor
extends FastAlignedSeriesCompactionExecutor {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"COMPACTION");
    private AlignedSeriesBatchCompactionUtils.BatchColumnSelection batchColumnSelection;
    private final IMeasurementSchema timeSchema;
    private final List<IMeasurementSchema> valueMeasurementSchemas;
    private final List<TsFileResource> sortedSourceFiles;
    private final Map<TsFileResource, List<AlignedChunkMetadata>> alignedChunkMetadataCache;
    private final BatchCompactionPlan batchCompactionPlan;
    private final int batchSize = IoTDBDescriptor.getInstance().getConfig().getCompactionMaxAlignedSeriesNumInOneBatch();

    public BatchedFastAlignedSeriesCompactionExecutor(AbstractCompactionWriter compactionWriter, Map<String, Map<TsFileResource, Pair<Long, Long>>> timeseriesMetadataOffsetMap, Map<TsFileResource, TsFileSequenceReader> readerCacheMap, Map<String, PatternTreeMap<ModEntry, PatternTreeMapFactory.ModsSerializer>> modificationCacheMap, List<TsFileResource> sortedSourceFiles, IDeviceID deviceId, int subTaskId, List<IMeasurementSchema> measurementSchemas, FastCompactionTaskSummary summary, boolean ignoreAllNullRows) {
        super(compactionWriter, timeseriesMetadataOffsetMap, readerCacheMap, modificationCacheMap, sortedSourceFiles, deviceId, subTaskId, measurementSchemas, summary, ignoreAllNullRows);
        this.timeSchema = measurementSchemas.remove(0);
        this.valueMeasurementSchemas = measurementSchemas;
        this.batchColumnSelection = new AlignedSeriesBatchCompactionUtils.BatchColumnSelection(this.valueMeasurementSchemas, this.batchSize);
        this.sortedSourceFiles = sortedSourceFiles;
        this.alignedChunkMetadataCache = new HashMap<TsFileResource, List<AlignedChunkMetadata>>();
        this.batchCompactionPlan = new BatchCompactionPlan();
    }

    private List<AlignedChunkMetadata> getAlignedChunkMetadataListBySelectedValueColumn(TsFileResource tsFileResource, List<IMeasurementSchema> selectedValueMeasurementSchemas) throws IOException, IllegalPathException {
        List<AlignedChunkMetadata> alignedChunkMetadataList = null;
        if (this.alignedChunkMetadataCache.containsKey(tsFileResource)) {
            alignedChunkMetadataList = this.alignedChunkMetadataCache.get(tsFileResource);
        } else {
            alignedChunkMetadataList = this.getAlignedChunkMetadataList(tsFileResource);
            AlignedSeriesBatchCompactionUtils.markAlignedChunkHasDeletion(alignedChunkMetadataList);
            this.alignedChunkMetadataCache.put(tsFileResource, alignedChunkMetadataList);
        }
        ArrayList<AlignedChunkMetadata> filteredAlignedChunkMetadataList = new ArrayList<AlignedChunkMetadata>();
        for (AlignedChunkMetadata alignedChunkMetadata : alignedChunkMetadataList) {
            filteredAlignedChunkMetadataList.add(AlignedSeriesBatchCompactionUtils.filterAlignedChunkMetadataByIndex(alignedChunkMetadata, this.batchColumnSelection.getSelectedColumnIndexList()));
        }
        return filteredAlignedChunkMetadataList;
    }

    @Override
    public void execute() throws PageException, IllegalPathException, IOException, WriteProcessException {
        this.compactFirstBatch();
        if (this.batchCompactionPlan.isEmpty()) {
            return;
        }
        this.compactLeftBatches();
    }

    private void compactFirstBatch() throws PageException, IllegalPathException, IOException, WriteProcessException {
        List<IMeasurementSchema> selectedMeasurementSchemas;
        if (!this.batchColumnSelection.hasNext()) {
            if (this.ignoreAllNullRows) {
                return;
            }
            selectedMeasurementSchemas = Collections.singletonList(this.timeSchema);
        } else {
            this.batchColumnSelection.next();
            selectedMeasurementSchemas = new ArrayList<IMeasurementSchema>(this.batchColumnSelection.getCurrentSelectedColumnSchemaList().size() + 1);
            selectedMeasurementSchemas.add(this.timeSchema);
            selectedMeasurementSchemas.addAll(this.batchColumnSelection.getCurrentSelectedColumnSchemaList());
        }
        FirstBatchFastAlignedSeriesCompactionExecutor executor = new FirstBatchFastAlignedSeriesCompactionExecutor(this.compactionWriter, this.filterTimeseriesMetadataOffsetMap(selectedMeasurementSchemas), this.readerCacheMap, this.modificationCacheMap, this.sortedSourceFiles, this.deviceId, this.subTaskId, selectedMeasurementSchemas, this.summary, this.ignoreAllNullRows);
        executor.execute();
        LOGGER.debug("[Batch Compaction] current device is {}, first batch compacted time chunk is {}", (Object)this.deviceId, (Object)this.batchCompactionPlan);
    }

    private void compactLeftBatches() throws PageException, IllegalPathException, IOException, WriteProcessException {
        while (this.batchColumnSelection.hasNext()) {
            this.batchColumnSelection.next();
            ArrayList<IMeasurementSchema> currentBatchMeasurementSchemas = new ArrayList<IMeasurementSchema>(this.batchColumnSelection.getCurrentSelectedColumnSchemaList().size() + 1);
            currentBatchMeasurementSchemas.add(this.timeSchema);
            currentBatchMeasurementSchemas.addAll(this.batchColumnSelection.getCurrentSelectedColumnSchemaList());
            FollowingBatchFastAlignedSeriesCompactionExecutor executor = new FollowingBatchFastAlignedSeriesCompactionExecutor(this.compactionWriter, this.filterTimeseriesMetadataOffsetMap(currentBatchMeasurementSchemas), this.readerCacheMap, this.modificationCacheMap, this.sortedSourceFiles, this.deviceId, this.subTaskId, currentBatchMeasurementSchemas, this.summary, this.ignoreAllNullRows);
            executor.execute();
        }
    }

    private Map<String, Map<TsFileResource, Pair<Long, Long>>> filterTimeseriesMetadataOffsetMap(List<IMeasurementSchema> measurementSchemas) {
        HashMap<String, Map<TsFileResource, Pair<Long, Long>>> result = new HashMap<String, Map<TsFileResource, Pair<Long, Long>>>();
        for (IMeasurementSchema measurementSchema : measurementSchemas) {
            String measurementId = measurementSchema.getMeasurementName();
            Map entryValue = (Map)this.timeseriesMetadataOffsetMap.get(measurementSchema.getMeasurementName());
            result.put(measurementId, entryValue);
        }
        return result;
    }

    private class FirstBatchFastAlignedSeriesCompactionExecutor
    extends FastAlignedSeriesCompactionExecutor {
        public FirstBatchFastAlignedSeriesCompactionExecutor(AbstractCompactionWriter compactionWriter, Map<String, Map<TsFileResource, Pair<Long, Long>>> timeseriesMetadataOffsetMap, Map<TsFileResource, TsFileSequenceReader> readerCacheMap, Map<String, PatternTreeMap<ModEntry, PatternTreeMapFactory.ModsSerializer>> modificationCacheMap, List<TsFileResource> sortedSourceFiles, IDeviceID deviceId, int subTaskId, List<IMeasurementSchema> measurementSchemas, FastCompactionTaskSummary summary, boolean ignoreAllNullRows) {
            super(compactionWriter, timeseriesMetadataOffsetMap, readerCacheMap, modificationCacheMap, sortedSourceFiles, deviceId, subTaskId, measurementSchemas, summary, ignoreAllNullRows);
            this.isBatchedCompaction = true;
        }

        @Override
        public void execute() throws PageException, IllegalPathException, IOException, WriteProcessException {
            FirstBatchCompactionAlignedChunkWriter firstBatchCompactionAlignedChunkWriter = new FirstBatchCompactionAlignedChunkWriter((IMeasurementSchema)this.measurementSchemas.remove(0), this.measurementSchemas);
            firstBatchCompactionAlignedChunkWriter.registerBeforeFlushChunkWriterCallback(chunkWriter -> BatchedFastAlignedSeriesCompactionExecutor.this.batchCompactionPlan.recordCompactedChunk(((FirstBatchCompactionAlignedChunkWriter)chunkWriter).getCompactedChunkRecord()));
            this.compactionWriter.startMeasurement("", (IChunkWriter)firstBatchCompactionAlignedChunkWriter, this.subTaskId);
            this.compactFiles();
            this.compactionWriter.endMeasurement(this.subTaskId);
        }

        @Override
        protected List<AlignedChunkMetadata> getAlignedChunkMetadataList(TsFileResource resource) throws IOException, IllegalPathException {
            return BatchedFastAlignedSeriesCompactionExecutor.this.getAlignedChunkMetadataListBySelectedValueColumn(resource, this.measurementSchemas);
        }

        @Override
        protected Chunk readChunk(TsFileSequenceReader reader, ChunkMetadata chunkMetadata) throws IOException {
            Chunk chunk = super.readChunk(reader, chunkMetadata);
            if (AlignedSeriesBatchCompactionUtils.isTimeChunk(chunkMetadata)) {
                BatchedFastAlignedSeriesCompactionExecutor.this.batchCompactionPlan.addTimeChunkToCache(reader.getFileName(), chunkMetadata.getOffsetOfChunkHeader(), chunk);
            }
            return chunk;
        }

        @Override
        protected boolean flushChunkToCompactionWriter(ChunkMetadataElement chunkMetadataElement) throws IOException {
            boolean success = super.flushChunkToCompactionWriter(chunkMetadataElement);
            if (success) {
                BatchedFastAlignedSeriesCompactionExecutor.this.batchCompactionPlan.recordCompactedChunk(new CompactChunkPlan(chunkMetadataElement.chunkMetadata.getStartTime(), chunkMetadataElement.chunkMetadata.getEndTime()));
            }
            return success;
        }

        @Override
        protected ModifiedStatus isPageModified(PageElement pageElement) {
            AlignedPageElement alignedPageElement = (AlignedPageElement)pageElement;
            long startTime = alignedPageElement.getStartTime();
            long endTime = alignedPageElement.getEndTime();
            IChunkMetadata batchedAlignedChunkMetadata = alignedPageElement.getChunkMetadataElement().chunkMetadata;
            TsFileResource resource = alignedPageElement.getChunkMetadataElement().fileElement.resource;
            List alignedChunkMetadataListOfFile = (List)BatchedFastAlignedSeriesCompactionExecutor.this.alignedChunkMetadataCache.get(resource);
            AlignedChunkMetadata originAlignedChunkMetadata = null;
            for (AlignedChunkMetadata alignedChunkMetadata : alignedChunkMetadataListOfFile) {
                if (alignedChunkMetadata.getOffsetOfChunkHeader() != batchedAlignedChunkMetadata.getOffsetOfChunkHeader()) continue;
                originAlignedChunkMetadata = alignedChunkMetadata;
                break;
            }
            ModifiedStatus modifiedStatus = AlignedSeriesBatchCompactionUtils.calculateAlignedPageModifiedStatus(startTime, endTime, originAlignedChunkMetadata, this.ignoreAllNullRows);
            BatchedFastAlignedSeriesCompactionExecutor.this.batchCompactionPlan.recordPageModifiedStatus(resource.getTsFile().getName(), new TimeRange(startTime, endTime), modifiedStatus);
            return modifiedStatus;
        }
    }

    private class FollowingBatchFastAlignedSeriesCompactionExecutor
    extends FastAlignedSeriesCompactionExecutor {
        private FollowedBatchedCompactionFlushController flushController;

        public FollowingBatchFastAlignedSeriesCompactionExecutor(AbstractCompactionWriter compactionWriter, Map<String, Map<TsFileResource, Pair<Long, Long>>> timeseriesMetadataOffsetMap, Map<TsFileResource, TsFileSequenceReader> readerCacheMap, Map<String, PatternTreeMap<ModEntry, PatternTreeMapFactory.ModsSerializer>> modificationCacheMap, List<TsFileResource> sortedSourceFiles, IDeviceID deviceId, int subTaskId, List<IMeasurementSchema> measurementSchemas, FastCompactionTaskSummary summary, boolean ignoreAllNullRows) {
            super(compactionWriter, timeseriesMetadataOffsetMap, readerCacheMap, modificationCacheMap, sortedSourceFiles, deviceId, subTaskId, measurementSchemas, summary, ignoreAllNullRows);
            this.isBatchedCompaction = true;
        }

        @Override
        public void execute() throws PageException, IllegalPathException, IOException, WriteProcessException {
            FollowingBatchCompactionAlignedChunkWriter followingBatchCompactionAlignedChunkWriter = new FollowingBatchCompactionAlignedChunkWriter((IMeasurementSchema)this.measurementSchemas.remove(0), this.measurementSchemas, BatchedFastAlignedSeriesCompactionExecutor.this.batchCompactionPlan.getCompactChunkPlan(0));
            this.flushController = new FollowedBatchedCompactionFlushController(BatchedFastAlignedSeriesCompactionExecutor.this.batchCompactionPlan, followingBatchCompactionAlignedChunkWriter);
            followingBatchCompactionAlignedChunkWriter.registerAfterFlushChunkWriterCallback(chunkWriter -> this.flushController.nextChunk());
            this.compactionWriter.startMeasurement("", (IChunkWriter)followingBatchCompactionAlignedChunkWriter, this.subTaskId);
            this.compactFiles();
            this.compactionWriter.endMeasurement(this.subTaskId);
        }

        @Override
        protected ModifiedStatus isPageModified(PageElement pageElement) {
            String file = pageElement.getChunkMetadataElement().fileElement.resource.getTsFile().getName();
            long startTime = pageElement.getStartTime();
            long endTime = pageElement.getEndTime();
            return BatchedFastAlignedSeriesCompactionExecutor.this.batchCompactionPlan.getAlignedPageModifiedStatus(file, new TimeRange(startTime, endTime));
        }

        @Override
        protected List<AlignedChunkMetadata> getAlignedChunkMetadataList(TsFileResource resource) throws IOException, IllegalPathException {
            return BatchedFastAlignedSeriesCompactionExecutor.this.getAlignedChunkMetadataListBySelectedValueColumn(resource, this.measurementSchemas);
        }

        @Override
        protected Chunk readChunk(TsFileSequenceReader reader, ChunkMetadata chunkMetadata) throws IOException {
            if (AlignedSeriesBatchCompactionUtils.isTimeChunk(chunkMetadata)) {
                return BatchedFastAlignedSeriesCompactionExecutor.this.batchCompactionPlan.getTimeChunkFromCache(reader, chunkMetadata);
            }
            return super.readChunk(reader, chunkMetadata);
        }

        @Override
        protected boolean flushChunkToCompactionWriter(ChunkMetadataElement chunkMetadataElement) throws IOException {
            boolean success = this.compactionWriter.flushBatchedValueChunk(chunkMetadataElement, this.subTaskId, this.flushController);
            if (success) {
                this.flushController.nextChunk();
            }
            return success;
        }

        @Override
        protected boolean flushPageToCompactionWriter(PageElement pageElement) throws PageException, IOException {
            AlignedPageElement alignedPageElement = (AlignedPageElement)pageElement;
            return this.compactionWriter.flushBatchedValuePage(alignedPageElement, this.subTaskId, this.flushController);
        }
    }
}

