/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.transformation.dag.column.binary;

import java.time.LocalDate;
import java.time.ZoneId;
import org.apache.iotdb.commons.exception.IoTDBRuntimeException;
import org.apache.iotdb.db.queryengine.transformation.dag.column.ColumnTransformer;
import org.apache.iotdb.db.queryengine.transformation.dag.column.binary.BinaryColumnTransformer;
import org.apache.iotdb.db.utils.DateTimeUtils;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.tsfile.block.column.Column;
import org.apache.tsfile.block.column.ColumnBuilder;
import org.apache.tsfile.read.common.type.Type;
import org.apache.tsfile.utils.DateUtils;

public class IntAdditionDateColumnTransformer
extends BinaryColumnTransformer {
    private static ZoneId zoneId;

    public IntAdditionDateColumnTransformer(Type returnType, ColumnTransformer leftTransformer, ColumnTransformer rightTransformer, ZoneId zoneId) {
        super(returnType, leftTransformer, rightTransformer);
        IntAdditionDateColumnTransformer.zoneId = zoneId;
    }

    @Override
    protected void doTransform(Column leftColumn, Column rightColumn, ColumnBuilder builder, int positionCount) {
        for (int i = 0; i < positionCount; ++i) {
            if (!leftColumn.isNull(i) && !rightColumn.isNull(i)) {
                this.returnType.writeInt(builder, IntAdditionDateColumnTransformer.transform(this.leftTransformer.getType().getInt(leftColumn, i), this.rightTransformer.getType().getInt(rightColumn, i)));
                continue;
            }
            builder.appendNull();
        }
    }

    @Override
    protected void doTransform(Column leftColumn, Column rightColumn, ColumnBuilder builder, int positionCount, boolean[] selection) {
        for (int i = 0; i < positionCount; ++i) {
            if (!leftColumn.isNull(i) && !rightColumn.isNull(i) && selection[i]) {
                this.returnType.writeInt(builder, IntAdditionDateColumnTransformer.transform(this.leftTransformer.getType().getInt(leftColumn, i), this.rightTransformer.getType().getInt(rightColumn, i)));
                continue;
            }
            builder.appendNull();
        }
    }

    @Override
    protected void checkType() {
    }

    public static int transform(int left, int right) {
        try {
            long timestamp = Math.addExact((long)left, DateTimeUtils.correctPrecision(DateUtils.parseIntToTimestamp((int)right, (ZoneId)zoneId)));
            return DateUtils.parseDateExpressionToInt((LocalDate)DateTimeUtils.convertToLocalDate(timestamp, zoneId));
        }
        catch (ArithmeticException e) {
            throw new IoTDBRuntimeException(String.format("long Addition overflow: %s + %s", left, right), TSStatusCode.NUMERIC_VALUE_OUT_OF_RANGE.getStatusCode(), true);
        }
    }
}

