/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.sql.util;

import com.google.common.collect.Streams;
import com.google.common.graph.Traverser;
import java.util.List;
import java.util.Objects;
import java.util.OptionalInt;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Stream;
import org.apache.iotdb.db.exception.sql.SemanticException;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Expression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Identifier;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Literal;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Node;

public final class AstUtil {
    public static Stream<Node> preOrder(Node node) {
        return Streams.stream((Iterable)Traverser.forTree(Node::getChildren).depthFirstPreOrder((Object)Objects.requireNonNull(node, "node is null")));
    }

    public static boolean treeEqual(Node left, Node right, BiFunction<Node, Node, Boolean> subtreeComparator) {
        Boolean equal = subtreeComparator.apply(left, right);
        if (equal != null) {
            return equal;
        }
        List<? extends Node> leftChildren = left.getChildren();
        List<? extends Node> rightChildren = right.getChildren();
        if (leftChildren.size() != rightChildren.size()) {
            return false;
        }
        for (int i = 0; i < leftChildren.size(); ++i) {
            if (AstUtil.treeEqual(leftChildren.get(i), rightChildren.get(i), subtreeComparator)) continue;
            return false;
        }
        return true;
    }

    public static int treeHash(Node node, Function<Node, OptionalInt> subtreeHasher) {
        OptionalInt hash = subtreeHasher.apply(node);
        if (hash.isPresent()) {
            return hash.getAsInt();
        }
        List<? extends Node> children = node.getChildren();
        int result = node.getClass().hashCode();
        for (Node node2 : children) {
            result = 31 * result + AstUtil.treeHash(node2, subtreeHasher);
        }
        return result;
    }

    public static Object expressionToTsValue(Expression expression) {
        if (expression instanceof Literal) {
            return ((Literal)expression).getTsValue();
        }
        if (expression instanceof Identifier) {
            throw new SemanticException(String.format("Cannot insert identifier %s, please use string literal", expression));
        }
        throw new SemanticException("Unsupported expression: " + expression);
    }

    private AstUtil() {
    }
}

