/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.sql.ast;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.AstVisitor;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Node;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Statement;
import org.apache.iotdb.db.storageengine.dataregion.memtable.DeviceIDFactory;

public class CreateOrUpdateDevice
extends Statement {
    private final String database;
    private final String table;
    private final List<Object[]> deviceIdList;
    private final List<String> attributeNameList;
    private final List<Object[]> attributeValueList;

    public CreateOrUpdateDevice(String database, String table, List<Object[]> deviceIdList, List<String> attributeNameList, List<Object[]> attributeValueList) {
        super(null);
        this.database = database;
        this.table = table;
        this.deviceIdList = DeviceIDFactory.truncateTailingNull(deviceIdList);
        this.attributeNameList = attributeNameList;
        this.attributeValueList = attributeValueList;
    }

    public String getDatabase() {
        return this.database;
    }

    public String getTable() {
        return this.table;
    }

    public List<Object[]> getDeviceIdList() {
        return this.deviceIdList;
    }

    public List<String> getAttributeNameList() {
        return this.attributeNameList;
    }

    public List<Object[]> getAttributeValueList() {
        return this.attributeValueList;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitCreateDevice(this, context);
    }

    @Override
    public List<? extends Node> getChildren() {
        return Collections.emptyList();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateOrUpdateDevice that = (CreateOrUpdateDevice)o;
        return Objects.equals(this.database, that.database) && Objects.equals(this.table, that.table) && Objects.equals(this.deviceIdList, that.deviceIdList) && Objects.equals(this.attributeNameList, that.attributeNameList) && Objects.equals(this.attributeValueList, that.attributeValueList);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.database, this.table, this.deviceIdList, this.attributeNameList, this.attributeValueList);
    }

    @Override
    public String toString() {
        return "CreateDevice{database='" + this.database + '\'' + ", table='" + this.table + '\'' + ", deviceIdList=" + this.deviceIdList + ", attributeNameList=" + this.attributeNameList + ", attributeValueList=" + this.attributeValueList + '}';
    }
}

