/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.planner.node.schema;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.iotdb.common.rpc.thrift.TRegionReplicaSet;
import org.apache.iotdb.db.queryengine.plan.analyze.IAnalysis;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeType;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanVisitor;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.WritePlanNode;
import org.apache.iotdb.db.schemaengine.schemaregion.ISchemaRegionPlan;
import org.apache.iotdb.db.schemaengine.schemaregion.SchemaRegionPlanType;
import org.apache.iotdb.db.schemaengine.schemaregion.SchemaRegionPlanVisitor;
import org.apache.iotdb.db.storageengine.dataregion.memtable.DeviceIDFactory;
import org.apache.tsfile.file.metadata.IDeviceID;
import org.apache.tsfile.utils.ReadWriteIOUtils;

public class CreateOrUpdateTableDeviceNode
extends WritePlanNode
implements ISchemaRegionPlan {
    private final String database;
    private final String tableName;
    private final List<Object[]> deviceIdList;
    private final List<String> attributeNameList;
    private final List<Object[]> attributeValueList;
    private TRegionReplicaSet regionReplicaSet;
    private transient List<IDeviceID> partitionKeyList;
    public static final CreateOrUpdateTableDeviceNode MOCK_INSTANCE = new CreateOrUpdateTableDeviceNode(new PlanNodeId(""), null, null, null, null, null);

    public CreateOrUpdateTableDeviceNode(PlanNodeId id, String database, String tableName, List<Object[]> deviceIdList, List<String> attributeNameList, List<Object[]> attributeValueList) {
        super(id);
        this.database = database;
        this.tableName = tableName;
        this.deviceIdList = deviceIdList;
        this.attributeNameList = attributeNameList;
        this.attributeValueList = attributeValueList;
    }

    public CreateOrUpdateTableDeviceNode(PlanNodeId id, TRegionReplicaSet regionReplicaSet, String database, String tableName, List<Object[]> deviceIdList, List<String> attributeNameList, List<Object[]> attributeValueList) {
        super(id);
        this.database = database;
        this.tableName = tableName;
        this.deviceIdList = deviceIdList;
        this.attributeNameList = attributeNameList;
        this.attributeValueList = attributeValueList;
        this.regionReplicaSet = regionReplicaSet;
    }

    @Override
    public PlanNodeType getType() {
        return PlanNodeType.CREATE_OR_UPDATE_TABLE_DEVICE;
    }

    public String getDatabase() {
        return this.database;
    }

    public String getTableName() {
        return this.tableName;
    }

    public List<Object[]> getDeviceIdList() {
        return this.deviceIdList;
    }

    public List<String> getAttributeNameList() {
        return this.attributeNameList;
    }

    public List<Object[]> getAttributeValueList() {
        return this.attributeValueList;
    }

    @Override
    public TRegionReplicaSet getRegionReplicaSet() {
        return this.regionReplicaSet;
    }

    public List<IDeviceID> getPartitionKeyList() {
        if (this.partitionKeyList == null) {
            this.partitionKeyList = DeviceIDFactory.convertRawDeviceIDs2PartitionKeys(this.tableName, this.deviceIdList);
        }
        return this.partitionKeyList;
    }

    @Override
    public List<PlanNode> getChildren() {
        return Collections.emptyList();
    }

    @Override
    public void addChild(PlanNode child) {
        throw new UnsupportedOperationException();
    }

    @Override
    public PlanNode clone() {
        return new CreateOrUpdateTableDeviceNode(this.getPlanNodeId(), this.regionReplicaSet, this.database, this.tableName, this.deviceIdList, this.attributeNameList, this.attributeValueList);
    }

    @Override
    public int allowedChildCount() {
        return 0;
    }

    @Override
    public List<String> getOutputColumnNames() {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void serializeAttributes(ByteBuffer byteBuffer) {
        PlanNodeType.CREATE_OR_UPDATE_TABLE_DEVICE.serialize(byteBuffer);
        ReadWriteIOUtils.write((String)this.database, (ByteBuffer)byteBuffer);
        ReadWriteIOUtils.write((String)this.tableName, (ByteBuffer)byteBuffer);
        ReadWriteIOUtils.write((int)this.deviceIdList.size(), (ByteBuffer)byteBuffer);
        for (Object[] deviceId : this.deviceIdList) {
            ReadWriteIOUtils.write((int)deviceId.length, (ByteBuffer)byteBuffer);
            for (Object idSeg : deviceId) {
                ReadWriteIOUtils.writeObject((Object)idSeg, (ByteBuffer)byteBuffer);
            }
        }
        ReadWriteIOUtils.write((int)this.attributeNameList.size(), (ByteBuffer)byteBuffer);
        for (String attributeName : this.attributeNameList) {
            ReadWriteIOUtils.write((String)attributeName, (ByteBuffer)byteBuffer);
        }
        ReadWriteIOUtils.write((int)this.attributeValueList.size(), (ByteBuffer)byteBuffer);
        for (Object[] deviceValueList : this.attributeValueList) {
            for (Object value : deviceValueList) {
                ReadWriteIOUtils.writeObject((Object)value, (ByteBuffer)byteBuffer);
            }
        }
    }

    @Override
    protected void serializeAttributes(DataOutputStream stream) throws IOException {
        PlanNodeType.CREATE_OR_UPDATE_TABLE_DEVICE.serialize(stream);
        ReadWriteIOUtils.write((String)this.database, (OutputStream)stream);
        ReadWriteIOUtils.write((String)this.tableName, (OutputStream)stream);
        ReadWriteIOUtils.write((int)this.deviceIdList.size(), (OutputStream)stream);
        for (Object[] deviceId : this.deviceIdList) {
            ReadWriteIOUtils.write((int)deviceId.length, (OutputStream)stream);
            for (Object idSeg : deviceId) {
                ReadWriteIOUtils.writeObject((Object)idSeg, (DataOutputStream)stream);
            }
        }
        ReadWriteIOUtils.write((int)this.attributeNameList.size(), (OutputStream)stream);
        for (String attributeName : this.attributeNameList) {
            ReadWriteIOUtils.write((String)attributeName, (OutputStream)stream);
        }
        for (Object[] deviceValueList : this.attributeValueList) {
            for (Object value : deviceValueList) {
                ReadWriteIOUtils.writeObject((Object)value, (DataOutputStream)stream);
            }
        }
    }

    public static CreateOrUpdateTableDeviceNode deserialize(ByteBuffer buffer) {
        String database = ReadWriteIOUtils.readString((ByteBuffer)buffer);
        String tableName = ReadWriteIOUtils.readString((ByteBuffer)buffer);
        int deviceNum = ReadWriteIOUtils.readInt((ByteBuffer)buffer);
        ArrayList<Object[]> deviceIdList = new ArrayList<Object[]>(deviceNum);
        for (int i = 0; i < deviceNum; ++i) {
            int length = ReadWriteIOUtils.readInt((ByteBuffer)buffer);
            Object[] deviceId = new Object[length];
            for (int j = 0; j < length; ++j) {
                deviceId[j] = ReadWriteIOUtils.readObject((ByteBuffer)buffer);
            }
            deviceIdList.add(deviceId);
        }
        int attributeNameNum = ReadWriteIOUtils.readInt((ByteBuffer)buffer);
        ArrayList<String> attributeNameList = new ArrayList<String>(attributeNameNum);
        for (int i = 0; i < attributeNameNum; ++i) {
            attributeNameList.add(ReadWriteIOUtils.readString((ByteBuffer)buffer));
        }
        ArrayList<Object[]> attributeValueList = new ArrayList<Object[]>(deviceNum);
        for (int i = 0; i < deviceNum; ++i) {
            Object[] deviceAttributeValues = new Object[attributeNameNum];
            for (int j = 0; j < attributeNameNum; ++j) {
                deviceAttributeValues[j] = ReadWriteIOUtils.readObject((ByteBuffer)buffer);
            }
            attributeValueList.add(deviceAttributeValues);
        }
        PlanNodeId planNodeId = PlanNodeId.deserialize(buffer);
        return new CreateOrUpdateTableDeviceNode(planNodeId, database, tableName, deviceIdList, attributeNameList, attributeValueList);
    }

    @Override
    public List<WritePlanNode> splitByPartition(IAnalysis analysis) {
        HashMap<TRegionReplicaSet, List> splitMap = new HashMap<TRegionReplicaSet, List>();
        List<IDeviceID> partitionKeyList = this.getPartitionKeyList();
        for (int i = 0; i < partitionKeyList.size(); ++i) {
            TRegionReplicaSet regionReplicaSet = analysis.getSchemaPartitionInfo().getSchemaRegionReplicaSet(this.database, partitionKeyList.get(i));
            splitMap.computeIfAbsent(regionReplicaSet, k -> new ArrayList()).add(i);
        }
        ArrayList<WritePlanNode> result = new ArrayList<WritePlanNode>(splitMap.size());
        for (Map.Entry entry : splitMap.entrySet()) {
            ArrayList<Object[]> subDeviceIdList = new ArrayList<Object[]>(((List)entry.getValue()).size());
            ArrayList<Object[]> subAttributeValueList = new ArrayList<Object[]>(((List)entry.getValue()).size());
            for (Integer index : (List)entry.getValue()) {
                subDeviceIdList.add(this.deviceIdList.get(index));
                subAttributeValueList.add(this.attributeValueList.get(index));
            }
            result.add(new CreateOrUpdateTableDeviceNode(this.getPlanNodeId(), (TRegionReplicaSet)entry.getKey(), this.database, this.tableName, subDeviceIdList, this.attributeNameList, subAttributeValueList));
        }
        return result;
    }

    @Override
    public <R, C> R accept(PlanVisitor<R, C> visitor, C context) {
        return visitor.visitCreateOrUpdateTableDevice(this, context);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CreateOrUpdateTableDeviceNode node = (CreateOrUpdateTableDeviceNode)o;
        return Objects.equals(this.database, node.database) && Objects.equals(this.tableName, node.tableName) && Objects.equals(this.deviceIdList, node.deviceIdList) && Objects.equals(this.attributeNameList, node.attributeNameList) && Objects.equals(this.attributeValueList, node.attributeValueList) && Objects.equals(this.regionReplicaSet, node.regionReplicaSet) && Objects.equals(this.partitionKeyList, node.partitionKeyList);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.database, this.tableName, this.deviceIdList, this.attributeNameList, this.attributeValueList, this.regionReplicaSet, this.partitionKeyList);
    }

    @Override
    public SchemaRegionPlanType getPlanType() {
        return SchemaRegionPlanType.CREATE_TABLE_DEVICE;
    }

    @Override
    public <R, C> R accept(SchemaRegionPlanVisitor<R, C> visitor, C context) {
        return visitor.visitCreateOrUpdateTableDevice(this, context);
    }
}

