/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.planner.distribute;

import java.util.HashMap;
import java.util.Map;
import org.apache.iotdb.db.queryengine.plan.analyze.TypeProvider;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.SimplePlanVisitor;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.metadata.read.CountSchemaMergeNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.sink.IdentitySinkNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.Symbol;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.AggregationNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.AggregationTableScanNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.CollectNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.ExchangeNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.FillNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.FilterNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.GapFillNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.JoinNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.LimitNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.MergeSortNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.OffsetNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.OutputNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.ProjectNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.SortNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.StreamSortNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.TableScanNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.TopKNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.schema.AbstractTableDeviceQueryNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.schema.TableDeviceQueryCountNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.schema.TableDeviceQueryScanNode;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Expression;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.read.common.type.Type;
import org.apache.tsfile.read.common.type.TypeFactory;

public class TableModelTypeProviderExtractor {
    private TableModelTypeProviderExtractor() {
    }

    public static TypeProvider extractor(PlanNode root, TypeProvider analyzedTypeProvider) {
        TypeProvider operatorTypeProvider = new TypeProvider(new HashMap<Symbol, Type>());
        root.accept(new Visitor(operatorTypeProvider, analyzedTypeProvider), null);
        return operatorTypeProvider;
    }

    private static class Visitor
    extends SimplePlanVisitor<Void> {
        private final TypeProvider beTypeProvider;
        private final TypeProvider feTypeProvider;

        public Visitor(TypeProvider beTypeProvider, TypeProvider feTypeProvider) {
            this.beTypeProvider = beTypeProvider;
            this.feTypeProvider = feTypeProvider;
        }

        @Override
        public Void visitPlan(PlanNode node, Void context) {
            this.addOutputSymbolsToTypeProvider(node);
            node.getChildren().forEach(child -> child.accept(this, context));
            return null;
        }

        private void addOutputSymbolsToTypeProvider(PlanNode node) {
            for (Symbol symbol : node.getOutputSymbols()) {
                if (!this.feTypeProvider.isSymbolExist(symbol)) {
                    throw new IllegalStateException(String.format("Symbol: %s is not exist in feTypeProvider with %s", symbol, node.getClass().getSimpleName()));
                }
                this.beTypeProvider.putTableModelType(symbol, this.feTypeProvider.getTableModelType(symbol));
            }
        }

        @Override
        public Void visitAggregation(AggregationNode node, Void context) {
            node.getChild().accept(this, context);
            node.getAggregations().forEach((k, v) -> this.beTypeProvider.putTableModelType((Symbol)k, this.feTypeProvider.getTableModelType((Symbol)k)));
            node.getGroupingKeys().forEach(k -> {
                if (!this.beTypeProvider.isSymbolExist((Symbol)k)) {
                    this.beTypeProvider.putTableModelType((Symbol)k, this.feTypeProvider.getTableModelType((Symbol)k));
                }
            });
            return null;
        }

        @Override
        public Void visitAggregationTableScan(AggregationTableScanNode node, Void context) {
            this.addOutputSymbolsToTypeProvider(node);
            node.getAssignments().forEach((k, v) -> this.beTypeProvider.putTableModelType((Symbol)k, v.getType()));
            return null;
        }

        @Override
        public Void visitTableScan(TableScanNode node, Void context) {
            node.getAssignments().forEach((k, v) -> this.beTypeProvider.putTableModelType((Symbol)k, v.getType()));
            return null;
        }

        @Override
        public Void visitCountMerge(CountSchemaMergeNode node, Void context) {
            this.beTypeProvider.putTableModelType(new Symbol("count(devices)"), TypeFactory.getType((TSDataType)TSDataType.INT64));
            node.getChildren().forEach(schemaCount -> schemaCount.accept(this, context));
            return null;
        }

        @Override
        public Void visitTableDeviceQueryScan(TableDeviceQueryScanNode node, Void context) {
            return this.visitAbstractTableDeviceQueryNode(node);
        }

        @Override
        public Void visitTableDeviceQueryCount(TableDeviceQueryCountNode node, Void context) {
            return this.visitAbstractTableDeviceQueryNode(node);
        }

        private Void visitAbstractTableDeviceQueryNode(AbstractTableDeviceQueryNode node) {
            node.getColumnHeaderList().forEach(columnHeader -> this.beTypeProvider.putTableModelType(new Symbol(columnHeader.getColumnName()), TypeFactory.getType((TSDataType)columnHeader.getColumnType())));
            return null;
        }

        @Override
        public Void visitProject(ProjectNode node, Void context) {
            node.getChild().accept(this, context);
            for (Map.Entry<Symbol, Expression> entry : node.getAssignments().getMap().entrySet()) {
                Symbol symbol = entry.getKey();
                if (this.beTypeProvider.isSymbolExist(symbol)) continue;
                this.beTypeProvider.putTableModelType(symbol, this.feTypeProvider.getTableModelType(symbol));
            }
            return null;
        }

        @Override
        public Void visitFilter(FilterNode node, Void context) {
            node.getChild().accept(this, context);
            return null;
        }

        @Override
        public Void visitOutput(OutputNode node, Void context) {
            node.getChild().accept(this, context);
            return null;
        }

        @Override
        public Void visitCollect(CollectNode node, Void context) {
            node.getChildren().forEach(c -> c.accept(this, context));
            return null;
        }

        @Override
        public Void visitSort(SortNode node, Void context) {
            node.getChild().accept(this, context);
            return null;
        }

        @Override
        public Void visitTopK(TopKNode node, Void context) {
            node.getChildren().forEach(c -> c.accept(this, context));
            return null;
        }

        @Override
        public Void visitStreamSort(StreamSortNode node, Void context) {
            node.getChild().accept(this, context);
            return null;
        }

        @Override
        public Void visitMergeSort(MergeSortNode node, Void context) {
            node.getChildren().forEach(c -> c.accept(this, context));
            return null;
        }

        @Override
        public Void visitFill(FillNode node, Void context) {
            node.getChild().accept(this, context);
            return null;
        }

        @Override
        public Void visitGapFill(GapFillNode node, Void context) {
            node.getChild().accept(this, context);
            return null;
        }

        @Override
        public Void visitLimit(LimitNode node, Void context) {
            node.getChild().accept(this, context);
            return null;
        }

        @Override
        public Void visitOffset(OffsetNode node, Void context) {
            node.getChild().accept(this, context);
            return null;
        }

        @Override
        public Void visitTableExchange(ExchangeNode node, Void context) {
            node.getChildren().forEach(c -> c.accept(this, context));
            node.getOutputSymbols().forEach(symbol -> this.beTypeProvider.putTableModelType((Symbol)symbol, this.feTypeProvider.getTableModelType((Symbol)symbol)));
            return null;
        }

        @Override
        public Void visitJoin(JoinNode node, Void context) {
            node.getLeftChild().accept(this, context);
            node.getRightChild().accept(this, context);
            return null;
        }

        @Override
        public Void visitIdentitySink(IdentitySinkNode node, Void context) {
            node.getChildren().forEach(c -> c.accept(this, context));
            return null;
        }
    }
}

