/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.analyze.cache.schema.dualkeycache.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import java.util.function.ToIntFunction;
import javax.annotation.Nonnull;
import org.apache.iotdb.commons.utils.TestOnly;
import org.apache.iotdb.db.queryengine.plan.analyze.cache.schema.dualkeycache.IDualKeyCache;
import org.apache.iotdb.db.queryengine.plan.analyze.cache.schema.dualkeycache.IDualKeyCacheComputation;
import org.apache.iotdb.db.queryengine.plan.analyze.cache.schema.dualkeycache.IDualKeyCacheStats;
import org.apache.iotdb.db.queryengine.plan.analyze.cache.schema.dualkeycache.IDualKeyCacheUpdating;
import org.apache.iotdb.db.queryengine.plan.analyze.cache.schema.dualkeycache.impl.CacheEntryGroupImpl;
import org.apache.iotdb.db.queryengine.plan.analyze.cache.schema.dualkeycache.impl.CacheStats;
import org.apache.iotdb.db.queryengine.plan.analyze.cache.schema.dualkeycache.impl.ICacheEntry;
import org.apache.iotdb.db.queryengine.plan.analyze.cache.schema.dualkeycache.impl.ICacheEntryGroup;
import org.apache.iotdb.db.queryengine.plan.analyze.cache.schema.dualkeycache.impl.ICacheEntryManager;
import org.apache.iotdb.db.queryengine.plan.analyze.cache.schema.dualkeycache.impl.ICacheSizeComputer;

class DualKeyCacheImpl<FK, SK, V, T extends ICacheEntry<SK, V>>
implements IDualKeyCache<FK, SK, V> {
    private final SegmentedConcurrentHashMap<FK, ICacheEntryGroup<FK, SK, V, T>> firstKeyMap = new SegmentedConcurrentHashMap();
    private final ICacheEntryManager<FK, SK, V, T> cacheEntryManager;
    private final ICacheSizeComputer<FK, SK, V> sizeComputer;
    private final CacheStats cacheStats;

    DualKeyCacheImpl(ICacheEntryManager<FK, SK, V, T> cacheEntryManager, ICacheSizeComputer<FK, SK, V> sizeComputer, long memoryCapacity) {
        this.cacheEntryManager = cacheEntryManager;
        this.sizeComputer = sizeComputer;
        this.cacheStats = new CacheStats(memoryCapacity);
    }

    @Override
    public V get(FK firstKey, SK secondKey) {
        ICacheEntryGroup<FK, SK, V, T> cacheEntryGroup = this.firstKeyMap.get(firstKey);
        if (cacheEntryGroup == null) {
            this.cacheStats.recordMiss(1);
            return null;
        }
        T cacheEntry = cacheEntryGroup.getCacheEntry(secondKey);
        if (cacheEntry == null) {
            this.cacheStats.recordMiss(1);
            return null;
        }
        this.cacheEntryManager.access(cacheEntry);
        this.cacheStats.recordHit(1);
        return cacheEntry.getValue();
    }

    @Override
    public void compute(IDualKeyCacheComputation<FK, SK, V> computation) {
        FK firstKey = computation.getFirstKey();
        ICacheEntryGroup<FK, SK, V, T> cacheEntryGroup = this.firstKeyMap.get(firstKey);
        SK[] secondKeyList = computation.getSecondKeyList();
        if (cacheEntryGroup == null) {
            for (int i = 0; i < secondKeyList.length; ++i) {
                computation.computeValue(i, null);
            }
            this.cacheStats.recordMiss(secondKeyList.length);
        } else {
            int hitCount = 0;
            for (int i = 0; i < secondKeyList.length; ++i) {
                T cacheEntry = cacheEntryGroup.getCacheEntry(secondKeyList[i]);
                if (cacheEntry == null) {
                    computation.computeValue(i, null);
                    continue;
                }
                computation.computeValue(i, cacheEntry.getValue());
                this.cacheEntryManager.access(cacheEntry);
                ++hitCount;
            }
            this.cacheStats.recordHit(hitCount);
            this.cacheStats.recordMiss(secondKeyList.length - hitCount);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateWithLock(IDualKeyCacheUpdating<FK, SK, V> updating) {
        FK firstKey = updating.getFirstKey();
        ICacheEntryGroup<FK, SK, V, T> cacheEntryGroup = this.firstKeyMap.get(firstKey);
        SK[] secondKeyList = updating.getSecondKeyList();
        if (cacheEntryGroup == null) {
            for (int i = 0; i < secondKeyList.length; ++i) {
                updating.updateValue(i, null);
            }
            this.cacheStats.recordMiss(secondKeyList.length);
        } else {
            for (int i = 0; i < secondKeyList.length; ++i) {
                T cacheEntry = cacheEntryGroup.getCacheEntry(secondKeyList[i]);
                if (cacheEntry == null) {
                    updating.updateValue(i, null);
                    continue;
                }
                int changeSize = 0;
                T t = cacheEntry;
                synchronized (t) {
                    if (cacheEntry.getBelongedGroup() != null) {
                        changeSize = updating.updateValue(i, cacheEntry.getValue());
                        this.cacheEntryManager.access(cacheEntry);
                    }
                }
                if (changeSize <= 0) continue;
                this.increaseMemoryUsageAndMayEvict(changeSize);
            }
        }
    }

    @Override
    public void put(FK firstKey, SK secondKey, V value) {
        AtomicInteger usedMemorySize = new AtomicInteger(0);
        this.firstKeyMap.compute(firstKey, (k, cacheEntryGroup) -> {
            if (cacheEntryGroup == null) {
                cacheEntryGroup = new CacheEntryGroupImpl(firstKey);
                usedMemorySize.getAndAdd(this.sizeComputer.computeFirstKeySize(firstKey));
            }
            CacheEntryGroupImpl finalCacheEntryGroup = cacheEntryGroup;
            cacheEntryGroup.computeCacheEntry(secondKey, (sk, cacheEntry) -> {
                if (cacheEntry == null) {
                    cacheEntry = this.cacheEntryManager.createCacheEntry(secondKey, value, finalCacheEntryGroup);
                    this.cacheEntryManager.put(cacheEntry);
                    usedMemorySize.getAndAdd(this.sizeComputer.computeSecondKeySize(sk));
                } else {
                    Object existingValue = cacheEntry.getValue();
                    if (existingValue != value && !existingValue.equals(value)) {
                        cacheEntry.replaceValue(value);
                        usedMemorySize.getAndAdd(-this.sizeComputer.computeValueSize(existingValue));
                    }
                    this.cacheEntryManager.access(cacheEntry);
                }
                usedMemorySize.getAndAdd(this.sizeComputer.computeValueSize(value));
                return cacheEntry;
            });
            return cacheEntryGroup;
        });
        this.increaseMemoryUsageAndMayEvict(usedMemorySize.get());
    }

    @Override
    public void update(FK firstKey, @Nonnull SK secondKey, V value, ToIntFunction<V> updater, boolean createIfNotExists) {
        AtomicInteger usedMemorySize = new AtomicInteger(0);
        this.firstKeyMap.compute(firstKey, (k, cacheEntryGroup) -> {
            Object cacheEntry;
            if (cacheEntryGroup == null) {
                if (!createIfNotExists) {
                    return null;
                }
                cacheEntryGroup = new CacheEntryGroupImpl(firstKey);
                usedMemorySize.getAndAdd(this.sizeComputer.computeFirstKeySize(firstKey));
            }
            CacheEntryGroupImpl finalCacheEntryGroup = cacheEntryGroup;
            Object object = cacheEntry = createIfNotExists ? cacheEntryGroup.computeCacheEntryIfAbsent(secondKey, sk -> {
                T entry = this.cacheEntryManager.createCacheEntry(secondKey, value, finalCacheEntryGroup);
                this.cacheEntryManager.put(entry);
                usedMemorySize.getAndAdd(this.sizeComputer.computeSecondKeySize(sk) + this.sizeComputer.computeValueSize(entry.getValue()));
                return entry;
            }) : cacheEntryGroup.getCacheEntry(secondKey);
            if (Objects.nonNull(cacheEntry)) {
                int result = updater.applyAsInt(cacheEntry.getValue());
                if (Objects.nonNull(cacheEntryGroup.getCacheEntry(secondKey))) {
                    usedMemorySize.getAndAdd(result);
                }
            }
            return cacheEntryGroup;
        });
        this.increaseMemoryUsageAndMayEvict(usedMemorySize.get());
    }

    @Override
    public void update(FK firstKey, Predicate<SK> secondKeyChecker, ToIntFunction<V> updater) {
        AtomicInteger usedMemorySize = new AtomicInteger(0);
        this.firstKeyMap.compute(firstKey, (k, cacheEntryGroup) -> {
            if (cacheEntryGroup == null) {
                return null;
            }
            ICacheEntryGroup finalCacheEntryGroup = cacheEntryGroup;
            cacheEntryGroup.getAllCacheEntries().forEachRemaining(entry -> {
                if (!secondKeyChecker.test(entry.getKey())) {
                    return;
                }
                int result = updater.applyAsInt(((ICacheEntry)entry.getValue()).getValue());
                if (Objects.nonNull(finalCacheEntryGroup.getCacheEntry(entry.getKey()))) {
                    usedMemorySize.getAndAdd(result);
                }
            });
            return cacheEntryGroup;
        });
        this.increaseMemoryUsageAndMayEvict(usedMemorySize.get());
    }

    @Override
    public void update(Predicate<FK> firstKeyChecker, Predicate<SK> secondKeyChecker, ToIntFunction<V> updater) {
        AtomicInteger usedMemorySize = new AtomicInteger(0);
        for (FK firstKey : this.firstKeyMap.getAllKeys()) {
            ICacheEntryGroup entryGroup;
            if (!firstKeyChecker.test(firstKey) || !Objects.nonNull(entryGroup = this.firstKeyMap.get(firstKey))) continue;
            entryGroup.getAllCacheEntries().forEachRemaining(entry -> {
                if (!secondKeyChecker.test(entry.getKey())) {
                    return;
                }
                int result = updater.applyAsInt(((ICacheEntry)entry.getValue()).getValue());
                if (Objects.nonNull(entryGroup.getCacheEntry(entry.getKey()))) {
                    usedMemorySize.getAndAdd(result);
                }
            });
        }
        this.increaseMemoryUsageAndMayEvict(usedMemorySize.get());
    }

    private void increaseMemoryUsageAndMayEvict(int memorySize) {
        this.cacheStats.increaseMemoryUsage(memorySize);
        while (this.cacheStats.isExceedMemoryCapacity()) {
            this.cacheStats.decreaseMemoryUsage(this.evictOneCacheEntry());
        }
    }

    private int evictOneCacheEntry() {
        T evictCacheEntry = this.cacheEntryManager.evict();
        if (evictCacheEntry == null) {
            return 0;
        }
        AtomicInteger evictedSize = new AtomicInteger(0);
        evictedSize.getAndAdd(this.sizeComputer.computeValueSize(evictCacheEntry.getValue()));
        ICacheEntryGroup belongedGroup = evictCacheEntry.getBelongedGroup();
        evictCacheEntry.setBelongedGroup(null);
        belongedGroup.removeCacheEntry(evictCacheEntry.getSecondKey());
        evictedSize.getAndAdd(this.sizeComputer.computeSecondKeySize(evictCacheEntry.getSecondKey()));
        if (belongedGroup.isEmpty()) {
            this.firstKeyMap.compute(belongedGroup.getFirstKey(), (firstKey, cacheEntryGroup) -> {
                if (cacheEntryGroup == null) {
                    return null;
                }
                if (cacheEntryGroup.isEmpty()) {
                    evictedSize.getAndAdd(this.sizeComputer.computeFirstKeySize(firstKey));
                    return null;
                }
                return cacheEntryGroup;
            });
        }
        return evictedSize.get();
    }

    @Override
    public void invalidateAll() {
        this.executeInvalidateAll();
    }

    private void executeInvalidateAll() {
        this.firstKeyMap.clear();
        this.cacheEntryManager.cleanUp();
        this.cacheStats.resetMemoryUsage();
    }

    @Override
    public void cleanUp() {
        this.executeInvalidateAll();
        this.cacheStats.reset();
    }

    @Override
    public IDualKeyCacheStats stats() {
        return this.cacheStats;
    }

    @Override
    @TestOnly
    public void evictOneEntry() {
        this.cacheStats.decreaseMemoryUsage(this.evictOneCacheEntry());
    }

    @Override
    public void invalidate(FK firstKey) {
        int estimateSize = 0;
        ICacheEntryGroup<FK, SK, V, T> cacheEntryGroup = this.firstKeyMap.remove(firstKey);
        if (cacheEntryGroup != null) {
            estimateSize += this.sizeComputer.computeFirstKeySize(firstKey);
            Iterator<Map.Entry<SK, T>> it = cacheEntryGroup.getAllCacheEntries();
            while (it.hasNext()) {
                Map.Entry<SK, T> entry = it.next();
                if (!this.cacheEntryManager.invalidate((ICacheEntry)entry.getValue())) continue;
                estimateSize += this.sizeComputer.computeSecondKeySize(entry.getKey()) + this.sizeComputer.computeValueSize(((ICacheEntry)entry.getValue()).getValue());
            }
            this.cacheStats.decreaseMemoryUsage(estimateSize);
        }
    }

    @Override
    public void invalidate(FK firstKey, SK secondKey) {
        AtomicInteger usedMemorySize = new AtomicInteger(0);
        this.firstKeyMap.compute(firstKey, (key, cacheEntryGroup) -> {
            if (cacheEntryGroup == null) {
                return null;
            }
            Object entry = cacheEntryGroup.getCacheEntry(secondKey);
            if (Objects.nonNull(entry) && this.cacheEntryManager.invalidate(entry)) {
                usedMemorySize.getAndAdd(this.sizeComputer.computeSecondKeySize(entry.getSecondKey()) + this.sizeComputer.computeValueSize(entry.getValue()));
                cacheEntryGroup.removeCacheEntry(entry.getSecondKey());
            }
            if (cacheEntryGroup.isEmpty()) {
                usedMemorySize.getAndAdd(this.sizeComputer.computeFirstKeySize(firstKey));
                return null;
            }
            return cacheEntryGroup;
        });
        this.cacheStats.decreaseMemoryUsage(usedMemorySize.get());
    }

    @Override
    public void invalidate(FK firstKey, Predicate<SK> secondKeyChecker) {
        AtomicInteger estimateSize = new AtomicInteger(0);
        this.firstKeyMap.compute(firstKey, (key, cacheEntryGroup) -> {
            if (cacheEntryGroup == null) {
                return null;
            }
            Iterator it = cacheEntryGroup.getAllCacheEntries();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                if (!this.cacheEntryManager.invalidate((ICacheEntry)entry.getValue())) continue;
                cacheEntryGroup.removeCacheEntry(entry.getKey());
                estimateSize.addAndGet(this.sizeComputer.computeSecondKeySize(entry.getKey()) + this.sizeComputer.computeValueSize(((ICacheEntry)entry.getValue()).getValue()));
            }
            if (cacheEntryGroup.isEmpty()) {
                estimateSize.getAndAdd(this.sizeComputer.computeFirstKeySize(firstKey));
                return null;
            }
            return cacheEntryGroup;
        });
        this.cacheStats.decreaseMemoryUsage(estimateSize.get());
    }

    @Override
    public void invalidate(Predicate<FK> firstKeyChecker, Predicate<SK> secondKeyChecker) {
        AtomicInteger estimateSize = new AtomicInteger(0);
        for (FK firstKey : this.firstKeyMap.getAllKeys()) {
            if (!firstKeyChecker.test(firstKey)) continue;
            ICacheEntryGroup<FK, SK, V, T> entryGroup = this.firstKeyMap.get(firstKey);
            Iterator<Map.Entry<SK, T>> it = entryGroup.getAllCacheEntries();
            while (it.hasNext()) {
                Map.Entry<SK, T> entry = it.next();
                if (!secondKeyChecker.test(entry.getKey()) || !this.cacheEntryManager.invalidate((ICacheEntry)entry.getValue())) continue;
                entryGroup.removeCacheEntry(entry.getKey());
                estimateSize.addAndGet(this.sizeComputer.computeSecondKeySize(entry.getKey()) + this.sizeComputer.computeValueSize(((ICacheEntry)entry.getValue()).getValue()));
            }
            this.firstKeyMap.compute(firstKey, (fk, sk) -> {
                if (sk.isEmpty()) {
                    estimateSize.getAndAdd(this.sizeComputer.computeFirstKeySize(firstKey));
                    return null;
                }
                return sk;
            });
        }
        this.cacheStats.decreaseMemoryUsage(estimateSize.get());
    }

    private static class SegmentedConcurrentHashMap<K, V> {
        private static final int SLOT_NUM = 31;
        private final Map<K, V>[] maps = new ConcurrentHashMap[31];

        private SegmentedConcurrentHashMap() {
        }

        V get(K key) {
            return this.getBelongedMap(key).get(key);
        }

        V remove(K key) {
            return this.getBelongedMap(key).remove(key);
        }

        V compute(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
            return this.getBelongedMap(key).compute((K)key, (BiFunction<? super K, ? extends V, ? extends V>)remappingFunction);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void clear() {
            Map<K, V>[] mapArray = this.maps;
            synchronized (this.maps) {
                for (int i = 0; i < 31; ++i) {
                    this.maps[i] = null;
                }
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        Map<K, V> getBelongedMap(K key) {
            int slotIndex = key.hashCode() % 31;
            slotIndex = slotIndex < 0 ? slotIndex + 31 : slotIndex;
            Map<K, V> map = this.maps[slotIndex];
            if (map != null) return map;
            Map<K, V>[] mapArray = this.maps;
            synchronized (this.maps) {
                map = this.maps[slotIndex];
                if (map != null) return map;
                this.maps[slotIndex] = map = new ConcurrentHashMap();
                // ** MonitorExit[var4_4] (shouldn't be in output)
                return map;
            }
        }

        List<K> getAllKeys() {
            ArrayList res = new ArrayList();
            Arrays.stream(this.maps).iterator().forEachRemaining(map -> {
                if (map != null) {
                    res.addAll(map.keySet());
                }
            });
            return res;
        }
    }
}

