/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.operator.source.relational.aggregation.grouped;

import com.google.common.base.Preconditions;
import org.apache.iotdb.db.queryengine.execution.operator.source.relational.aggregation.grouped.GroupedAccumulator;
import org.apache.iotdb.db.queryengine.execution.operator.source.relational.aggregation.grouped.array.BooleanBigArray;
import org.apache.iotdb.db.queryengine.execution.operator.source.relational.aggregation.grouped.array.DoubleBigArray;
import org.apache.tsfile.block.column.Column;
import org.apache.tsfile.block.column.ColumnBuilder;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.utils.RamUsageEstimator;
import org.apache.tsfile.write.UnSupportedDataTypeException;

public class GroupedSumAccumulator
implements GroupedAccumulator {
    private static final long INSTANCE_SIZE = RamUsageEstimator.shallowSizeOfInstance(GroupedSumAccumulator.class);
    private final TSDataType argumentDataType;
    private final BooleanBigArray initResult = new BooleanBigArray();
    private final DoubleBigArray sumValues = new DoubleBigArray();

    public GroupedSumAccumulator(TSDataType argumentDataType) {
        this.argumentDataType = argumentDataType;
    }

    @Override
    public long getEstimatedSize() {
        return INSTANCE_SIZE + this.initResult.sizeOf() + this.sumValues.sizeOf();
    }

    @Override
    public void setGroupCount(long groupCount) {
        this.sumValues.ensureCapacity(groupCount);
    }

    @Override
    public void addInput(int[] groupIds, Column[] arguments) {
        Preconditions.checkArgument((arguments.length == 1 ? 1 : 0) != 0, (Object)"argument of Sum should be one column");
        switch (this.argumentDataType) {
            case INT32: {
                this.addIntInput(groupIds, arguments[0]);
                return;
            }
            case INT64: {
                this.addLongInput(groupIds, arguments[0]);
                return;
            }
            case FLOAT: {
                this.addFloatInput(groupIds, arguments[0]);
                return;
            }
            case DOUBLE: {
                this.addDoubleInput(groupIds, arguments[0]);
                return;
            }
        }
        throw new UnSupportedDataTypeException(String.format("Unsupported data type in aggregation AVG : %s", this.argumentDataType));
    }

    @Override
    public void addIntermediate(int[] groupIds, Column argument) {
        for (int i = 0; i < groupIds.length; ++i) {
            if (argument.isNull(i)) continue;
            this.initResult.set(groupIds[i], true);
            this.sumValues.add(groupIds[i], argument.getDouble(i));
        }
    }

    @Override
    public void evaluateIntermediate(int groupId, ColumnBuilder columnBuilder) {
        if (!this.initResult.get(groupId)) {
            columnBuilder.appendNull();
        } else {
            columnBuilder.writeDouble(this.sumValues.get(groupId));
        }
    }

    private void addIntInput(int[] groupIds, Column column) {
        int count = column.getPositionCount();
        for (int i = 0; i < count; ++i) {
            if (column.isNull(i)) continue;
            this.initResult.set(groupIds[i], true);
            this.sumValues.add(groupIds[i], column.getInt(i));
        }
    }

    private void addLongInput(int[] groupIds, Column column) {
        int count = column.getPositionCount();
        for (int i = 0; i < count; ++i) {
            if (column.isNull(i)) continue;
            this.initResult.set(groupIds[i], true);
            this.sumValues.add(groupIds[i], column.getLong(i));
        }
    }

    private void addFloatInput(int[] groupIds, Column column) {
        int count = column.getPositionCount();
        for (int i = 0; i < count; ++i) {
            if (column.isNull(i)) continue;
            this.initResult.set(groupIds[i], true);
            this.sumValues.add(groupIds[i], column.getFloat(i));
        }
    }

    private void addDoubleInput(int[] groupIds, Column column) {
        int count = column.getPositionCount();
        for (int i = 0; i < count; ++i) {
            if (column.isNull(i)) continue;
            this.initResult.set(groupIds[i], true);
            this.sumValues.add(groupIds[i], column.getDouble(i));
        }
    }

    @Override
    public void evaluateFinal(int groupId, ColumnBuilder columnBuilder) {
        if (!this.initResult.get(groupId)) {
            columnBuilder.appendNull();
        } else {
            columnBuilder.writeDouble(this.sumValues.get(groupId));
        }
    }

    @Override
    public void prepareFinal() {
    }

    @Override
    public void reset() {
        this.initResult.reset();
        this.sumValues.reset();
    }
}

