/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.operator.source.relational.aggregation.grouped;

import org.apache.iotdb.db.queryengine.execution.operator.source.relational.aggregation.grouped.GroupedAccumulator;
import org.apache.iotdb.db.queryengine.execution.operator.source.relational.aggregation.grouped.array.BooleanBigArray;
import org.apache.iotdb.db.queryengine.execution.operator.source.relational.aggregation.grouped.array.DoubleBigArray;
import org.apache.iotdb.db.queryengine.execution.operator.source.relational.aggregation.grouped.array.FloatBigArray;
import org.apache.iotdb.db.queryengine.execution.operator.source.relational.aggregation.grouped.array.IntBigArray;
import org.apache.iotdb.db.queryengine.execution.operator.source.relational.aggregation.grouped.array.LongBigArray;
import org.apache.tsfile.block.column.Column;
import org.apache.tsfile.block.column.ColumnBuilder;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.utils.RamUsageEstimator;
import org.apache.tsfile.write.UnSupportedDataTypeException;

public class GroupedExtremeAccumulator
implements GroupedAccumulator {
    private static final long INSTANCE_SIZE = RamUsageEstimator.shallowSizeOfInstance(GroupedExtremeAccumulator.class);
    private final TSDataType seriesDataType;
    private final BooleanBigArray inits = new BooleanBigArray();
    private LongBigArray longValues;
    private IntBigArray intValues;
    private FloatBigArray floatValues;
    private DoubleBigArray doubleValues;

    public GroupedExtremeAccumulator(TSDataType seriesDataType) {
        this.seriesDataType = seriesDataType;
        switch (seriesDataType) {
            case INT32: {
                this.intValues = new IntBigArray();
                return;
            }
            case INT64: {
                this.longValues = new LongBigArray();
                return;
            }
            case FLOAT: {
                this.floatValues = new FloatBigArray();
                return;
            }
            case DOUBLE: {
                this.doubleValues = new DoubleBigArray();
                return;
            }
        }
        throw new UnSupportedDataTypeException(String.format("Unsupported data type : %s", seriesDataType));
    }

    @Override
    public long getEstimatedSize() {
        long valuesSize = 0L;
        switch (this.seriesDataType) {
            case INT32: 
            case DATE: {
                valuesSize += this.intValues.sizeOf();
                break;
            }
            case INT64: 
            case TIMESTAMP: {
                valuesSize += this.longValues.sizeOf();
                break;
            }
            case FLOAT: {
                valuesSize += this.floatValues.sizeOf();
                break;
            }
            case DOUBLE: {
                valuesSize += this.doubleValues.sizeOf();
                break;
            }
            case TEXT: 
            case STRING: 
            case BLOB: {
                break;
            }
            case BOOLEAN: {
                break;
            }
            default: {
                throw new UnSupportedDataTypeException(String.format("Unsupported data type in : %s", this.seriesDataType));
            }
        }
        return INSTANCE_SIZE + valuesSize;
    }

    @Override
    public void setGroupCount(long groupCount) {
        switch (this.seriesDataType) {
            case INT32: 
            case DATE: {
                this.intValues.ensureCapacity(groupCount);
                return;
            }
            case INT64: 
            case TIMESTAMP: {
                this.longValues.ensureCapacity(groupCount);
                return;
            }
            case FLOAT: {
                this.floatValues.ensureCapacity(groupCount);
                return;
            }
            case DOUBLE: {
                this.doubleValues.ensureCapacity(groupCount);
                return;
            }
        }
        throw new UnSupportedDataTypeException(String.format("Unsupported data type in : %s", this.seriesDataType));
    }

    @Override
    public void addInput(int[] groupIds, Column[] arguments) {
        switch (this.seriesDataType) {
            case INT32: {
                this.addIntInput(groupIds, arguments[0]);
                return;
            }
            case INT64: {
                this.addLongInput(groupIds, arguments[0]);
                return;
            }
            case FLOAT: {
                this.addFloatInput(groupIds, arguments[0]);
                return;
            }
            case DOUBLE: {
                this.addDoubleInput(groupIds, arguments[0]);
                return;
            }
        }
        throw new UnSupportedDataTypeException(String.format("Unsupported data type : %s", this.seriesDataType));
    }

    @Override
    public void addIntermediate(int[] groupIds, Column argument) {
        block6: for (int i = 0; i < groupIds.length; ++i) {
            if (argument.isNull(i)) continue;
            switch (this.seriesDataType) {
                case INT32: {
                    this.updateIntValue(groupIds[i], Math.abs(argument.getInt(i)));
                    continue block6;
                }
                case INT64: {
                    this.updateLongValue(groupIds[i], Math.abs(argument.getLong(i)));
                    continue block6;
                }
                case FLOAT: {
                    this.updateFloatValue(groupIds[i], Math.abs(argument.getFloat(i)));
                    continue block6;
                }
                case DOUBLE: {
                    this.updateDoubleValue(groupIds[i], Math.abs(argument.getDouble(i)));
                    continue block6;
                }
                default: {
                    throw new UnSupportedDataTypeException(String.format("Unsupported data type: %s", this.seriesDataType));
                }
            }
        }
    }

    @Override
    public void evaluateIntermediate(int groupId, ColumnBuilder columnBuilder) {
        if (!this.inits.get(groupId)) {
            columnBuilder.appendNull();
        } else {
            switch (this.seriesDataType) {
                case INT32: {
                    columnBuilder.writeInt(this.intValues.get(groupId));
                    break;
                }
                case INT64: {
                    columnBuilder.writeLong(this.longValues.get(groupId));
                    break;
                }
                case FLOAT: {
                    columnBuilder.writeFloat(this.floatValues.get(groupId));
                    break;
                }
                case DOUBLE: {
                    columnBuilder.writeDouble(this.doubleValues.get(groupId));
                    break;
                }
                default: {
                    throw new UnSupportedDataTypeException(String.format("Unsupported data type: %s", this.seriesDataType));
                }
            }
        }
    }

    @Override
    public void evaluateFinal(int groupId, ColumnBuilder columnBuilder) {
        if (!this.inits.get(groupId)) {
            columnBuilder.appendNull();
        } else {
            switch (this.seriesDataType) {
                case INT32: {
                    columnBuilder.writeInt(this.intValues.get(groupId));
                    break;
                }
                case INT64: {
                    columnBuilder.writeLong(this.longValues.get(groupId));
                    break;
                }
                case FLOAT: {
                    columnBuilder.writeFloat(this.floatValues.get(groupId));
                    break;
                }
                case DOUBLE: {
                    columnBuilder.writeDouble(this.doubleValues.get(groupId));
                    break;
                }
                default: {
                    throw new UnSupportedDataTypeException(String.format("Unsupported data type: %s", this.seriesDataType));
                }
            }
        }
    }

    @Override
    public void prepareFinal() {
    }

    @Override
    public void reset() {
        this.inits.reset();
        switch (this.seriesDataType) {
            case INT32: {
                this.intValues.reset();
                return;
            }
            case INT64: {
                this.longValues.reset();
                return;
            }
            case FLOAT: {
                this.floatValues.reset();
                return;
            }
            case DOUBLE: {
                this.doubleValues.reset();
                return;
            }
        }
        throw new UnSupportedDataTypeException(String.format("Unsupported data type : %s", this.seriesDataType));
    }

    private void addIntInput(int[] groupIds, Column valueColumn) {
        for (int i = 0; i < groupIds.length; ++i) {
            if (valueColumn.isNull(i)) continue;
            this.updateIntValue(groupIds[i], Math.abs(valueColumn.getInt(i)));
        }
    }

    protected void updateIntValue(int groupId, int value) {
        int max = this.intValues.get(groupId);
        if (value >= max) {
            this.inits.set(groupId, true);
            this.intValues.set(groupId, value);
        }
    }

    private void addLongInput(int[] groupIds, Column valueColumn) {
        for (int i = 0; i < groupIds.length; ++i) {
            if (valueColumn.isNull(i)) continue;
            this.updateLongValue(groupIds[i], Math.abs(valueColumn.getLong(i)));
        }
    }

    protected void updateLongValue(int groupId, long value) {
        long max = this.longValues.get(groupId);
        if (value >= max) {
            this.inits.set(groupId, true);
            this.longValues.set(groupId, value);
        }
    }

    private void addFloatInput(int[] groupIds, Column valueColumn) {
        for (int i = 0; i < groupIds.length; ++i) {
            if (valueColumn.isNull(i)) continue;
            this.updateFloatValue(groupIds[i], Math.abs(valueColumn.getFloat(i)));
        }
    }

    protected void updateFloatValue(int groupId, float value) {
        float max = this.floatValues.get(groupId);
        if (value >= max) {
            this.inits.set(groupId, true);
            this.floatValues.set(groupId, value);
        }
    }

    private void addDoubleInput(int[] groupIds, Column valueColumn) {
        for (int i = 0; i < groupIds.length; ++i) {
            if (valueColumn.isNull(i)) continue;
            this.updateDoubleValue(groupIds[i], Math.abs(valueColumn.getDouble(i)));
        }
    }

    protected void updateDoubleValue(int groupId, double value) {
        double max = this.doubleValues.get(groupId);
        if (value >= max) {
            this.inits.set(groupId, true);
            this.doubleValues.set(groupId, value);
        }
    }
}

