/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.operator.source.relational.aggregation.grouped;

import org.apache.iotdb.db.queryengine.execution.operator.source.relational.aggregation.grouped.GroupedAccumulator;
import org.apache.iotdb.db.queryengine.execution.operator.source.relational.aggregation.grouped.array.LongBigArray;
import org.apache.tsfile.block.column.Column;
import org.apache.tsfile.block.column.ColumnBuilder;
import org.apache.tsfile.utils.RamUsageEstimator;

public class GroupedCountAccumulator
implements GroupedAccumulator {
    private final LongBigArray countValues = new LongBigArray(0L);
    private static final long INSTANCE_SIZE = RamUsageEstimator.shallowSizeOfInstance(GroupedCountAccumulator.class);

    @Override
    public long getEstimatedSize() {
        return INSTANCE_SIZE + this.countValues.sizeOf();
    }

    @Override
    public void setGroupCount(long groupCount) {
        this.countValues.ensureCapacity(groupCount);
    }

    @Override
    public void addInput(int[] groupIds, Column[] arguments) {
        for (int i = 0; i < groupIds.length; ++i) {
            if (arguments[0].isNull(i)) continue;
            this.countValues.increment(groupIds[i]);
        }
    }

    @Override
    public void addIntermediate(int[] groupIds, Column argument) {
        for (int i = 0; i < groupIds.length; ++i) {
            if (argument.isNull(i)) continue;
            this.countValues.add(groupIds[i], argument.getLong(i));
        }
    }

    @Override
    public void evaluateIntermediate(int groupId, ColumnBuilder columnBuilder) {
        columnBuilder.writeLong(this.countValues.get(groupId));
    }

    @Override
    public void evaluateFinal(int groupId, ColumnBuilder columnBuilder) {
        columnBuilder.writeLong(this.countValues.get(groupId));
    }

    @Override
    public void prepareFinal() {
    }

    @Override
    public void reset() {
        this.countValues.reset();
    }
}

