/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.operator.source.relational.aggregation.grouped;

import com.google.common.base.Preconditions;
import org.apache.iotdb.db.queryengine.execution.operator.source.relational.aggregation.grouped.GroupedAccumulator;
import org.apache.iotdb.db.queryengine.execution.operator.source.relational.aggregation.grouped.array.DoubleBigArray;
import org.apache.iotdb.db.queryengine.execution.operator.source.relational.aggregation.grouped.array.LongBigArray;
import org.apache.tsfile.block.column.Column;
import org.apache.tsfile.block.column.ColumnBuilder;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.read.common.block.column.BinaryColumn;
import org.apache.tsfile.read.common.block.column.BinaryColumnBuilder;
import org.apache.tsfile.read.common.block.column.RunLengthEncodedColumn;
import org.apache.tsfile.utils.Binary;
import org.apache.tsfile.utils.BytesUtils;
import org.apache.tsfile.utils.RamUsageEstimator;
import org.apache.tsfile.write.UnSupportedDataTypeException;

public class GroupedAvgAccumulator
implements GroupedAccumulator {
    private static final long INSTANCE_SIZE = RamUsageEstimator.shallowSizeOfInstance(GroupedAvgAccumulator.class);
    private final TSDataType argumentDataType;
    private final LongBigArray countValues = new LongBigArray();
    private final DoubleBigArray sumValues = new DoubleBigArray();

    public GroupedAvgAccumulator(TSDataType argumentDataType) {
        this.argumentDataType = argumentDataType;
    }

    @Override
    public long getEstimatedSize() {
        return INSTANCE_SIZE + this.countValues.sizeOf() + this.sumValues.sizeOf();
    }

    @Override
    public void setGroupCount(long groupCount) {
        this.countValues.ensureCapacity(groupCount);
        this.sumValues.ensureCapacity(groupCount);
    }

    @Override
    public void addInput(int[] groupIds, Column[] arguments) {
        Preconditions.checkArgument((arguments.length == 1 ? 1 : 0) != 0, (Object)"argument of Avg should be one column");
        switch (this.argumentDataType) {
            case INT32: {
                this.addIntInput(groupIds, arguments[0]);
                return;
            }
            case INT64: {
                this.addLongInput(groupIds, arguments[0]);
                return;
            }
            case FLOAT: {
                this.addFloatInput(groupIds, arguments[0]);
                return;
            }
            case DOUBLE: {
                this.addDoubleInput(groupIds, arguments[0]);
                return;
            }
        }
        throw new UnSupportedDataTypeException(String.format("Unsupported data type in aggregation AVG : %s", this.argumentDataType));
    }

    @Override
    public void addIntermediate(int[] groupIds, Column argument) {
        Preconditions.checkArgument((argument instanceof BinaryColumn || argument instanceof RunLengthEncodedColumn && ((RunLengthEncodedColumn)argument).getValue() instanceof BinaryColumn ? 1 : 0) != 0, (Object)"intermediate input and output of Avg should be BinaryColumn");
        for (int i = 0; i < groupIds.length; ++i) {
            if (argument.isNull(i)) continue;
            this.deserialize(groupIds[i], argument.getBinary(i).getValues());
        }
    }

    @Override
    public void evaluateIntermediate(int groupId, ColumnBuilder columnBuilder) {
        Preconditions.checkArgument((boolean)(columnBuilder instanceof BinaryColumnBuilder), (Object)"intermediate input and output of Avg should be BinaryColumn");
        if (this.countValues.get(groupId) == 0L) {
            columnBuilder.appendNull();
        } else {
            columnBuilder.writeBinary(new Binary(this.serializeState(groupId)));
        }
    }

    private void deserialize(int groupId, byte[] bytes) {
        this.countValues.add(groupId, BytesUtils.bytesToLong((byte[])bytes, (int)8));
        this.sumValues.add(groupId, BytesUtils.bytesToDouble((byte[])bytes, (int)8));
    }

    private byte[] serializeState(int groupId) {
        byte[] bytes = new byte[16];
        BytesUtils.longToBytes((long)this.countValues.get(groupId), (byte[])bytes, (int)0);
        BytesUtils.doubleToBytes((double)this.sumValues.get(groupId), (byte[])bytes, (int)8);
        return bytes;
    }

    private void addIntInput(int[] groupIds, Column column) {
        int count = column.getPositionCount();
        for (int i = 0; i < count; ++i) {
            if (column.isNull(i)) continue;
            this.countValues.increment(groupIds[i]);
            this.sumValues.add(groupIds[i], column.getInt(i));
        }
    }

    private void addLongInput(int[] groupIds, Column column) {
        int count = column.getPositionCount();
        for (int i = 0; i < count; ++i) {
            if (column.isNull(i)) continue;
            this.countValues.increment(groupIds[i]);
            this.sumValues.add(groupIds[i], column.getLong(i));
        }
    }

    private void addFloatInput(int[] groupIds, Column column) {
        int count = column.getPositionCount();
        for (int i = 0; i < count; ++i) {
            if (column.isNull(i)) continue;
            this.countValues.increment(groupIds[i]);
            this.sumValues.add(groupIds[i], column.getFloat(i));
        }
    }

    private void addDoubleInput(int[] groupIds, Column column) {
        int count = column.getPositionCount();
        for (int i = 0; i < count; ++i) {
            if (column.isNull(i)) continue;
            this.countValues.increment(groupIds[i]);
            this.sumValues.add(groupIds[i], column.getDouble(i));
        }
    }

    @Override
    public void evaluateFinal(int groupId, ColumnBuilder columnBuilder) {
        long countValue = this.countValues.get(groupId);
        if (countValue == 0L) {
            columnBuilder.appendNull();
        } else {
            columnBuilder.writeDouble(this.sumValues.get(groupId) / (double)countValue);
        }
    }

    @Override
    public void prepareFinal() {
    }

    @Override
    public void reset() {
        this.countValues.reset();
        this.sumValues.reset();
    }
}

