/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.operator.source.relational.aggregation;

import com.google.common.base.Preconditions;
import org.apache.iotdb.db.queryengine.execution.operator.source.relational.aggregation.TableAccumulator;
import org.apache.tsfile.block.column.Column;
import org.apache.tsfile.block.column.ColumnBuilder;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.file.metadata.statistics.Statistics;
import org.apache.tsfile.utils.Binary;
import org.apache.tsfile.utils.RamUsageEstimator;
import org.apache.tsfile.utils.TsPrimitiveType;
import org.apache.tsfile.write.UnSupportedDataTypeException;

public class MaxAccumulator
implements TableAccumulator {
    private static final long INSTANCE_SIZE = RamUsageEstimator.shallowSizeOfInstance(MaxAccumulator.class);
    private final TSDataType seriesDataType;
    private final TsPrimitiveType maxResult;
    private boolean initResult;

    public MaxAccumulator(TSDataType seriesDataType) {
        this.seriesDataType = seriesDataType;
        this.maxResult = TsPrimitiveType.getByType((TSDataType)seriesDataType);
    }

    @Override
    public long getEstimatedSize() {
        return INSTANCE_SIZE;
    }

    @Override
    public TableAccumulator copy() {
        return new MaxAccumulator(this.seriesDataType);
    }

    @Override
    public void addInput(Column[] arguments) {
        Preconditions.checkArgument((arguments.length == 1 ? 1 : 0) != 0, (Object)"argument of Max should be one column");
        switch (this.seriesDataType) {
            case INT32: 
            case DATE: {
                this.addIntInput(arguments[0]);
                return;
            }
            case INT64: 
            case TIMESTAMP: {
                this.addLongInput(arguments[0]);
                return;
            }
            case FLOAT: {
                this.addFloatInput(arguments[0]);
                return;
            }
            case DOUBLE: {
                this.addDoubleInput(arguments[0]);
                return;
            }
            case TEXT: 
            case STRING: 
            case BLOB: {
                this.addBinaryInput(arguments[0]);
                return;
            }
            case BOOLEAN: {
                this.addBooleanInput(arguments[0]);
                return;
            }
        }
        throw new UnSupportedDataTypeException(String.format("Unsupported data type in LastValue: %s", this.seriesDataType));
    }

    @Override
    public void addIntermediate(Column argument) {
        block8: for (int i = 0; i < argument.getPositionCount(); ++i) {
            if (argument.isNull(i)) continue;
            switch (this.seriesDataType) {
                case INT32: 
                case DATE: {
                    this.updateIntMaxValue(argument.getInt(i));
                    continue block8;
                }
                case INT64: 
                case TIMESTAMP: {
                    this.updateLongMaxValue(argument.getLong(i));
                    continue block8;
                }
                case FLOAT: {
                    this.updateFloatMaxValue(argument.getFloat(i));
                    continue block8;
                }
                case DOUBLE: {
                    this.updateDoubleMaxValue(argument.getDouble(i));
                    continue block8;
                }
                case TEXT: 
                case STRING: 
                case BLOB: {
                    this.updateBinaryMaxValue(argument.getBinary(i));
                    continue block8;
                }
                case BOOLEAN: {
                    this.updateBooleanMaxValue(argument.getBoolean(i));
                    continue block8;
                }
                default: {
                    throw new UnSupportedDataTypeException(String.format("Unsupported data type in Max Aggregation: %s", this.seriesDataType));
                }
            }
        }
    }

    @Override
    public void evaluateIntermediate(ColumnBuilder columnBuilder) {
        if (!this.initResult) {
            columnBuilder.appendNull();
            return;
        }
        switch (this.seriesDataType) {
            case INT32: 
            case DATE: {
                columnBuilder.writeInt(this.maxResult.getInt());
                break;
            }
            case INT64: 
            case TIMESTAMP: {
                columnBuilder.writeLong(this.maxResult.getLong());
                break;
            }
            case FLOAT: {
                columnBuilder.writeFloat(this.maxResult.getFloat());
                break;
            }
            case DOUBLE: {
                columnBuilder.writeDouble(this.maxResult.getDouble());
                break;
            }
            case TEXT: 
            case STRING: 
            case BLOB: {
                columnBuilder.writeBinary(this.maxResult.getBinary());
                break;
            }
            case BOOLEAN: {
                columnBuilder.writeBoolean(this.maxResult.getBoolean());
                break;
            }
            default: {
                throw new UnSupportedDataTypeException(String.format("Unsupported data type in Max Aggregation: %s", this.seriesDataType));
            }
        }
    }

    @Override
    public void evaluateFinal(ColumnBuilder columnBuilder) {
        if (!this.initResult) {
            columnBuilder.appendNull();
            return;
        }
        switch (this.seriesDataType) {
            case INT32: 
            case DATE: {
                columnBuilder.writeInt(this.maxResult.getInt());
                break;
            }
            case INT64: 
            case TIMESTAMP: {
                columnBuilder.writeLong(this.maxResult.getLong());
                break;
            }
            case FLOAT: {
                columnBuilder.writeFloat(this.maxResult.getFloat());
                break;
            }
            case DOUBLE: {
                columnBuilder.writeDouble(this.maxResult.getDouble());
                break;
            }
            case TEXT: 
            case STRING: 
            case BLOB: {
                columnBuilder.writeBinary(this.maxResult.getBinary());
                break;
            }
            case BOOLEAN: {
                columnBuilder.writeBoolean(this.maxResult.getBoolean());
                break;
            }
            default: {
                throw new UnSupportedDataTypeException(String.format("Unsupported data type in MaxAggregation: %s", this.seriesDataType));
            }
        }
    }

    @Override
    public boolean hasFinalResult() {
        return false;
    }

    @Override
    public void addStatistics(Statistics[] statistics) {
        if (statistics == null || statistics[0] == null) {
            return;
        }
        switch (this.seriesDataType) {
            case INT32: 
            case DATE: {
                this.updateIntMaxValue((Integer)statistics[0].getMaxValue());
                break;
            }
            case INT64: {
                this.updateLongMaxValue((Long)statistics[0].getMaxValue());
                break;
            }
            case TIMESTAMP: {
                this.updateLongMaxValue(statistics[0].getEndTime());
                break;
            }
            case FLOAT: {
                this.updateFloatMaxValue(((Float)statistics[0].getMaxValue()).floatValue());
                break;
            }
            case DOUBLE: {
                this.updateDoubleMaxValue((Double)statistics[0].getMaxValue());
                break;
            }
            case TEXT: 
            case STRING: 
            case BLOB: {
                this.updateBinaryMaxValue((Binary)statistics[0].getMaxValue());
                break;
            }
            case BOOLEAN: {
                this.updateBooleanMaxValue((Boolean)statistics[0].getMaxValue());
                break;
            }
            default: {
                throw new UnSupportedDataTypeException(String.format("Unsupported data type in Last Aggregation: %s", this.seriesDataType));
            }
        }
    }

    @Override
    public void reset() {
        this.initResult = false;
        this.maxResult.reset();
    }

    private void addIntInput(Column valueColumn) {
        for (int i = 0; i < valueColumn.getPositionCount(); ++i) {
            if (valueColumn.isNull(i)) continue;
            this.updateIntMaxValue(valueColumn.getInt(i));
        }
    }

    protected void updateIntMaxValue(int value) {
        if (!this.initResult || value > this.maxResult.getInt()) {
            this.initResult = true;
            this.maxResult.setInt(value);
        }
    }

    private void addLongInput(Column valueColumn) {
        for (int i = 0; i < valueColumn.getPositionCount(); ++i) {
            if (valueColumn.isNull(i)) continue;
            this.updateLongMaxValue(valueColumn.getLong(i));
        }
    }

    protected void updateLongMaxValue(long value) {
        if (!this.initResult || value > this.maxResult.getLong()) {
            this.initResult = true;
            this.maxResult.setLong(value);
        }
    }

    private void addFloatInput(Column valueColumn) {
        for (int i = 0; i < valueColumn.getPositionCount(); ++i) {
            if (valueColumn.isNull(i)) continue;
            this.updateFloatMaxValue(valueColumn.getFloat(i));
        }
    }

    protected void updateFloatMaxValue(float value) {
        if (!this.initResult || value > this.maxResult.getFloat()) {
            this.initResult = true;
            this.maxResult.setFloat(value);
        }
    }

    private void addDoubleInput(Column valueColumn) {
        for (int i = 0; i < valueColumn.getPositionCount(); ++i) {
            if (valueColumn.isNull(i)) continue;
            this.updateDoubleMaxValue(valueColumn.getDouble(i));
        }
    }

    protected void updateDoubleMaxValue(double value) {
        if (!this.initResult || value > this.maxResult.getDouble()) {
            this.initResult = true;
            this.maxResult.setDouble(value);
        }
    }

    private void addBinaryInput(Column valueColumn) {
        for (int i = 0; i < valueColumn.getPositionCount(); ++i) {
            if (valueColumn.isNull(i)) continue;
            this.updateBinaryMaxValue(valueColumn.getBinary(i));
        }
    }

    protected void updateBinaryMaxValue(Binary value) {
        if (!this.initResult || value.compareTo(this.maxResult.getBinary()) > 0) {
            this.initResult = true;
            this.maxResult.setBinary(value);
        }
    }

    private void addBooleanInput(Column valueColumn) {
        for (int i = 0; i < valueColumn.getPositionCount(); ++i) {
            if (valueColumn.isNull(i)) continue;
            this.updateBooleanMaxValue(valueColumn.getBoolean(i));
        }
    }

    protected void updateBooleanMaxValue(boolean value) {
        if (!this.initResult || value) {
            this.initResult = true;
            this.maxResult.setBoolean(value);
        }
    }
}

