/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.operator.schema.source;

import java.util.List;
import java.util.Map;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.path.PathPatternTree;
import org.apache.iotdb.commons.schema.column.ColumnHeader;
import org.apache.iotdb.commons.schema.filter.SchemaFilter;
import org.apache.iotdb.db.queryengine.execution.operator.schema.source.DevicePredicateFilter;
import org.apache.iotdb.db.queryengine.execution.operator.schema.source.DeviceSchemaSource;
import org.apache.iotdb.db.queryengine.execution.operator.schema.source.ISchemaSource;
import org.apache.iotdb.db.queryengine.execution.operator.schema.source.LogicalViewSchemaSource;
import org.apache.iotdb.db.queryengine.execution.operator.schema.source.NodeSchemaSource;
import org.apache.iotdb.db.queryengine.execution.operator.schema.source.PathsUsingTemplateSource;
import org.apache.iotdb.db.queryengine.execution.operator.schema.source.TableDeviceFetchSource;
import org.apache.iotdb.db.queryengine.execution.operator.schema.source.TableDeviceQuerySource;
import org.apache.iotdb.db.queryengine.execution.operator.schema.source.TimeSeriesSchemaSource;
import org.apache.iotdb.db.schemaengine.schemaregion.read.resp.info.IDeviceSchemaInfo;
import org.apache.iotdb.db.schemaengine.schemaregion.read.resp.info.INodeSchemaInfo;
import org.apache.iotdb.db.schemaengine.schemaregion.read.resp.info.ITimeSeriesSchemaInfo;
import org.apache.iotdb.db.schemaengine.template.Template;

public class SchemaSourceFactory {
    private SchemaSourceFactory() {
    }

    public static ISchemaSource<ITimeSeriesSchemaInfo> getTimeSeriesSchemaCountSource(PartialPath pathPattern, boolean isPrefixMatch, SchemaFilter schemaFilter, Map<Integer, Template> templateMap, PathPatternTree scope) {
        return new TimeSeriesSchemaSource(pathPattern, isPrefixMatch, 0L, 0L, schemaFilter, templateMap, false, scope);
    }

    public static ISchemaSource<ITimeSeriesSchemaInfo> getTimeSeriesSchemaScanSource(PartialPath pathPattern, boolean isPrefixMatch, long limit, long offset, SchemaFilter schemaFilter, Map<Integer, Template> templateMap, PathPatternTree scope) {
        return new TimeSeriesSchemaSource(pathPattern, isPrefixMatch, limit, offset, schemaFilter, templateMap, true, scope);
    }

    public static ISchemaSource<IDeviceSchemaInfo> getDeviceSchemaSource(PartialPath pathPattern, boolean isPrefixPath, PathPatternTree scope) {
        return new DeviceSchemaSource(pathPattern, isPrefixPath, 0L, 0L, false, null, scope);
    }

    public static ISchemaSource<IDeviceSchemaInfo> getDeviceSchemaSource(PartialPath pathPattern, boolean isPrefixPath, long limit, long offset, boolean hasSgCol, SchemaFilter schemaFilter, PathPatternTree scope) {
        return new DeviceSchemaSource(pathPattern, isPrefixPath, limit, offset, hasSgCol, schemaFilter, scope);
    }

    public static ISchemaSource<INodeSchemaInfo> getNodeSchemaSource(PartialPath pathPattern, int level, PathPatternTree scope) {
        return new NodeSchemaSource(pathPattern, level, scope);
    }

    public static ISchemaSource<IDeviceSchemaInfo> getPathsUsingTemplateSource(List<PartialPath> pathPatternList, int templateId, PathPatternTree scope) {
        return new PathsUsingTemplateSource(pathPatternList, templateId, scope);
    }

    public static ISchemaSource<ITimeSeriesSchemaInfo> getLogicalViewSchemaSource(PartialPath pathPattern, long limit, long offset, SchemaFilter schemaFilter, PathPatternTree scope) {
        return new LogicalViewSchemaSource(pathPattern, limit, offset, schemaFilter, scope);
    }

    public static ISchemaSource<IDeviceSchemaInfo> getTableDeviceFetchSource(String database, String tableName, List<Object[]> deviceIdList, List<ColumnHeader> columnHeaderList) {
        return new TableDeviceFetchSource(database, tableName, deviceIdList, columnHeaderList);
    }

    public static ISchemaSource<IDeviceSchemaInfo> getTableDeviceQuerySource(String database, String tableName, List<List<SchemaFilter>> idDeterminedFilterList, List<ColumnHeader> columnHeaderList, DevicePredicateFilter filter) {
        return new TableDeviceQuerySource(database, tableName, idDeterminedFilterList, columnHeaderList, filter);
    }
}

