/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.processor.schemachange;

import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.pipe.event.common.PipeInsertionEvent;
import org.apache.iotdb.db.queryengine.plan.execution.config.TableConfigTaskVisitor;
import org.apache.iotdb.pipe.api.PipeProcessor;
import org.apache.iotdb.pipe.api.collector.EventCollector;
import org.apache.iotdb.pipe.api.customizer.configuration.PipeProcessorRuntimeConfiguration;
import org.apache.iotdb.pipe.api.customizer.parameter.PipeParameterValidator;
import org.apache.iotdb.pipe.api.customizer.parameter.PipeParameters;
import org.apache.iotdb.pipe.api.event.Event;
import org.apache.iotdb.pipe.api.event.dml.insertion.TabletInsertionEvent;
import org.apache.iotdb.pipe.api.event.dml.insertion.TsFileInsertionEvent;
import org.apache.iotdb.pipe.api.exception.PipeException;

public class RenameDatabaseProcessor
implements PipeProcessor {
    private String newDatabaseName;

    public void validate(PipeParameterValidator validator) throws Exception {
        validator.validateRequiredAttribute("processor.new-db-name");
        try {
            TableConfigTaskVisitor.validateDatabaseName(validator.getParameters().getString("processor.new-db-name"));
        }
        catch (Exception e) {
            throw new PipeException(String.format("The new database name %s is invalid, it should not contain '%s', should match the pattern %s, and the length should not exceed %d", this.newDatabaseName, ".", IoTDBConfig.STORAGE_GROUP_PATTERN, 64), (Throwable)e);
        }
    }

    public void customize(PipeParameters parameters, PipeProcessorRuntimeConfiguration configuration) throws Exception {
        this.newDatabaseName = parameters.getString("processor.new-db-name").toLowerCase();
    }

    public void process(TabletInsertionEvent tabletInsertionEvent, EventCollector eventCollector) throws Exception {
        this.renameDatabase((Event)tabletInsertionEvent, eventCollector);
    }

    public void process(TsFileInsertionEvent tsFileInsertionEvent, EventCollector eventCollector) throws Exception {
        this.renameDatabase((Event)tsFileInsertionEvent, eventCollector);
    }

    public void process(Event event, EventCollector eventCollector) throws Exception {
        this.renameDatabase(event, eventCollector);
    }

    private void renameDatabase(Event event, EventCollector eventCollector) throws Exception {
        if (event instanceof PipeInsertionEvent && ((PipeInsertionEvent)event).isTableModelEvent()) {
            ((PipeInsertionEvent)event).renameTableModelDatabase(this.newDatabaseName);
        }
        eventCollector.collect(event);
    }

    public void close() throws Exception {
    }
}

