/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.event.common.tablet;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import org.apache.iotdb.commons.consensus.index.ProgressIndex;
import org.apache.iotdb.commons.consensus.index.impl.MinimumProgressIndex;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.pipe.agent.task.meta.PipeTaskMeta;
import org.apache.iotdb.commons.pipe.datastructure.pattern.TablePattern;
import org.apache.iotdb.commons.pipe.datastructure.pattern.TreePattern;
import org.apache.iotdb.commons.pipe.event.EnrichedEvent;
import org.apache.iotdb.commons.pipe.resource.ref.PipePhantomReferenceManager;
import org.apache.iotdb.db.pipe.agent.PipeDataNodeAgent;
import org.apache.iotdb.db.pipe.event.ReferenceTrackableEvent;
import org.apache.iotdb.db.pipe.event.common.PipeInsertionEvent;
import org.apache.iotdb.db.pipe.event.common.tablet.PipeRawTabletInsertionEvent;
import org.apache.iotdb.db.pipe.event.common.tablet.parser.TabletInsertionEventParser;
import org.apache.iotdb.db.pipe.event.common.tablet.parser.TabletInsertionEventTablePatternParser;
import org.apache.iotdb.db.pipe.event.common.tablet.parser.TabletInsertionEventTreePatternParser;
import org.apache.iotdb.db.pipe.metric.PipeDataNodeRemainingEventAndTimeMetrics;
import org.apache.iotdb.db.pipe.resource.PipeDataNodeResourceManager;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.InsertNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.InsertRowNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.InsertRowsNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.InsertTabletNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.RelationalInsertRowNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.RelationalInsertRowsNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.RelationalInsertTabletNode;
import org.apache.iotdb.db.storageengine.dataregion.wal.exception.WALPipeException;
import org.apache.iotdb.db.storageengine.dataregion.wal.utils.WALEntryHandler;
import org.apache.iotdb.db.storageengine.dataregion.wal.utils.WALEntryPosition;
import org.apache.iotdb.pipe.api.access.Row;
import org.apache.iotdb.pipe.api.collector.RowCollector;
import org.apache.iotdb.pipe.api.event.dml.insertion.TabletInsertionEvent;
import org.apache.iotdb.pipe.api.exception.PipeException;
import org.apache.tsfile.utils.Accountable;
import org.apache.tsfile.utils.RamUsageEstimator;
import org.apache.tsfile.write.UnSupportedDataTypeException;
import org.apache.tsfile.write.record.Tablet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipeInsertNodeTabletInsertionEvent
extends PipeInsertionEvent
implements TabletInsertionEvent,
ReferenceTrackableEvent,
Accountable {
    private static final Logger LOGGER = LoggerFactory.getLogger(PipeInsertNodeTabletInsertionEvent.class);
    private static final long INSTANCE_SIZE = RamUsageEstimator.shallowSizeOfInstance(PipeInsertNodeTabletInsertionEvent.class) + RamUsageEstimator.shallowSizeOfInstance(WALEntryHandler.class) + RamUsageEstimator.shallowSizeOfInstance(WALEntryPosition.class) + RamUsageEstimator.shallowSizeOfInstance(AtomicInteger.class) + RamUsageEstimator.shallowSizeOfInstance(AtomicBoolean.class);
    private final WALEntryHandler walEntryHandler;
    private final boolean isAligned;
    private final boolean isGeneratedByPipe;
    private List<TabletInsertionEventParser> eventParsers;
    private final PartialPath devicePath;
    private ProgressIndex progressIndex;

    public PipeInsertNodeTabletInsertionEvent(String databaseName, WALEntryHandler walEntryHandler, PartialPath devicePath, ProgressIndex progressIndex, boolean isAligned, boolean isGeneratedByPipe) {
        this(null, databaseName, walEntryHandler, devicePath, progressIndex, isAligned, isGeneratedByPipe, null, 0L, null, null, null, Long.MIN_VALUE, Long.MAX_VALUE);
    }

    private PipeInsertNodeTabletInsertionEvent(Boolean isTableModelEvent, String databaseName, WALEntryHandler walEntryHandler, PartialPath devicePath, ProgressIndex progressIndex, boolean isAligned, boolean isGeneratedByPipe, String pipeName, long creationTime, PipeTaskMeta pipeTaskMeta, TreePattern treePattern, TablePattern tablePattern, long startTime, long endTime) {
        super(pipeName, creationTime, pipeTaskMeta, treePattern, tablePattern, startTime, endTime, isTableModelEvent, databaseName);
        this.walEntryHandler = walEntryHandler;
        this.devicePath = devicePath;
        this.progressIndex = progressIndex;
        this.isAligned = isAligned;
        this.isGeneratedByPipe = isGeneratedByPipe;
    }

    public InsertNode getInsertNode() throws WALPipeException {
        return this.walEntryHandler.getInsertNode();
    }

    public ByteBuffer getByteBuffer() throws WALPipeException {
        return this.walEntryHandler.getByteBuffer();
    }

    public InsertNode getInsertNodeViaCacheIfPossible() {
        return this.walEntryHandler.getInsertNodeViaCacheIfPossible();
    }

    public String getDeviceId() {
        return Objects.nonNull(this.devicePath) ? this.devicePath.getFullPath() : null;
    }

    public boolean internallyIncreaseResourceReferenceCount(String holderMessage) {
        try {
            PipeDataNodeResourceManager.wal().pin(this.walEntryHandler);
            if (Objects.nonNull(this.pipeName)) {
                PipeDataNodeRemainingEventAndTimeMetrics.getInstance().increaseTabletEventCount(this.pipeName, this.creationTime);
                PipeDataNodeAgent.task().addFloatingMemoryUsageInByte(this.pipeName, this.ramBytesUsed());
            }
            return true;
        }
        catch (Exception e) {
            LOGGER.warn(String.format("Increase reference count for memTable %d error. Holder Message: %s", this.walEntryHandler.getMemTableId(), holderMessage), (Throwable)e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean internallyDecreaseResourceReferenceCount(String holderMessage) {
        try {
            PipeDataNodeResourceManager.wal().unpin(this.walEntryHandler);
            if (this.eventParsers != null) {
                this.eventParsers.clear();
                this.eventParsers = null;
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            LOGGER.warn(String.format("Decrease reference count for memtable %d error. Holder Message: %s", this.walEntryHandler.getMemTableId(), holderMessage), (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            if (Objects.nonNull(this.pipeName)) {
                PipeDataNodeAgent.task().decreaseFloatingMemoryUsageInByte(this.pipeName, this.ramBytesUsed());
                PipeDataNodeRemainingEventAndTimeMetrics.getInstance().decreaseTabletEventCount(this.pipeName, this.creationTime);
            }
        }
    }

    public void bindProgressIndex(ProgressIndex progressIndex) {
        this.progressIndex = progressIndex;
    }

    public ProgressIndex getProgressIndex() {
        return this.progressIndex == null ? MinimumProgressIndex.INSTANCE : this.progressIndex;
    }

    public PipeInsertNodeTabletInsertionEvent shallowCopySelfAndBindPipeTaskMetaForProgressReport(String pipeName, long creationTime, PipeTaskMeta pipeTaskMeta, TreePattern treePattern, TablePattern tablePattern, long startTime, long endTime) {
        return new PipeInsertNodeTabletInsertionEvent(this.getRawIsTableModelEvent(), this.getTreeModelDatabaseName(), this.walEntryHandler, this.devicePath, this.progressIndex, this.isAligned, this.isGeneratedByPipe, pipeName, creationTime, pipeTaskMeta, treePattern, tablePattern, startTime, endTime);
    }

    public boolean isGeneratedByPipe() {
        return this.isGeneratedByPipe;
    }

    public boolean mayEventTimeOverlappedWithTimeRange() {
        try {
            InsertNode insertNode = this.getInsertNodeViaCacheIfPossible();
            if (Objects.isNull(insertNode)) {
                return true;
            }
            if (insertNode instanceof InsertRowNode) {
                long timestamp = ((InsertRowNode)insertNode).getTime();
                return this.startTime <= timestamp && timestamp <= this.endTime;
            }
            if (insertNode instanceof InsertTabletNode) {
                long[] timestamps = ((InsertTabletNode)insertNode).getTimes();
                if (Objects.isNull(timestamps) || timestamps.length == 0) {
                    return false;
                }
                return this.startTime <= timestamps[timestamps.length - 1] && timestamps[0] <= this.endTime;
            }
            if (insertNode instanceof InsertRowsNode) {
                return ((InsertRowsNode)insertNode).getInsertRowNodeList().stream().anyMatch(insertRowNode -> {
                    long timestamp = insertRowNode.getTime();
                    return this.startTime <= timestamp && timestamp <= this.endTime;
                });
            }
            return true;
        }
        catch (Exception e) {
            LOGGER.warn("Exception occurred when determining the event time of PipeInsertNodeTabletInsertionEvent({}) overlaps with the time range: [{}, {}]. Returning true to ensure data integrity.", new Object[]{this, this.startTime, this.endTime, e});
            return true;
        }
    }

    public boolean mayEventPathsOverlappedWithPattern() {
        try {
            InsertNode insertNode = this.getInsertNodeViaCacheIfPossible();
            if (Objects.isNull(insertNode)) {
                return true;
            }
            if (insertNode instanceof RelationalInsertRowNode || insertNode instanceof RelationalInsertTabletNode || insertNode instanceof RelationalInsertRowsNode) {
                return true;
            }
            if (insertNode instanceof InsertRowNode || insertNode instanceof InsertTabletNode) {
                PartialPath devicePartialPath = insertNode.getTargetPath();
                return Objects.isNull(devicePartialPath) || this.treePattern.mayOverlapWithDevice(devicePartialPath.getIDeviceIDAsFullDevice());
            }
            if (insertNode instanceof InsertRowsNode) {
                return ((InsertRowsNode)insertNode).getInsertRowNodeList().stream().anyMatch(insertRowNode -> Objects.isNull(insertRowNode.getTargetPath()) || this.treePattern.mayOverlapWithDevice(insertRowNode.getTargetPath().getIDeviceIDAsFullDevice()));
            }
            return true;
        }
        catch (Exception e) {
            LOGGER.warn("Exception occurred when determining the event time of PipeInsertNodeTabletInsertionEvent({}) overlaps with the time range: [{}, {}]. Returning true to ensure data integrity.", new Object[]{this, this.startTime, this.endTime, e});
            return true;
        }
    }

    public Iterable<TabletInsertionEvent> processRowByRow(BiConsumer<Row, RowCollector> consumer) {
        return this.initEventParsers().stream().map(tabletInsertionEventParser -> tabletInsertionEventParser.processRowByRow(consumer)).flatMap(Collection::stream).collect(Collectors.toList());
    }

    public Iterable<TabletInsertionEvent> processTablet(BiConsumer<Tablet, RowCollector> consumer) {
        return this.initEventParsers().stream().map(tabletInsertionEventParser -> tabletInsertionEventParser.processTablet(consumer)).flatMap(Collection::stream).collect(Collectors.toList());
    }

    public boolean isAligned(int i) {
        return this.initEventParsers().get(i).isAligned();
    }

    public List<Tablet> convertToTablets() {
        return this.initEventParsers().stream().map(TabletInsertionEventParser::convertToTablet).collect(Collectors.toList());
    }

    private List<TabletInsertionEventParser> initEventParsers() {
        try {
            if (this.eventParsers != null) {
                return this.eventParsers;
            }
            this.eventParsers = new ArrayList<TabletInsertionEventParser>();
            InsertNode node = this.getInsertNode();
            switch (node.getType()) {
                case INSERT_ROW: 
                case INSERT_TABLET: {
                    this.eventParsers.add(new TabletInsertionEventTreePatternParser(this.pipeTaskMeta, this, node, this.treePattern));
                    break;
                }
                case INSERT_ROWS: {
                    for (InsertRowNode insertRowNode : ((InsertRowsNode)node).getInsertRowNodeList()) {
                        this.eventParsers.add(new TabletInsertionEventTreePatternParser(this.pipeTaskMeta, this, insertRowNode, this.treePattern));
                    }
                    break;
                }
                case RELATIONAL_INSERT_ROW: 
                case RELATIONAL_INSERT_TABLET: {
                    this.eventParsers.add(new TabletInsertionEventTablePatternParser(this.pipeTaskMeta, this, node, this.tablePattern));
                    break;
                }
                case RELATIONAL_INSERT_ROWS: {
                    for (InsertRowNode insertRowNode : ((RelationalInsertRowsNode)node).getInsertRowNodeList()) {
                        this.eventParsers.add(new TabletInsertionEventTablePatternParser(this.pipeTaskMeta, this, insertRowNode, this.tablePattern));
                    }
                    break;
                }
                default: {
                    throw new UnSupportedDataTypeException("Unsupported node type " + (Object)((Object)node.getType()));
                }
            }
            int size = this.eventParsers.size();
            if (size > 0) {
                this.eventParsers.get(size - 1).markAsNeedToReport();
            }
            return this.eventParsers;
        }
        catch (Exception e) {
            throw new PipeException("Initialize data container error.", (Throwable)e);
        }
    }

    public long count() {
        long count = 0L;
        for (Tablet covertedTablet : this.convertToTablets()) {
            count += (long)covertedTablet.getRowSize() * (long)covertedTablet.getSchemas().size();
        }
        return count;
    }

    public List<PipeRawTabletInsertionEvent> toRawTabletInsertionEvents() {
        List<PipeRawTabletInsertionEvent> events = this.initEventParsers().stream().map(container -> new PipeRawTabletInsertionEvent(this.getRawIsTableModelEvent(), this.getTreeModelDatabaseName(), container.convertToTablet(), container.isAligned(), this.pipeName, this.creationTime, this.pipeTaskMeta, this, false)).filter(event -> !event.hasNoNeedParsingAndIsEmpty()).collect(Collectors.toList());
        int size = events.size();
        if (size > 0) {
            events.get(size - 1).markAsNeedToReport();
        }
        return events;
    }

    public String toString() {
        return String.format("PipeInsertNodeTabletInsertionEvent{walEntryHandler=%s, progressIndex=%s, isAligned=%s, isGeneratedByPipe=%s, eventParsers=%s}", this.walEntryHandler, this.progressIndex, this.isAligned, this.isGeneratedByPipe, this.eventParsers) + " - " + super.toString();
    }

    public String coreReportMessage() {
        return String.format("PipeInsertNodeTabletInsertionEvent{walEntryHandler=%s, progressIndex=%s, isAligned=%s, isGeneratedByPipe=%s}", this.walEntryHandler, this.progressIndex, this.isAligned, this.isGeneratedByPipe) + " - " + super.coreReportMessage();
    }

    protected void trackResource() {
        PipeDataNodeResourceManager.ref().trackPipeEventResource((EnrichedEvent)this, this.eventResourceBuilder());
    }

    @Override
    public PipePhantomReferenceManager.PipeEventResource eventResourceBuilder() {
        return new PipeInsertNodeTabletInsertionEventResource(this.isReleased, this.referenceCount, this.walEntryHandler);
    }

    public long ramBytesUsed() {
        return INSTANCE_SIZE + (long)(Objects.nonNull(this.devicePath) ? PartialPath.estimateSize((PartialPath)this.devicePath) : 0) + (Objects.nonNull(this.progressIndex) ? this.progressIndex.ramBytesUsed() : 0L);
    }

    private static class PipeInsertNodeTabletInsertionEventResource
    extends PipePhantomReferenceManager.PipeEventResource {
        private final WALEntryHandler walEntryHandler;

        private PipeInsertNodeTabletInsertionEventResource(AtomicBoolean isReleased, AtomicInteger referenceCount, WALEntryHandler walEntryHandler) {
            super(isReleased, referenceCount);
            this.walEntryHandler = walEntryHandler;
        }

        protected void finalizeResource() {
            try {
                PipeDataNodeResourceManager.wal().unpin(this.walEntryHandler);
            }
            catch (Exception e) {
                LOGGER.warn(String.format("Decrease reference count for memTable %d error.", this.walEntryHandler.getMemTableId()), (Throwable)e);
            }
        }
    }
}

