/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.connector.protocol.writeback;

import com.google.common.util.concurrent.ListenableFuture;
import java.io.IOException;
import java.time.ZoneId;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.conf.IoTDBConstant;
import org.apache.iotdb.confignode.rpc.thrift.TDatabaseSchema;
import org.apache.iotdb.db.auth.AuthorityChecker;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.pipe.connector.payload.evolvable.request.PipeTransferTabletBinaryReqV2;
import org.apache.iotdb.db.pipe.connector.payload.evolvable.request.PipeTransferTabletInsertNodeReqV2;
import org.apache.iotdb.db.pipe.connector.payload.evolvable.request.PipeTransferTabletRawReqV2;
import org.apache.iotdb.db.pipe.event.common.tablet.PipeInsertNodeTabletInsertionEvent;
import org.apache.iotdb.db.pipe.event.common.tablet.PipeRawTabletInsertionEvent;
import org.apache.iotdb.db.protocol.session.IClientSession;
import org.apache.iotdb.db.protocol.session.InternalClientSession;
import org.apache.iotdb.db.protocol.session.SessionManager;
import org.apache.iotdb.db.queryengine.common.SessionInfo;
import org.apache.iotdb.db.queryengine.plan.Coordinator;
import org.apache.iotdb.db.queryengine.plan.analyze.ClusterPartitionFetcher;
import org.apache.iotdb.db.queryengine.plan.analyze.IPartitionFetcher;
import org.apache.iotdb.db.queryengine.plan.analyze.schema.ClusterSchemaFetcher;
import org.apache.iotdb.db.queryengine.plan.analyze.schema.ISchemaFetcher;
import org.apache.iotdb.db.queryengine.plan.execution.config.ConfigTaskResult;
import org.apache.iotdb.db.queryengine.plan.execution.config.executor.ClusterConfigTaskExecutor;
import org.apache.iotdb.db.queryengine.plan.execution.config.metadata.relational.CreateDBTask;
import org.apache.iotdb.db.queryengine.plan.planner.LocalExecutionPlanner;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.InsertNode;
import org.apache.iotdb.db.queryengine.plan.relational.metadata.Metadata;
import org.apache.iotdb.db.queryengine.plan.relational.sql.parser.SqlParser;
import org.apache.iotdb.db.queryengine.plan.statement.Statement;
import org.apache.iotdb.db.queryengine.plan.statement.crud.InsertBaseStatement;
import org.apache.iotdb.db.queryengine.plan.statement.crud.InsertTabletStatement;
import org.apache.iotdb.db.queryengine.plan.statement.pipe.PipeEnrichedStatement;
import org.apache.iotdb.db.storageengine.dataregion.wal.exception.WALPipeException;
import org.apache.iotdb.db.utils.ErrorHandlingUtils;
import org.apache.iotdb.pipe.api.PipeConnector;
import org.apache.iotdb.pipe.api.customizer.configuration.PipeConnectorRuntimeConfiguration;
import org.apache.iotdb.pipe.api.customizer.configuration.PipeRuntimeEnvironment;
import org.apache.iotdb.pipe.api.customizer.parameter.PipeParameterValidator;
import org.apache.iotdb.pipe.api.customizer.parameter.PipeParameters;
import org.apache.iotdb.pipe.api.event.Event;
import org.apache.iotdb.pipe.api.event.dml.insertion.TabletInsertionEvent;
import org.apache.iotdb.pipe.api.exception.PipeException;
import org.apache.iotdb.rpc.TSStatusCode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WriteBackConnector
implements PipeConnector {
    private static final Logger LOGGER = LoggerFactory.getLogger(WriteBackConnector.class);
    private static final Coordinator COORDINATOR = Coordinator.getInstance();
    private static final SessionManager SESSION_MANAGER = SessionManager.getInstance();
    private IClientSession session;
    private static final String TREE_MODEL_DATABASE_NAME_IDENTIFIER = null;
    private static final SqlParser RELATIONAL_SQL_PARSER = new SqlParser();
    private static final Set<String> ALREADY_CREATED_DATABASES = ConcurrentHashMap.newKeySet();

    public void validate(PipeParameterValidator validator) throws Exception {
    }

    public void customize(PipeParameters parameters, PipeConnectorRuntimeConfiguration configuration) throws Exception {
        PipeRuntimeEnvironment environment = configuration.getRuntimeEnvironment();
        this.session = new InternalClientSession(String.format("%s_%s_%s_%s", WriteBackConnector.class.getSimpleName(), environment.getPipeName(), environment.getCreationTime(), environment.getRegionId()));
        this.session.setUsername(AuthorityChecker.SUPER_USER);
        this.session.setClientVersion(IoTDBConstant.ClientVersion.V_1_0);
        this.session.setZoneId(ZoneId.systemDefault());
    }

    public void handshake() throws Exception {
    }

    public void heartbeat() throws Exception {
    }

    public void transfer(TabletInsertionEvent tabletInsertionEvent) throws Exception {
        if (!(tabletInsertionEvent instanceof PipeInsertNodeTabletInsertionEvent) && !(tabletInsertionEvent instanceof PipeRawTabletInsertionEvent)) {
            LOGGER.warn("WriteBackConnector only support PipeInsertNodeTabletInsertionEvent and PipeRawTabletInsertionEvent. Ignore {}.", (Object)tabletInsertionEvent);
            return;
        }
        if (tabletInsertionEvent instanceof PipeInsertNodeTabletInsertionEvent) {
            this.doTransferWrapper((PipeInsertNodeTabletInsertionEvent)tabletInsertionEvent);
        } else {
            this.doTransferWrapper((PipeRawTabletInsertionEvent)tabletInsertionEvent);
        }
    }

    private void doTransferWrapper(PipeInsertNodeTabletInsertionEvent pipeInsertNodeTabletInsertionEvent) throws PipeException, WALPipeException, IOException {
        if (!pipeInsertNodeTabletInsertionEvent.increaseReferenceCount(WriteBackConnector.class.getName())) {
            return;
        }
        try {
            this.doTransfer(pipeInsertNodeTabletInsertionEvent);
        }
        finally {
            pipeInsertNodeTabletInsertionEvent.decreaseReferenceCount(WriteBackConnector.class.getName(), false);
        }
    }

    private void doTransfer(PipeInsertNodeTabletInsertionEvent pipeInsertNodeTabletInsertionEvent) throws PipeException, WALPipeException, IOException {
        TSStatus status;
        InsertNode insertNode = pipeInsertNodeTabletInsertionEvent.getInsertNodeViaCacheIfPossible();
        String dataBaseName = pipeInsertNodeTabletInsertionEvent.isTableModelEvent() ? pipeInsertNodeTabletInsertionEvent.getTableModelDatabaseName() : TREE_MODEL_DATABASE_NAME_IDENTIFIER;
        InsertBaseStatement insertBaseStatement = Objects.isNull(insertNode) ? PipeTransferTabletBinaryReqV2.toTPipeTransferReq(pipeInsertNodeTabletInsertionEvent.getByteBuffer(), dataBaseName).constructStatement() : PipeTransferTabletInsertNodeReqV2.toTabletInsertNodeReq(insertNode, dataBaseName).constructStatement();
        TSStatus tSStatus = status = insertBaseStatement.isWriteToTable() ? this.executeStatementForTableModel(insertBaseStatement, dataBaseName) : this.executeStatementForTreeModel(insertBaseStatement);
        if (status.getCode() != TSStatusCode.REDIRECTION_RECOMMEND.getStatusCode() && status.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            throw new PipeException(String.format("Write back PipeInsertNodeTabletInsertionEvent %s error, result status %s", pipeInsertNodeTabletInsertionEvent, status));
        }
    }

    private void doTransferWrapper(PipeRawTabletInsertionEvent pipeRawTabletInsertionEvent) throws PipeException {
        if (!pipeRawTabletInsertionEvent.increaseReferenceCount(WriteBackConnector.class.getName())) {
            return;
        }
        try {
            this.doTransfer(pipeRawTabletInsertionEvent);
        }
        finally {
            pipeRawTabletInsertionEvent.decreaseReferenceCount(WriteBackConnector.class.getName(), false);
        }
    }

    private void doTransfer(PipeRawTabletInsertionEvent pipeRawTabletInsertionEvent) throws PipeException {
        TSStatus status;
        String dataBaseName = pipeRawTabletInsertionEvent.isTableModelEvent() ? pipeRawTabletInsertionEvent.getTableModelDatabaseName() : TREE_MODEL_DATABASE_NAME_IDENTIFIER;
        InsertTabletStatement insertTabletStatement = PipeTransferTabletRawReqV2.toTPipeTransferRawReq(pipeRawTabletInsertionEvent.convertToTablet(), pipeRawTabletInsertionEvent.isAligned(), dataBaseName).constructStatement();
        TSStatus tSStatus = status = insertTabletStatement.isWriteToTable() ? this.executeStatementForTableModel(insertTabletStatement, dataBaseName) : this.executeStatementForTreeModel(insertTabletStatement);
        if (status.getCode() != TSStatusCode.REDIRECTION_RECOMMEND.getStatusCode() && status.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            throw new PipeException(String.format("Write back PipeRawTabletInsertionEvent %s error, result status %s", pipeRawTabletInsertionEvent, status));
        }
    }

    public void transfer(Event event) throws Exception {
    }

    public void close() throws Exception {
        if (this.session != null) {
            SESSION_MANAGER.closeSession(this.session, COORDINATOR::cleanupQueryExecution);
        }
    }

    private TSStatus executeStatementForTableModel(Statement statement, String dataBaseName) {
        this.session.setDatabaseName(dataBaseName);
        this.session.setSqlDialect(IClientSession.SqlDialect.TABLE);
        SESSION_MANAGER.registerSession(this.session);
        try {
            this.autoCreateDatabaseIfNecessary(dataBaseName);
            TSStatus tSStatus = Coordinator.getInstance().executeForTableModel((Statement)new PipeEnrichedStatement((Statement)statement), (SqlParser)WriteBackConnector.RELATIONAL_SQL_PARSER, (IClientSession)this.session, (long)WriteBackConnector.SESSION_MANAGER.requestQueryId(), (SessionInfo)WriteBackConnector.SESSION_MANAGER.getSessionInfoOfPipeReceiver((IClientSession)this.session, (String)dataBaseName), (String)"", (Metadata)LocalExecutionPlanner.getInstance().metadata, (long)IoTDBDescriptor.getInstance().getConfig().getQueryTimeoutThreshold()).status;
            return tSStatus;
        }
        catch (Exception e) {
            ALREADY_CREATED_DATABASES.remove(dataBaseName);
            Throwable rootCause = ErrorHandlingUtils.getRootCause(e);
            if (rootCause.getMessage() != null && rootCause.getMessage().toLowerCase(Locale.ENGLISH).contains("Database is not set".toLowerCase(Locale.ENGLISH))) {
                this.autoCreateDatabaseIfNecessary(dataBaseName);
                this.session.setDatabaseName(dataBaseName);
                TSStatus tSStatus = Coordinator.getInstance().executeForTableModel((Statement)new PipeEnrichedStatement((Statement)statement), (SqlParser)WriteBackConnector.RELATIONAL_SQL_PARSER, (IClientSession)this.session, (long)WriteBackConnector.SESSION_MANAGER.requestQueryId(), (SessionInfo)WriteBackConnector.SESSION_MANAGER.getSessionInfo((IClientSession)this.session), (String)"", (Metadata)LocalExecutionPlanner.getInstance().metadata, (long)IoTDBDescriptor.getInstance().getConfig().getQueryTimeoutThreshold()).status;
                return tSStatus;
            }
            throw e;
        }
        finally {
            SESSION_MANAGER.removeCurrSession();
        }
    }

    private void autoCreateDatabaseIfNecessary(String database) {
        if (ALREADY_CREATED_DATABASES.contains(database)) {
            return;
        }
        TDatabaseSchema schema = new TDatabaseSchema(new TDatabaseSchema(database));
        schema.setIsTableModel(true);
        CreateDBTask task = new CreateDBTask(schema, true);
        try {
            ListenableFuture<ConfigTaskResult> future = task.execute(ClusterConfigTaskExecutor.getInstance());
            ConfigTaskResult result = (ConfigTaskResult)future.get();
            int statusCode = result.getStatusCode().getStatusCode();
            if (statusCode != TSStatusCode.SUCCESS_STATUS.getStatusCode() && statusCode != TSStatusCode.DATABASE_ALREADY_EXISTS.getStatusCode()) {
                throw new PipeException(String.format("Auto create database failed: %s, status code: %s", database, result.getStatusCode()));
            }
        }
        catch (InterruptedException | ExecutionException e) {
            if (e instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            throw new PipeException("Auto create database failed because: " + e.getMessage());
        }
        ALREADY_CREATED_DATABASES.add(database);
    }

    private TSStatus executeStatementForTreeModel(Statement statement) {
        this.session.setDatabaseName(null);
        this.session.setSqlDialect(IClientSession.SqlDialect.TREE);
        SESSION_MANAGER.registerSession(this.session);
        try {
            TSStatus tSStatus = Coordinator.getInstance().executeForTreeModel((Statement)new PipeEnrichedStatement((Statement)statement), (long)WriteBackConnector.SESSION_MANAGER.requestQueryId(), (SessionInfo)WriteBackConnector.SESSION_MANAGER.getSessionInfo((IClientSession)this.session), (String)"", (IPartitionFetcher)ClusterPartitionFetcher.getInstance(), (ISchemaFetcher)ClusterSchemaFetcher.getInstance(), (long)IoTDBDescriptor.getInstance().getConfig().getQueryTimeoutThreshold(), (boolean)false).status;
            return tSStatus;
        }
        finally {
            SESSION_MANAGER.removeCurrSession();
        }
    }
}

