/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.service;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.iotdb.commons.concurrent.IoTDBThreadPoolFactory;
import org.apache.iotdb.commons.concurrent.threadpool.WrappedThreadPoolExecutor;
import org.apache.iotdb.commons.exception.runtime.RPCServiceException;
import org.apache.thrift.TBaseAsyncProcessor;
import org.apache.thrift.TProcessor;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TProtocolFactory;
import org.apache.thrift.server.THsHaServer;
import org.apache.thrift.server.TServer;
import org.apache.thrift.server.TServerEventHandler;
import org.apache.thrift.server.TThreadPoolServer;
import org.apache.thrift.server.TThreadedSelectorServer;
import org.apache.thrift.transport.TNonblockingServerSocket;
import org.apache.thrift.transport.TNonblockingServerTransport;
import org.apache.thrift.transport.TSSLTransportFactory;
import org.apache.thrift.transport.TServerSocket;
import org.apache.thrift.transport.TServerTransport;
import org.apache.thrift.transport.TTransportException;
import org.apache.thrift.transport.TTransportFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractThriftServiceThread
extends Thread {
    private static final Logger logger = LoggerFactory.getLogger(AbstractThriftServiceThread.class);
    private TServerTransport serverTransport;
    private TServer poolServer;
    private CountDownLatch threadStopLatch;
    private ExecutorService executorService;
    private String serviceName;
    private TProtocolFactory protocolFactory;
    private TTransportFactory transportFactory;
    private static TCompactProtocol.Factory compactProtocolFactory = new TCompactProtocol.Factory();
    private static TBinaryProtocol.Factory binaryProtocolFactory = new TBinaryProtocol.Factory();

    private void initProtocolFactory(boolean compress) {
        this.protocolFactory = AbstractThriftServiceThread.getProtocolFactory(compress);
    }

    public TTransportFactory getTTransportFactory() {
        return this.transportFactory;
    }

    public static TProtocolFactory getProtocolFactory(boolean compress) {
        if (compress) {
            return compactProtocolFactory;
        }
        return binaryProtocolFactory;
    }

    private void catchFailedInitialization(TTransportException e) throws RPCServiceException {
        this.close();
        if (this.threadStopLatch == null) {
            logger.debug("Stop Count Down latch is null");
        } else {
            logger.debug("Stop Count Down latch is {}", (Object)this.threadStopLatch.getCount());
        }
        if (this.threadStopLatch != null && this.threadStopLatch.getCount() == 1L) {
            this.threadStopLatch.countDown();
        }
        logger.debug("{}: close TThreadPoolServer and TServerSocket for {}", (Object)"IoTDB", (Object)this.serviceName);
        throw new RPCServiceException(String.format("%s: failed to start %s, because ", "IoTDB", this.serviceName), e);
    }

    protected AbstractThriftServiceThread(TBaseAsyncProcessor<?> processor, String serviceName, String threadsName, String bindAddress, int port, int selectorThreads, int minWorkerThreads, int maxWorkerThreads, int timeoutSecond, TServerEventHandler serverEventHandler, boolean compress, int connectionTimeoutInMS, int maxReadBufferBytes, ServerType serverType, TTransportFactory transportFactory) {
        this.transportFactory = transportFactory;
        this.initProtocolFactory(compress);
        this.serviceName = serviceName;
        try {
            this.serverTransport = this.openNonblockingTransport(bindAddress, port, connectionTimeoutInMS);
            switch (serverType) {
                case SELECTOR: {
                    TThreadedSelectorServer.Args poolArgs = this.initAsyncedSelectorPoolArgs(processor, threadsName, selectorThreads, minWorkerThreads, maxWorkerThreads, timeoutSecond, maxReadBufferBytes);
                    this.poolServer = new TThreadedSelectorServer(poolArgs);
                    break;
                }
                case HSHA: {
                    THsHaServer.Args poolArgs1 = this.initAsyncedHshaPoolArgs(processor, threadsName, minWorkerThreads, maxWorkerThreads, timeoutSecond, maxReadBufferBytes);
                    this.poolServer = new THsHaServer(poolArgs1);
                    break;
                }
                default: {
                    logger.error("Unexpected serverType {}", (Object)serverType);
                }
            }
            this.poolServer.setServerEventHandler(serverEventHandler);
        }
        catch (TTransportException e) {
            this.catchFailedInitialization(e);
        }
    }

    protected AbstractThriftServiceThread(TProcessor processor, String serviceName, String threadsName, String bindAddress, int port, int maxWorkerThreads, int timeoutSecond, TServerEventHandler serverEventHandler, boolean compress, String keyStorePath, String keyStorePwd, int clientTimeout, TTransportFactory transportFactory) {
        this.transportFactory = transportFactory;
        this.initProtocolFactory(compress);
        this.serviceName = serviceName;
        try {
            TSSLTransportFactory.TSSLTransportParameters params = new TSSLTransportFactory.TSSLTransportParameters();
            params.setKeyStore(keyStorePath, keyStorePwd);
            params.requireClientAuth(false);
            InetSocketAddress socketAddress = new InetSocketAddress(bindAddress, port);
            this.serverTransport = TSSLTransportFactory.getServerSocket((int)socketAddress.getPort(), (int)clientTimeout, (InetAddress)socketAddress.getAddress(), (TSSLTransportFactory.TSSLTransportParameters)params);
            TThreadPoolServer.Args poolArgs = this.initSyncedPoolArgs(processor, threadsName, maxWorkerThreads, timeoutSecond);
            this.poolServer = new TThreadPoolServer(poolArgs);
            this.poolServer.setServerEventHandler(serverEventHandler);
        }
        catch (TTransportException e) {
            this.catchFailedInitialization(e);
        }
    }

    protected AbstractThriftServiceThread(TProcessor processor, String serviceName, String threadsName, String bindAddress, int port, int maxWorkerThreads, int timeoutSecond, TServerEventHandler serverEventHandler, boolean compress, TTransportFactory transportFactory) {
        this.transportFactory = transportFactory;
        this.initProtocolFactory(compress);
        this.serviceName = serviceName;
        try {
            this.serverTransport = this.openTransport(bindAddress, port);
            TThreadPoolServer.Args poolArgs = this.initSyncedPoolArgs(processor, threadsName, maxWorkerThreads, timeoutSecond);
            this.poolServer = new TThreadPoolServer(poolArgs);
            this.poolServer.setServerEventHandler(serverEventHandler);
        }
        catch (TTransportException e) {
            this.catchFailedInitialization(e);
        }
    }

    private TThreadPoolServer.Args initSyncedPoolArgs(TProcessor processor, String threadsName, int maxWorkerThreads, int timeoutSecond) {
        TThreadPoolServer.Args poolArgs = new TThreadPoolServer.Args(this.serverTransport);
        poolArgs.maxWorkerThreads(maxWorkerThreads).minWorkerThreads(Runtime.getRuntime().availableProcessors()).stopTimeoutVal(timeoutSecond);
        poolArgs.executorService = this.executorService = IoTDBThreadPoolFactory.createThriftRpcClientThreadPool(poolArgs, threadsName);
        poolArgs.processor(processor);
        poolArgs.protocolFactory(this.protocolFactory);
        poolArgs.transportFactory(this.getTTransportFactory());
        return poolArgs;
    }

    private TThreadedSelectorServer.Args initAsyncedSelectorPoolArgs(TBaseAsyncProcessor<?> processor, String threadsName, int selectorThreads, int minWorkerThreads, int maxWorkerThreads, int timeoutSecond, int maxReadBufferBytes) {
        TThreadedSelectorServer.Args poolArgs = new TThreadedSelectorServer.Args((TNonblockingServerTransport)this.serverTransport);
        poolArgs.maxReadBufferBytes = maxReadBufferBytes;
        poolArgs.selectorThreads(selectorThreads);
        this.executorService = IoTDBThreadPoolFactory.createThriftRpcClientThreadPool(minWorkerThreads, maxWorkerThreads, timeoutSecond, TimeUnit.SECONDS, threadsName);
        poolArgs.executorService(this.executorService);
        poolArgs.processor(processor);
        poolArgs.protocolFactory(this.protocolFactory);
        poolArgs.transportFactory(this.getTTransportFactory());
        return poolArgs;
    }

    private THsHaServer.Args initAsyncedHshaPoolArgs(TBaseAsyncProcessor<?> processor, String threadsName, int minWorkerThreads, int maxWorkerThreads, int timeoutSecond, int maxReadBufferBytes) {
        THsHaServer.Args poolArgs = new THsHaServer.Args((TNonblockingServerTransport)this.serverTransport);
        poolArgs.maxReadBufferBytes = maxReadBufferBytes;
        this.executorService = IoTDBThreadPoolFactory.createThriftRpcClientThreadPool(minWorkerThreads, maxWorkerThreads, timeoutSecond, TimeUnit.SECONDS, threadsName);
        poolArgs.executorService(this.executorService);
        poolArgs.processor(processor);
        poolArgs.protocolFactory(this.protocolFactory);
        poolArgs.transportFactory(this.getTTransportFactory());
        return poolArgs;
    }

    private TServerTransport openTransport(String bindAddress, int port) throws TTransportException {
        return new TServerSocket(new InetSocketAddress(port));
    }

    private TServerTransport openNonblockingTransport(String bindAddress, int port, int connectionTimeoutInMS) throws TTransportException {
        return new TNonblockingServerSocket(new InetSocketAddress(port), connectionTimeoutInMS);
    }

    public void setThreadStopLatch(CountDownLatch threadStopLatch) {
        this.threadStopLatch = threadStopLatch;
    }

    @Override
    public void run() {
        logger.info("The {} service thread begin to run...", (Object)this.serviceName);
        try {
            this.poolServer.serve();
        }
        catch (Exception e) {
            throw new RPCServiceException(String.format("%s: %s exit, because ", "IoTDB", this.serviceName), e);
        }
        finally {
            this.close();
            if (this.threadStopLatch == null) {
                logger.debug("Stop Count Down latch is null");
            } else {
                logger.debug("Stop Count Down latch is {}", (Object)this.threadStopLatch.getCount());
            }
            if (this.threadStopLatch != null && this.threadStopLatch.getCount() == 1L) {
                this.threadStopLatch.countDown();
            }
            logger.debug("{}: close TThreadPoolServer and TServerSocket for {}", (Object)"IoTDB", (Object)this.serviceName);
        }
    }

    public synchronized void close() {
        if (this.poolServer != null) {
            this.poolServer.setShouldStop(true);
            this.poolServer.stop();
            this.poolServer = null;
        }
        if (this.serverTransport != null) {
            this.serverTransport.close();
            this.serverTransport = null;
        }
        if (this.threadStopLatch != null && this.threadStopLatch.getCount() == 1L) {
            this.threadStopLatch.countDown();
        }
    }

    public boolean isServing() {
        if (this.poolServer != null) {
            return this.poolServer.isServing();
        }
        return false;
    }

    public long getActiveThreadCount() {
        if (this.executorService != null) {
            return ((WrappedThreadPoolExecutor)this.executorService).getActiveCount();
        }
        return -1L;
    }

    public static enum ServerType {
        SELECTOR,
        HSHA;

    }
}

