/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tsfile.file.metadata;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.file.metadata.IChunkMetadata;
import org.apache.tsfile.file.metadata.TimeseriesMetadata;
import org.apache.tsfile.file.metadata.enums.CompressionType;
import org.apache.tsfile.file.metadata.enums.TSEncoding;
import org.apache.tsfile.file.metadata.statistics.Statistics;
import org.apache.tsfile.read.common.TimeRange;
import org.apache.tsfile.read.controller.IChunkLoader;
import org.apache.tsfile.utils.Preconditions;
import org.apache.tsfile.utils.RamUsageEstimator;
import org.apache.tsfile.utils.ReadWriteIOUtils;
import org.apache.tsfile.write.schema.MeasurementSchema;

public class ChunkMetadata
implements IChunkMetadata {
    private static final long INSTANCE_SIZE = RamUsageEstimator.shallowSizeOfInstance(ChunkMetadata.class) + RamUsageEstimator.shallowSizeOfInstance(TSDataType.class) + RamUsageEstimator.shallowSizeOfInstance(ArrayList.class);
    private String measurementUid;
    private long offsetOfChunkHeader;
    private TSDataType tsDataType;
    private TSEncoding encoding;
    private CompressionType compressionType;
    private long version;
    private ArrayList<TimeRange> deleteIntervalList;
    private boolean modified;
    private IChunkLoader chunkLoader;
    private Statistics<? extends Serializable> statistics;
    private static final int CHUNK_METADATA_FIXED_RAM_SIZE = 93;
    private boolean isSeq = true;
    private boolean isClosed;
    private byte mask;

    public ChunkMetadata() {
    }

    public ChunkMetadata(String measurementUid, TSDataType tsDataType, TSEncoding encoding, CompressionType compressionType, long fileOffset, Statistics<? extends Serializable> statistics) {
        this.measurementUid = measurementUid;
        this.tsDataType = tsDataType;
        this.offsetOfChunkHeader = fileOffset;
        this.statistics = statistics;
        this.encoding = encoding;
        this.compressionType = compressionType;
    }

    public ChunkMetadata(ChunkMetadata other) {
        this.measurementUid = other.measurementUid;
        this.offsetOfChunkHeader = other.offsetOfChunkHeader;
        this.tsDataType = other.tsDataType;
        this.version = other.version;
        this.statistics = other.statistics;
        this.isSeq = other.isSeq;
        this.isClosed = other.isClosed;
        this.mask = other.mask;
        this.encoding = other.encoding;
        this.compressionType = other.compressionType;
    }

    public String toString() {
        return String.format("measurementId: %s, datatype: %s, version: %d, Statistics: %s, deleteIntervalList: %s", this.measurementUid, this.tsDataType, this.version, this.statistics, this.deleteIntervalList);
    }

    public long getNumOfPoints() {
        return this.statistics.getCount();
    }

    @Override
    public long getOffsetOfChunkHeader() {
        return this.offsetOfChunkHeader;
    }

    @Override
    public String getMeasurementUid() {
        return this.measurementUid;
    }

    @Override
    public Statistics<? extends Serializable> getStatistics() {
        return this.statistics;
    }

    @Override
    public long getStartTime() {
        return this.statistics.getStartTime();
    }

    @Override
    public long getEndTime() {
        return this.statistics.getEndTime();
    }

    @Override
    public TSDataType getDataType() {
        return this.tsDataType;
    }

    @Override
    public int serializeTo(OutputStream outputStream, boolean serializeStatistic) throws IOException {
        int byteLen = 0;
        byteLen += ReadWriteIOUtils.write(this.offsetOfChunkHeader, outputStream);
        if (serializeStatistic) {
            byteLen += this.statistics.serialize(outputStream);
        }
        return byteLen;
    }

    public int serializedSize(boolean includeStatistics) {
        int cnt = 8;
        if (includeStatistics) {
            cnt += this.statistics.getSerializedSize();
        }
        return cnt;
    }

    public static ChunkMetadata deserializeFrom(ByteBuffer buffer, TimeseriesMetadata timeseriesMetadata) {
        ChunkMetadata chunkMetaData = new ChunkMetadata();
        chunkMetaData.measurementUid = timeseriesMetadata.getMeasurementId();
        chunkMetaData.tsDataType = timeseriesMetadata.getTsDataType();
        chunkMetaData.offsetOfChunkHeader = ReadWriteIOUtils.readLong(buffer);
        chunkMetaData.statistics = (timeseriesMetadata.getTimeSeriesMetadataType() & 0x3F) != 0 ? Statistics.deserialize(buffer, chunkMetaData.tsDataType) : timeseriesMetadata.getStatistics();
        return chunkMetaData;
    }

    public static ChunkMetadata deserializeFrom(InputStream inputStream, TimeseriesMetadata timeseriesMetadata) throws IOException {
        ChunkMetadata chunkMetaData = new ChunkMetadata();
        chunkMetaData.measurementUid = timeseriesMetadata.getMeasurementId();
        chunkMetaData.tsDataType = timeseriesMetadata.getTsDataType();
        chunkMetaData.offsetOfChunkHeader = ReadWriteIOUtils.readLong(inputStream);
        chunkMetaData.statistics = (timeseriesMetadata.getTimeSeriesMetadataType() & 0x3F) != 0 ? Statistics.deserialize(inputStream, chunkMetaData.tsDataType) : timeseriesMetadata.getStatistics();
        return chunkMetaData;
    }

    public static ChunkMetadata deserializeFrom(ByteBuffer buffer, TSDataType dataType) {
        ChunkMetadata chunkMetadata = new ChunkMetadata();
        chunkMetadata.tsDataType = dataType;
        chunkMetadata.offsetOfChunkHeader = ReadWriteIOUtils.readLong(buffer);
        chunkMetadata.statistics = Statistics.deserialize(buffer, dataType);
        return chunkMetadata;
    }

    @Override
    public long getVersion() {
        return this.version;
    }

    @Override
    public void setVersion(long version) {
        this.version = version;
    }

    @Override
    public List<TimeRange> getDeleteIntervalList() {
        return this.deleteIntervalList;
    }

    @Override
    public void insertIntoSortedDeletions(TimeRange timeRange) {
        ArrayList<TimeRange> resultInterval = new ArrayList<TimeRange>();
        long startTime = timeRange.getMin();
        long endTime = timeRange.getMax();
        if (this.deleteIntervalList != null) {
            if (this.deleteIntervalList.get(this.deleteIntervalList.size() - 1).getMax() < timeRange.getMin()) {
                this.deleteIntervalList.add(timeRange);
                return;
            }
            for (int i = 0; i < this.deleteIntervalList.size(); ++i) {
                TimeRange interval = this.deleteIntervalList.get(i);
                if (interval.getMax() < startTime) {
                    resultInterval.add(interval);
                    continue;
                }
                if (interval.getMin() > endTime) {
                    resultInterval.add(new TimeRange(startTime, endTime));
                    resultInterval.addAll(this.deleteIntervalList.subList(i, this.deleteIntervalList.size()));
                    this.deleteIntervalList = resultInterval;
                    return;
                }
                if (interval.getMax() < startTime && interval.getMin() > endTime) continue;
                startTime = Math.min(interval.getMin(), startTime);
                endTime = Math.max(interval.getMax(), endTime);
            }
        }
        resultInterval.add(new TimeRange(startTime, endTime));
        this.deleteIntervalList = resultInterval;
    }

    @Override
    public IChunkLoader getChunkLoader() {
        return this.chunkLoader;
    }

    @Override
    public boolean needSetChunkLoader() {
        return this.chunkLoader == null;
    }

    @Override
    public void setChunkLoader(IChunkLoader chunkLoader) {
        this.chunkLoader = chunkLoader;
    }

    @Override
    public boolean isModified() {
        return this.modified;
    }

    @Override
    public void setModified(boolean modified) {
        this.modified = modified;
    }

    public static long calculateRamSize(String measurementId, TSDataType dataType) {
        return 93L + RamUsageEstimator.sizeOf((String)measurementId) + Statistics.getSizeByType(dataType);
    }

    public void mergeChunkMetadata(ChunkMetadata chunkMetadata) {
        Statistics<? extends Serializable> chunkMetadataStatistics = chunkMetadata.getStatistics();
        this.statistics.mergeStatistics(chunkMetadataStatistics);
    }

    public long getRetainedSizeInBytes() {
        return INSTANCE_SIZE + (this.statistics == null ? 0L : this.statistics.getRetainedSizeInBytes());
    }

    @Override
    public void setSeq(boolean seq) {
        this.isSeq = seq;
    }

    @Override
    public boolean isSeq() {
        return this.isSeq;
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    @Override
    public void setClosed(boolean closed) {
        this.isClosed = closed;
    }

    @Override
    public byte getMask() {
        return this.mask;
    }

    public void setMask(byte mask) {
        this.mask = mask;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ChunkMetadata that = (ChunkMetadata)o;
        return this.offsetOfChunkHeader == that.offsetOfChunkHeader && this.version == that.version && this.isSeq == that.isSeq && this.isClosed == that.isClosed && this.mask == that.mask && Objects.equals(this.measurementUid, that.measurementUid) && this.tsDataType == that.tsDataType && Objects.equals(this.statistics, that.statistics);
    }

    public int hashCode() {
        return Objects.hash(this.measurementUid, this.offsetOfChunkHeader, this.tsDataType, this.version, this.statistics, this.isSeq, this.isClosed, this.mask);
    }

    @Override
    public Statistics<? extends Serializable> getTimeStatistics() {
        return this.getStatistics();
    }

    @Override
    public Optional<Statistics<? extends Serializable>> getMeasurementStatistics(int measurementIndex) {
        Preconditions.checkArgument(measurementIndex == 0, "Non-aligned chunk only has one measurement, but measurementIndex is " + measurementIndex);
        return Optional.ofNullable(this.statistics);
    }

    @Override
    public boolean hasNullValue(int measurementIndex) {
        return false;
    }

    public MeasurementSchema toMeasurementSchema() {
        return new MeasurementSchema(this.measurementUid, this.tsDataType, this.encoding, this.compressionType);
    }
}

