/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.rpc;

import java.nio.ByteBuffer;
import java.sql.Timestamp;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.rpc.IoTDBConnectionException;
import org.apache.iotdb.rpc.RpcUtils;
import org.apache.iotdb.rpc.StatementExecutionException;
import org.apache.iotdb.service.rpc.thrift.IClientRPCService;
import org.apache.iotdb.service.rpc.thrift.TSCloseOperationReq;
import org.apache.iotdb.service.rpc.thrift.TSFetchResultsReq;
import org.apache.iotdb.service.rpc.thrift.TSFetchResultsResp;
import org.apache.thrift.TException;
import org.apache.tsfile.common.conf.TSFileConfig;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.read.common.block.TsBlock;
import org.apache.tsfile.read.common.block.column.TsBlockSerde;
import org.apache.tsfile.utils.Binary;
import org.apache.tsfile.utils.BytesUtils;
import org.apache.tsfile.utils.DateUtils;

public class IoTDBRpcDataSet {
    private static final String TIMESTAMP_STR = "Time";
    private static final TsBlockSerde SERDE = new TsBlockSerde();
    private final String sql;
    private boolean isClosed = false;
    private IClientRPCService.Iface client;
    private final List<String> columnNameList;
    private final List<String> columnTypeList;
    private final Map<String, Integer> columnOrdinalMap;
    private final Map<String, Integer> columnName2TsBlockColumnIndexMap;
    private final List<Integer> columnIndex2TsBlockColumnIndexList;
    private final List<TSDataType> dataTypeForTsBlockColumn;
    private int fetchSize;
    private final long timeout;
    private boolean hasCachedRecord = false;
    private boolean lastReadWasNull;
    private final long sessionId;
    private final long queryId;
    private final long statementId;
    private long time;
    private final boolean ignoreTimeStamp;
    private boolean moreData;
    private List<ByteBuffer> queryResult;
    private TsBlock curTsBlock;
    private int queryResultSize;
    private int queryResultIndex;
    private int tsBlockSize;
    private int tsBlockIndex;
    private final ZoneId zoneId;
    private final String timeFormat;
    private final int timeFactor;
    private final String timePrecision;

    public IoTDBRpcDataSet(String sql, List<String> columnNameList, List<String> columnTypeList, Map<String, Integer> columnNameIndex, boolean ignoreTimeStamp, boolean moreData, long queryId, long statementId, IClientRPCService.Iface client, long sessionId, List<ByteBuffer> queryResult, int fetchSize, long timeout, ZoneId zoneId, String timeFormat, int timeFactor, boolean tableModel, List<Integer> columnIndex2TsBlockColumnIndexList) {
        int i;
        this.sessionId = sessionId;
        this.statementId = statementId;
        this.ignoreTimeStamp = ignoreTimeStamp;
        this.sql = sql;
        this.queryId = queryId;
        this.client = client;
        this.fetchSize = fetchSize;
        this.timeout = timeout;
        this.moreData = moreData;
        this.columnNameList = new ArrayList<String>();
        this.columnTypeList = new ArrayList<String>();
        this.columnOrdinalMap = new HashMap<String, Integer>();
        this.columnName2TsBlockColumnIndexMap = new HashMap<String, Integer>();
        int columnStartIndex = 1;
        int resultSetColumnSize = columnNameList.size();
        int startIndexForColumnIndex2TsBlockColumnIndexList = 0;
        if (!ignoreTimeStamp) {
            this.columnNameList.add(TIMESTAMP_STR);
            this.columnTypeList.add(String.valueOf(TSDataType.INT64));
            this.columnName2TsBlockColumnIndexMap.put(TIMESTAMP_STR, -1);
            this.columnOrdinalMap.put(TIMESTAMP_STR, 1);
            if (columnIndex2TsBlockColumnIndexList != null) {
                columnIndex2TsBlockColumnIndexList.add(0, -1);
                startIndexForColumnIndex2TsBlockColumnIndexList = 1;
            }
            ++columnStartIndex;
            ++resultSetColumnSize;
        }
        if (columnIndex2TsBlockColumnIndexList == null) {
            columnIndex2TsBlockColumnIndexList = new ArrayList<Integer>(resultSetColumnSize);
            if (!ignoreTimeStamp) {
                startIndexForColumnIndex2TsBlockColumnIndexList = 1;
                columnIndex2TsBlockColumnIndexList.add(-1);
            }
            int size = columnNameList.size();
            for (int i2 = 0; i2 < size; ++i2) {
                columnIndex2TsBlockColumnIndexList.add(i2);
            }
        }
        int tsBlockColumnSize = columnIndex2TsBlockColumnIndexList.stream().mapToInt(Integer::intValue).max().orElse(0) + 1;
        this.dataTypeForTsBlockColumn = new ArrayList<TSDataType>(tsBlockColumnSize);
        for (i = 0; i < tsBlockColumnSize; ++i) {
            this.dataTypeForTsBlockColumn.add(null);
        }
        int size = columnNameList.size();
        for (i = 0; i < size; ++i) {
            String name = columnNameList.get(i);
            this.columnNameList.add(name);
            this.columnTypeList.add(columnTypeList.get(i));
            int tsBlockColumnIndex = columnIndex2TsBlockColumnIndexList.get(startIndexForColumnIndex2TsBlockColumnIndexList + i);
            if (tsBlockColumnIndex != -1) {
                TSDataType columnType = TSDataType.valueOf((String)columnTypeList.get(i));
                this.dataTypeForTsBlockColumn.set(tsBlockColumnIndex, columnType);
            }
            if (this.columnName2TsBlockColumnIndexMap.containsKey(name)) continue;
            this.columnOrdinalMap.put(name, i + columnStartIndex);
            this.columnName2TsBlockColumnIndexMap.put(name, tsBlockColumnIndex);
        }
        this.queryResult = queryResult;
        this.queryResultSize = 0;
        if (queryResult != null) {
            this.queryResultSize = queryResult.size();
        }
        this.queryResultIndex = 0;
        this.tsBlockSize = 0;
        this.tsBlockIndex = -1;
        this.zoneId = zoneId;
        this.timeFormat = timeFormat;
        this.timeFactor = timeFactor;
        this.timePrecision = RpcUtils.getTimePrecision(timeFactor);
        if (columnIndex2TsBlockColumnIndexList.size() != this.columnNameList.size()) {
            throw new IllegalArgumentException(String.format("Size of columnIndex2TsBlockColumnIndexList %s doesn't equal to size of columnNameList %s.", columnIndex2TsBlockColumnIndexList.size(), this.columnNameList.size()));
        }
        this.columnIndex2TsBlockColumnIndexList = columnIndex2TsBlockColumnIndexList;
    }

    public void close() throws StatementExecutionException, TException {
        if (this.isClosed) {
            return;
        }
        if (this.client != null) {
            try {
                TSCloseOperationReq closeReq = new TSCloseOperationReq(this.sessionId);
                closeReq.setStatementId(this.statementId);
                closeReq.setQueryId(this.queryId);
                TSStatus closeResp = this.client.closeOperation(closeReq);
                RpcUtils.verifySuccess(closeResp);
            }
            catch (StatementExecutionException e) {
                throw new StatementExecutionException("Error occurs for close operation in server side because ", e);
            }
            catch (TException e) {
                throw new TException("Error occurs when connecting to server for close operation ", (Throwable)e);
            }
        }
        this.client = null;
        this.isClosed = true;
    }

    public boolean next() throws StatementExecutionException, IoTDBConnectionException {
        if (this.hasCachedBlock()) {
            this.lastReadWasNull = false;
            this.constructOneRow();
            return true;
        }
        if (this.hasCachedByteBuffer()) {
            this.constructOneTsBlock();
            this.constructOneRow();
            return true;
        }
        if (this.moreData && this.fetchResults() && this.hasCachedByteBuffer()) {
            this.constructOneTsBlock();
            this.constructOneRow();
            return true;
        }
        try {
            this.close();
            return false;
        }
        catch (TException e) {
            throw new IoTDBConnectionException("Cannot close dataset, because of network connection: {} ", e);
        }
    }

    public boolean fetchResults() throws StatementExecutionException, IoTDBConnectionException {
        if (this.isClosed) {
            throw new IoTDBConnectionException("This DataSet is already closed");
        }
        TSFetchResultsReq req = new TSFetchResultsReq(this.sessionId, this.sql, this.fetchSize, this.queryId, true);
        req.setTimeout(this.timeout);
        try {
            TSFetchResultsResp resp = this.client.fetchResultsV2(req);
            RpcUtils.verifySuccess(resp.getStatus());
            this.moreData = resp.moreData;
            if (!resp.hasResultSet) {
                this.close();
            } else {
                this.queryResult = resp.getQueryResult();
                this.queryResultIndex = 0;
                this.queryResultSize = 0;
                if (this.queryResult != null) {
                    this.queryResultSize = this.queryResult.size();
                }
                this.tsBlockSize = 0;
                this.tsBlockIndex = -1;
            }
            return resp.hasResultSet;
        }
        catch (TException e) {
            throw new IoTDBConnectionException("Cannot fetch result from server, because of network connection: {} ", e);
        }
    }

    public boolean hasCachedBlock() {
        return this.curTsBlock != null && this.tsBlockIndex < this.tsBlockSize - 1;
    }

    public boolean hasCachedByteBuffer() {
        return this.queryResult != null && this.queryResultIndex < this.queryResultSize;
    }

    public void constructOneRow() {
        ++this.tsBlockIndex;
        this.hasCachedRecord = true;
        this.time = this.curTsBlock.getTimeColumn().getLong(this.tsBlockIndex);
    }

    public void constructOneTsBlock() {
        this.lastReadWasNull = false;
        ByteBuffer byteBuffer = this.queryResult.get(this.queryResultIndex);
        ++this.queryResultIndex;
        this.curTsBlock = SERDE.deserialize(byteBuffer);
        this.tsBlockIndex = -1;
        this.tsBlockSize = this.curTsBlock.getPositionCount();
    }

    public boolean isNull(int columnIndex) throws StatementExecutionException {
        return this.isNull(this.getTsBlockColumnIndexForColumnIndex(columnIndex), this.tsBlockIndex);
    }

    public boolean isNull(String columnName) {
        return this.isNull(this.getTsBlockColumnIndexForColumnName(columnName), this.tsBlockIndex);
    }

    private boolean isNull(int index, int rowNum) {
        return index >= 0 && this.curTsBlock.getColumn(index).isNull(rowNum);
    }

    public boolean getBoolean(int columnIndex) throws StatementExecutionException {
        return this.getBooleanByTsBlockColumnIndex(this.getTsBlockColumnIndexForColumnIndex(columnIndex));
    }

    public boolean getBoolean(String columnName) throws StatementExecutionException {
        return this.getBooleanByTsBlockColumnIndex(this.getTsBlockColumnIndexForColumnName(columnName));
    }

    private boolean getBooleanByTsBlockColumnIndex(int tsBlockColumnIndex) throws StatementExecutionException {
        this.checkRecord();
        if (!this.isNull(tsBlockColumnIndex, this.tsBlockIndex)) {
            this.lastReadWasNull = false;
            return this.curTsBlock.getColumn(tsBlockColumnIndex).getBoolean(this.tsBlockIndex);
        }
        this.lastReadWasNull = true;
        return false;
    }

    public double getDouble(int columnIndex) throws StatementExecutionException {
        return this.getDoubleByTsBlockColumnIndex(this.getTsBlockColumnIndexForColumnIndex(columnIndex));
    }

    public double getDouble(String columnName) throws StatementExecutionException {
        return this.getDoubleByTsBlockColumnIndex(this.getTsBlockColumnIndexForColumnName(columnName));
    }

    private double getDoubleByTsBlockColumnIndex(int tsBlockColumnIndex) throws StatementExecutionException {
        this.checkRecord();
        if (!this.isNull(tsBlockColumnIndex, this.tsBlockIndex)) {
            this.lastReadWasNull = false;
            return this.curTsBlock.getColumn(tsBlockColumnIndex).getDouble(this.tsBlockIndex);
        }
        this.lastReadWasNull = true;
        return 0.0;
    }

    public float getFloat(int columnIndex) throws StatementExecutionException {
        return this.getFloatByTsBlockColumnIndex(this.getTsBlockColumnIndexForColumnIndex(columnIndex));
    }

    public float getFloat(String columnName) throws StatementExecutionException {
        return this.getFloatByTsBlockColumnIndex(this.getTsBlockColumnIndexForColumnName(columnName));
    }

    private float getFloatByTsBlockColumnIndex(int tsBlockColumnIndex) throws StatementExecutionException {
        this.checkRecord();
        if (!this.isNull(tsBlockColumnIndex, this.tsBlockIndex)) {
            this.lastReadWasNull = false;
            return this.curTsBlock.getColumn(tsBlockColumnIndex).getFloat(this.tsBlockIndex);
        }
        this.lastReadWasNull = true;
        return 0.0f;
    }

    public int getInt(int columnIndex) throws StatementExecutionException {
        return this.getIntByTsBlockColumnIndex(this.getTsBlockColumnIndexForColumnIndex(columnIndex));
    }

    public int getInt(String columnName) throws StatementExecutionException {
        return this.getIntByTsBlockColumnIndex(this.getTsBlockColumnIndexForColumnName(columnName));
    }

    private int getIntByTsBlockColumnIndex(int tsBlockColumnIndex) throws StatementExecutionException {
        this.checkRecord();
        if (!this.isNull(tsBlockColumnIndex, this.tsBlockIndex)) {
            this.lastReadWasNull = false;
            TSDataType type = this.curTsBlock.getColumn(tsBlockColumnIndex).getDataType();
            if (type == TSDataType.INT64) {
                return (int)this.curTsBlock.getColumn(tsBlockColumnIndex).getLong(this.tsBlockIndex);
            }
            return this.curTsBlock.getColumn(tsBlockColumnIndex).getInt(this.tsBlockIndex);
        }
        this.lastReadWasNull = true;
        return 0;
    }

    public long getLong(int columnIndex) throws StatementExecutionException {
        return this.getLongByTsBlockColumnIndex(this.getTsBlockColumnIndexForColumnIndex(columnIndex));
    }

    public long getLong(String columnName) throws StatementExecutionException {
        int index = this.getTsBlockColumnIndexForColumnName(columnName);
        return this.getLongByTsBlockColumnIndex(index);
    }

    private long getLongByTsBlockColumnIndex(int tsBlockColumnIndex) throws StatementExecutionException {
        this.checkRecord();
        if (tsBlockColumnIndex < 0) {
            this.lastReadWasNull = false;
            return this.curTsBlock.getTimeByIndex(this.tsBlockIndex);
        }
        if (!this.isNull(tsBlockColumnIndex, this.tsBlockIndex)) {
            this.lastReadWasNull = false;
            TSDataType type = this.curTsBlock.getColumn(tsBlockColumnIndex).getDataType();
            if (type == TSDataType.INT32) {
                return this.curTsBlock.getColumn(tsBlockColumnIndex).getInt(this.tsBlockIndex);
            }
            return this.curTsBlock.getColumn(tsBlockColumnIndex).getLong(this.tsBlockIndex);
        }
        this.lastReadWasNull = true;
        return 0L;
    }

    public Binary getBinary(int columIndex) throws StatementExecutionException {
        return this.getBinaryTsBlockColumnIndex(this.getTsBlockColumnIndexForColumnIndex(columIndex));
    }

    public Binary getBinary(String columnName) throws StatementExecutionException {
        return this.getBinaryTsBlockColumnIndex(this.getTsBlockColumnIndexForColumnName(columnName));
    }

    private Binary getBinaryTsBlockColumnIndex(int tsBlockColumnIndex) throws StatementExecutionException {
        this.checkRecord();
        if (!this.isNull(tsBlockColumnIndex, this.tsBlockIndex)) {
            this.lastReadWasNull = false;
            return this.curTsBlock.getColumn(tsBlockColumnIndex).getBinary(this.tsBlockIndex);
        }
        this.lastReadWasNull = true;
        return null;
    }

    public Object getObject(int columnIndex) throws StatementExecutionException {
        return this.getObjectByTsBlockIndex(this.getTsBlockColumnIndexForColumnIndex(columnIndex));
    }

    public Object getObject(String columnName) throws StatementExecutionException {
        return this.getObjectByTsBlockIndex(this.getTsBlockColumnIndexForColumnName(columnName));
    }

    private Object getObjectByTsBlockIndex(int tsBlockColumnIndex) throws StatementExecutionException {
        this.checkRecord();
        if (this.isNull(tsBlockColumnIndex, this.tsBlockIndex)) {
            this.lastReadWasNull = true;
            return null;
        }
        this.lastReadWasNull = false;
        TSDataType tsDataType = this.getDataTypeByTsBlockColumnIndex(tsBlockColumnIndex);
        switch (tsDataType) {
            case BOOLEAN: 
            case INT32: 
            case INT64: 
            case FLOAT: 
            case DOUBLE: {
                return this.curTsBlock.getColumn(tsBlockColumnIndex).getObject(this.tsBlockIndex);
            }
            case TIMESTAMP: {
                long timestamp = tsBlockColumnIndex == -1 ? this.curTsBlock.getTimeByIndex(this.tsBlockIndex) : this.curTsBlock.getColumn(tsBlockColumnIndex).getLong(this.tsBlockIndex);
                return RpcUtils.convertToTimestamp(timestamp, this.timeFactor);
            }
            case TEXT: 
            case STRING: {
                return this.curTsBlock.getColumn(tsBlockColumnIndex).getBinary(this.tsBlockIndex).getStringValue(TSFileConfig.STRING_CHARSET);
            }
            case BLOB: {
                return BytesUtils.parseBlobByteArrayToString((byte[])this.curTsBlock.getColumn(tsBlockColumnIndex).getBinary(this.tsBlockIndex).getValues());
            }
            case DATE: {
                return DateUtils.formatDate((int)this.curTsBlock.getColumn(tsBlockColumnIndex).getInt(this.tsBlockIndex));
            }
        }
        return null;
    }

    public String getString(int columnIndex) throws StatementExecutionException {
        return this.getStringByTsBlockColumnIndex(this.getTsBlockColumnIndexForColumnIndex(columnIndex));
    }

    public String getString(String columnName) throws StatementExecutionException {
        return this.getStringByTsBlockColumnIndex(this.getTsBlockColumnIndexForColumnName(columnName));
    }

    private String getStringByTsBlockColumnIndex(int tsBlockColumnIndex) throws StatementExecutionException {
        this.checkRecord();
        if (tsBlockColumnIndex == -1) {
            return String.valueOf(this.curTsBlock.getTimeByIndex(this.tsBlockIndex));
        }
        if (this.isNull(tsBlockColumnIndex, this.tsBlockIndex)) {
            this.lastReadWasNull = true;
            return null;
        }
        this.lastReadWasNull = false;
        return this.getString(tsBlockColumnIndex, this.getDataTypeByTsBlockColumnIndex(tsBlockColumnIndex));
    }

    private String getString(int index, TSDataType tsDataType) {
        switch (tsDataType) {
            case BOOLEAN: {
                return String.valueOf(this.curTsBlock.getColumn(index).getBoolean(this.tsBlockIndex));
            }
            case INT32: {
                return String.valueOf(this.curTsBlock.getColumn(index).getInt(this.tsBlockIndex));
            }
            case INT64: {
                return String.valueOf(index == -1 ? this.curTsBlock.getTimeByIndex(this.tsBlockIndex) : this.curTsBlock.getColumn(index).getLong(this.tsBlockIndex));
            }
            case TIMESTAMP: {
                long timestamp = index == -1 ? this.curTsBlock.getTimeByIndex(this.tsBlockIndex) : this.curTsBlock.getColumn(index).getLong(this.tsBlockIndex);
                return RpcUtils.formatDatetime(this.timeFormat, this.timePrecision, timestamp, this.zoneId);
            }
            case FLOAT: {
                return String.valueOf(this.curTsBlock.getColumn(index).getFloat(this.tsBlockIndex));
            }
            case DOUBLE: {
                return String.valueOf(this.curTsBlock.getColumn(index).getDouble(this.tsBlockIndex));
            }
            case TEXT: 
            case STRING: {
                return this.curTsBlock.getColumn(index).getBinary(this.tsBlockIndex).getStringValue(TSFileConfig.STRING_CHARSET);
            }
            case BLOB: {
                return BytesUtils.parseBlobByteArrayToString((byte[])this.curTsBlock.getColumn(index).getBinary(this.tsBlockIndex).getValues());
            }
            case DATE: {
                return DateUtils.formatDate((int)this.curTsBlock.getColumn(index).getInt(this.tsBlockIndex));
            }
        }
        return null;
    }

    public Timestamp getTimestamp(int columnIndex) throws StatementExecutionException {
        return this.getTimestampByTsBlockColumnIndex(this.getTsBlockColumnIndexForColumnIndex(columnIndex));
    }

    public Timestamp getTimestamp(String columnName) throws StatementExecutionException {
        return this.getTimestampByTsBlockColumnIndex(this.getTsBlockColumnIndexForColumnName(columnName));
    }

    private Timestamp getTimestampByTsBlockColumnIndex(int tsBlockColumnIndex) throws StatementExecutionException {
        long timestamp = this.getLongByTsBlockColumnIndex(tsBlockColumnIndex);
        return RpcUtils.convertToTimestamp(timestamp, this.timeFactor);
    }

    public TSDataType getDataType(int columnIndex) {
        return this.getDataTypeByTsBlockColumnIndex(this.getTsBlockColumnIndexForColumnIndex(columnIndex));
    }

    public TSDataType getDataType(String columnName) {
        return this.getDataTypeByTsBlockColumnIndex(this.getTsBlockColumnIndexForColumnName(columnName));
    }

    private TSDataType getDataTypeByTsBlockColumnIndex(int tsBlockColumnIndex) {
        return tsBlockColumnIndex < 0 ? TSDataType.TIMESTAMP : this.dataTypeForTsBlockColumn.get(tsBlockColumnIndex);
    }

    public int findColumn(String columnName) {
        return this.columnOrdinalMap.get(columnName);
    }

    public String findColumnNameByIndex(int columnIndex) throws StatementExecutionException {
        if (columnIndex <= 0) {
            throw new StatementExecutionException("column index should start from 1");
        }
        if (columnIndex > this.columnNameList.size()) {
            throw new StatementExecutionException(String.format("column index %d out of range %d", columnIndex, this.columnNameList.size()));
        }
        return this.columnNameList.get(columnIndex - 1);
    }

    private int getTsBlockColumnIndexForColumnName(String columnName) {
        Integer index = this.columnName2TsBlockColumnIndexMap.get(columnName);
        if (index == null) {
            throw new IllegalArgumentException("Unknown column name: " + columnName);
        }
        return index;
    }

    private int getTsBlockColumnIndexForColumnIndex(int columnIndex) {
        return this.columnIndex2TsBlockColumnIndexList.get(columnIndex - 1);
    }

    public void checkRecord() throws StatementExecutionException {
        if (this.queryResultIndex > this.queryResultSize || this.tsBlockIndex >= this.tsBlockSize || this.queryResult == null || this.curTsBlock == null) {
            throw new StatementExecutionException("No record remains");
        }
    }

    public int getValueColumnStartIndex() {
        return this.ignoreTimeStamp ? 0 : 1;
    }

    public int getColumnSize() {
        return this.columnNameList.size();
    }

    public List<String> getColumnTypeList() {
        return this.columnTypeList;
    }

    public List<String> getColumnNameList() {
        return this.columnNameList;
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    public int getFetchSize() {
        return this.fetchSize;
    }

    public void setFetchSize(int fetchSize) {
        this.fetchSize = fetchSize;
    }

    public boolean hasCachedRecord() {
        return this.hasCachedRecord;
    }

    public void setHasCachedRecord(boolean hasCachedRecord) {
        this.hasCachedRecord = hasCachedRecord;
    }

    public boolean isLastReadWasNull() {
        return this.lastReadWasNull;
    }

    public long getCurrentRowTime() {
        return this.time;
    }

    public boolean isIgnoreTimeStamp() {
        return this.ignoreTimeStamp;
    }
}

