/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.consensus.pipe.metric;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.iotdb.consensus.pipe.consensuspipe.ConsensusPipeConnector;

public class PipeConsensusSyncLagManager {
    long syncLag = Long.MIN_VALUE;
    ReentrantLock lock = new ReentrantLock();
    List<ConsensusPipeConnector> consensusPipeConnectorList = new ArrayList<ConsensusPipeConnector>();

    private long getSyncLagForSpecificConsensusPipe(ConsensusPipeConnector consensusPipeConnector) {
        long userWriteProgress = consensusPipeConnector.getConsensusPipeCommitProgress();
        long replicateProgress = consensusPipeConnector.getConsensusPipeReplicateProgress();
        return Math.max(userWriteProgress - replicateProgress, 0L);
    }

    public void addConsensusPipeConnector(ConsensusPipeConnector consensusPipeConnector) {
        try {
            this.lock.lock();
            this.consensusPipeConnectorList.add(consensusPipeConnector);
        }
        finally {
            this.lock.unlock();
        }
    }

    public void removeConsensusPipeConnector(ConsensusPipeConnector connector) {
        try {
            this.lock.lock();
            this.consensusPipeConnectorList.remove(connector);
        }
        finally {
            this.lock.unlock();
        }
    }

    public long calculateSyncLag() {
        try {
            this.lock.lock();
            if (this.consensusPipeConnectorList.isEmpty()) {
                long l = 0L;
                return l;
            }
            this.syncLag = Long.MIN_VALUE;
            this.consensusPipeConnectorList.forEach(consensusPipeConnector -> {
                this.syncLag = Math.max(this.syncLag, this.getSyncLagForSpecificConsensusPipe((ConsensusPipeConnector)consensusPipeConnector));
            });
            long l = this.syncLag;
            return l;
        }
        finally {
            this.lock.unlock();
        }
    }

    private PipeConsensusSyncLagManager() {
    }

    public static PipeConsensusSyncLagManager getInstance(String groupId) {
        return PipeConsensusSyncLagManagerHolder.CONSENSU_GROUP_ID_2_INSTANCE_MAP.computeIfAbsent(groupId, key -> new PipeConsensusSyncLagManager());
    }

    public static void release(String groupId) {
        PipeConsensusSyncLagManagerHolder.CONSENSU_GROUP_ID_2_INSTANCE_MAP.remove(groupId);
    }

    public static void build() {
        PipeConsensusSyncLagManagerHolder.build();
    }

    private static class PipeConsensusSyncLagManagerHolder {
        private static Map<String, PipeConsensusSyncLagManager> CONSENSU_GROUP_ID_2_INSTANCE_MAP;

        private PipeConsensusSyncLagManagerHolder() {
        }

        private static void build() {
            if (CONSENSU_GROUP_ID_2_INSTANCE_MAP == null) {
                CONSENSU_GROUP_ID_2_INSTANCE_MAP = new ConcurrentHashMap<String, PipeConsensusSyncLagManager>();
            }
        }
    }
}

