/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.procedure.impl.schema.table;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Objects;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.exception.IoTDBException;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.schema.table.TsTable;
import org.apache.iotdb.commons.schema.table.column.TsTableColumnSchema;
import org.apache.iotdb.commons.schema.table.column.TsTableColumnSchemaUtil;
import org.apache.iotdb.confignode.procedure.env.ConfigNodeProcedureEnv;
import org.apache.iotdb.confignode.procedure.exception.ProcedureException;
import org.apache.iotdb.confignode.procedure.exception.ProcedureSuspendedException;
import org.apache.iotdb.confignode.procedure.exception.ProcedureYieldException;
import org.apache.iotdb.confignode.procedure.impl.StateMachineProcedure;
import org.apache.iotdb.confignode.procedure.impl.schema.table.AbstractAlterOrDropTableProcedure;
import org.apache.iotdb.confignode.procedure.state.schema.AddTableColumnState;
import org.apache.iotdb.confignode.procedure.store.ProcedureType;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.tsfile.utils.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddTableColumnProcedure
extends AbstractAlterOrDropTableProcedure<AddTableColumnState> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AddTableColumnProcedure.class);
    private List<TsTableColumnSchema> addedColumnList;

    public AddTableColumnProcedure() {
    }

    public AddTableColumnProcedure(String database, String tableName, String queryId, List<TsTableColumnSchema> addedColumnList) {
        super(database, tableName, queryId);
        this.addedColumnList = addedColumnList;
    }

    /*
     * Exception decompiling
     */
    @Override
    protected StateMachineProcedure.Flow executeFromState(ConfigNodeProcedureEnv env, AddTableColumnState state) throws ProcedureSuspendedException, ProcedureYieldException, InterruptedException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void columnCheck(ConfigNodeProcedureEnv env) {
        try {
            Pair<TSStatus, TsTable> result = env.getConfigManager().getClusterSchemaManager().tableColumnCheckForColumnExtension(this.database, this.tableName, this.addedColumnList);
            TSStatus status = (TSStatus)result.getLeft();
            if (status.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                this.setFailure(new ProcedureException((Throwable)new IoTDBException(status.getMessage(), status.getCode())));
                return;
            }
            this.table = (TsTable)result.getRight();
            this.setNextState(AddTableColumnState.PRE_RELEASE);
        }
        catch (MetadataException e) {
            this.setFailure(new ProcedureException(e));
        }
    }

    @Override
    protected void preRelease(ConfigNodeProcedureEnv env) {
        super.preRelease(env);
        this.setNextState(AddTableColumnState.ADD_COLUMN);
    }

    private void addColumn(ConfigNodeProcedureEnv env) {
        TSStatus status = env.getConfigManager().getClusterSchemaManager().addTableColumn(this.database, this.tableName, this.addedColumnList);
        if (status.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            this.setFailure(new ProcedureException((Throwable)new IoTDBException(status.getMessage(), status.getCode())));
        } else {
            this.setNextState(AddTableColumnState.COMMIT_RELEASE);
        }
    }

    @Override
    protected String getActionMessage() {
        return "add table column";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void rollbackState(ConfigNodeProcedureEnv env, AddTableColumnState state) throws IOException, InterruptedException, ProcedureException {
        long startTime = System.currentTimeMillis();
        try {
            switch (state) {
                case ADD_COLUMN: {
                    LOGGER.info("Start rollback Add column to table {}.{} when adding column", (Object)this.database, (Object)this.table.getTableName());
                    this.rollbackAddColumn(env);
                    return;
                }
                case PRE_RELEASE: {
                    LOGGER.info("Start rollback pre release info of table {}.{}", (Object)this.database, (Object)this.table.getTableName());
                    this.rollbackPreRelease(env);
                    return;
                }
            }
            return;
        }
        finally {
            LOGGER.info("Rollback DropTable-{} costs {}ms.", (Object)state, (Object)(System.currentTimeMillis() - startTime));
        }
    }

    private void rollbackAddColumn(ConfigNodeProcedureEnv env) {
        if (this.table == null) {
            return;
        }
        TSStatus status = env.getConfigManager().getClusterSchemaManager().rollbackAddTableColumn(this.database, this.tableName, this.addedColumnList);
        if (status.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            this.setFailure(new ProcedureException((Throwable)new IoTDBException(status.getMessage(), status.getCode())));
        }
    }

    @Override
    protected AddTableColumnState getState(int stateId) {
        return AddTableColumnState.values()[stateId];
    }

    @Override
    protected int getStateId(AddTableColumnState state) {
        return state.ordinal();
    }

    @Override
    protected AddTableColumnState getInitialState() {
        return AddTableColumnState.COLUMN_CHECK;
    }

    @Override
    public void serialize(DataOutputStream stream) throws IOException {
        stream.writeShort(ProcedureType.ADD_TABLE_COLUMN_PROCEDURE.getTypeCode());
        super.serialize(stream);
        TsTableColumnSchemaUtil.serialize(this.addedColumnList, (OutputStream)stream);
    }

    @Override
    public void deserialize(ByteBuffer byteBuffer) {
        super.deserialize(byteBuffer);
        this.addedColumnList = TsTableColumnSchemaUtil.deserializeColumnSchemaList((ByteBuffer)byteBuffer);
    }

    @Override
    public boolean equals(Object o) {
        return super.equals(o) && Objects.equals(this.addedColumnList, ((AddTableColumnProcedure)o).addedColumnList);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.addedColumnList);
    }
}

