/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.consensus.request.write.table;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.apache.iotdb.confignode.consensus.request.ConfigPhysicalPlan;
import org.apache.iotdb.confignode.consensus.request.ConfigPhysicalPlanType;
import org.apache.tsfile.utils.ReadWriteIOUtils;

abstract class AbstractTablePlan
extends ConfigPhysicalPlan {
    private String database;
    private String tableName;

    protected AbstractTablePlan(ConfigPhysicalPlanType type) {
        super(type);
    }

    protected AbstractTablePlan(ConfigPhysicalPlanType type, String database, String tableName) {
        super(type);
        this.database = database;
        this.tableName = tableName;
    }

    public String getDatabase() {
        return this.database;
    }

    public String getTableName() {
        return this.tableName;
    }

    @Override
    protected void serializeImpl(DataOutputStream stream) throws IOException {
        stream.writeShort(this.getType().getPlanType());
        ReadWriteIOUtils.write((String)this.database, (OutputStream)stream);
        ReadWriteIOUtils.write((String)this.tableName, (OutputStream)stream);
    }

    @Override
    protected void deserializeImpl(ByteBuffer buffer) throws IOException {
        this.database = ReadWriteIOUtils.readString((ByteBuffer)buffer);
        this.tableName = ReadWriteIOUtils.readString((ByteBuffer)buffer);
    }
}

