/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tsfile.write.v4;

import java.io.File;
import java.io.IOException;
import org.apache.tsfile.annotations.TsFileApi;
import org.apache.tsfile.file.metadata.TableSchema;
import org.apache.tsfile.write.v4.DeviceTableModelWriter;
import org.apache.tsfile.write.v4.ITsFileWriter;

public class TsFileWriterBuilder {
    private static final long defaultMemoryThresholdInByte = 0x2000000L;
    private File file;
    private TableSchema tableSchema;
    private long memoryThresholdInByte = 0x2000000L;

    @TsFileApi
    public ITsFileWriter build() throws IOException {
        this.validateParameters();
        return new DeviceTableModelWriter(this.file, this.tableSchema, this.memoryThresholdInByte);
    }

    @TsFileApi
    public TsFileWriterBuilder file(File file) {
        this.file = file;
        return this;
    }

    @TsFileApi
    public TsFileWriterBuilder tableSchema(TableSchema schema) {
        this.tableSchema = schema;
        return this;
    }

    @TsFileApi
    public TsFileWriterBuilder memoryThreshold(long memoryThreshold) {
        this.memoryThresholdInByte = memoryThreshold;
        return this;
    }

    private void validateParameters() {
        if (this.file == null || this.file.isDirectory()) {
            throw new IllegalArgumentException("The file must be a non-null and non-directory File.");
        }
        if (this.tableSchema == null) {
            throw new IllegalArgumentException("TableSchema must not be null.");
        }
        if (this.memoryThresholdInByte <= 0L) {
            throw new IllegalArgumentException("Memory threshold must be > 0 bytes.");
        }
    }
}

