/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.udf.access;

import java.time.LocalDate;
import java.util.Iterator;
import java.util.List;
import org.apache.iotdb.commons.udf.utils.UDFDataTypeTransformer;
import org.apache.iotdb.udf.api.relational.access.Record;
import org.apache.iotdb.udf.api.type.Type;
import org.apache.tsfile.block.column.Column;
import org.apache.tsfile.common.conf.TSFileConfig;
import org.apache.tsfile.utils.Binary;
import org.apache.tsfile.utils.DateUtils;

public class RecordIterator
implements Iterator<Record> {
    private final List<Column> childrenColumns;
    private final List<org.apache.tsfile.read.common.type.Type> dataTypes;
    private final int positionCount;
    private int currentIndex;

    public RecordIterator(List<Column> childrenColumns, List<org.apache.tsfile.read.common.type.Type> dataTypes, int positionCount) {
        this.childrenColumns = childrenColumns;
        this.dataTypes = dataTypes;
        this.positionCount = positionCount;
        if (childrenColumns.size() != dataTypes.size()) {
            throw new IllegalArgumentException("The size of childrenColumns and dataTypes should be the same.");
        }
    }

    @Override
    public boolean hasNext() {
        return this.currentIndex < this.positionCount;
    }

    @Override
    public Record next() {
        final int index = this.currentIndex++;
        return new Record(){

            public int getInt(int columnIndex) {
                return ((Column)RecordIterator.this.childrenColumns.get(columnIndex)).getInt(index);
            }

            public long getLong(int columnIndex) {
                return ((Column)RecordIterator.this.childrenColumns.get(columnIndex)).getLong(index);
            }

            public float getFloat(int columnIndex) {
                return ((Column)RecordIterator.this.childrenColumns.get(columnIndex)).getFloat(index);
            }

            public double getDouble(int columnIndex) {
                return ((Column)RecordIterator.this.childrenColumns.get(columnIndex)).getDouble(index);
            }

            public boolean getBoolean(int columnIndex) {
                return ((Column)RecordIterator.this.childrenColumns.get(columnIndex)).getBoolean(index);
            }

            public Binary getBinary(int columnIndex) {
                return ((Column)RecordIterator.this.childrenColumns.get(columnIndex)).getBinary(index);
            }

            public String getString(int columnIndex) {
                return ((Column)RecordIterator.this.childrenColumns.get(columnIndex)).getBinary(index).getStringValue(TSFileConfig.STRING_CHARSET);
            }

            public LocalDate getLocalDate(int columnIndex) {
                return DateUtils.parseIntToLocalDate((int)((Column)RecordIterator.this.childrenColumns.get(columnIndex)).getInt(index));
            }

            public Type getDataType(int columnIndex) {
                return UDFDataTypeTransformer.transformReadTypeToUDFDataType((org.apache.tsfile.read.common.type.Type)RecordIterator.this.dataTypes.get(columnIndex));
            }

            public boolean isNull(int columnIndex) {
                return ((Column)RecordIterator.this.childrenColumns.get(columnIndex)).isNull(index);
            }

            public int size() {
                return RecordIterator.this.childrenColumns.size();
            }
        };
    }
}

