/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.subscription.event.batch;

import com.codahale.metrics.Clock;
import com.codahale.metrics.Meter;
import com.codahale.metrics.MovingAverages;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.iotdb.commons.pipe.event.EnrichedEvent;
import org.apache.iotdb.db.pipe.event.common.tablet.PipeInsertNodeTabletInsertionEvent;
import org.apache.iotdb.db.pipe.event.common.tablet.PipeRawTabletInsertionEvent;
import org.apache.iotdb.db.pipe.event.common.tsfile.PipeTsFileInsertionEvent;
import org.apache.iotdb.db.pipe.resource.memory.PipeMemoryWeightUtil;
import org.apache.iotdb.db.subscription.agent.SubscriptionAgent;
import org.apache.iotdb.db.subscription.broker.SubscriptionPrefetchingTabletQueue;
import org.apache.iotdb.db.subscription.event.SubscriptionEvent;
import org.apache.iotdb.db.subscription.event.batch.SubscriptionPipeEventBatch;
import org.apache.iotdb.metrics.core.utils.IoTDBMovingAverage;
import org.apache.iotdb.pipe.api.event.dml.insertion.TabletInsertionEvent;
import org.apache.iotdb.pipe.api.event.dml.insertion.TsFileInsertionEvent;
import org.apache.tsfile.write.record.Tablet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubscriptionPipeTabletEventBatch
extends SubscriptionPipeEventBatch
implements Iterator<List<Tablet>> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SubscriptionPipeTabletEventBatch.class);
    private long firstEventProcessingTime = Long.MIN_VALUE;
    private long totalBufferSize = 0L;
    private volatile Iterator<EnrichedEvent> currentEnrichedEventsIterator;
    private volatile Iterator<TabletInsertionEvent> currentTabletInsertionEventsIterator;
    private volatile TsFileInsertionEvent currentTsFileInsertionEvent;
    private final Meter insertNodeTabletInsertionEventSizeEstimator;
    private final Meter rawTabletInsertionEventSizeEstimator;
    private final List<EnrichedEvent> iteratedEnrichedEvents = new ArrayList<EnrichedEvent>();
    private static final long ITERATED_COUNT_REPORT_FREQ = 30000L;
    private final AtomicLong iteratedCount = new AtomicLong();

    public SubscriptionPipeTabletEventBatch(int regionId, SubscriptionPrefetchingTabletQueue prefetchingQueue, int maxDelayInMs, long maxBatchSizeInBytes) {
        super(regionId, prefetchingQueue, maxDelayInMs, maxBatchSizeInBytes);
        this.insertNodeTabletInsertionEventSizeEstimator = new Meter((MovingAverages)new IoTDBMovingAverage(), Clock.defaultClock());
        this.rawTabletInsertionEventSizeEstimator = new Meter((MovingAverages)new IoTDBMovingAverage(), Clock.defaultClock());
    }

    @Override
    public synchronized void ack() {
        for (EnrichedEvent enrichedEvent : this.iteratedEnrichedEvents) {
            enrichedEvent.decreaseReferenceCount(this.getClass().getName(), true);
        }
        this.iteratedEnrichedEvents.clear();
    }

    @Override
    public synchronized void cleanUp() {
        if (this.hasNext()) {
            return;
        }
        for (EnrichedEvent enrichedEvent : this.enrichedEvents) {
            enrichedEvent.clearReferenceCount(this.getClass().getName());
        }
        this.enrichedEvents.clear();
        this.currentEnrichedEventsIterator = null;
        this.currentTabletInsertionEventsIterator = null;
        this.currentTsFileInsertionEvent = null;
    }

    @Override
    protected void onTabletInsertionEvent(TabletInsertionEvent event) {
        if (this.firstEventProcessingTime == Long.MIN_VALUE) {
            this.firstEventProcessingTime = System.currentTimeMillis();
        }
        if (event instanceof PipeInsertNodeTabletInsertionEvent) {
            this.totalBufferSize += this.getEstimatedInsertNodeTabletInsertionEventSize();
        } else if (event instanceof PipeRawTabletInsertionEvent) {
            this.totalBufferSize += this.getEstimatedRawTabletInsertionEventSize();
        }
    }

    @Override
    protected void onTsFileInsertionEvent(TsFileInsertionEvent event) {
        if (this.firstEventProcessingTime == Long.MIN_VALUE) {
            this.firstEventProcessingTime = System.currentTimeMillis();
        }
        this.totalBufferSize += ((PipeTsFileInsertionEvent)event).getTsFile().length();
    }

    @Override
    protected List<SubscriptionEvent> generateSubscriptionEvents() {
        this.resetIterator();
        return Collections.singletonList(new SubscriptionEvent(this, this.prefetchingQueue::generateSubscriptionCommitContext));
    }

    @Override
    protected boolean shouldEmit() {
        return this.totalBufferSize >= this.maxBatchSizeInBytes || System.currentTimeMillis() - this.firstEventProcessingTime >= (long)this.maxDelayInMs;
    }

    private List<Tablet> convertToTablets(TabletInsertionEvent tabletInsertionEvent) {
        if (tabletInsertionEvent instanceof PipeInsertNodeTabletInsertionEvent) {
            List<Tablet> tablets = ((PipeInsertNodeTabletInsertionEvent)tabletInsertionEvent).convertToTablets();
            this.updateEstimatedInsertNodeTabletInsertionEventSize(tablets.stream().map(PipeMemoryWeightUtil::calculateTabletSizeInBytes).reduce(Long::sum).orElse(0L));
            return tablets;
        }
        if (tabletInsertionEvent instanceof PipeRawTabletInsertionEvent) {
            Tablet tablet = ((PipeRawTabletInsertionEvent)tabletInsertionEvent).convertToTablet();
            this.updateEstimatedRawTabletInsertionEventSize(PipeMemoryWeightUtil.calculateTabletSizeInBytes(tablet));
            return Collections.singletonList(tablet);
        }
        LOGGER.warn("SubscriptionPipeTabletEventBatch {} only support convert PipeInsertNodeTabletInsertionEvent or PipeRawTabletInsertionEvent to tablet. Ignore {}.", (Object)this, (Object)tabletInsertionEvent);
        return Collections.emptyList();
    }

    private long getEstimatedInsertNodeTabletInsertionEventSize() {
        return Math.max(100L, (long)this.insertNodeTabletInsertionEventSizeEstimator.getOneMinuteRate());
    }

    private void updateEstimatedInsertNodeTabletInsertionEventSize(long size) {
        this.insertNodeTabletInsertionEventSizeEstimator.mark(size);
    }

    private long getEstimatedRawTabletInsertionEventSize() {
        return Math.max(100L, (long)this.rawTabletInsertionEventSizeEstimator.getOneMinuteRate());
    }

    private void updateEstimatedRawTabletInsertionEventSize(long size) {
        this.rawTabletInsertionEventSizeEstimator.mark(size);
    }

    public void resetIterator() {
        this.currentEnrichedEventsIterator = this.enrichedEvents.iterator();
        this.currentTabletInsertionEventsIterator = null;
        this.currentTsFileInsertionEvent = null;
        this.iteratedEnrichedEvents.clear();
    }

    @Override
    public boolean hasNext() {
        if (Objects.nonNull(this.currentTabletInsertionEventsIterator)) {
            if (this.currentTabletInsertionEventsIterator.hasNext()) {
                return true;
            }
            this.currentTabletInsertionEventsIterator = null;
            this.currentTsFileInsertionEvent = null;
            return this.hasNext();
        }
        if (Objects.isNull(this.currentEnrichedEventsIterator)) {
            return false;
        }
        if (this.currentEnrichedEventsIterator.hasNext()) {
            return true;
        }
        this.currentEnrichedEventsIterator = null;
        return false;
    }

    @Override
    public List<Tablet> next() {
        List<Tablet> tablets = this.nextInternal();
        if (Objects.isNull(tablets)) {
            return null;
        }
        if (this.iteratedCount.incrementAndGet() % 30000L == 0L) {
            LOGGER.info("{} has been iterated {} times, current TsFileInsertionEvent {}", new Object[]{this, this.iteratedCount, Objects.isNull(this.currentTsFileInsertionEvent) ? "<unknown>" : ((EnrichedEvent)this.currentTsFileInsertionEvent).coreReportMessage()});
        }
        return tablets;
    }

    private List<Tablet> nextInternal() {
        if (Objects.nonNull(this.currentTabletInsertionEventsIterator)) {
            if (this.currentTabletInsertionEventsIterator.hasNext()) {
                TabletInsertionEvent tabletInsertionEvent = this.currentTabletInsertionEventsIterator.next();
                if (!this.currentTabletInsertionEventsIterator.hasNext()) {
                    this.iteratedEnrichedEvents.add((EnrichedEvent)this.currentTsFileInsertionEvent);
                }
                return this.convertToTablets(tabletInsertionEvent);
            }
            this.currentTabletInsertionEventsIterator = null;
            this.currentTsFileInsertionEvent = null;
        }
        if (Objects.isNull(this.currentEnrichedEventsIterator)) {
            return null;
        }
        if (!this.currentEnrichedEventsIterator.hasNext()) {
            return null;
        }
        EnrichedEvent enrichedEvent = this.currentEnrichedEventsIterator.next();
        if (enrichedEvent instanceof TsFileInsertionEvent) {
            if (Objects.nonNull(this.currentTabletInsertionEventsIterator)) {
                LOGGER.warn("SubscriptionPipeTabletEventBatch {} override non-null currentTabletInsertionEventsIterator when iterating (broken invariant).", (Object)this);
            }
            PipeTsFileInsertionEvent tsFileInsertionEvent = (PipeTsFileInsertionEvent)enrichedEvent;
            this.currentTsFileInsertionEvent = tsFileInsertionEvent;
            this.currentTabletInsertionEventsIterator = tsFileInsertionEvent.toTabletInsertionEvents(SubscriptionAgent.receiver().remainingMs()).iterator();
            return this.next();
        }
        if (enrichedEvent instanceof TabletInsertionEvent) {
            this.iteratedEnrichedEvents.add(enrichedEvent);
            return this.convertToTablets((TabletInsertionEvent)enrichedEvent);
        }
        LOGGER.warn("SubscriptionPipeTabletEventBatch {} ignore EnrichedEvent {} when iterating (broken invariant).", (Object)this, (Object)enrichedEvent);
        return null;
    }

    public String toString() {
        return "SubscriptionPipeTabletEventBatch" + this.coreReportMessage();
    }

    @Override
    protected Map<String, String> coreReportMessage() {
        Map<String, String> coreReportMessage = super.coreReportMessage();
        coreReportMessage.put("firstEventProcessingTime", String.valueOf(this.firstEventProcessingTime));
        coreReportMessage.put("totalBufferSize", String.valueOf(this.totalBufferSize));
        coreReportMessage.put("estimatedInsertNodeTabletInsertionEventSize", String.valueOf(this.getEstimatedInsertNodeTabletInsertionEventSize()));
        coreReportMessage.put("estimatedRawTabletInsertionEventSize", String.valueOf(this.getEstimatedRawTabletInsertionEventSize()));
        return coreReportMessage;
    }
}

