/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.executor.batch;

import java.io.IOException;
import java.io.Serializable;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.exception.BatchCompactionCannotAlignedException;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.task.CompactionTaskSummary;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.executor.ModifiedStatus;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.executor.batch.utils.AlignedSeriesBatchCompactionUtils;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.executor.batch.utils.BatchCompactionPlan;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.executor.batch.utils.CompactChunkPlan;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.executor.batch.utils.CompactionAlignedPageLazyLoadPointReader;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.executor.batch.utils.FirstBatchCompactionAlignedChunkWriter;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.executor.batch.utils.FollowingBatchCompactionAlignedChunkWriter;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.executor.readchunk.ReadChunkAlignedSeriesCompactionExecutor;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.executor.readchunk.loader.ChunkLoader;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.executor.readchunk.loader.InstantChunkLoader;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.executor.readchunk.loader.PageLoader;
import org.apache.iotdb.db.storageengine.dataregion.compaction.io.CompactionTsFileWriter;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResource;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.exception.write.PageException;
import org.apache.tsfile.file.metadata.AlignedChunkMetadata;
import org.apache.tsfile.file.metadata.ChunkMetadata;
import org.apache.tsfile.file.metadata.IChunkMetadata;
import org.apache.tsfile.file.metadata.IDeviceID;
import org.apache.tsfile.file.metadata.statistics.Statistics;
import org.apache.tsfile.read.TsFileSequenceReader;
import org.apache.tsfile.read.common.Chunk;
import org.apache.tsfile.read.common.TimeRange;
import org.apache.tsfile.read.reader.IPointReader;
import org.apache.tsfile.read.reader.page.TimePageReader;
import org.apache.tsfile.read.reader.page.ValuePageReader;
import org.apache.tsfile.utils.Pair;
import org.apache.tsfile.write.chunk.AlignedChunkWriterImpl;
import org.apache.tsfile.write.chunk.IChunkWriter;
import org.apache.tsfile.write.schema.IMeasurementSchema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BatchedReadChunkAlignedSeriesCompactionExecutor
extends ReadChunkAlignedSeriesCompactionExecutor {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"COMPACTION");
    private final BatchCompactionPlan batchCompactionPlan = new BatchCompactionPlan();
    private final int batchSize = IoTDBDescriptor.getInstance().getConfig().getCompactionMaxAlignedSeriesNumInOneBatch();
    private final AlignedSeriesBatchCompactionUtils.BatchColumnSelection batchColumnSelection;
    private final LinkedList<Pair<TsFileSequenceReader, List<AlignedChunkMetadata>>> originReaderAndChunkMetadataList;

    public BatchedReadChunkAlignedSeriesCompactionExecutor(IDeviceID device, TsFileResource targetResource, LinkedList<Pair<TsFileSequenceReader, List<AlignedChunkMetadata>>> readerAndChunkMetadataList, CompactionTsFileWriter writer, CompactionTaskSummary summary, boolean ignoreAllNullRows) throws IOException {
        super(device, targetResource, readerAndChunkMetadataList, writer, summary, ignoreAllNullRows);
        this.originReaderAndChunkMetadataList = readerAndChunkMetadataList;
        this.batchColumnSelection = new AlignedSeriesBatchCompactionUtils.BatchColumnSelection(this.schemaList, this.batchSize);
    }

    @Override
    public void execute() throws IOException, PageException {
        if (this.batchSize <= 0 || this.batchSize >= this.schemaList.size()) {
            super.execute();
            return;
        }
        AlignedSeriesBatchCompactionUtils.markAlignedChunkHasDeletion(this.readerAndChunkMetadataList);
        this.compactFirstBatch();
        if (this.batchCompactionPlan.isEmpty()) {
            return;
        }
        this.compactLeftBatches();
    }

    private void compactFirstBatch() throws IOException, PageException {
        List<IMeasurementSchema> selectedColumnSchemaList;
        List<Integer> selectedColumnIndexList;
        if (!this.batchColumnSelection.hasNext()) {
            if (this.ignoreAllNullRows) {
                return;
            }
            selectedColumnIndexList = Collections.emptyList();
            selectedColumnSchemaList = Collections.emptyList();
        } else {
            this.batchColumnSelection.next();
            selectedColumnIndexList = this.batchColumnSelection.getSelectedColumnIndexList();
            selectedColumnSchemaList = this.batchColumnSelection.getCurrentSelectedColumnSchemaList();
        }
        LinkedList<Pair<TsFileSequenceReader, List<AlignedChunkMetadata>>> batchedReaderAndChunkMetadataList = this.filterAlignedChunkMetadataList(this.readerAndChunkMetadataList, selectedColumnIndexList);
        FirstBatchedReadChunkAlignedSeriesCompactionExecutor executor = new FirstBatchedReadChunkAlignedSeriesCompactionExecutor(this.device, this.targetResource, batchedReaderAndChunkMetadataList, this.writer, this.summary, this.timeSchema, selectedColumnSchemaList, this.ignoreAllNullRows);
        executor.execute();
        LOGGER.debug("[Batch Compaction] current device is {}, first batch compacted time chunk is {}", (Object)this.device, (Object)this.batchCompactionPlan);
    }

    private void compactLeftBatches() throws PageException, IOException {
        while (this.batchColumnSelection.hasNext()) {
            this.batchColumnSelection.next();
            LinkedList<Pair<TsFileSequenceReader, List<AlignedChunkMetadata>>> groupReaderAndChunkMetadataList = this.filterAlignedChunkMetadataList(this.readerAndChunkMetadataList, this.batchColumnSelection.getSelectedColumnIndexList());
            FollowingBatchedReadChunkAlignedSeriesGroupCompactionExecutor executor = new FollowingBatchedReadChunkAlignedSeriesGroupCompactionExecutor(this.device, this.targetResource, groupReaderAndChunkMetadataList, this.writer, this.summary, this.timeSchema, this.batchColumnSelection.getCurrentSelectedColumnSchemaList(), this.ignoreAllNullRows);
            executor.execute();
        }
    }

    private LinkedList<Pair<TsFileSequenceReader, List<AlignedChunkMetadata>>> filterAlignedChunkMetadataList(List<Pair<TsFileSequenceReader, List<AlignedChunkMetadata>>> readerAndChunkMetadataList, List<Integer> selectedMeasurementIndexs) {
        LinkedList<Pair<TsFileSequenceReader, List<AlignedChunkMetadata>>> groupReaderAndChunkMetadataList = new LinkedList<Pair<TsFileSequenceReader, List<AlignedChunkMetadata>>>();
        for (Pair<TsFileSequenceReader, List<AlignedChunkMetadata>> pair : readerAndChunkMetadataList) {
            List alignedChunkMetadataList = (List)pair.getRight();
            LinkedList<AlignedChunkMetadata> selectedColumnAlignedChunkMetadataList = new LinkedList<AlignedChunkMetadata>();
            for (AlignedChunkMetadata alignedChunkMetadata : alignedChunkMetadataList) {
                selectedColumnAlignedChunkMetadataList.add(AlignedSeriesBatchCompactionUtils.filterAlignedChunkMetadataByIndex(alignedChunkMetadata, selectedMeasurementIndexs));
            }
            groupReaderAndChunkMetadataList.add((Pair<TsFileSequenceReader, List<AlignedChunkMetadata>>)new Pair((Object)((TsFileSequenceReader)pair.getLeft()), selectedColumnAlignedChunkMetadataList));
        }
        return groupReaderAndChunkMetadataList;
    }

    public class FirstBatchedReadChunkAlignedSeriesCompactionExecutor
    extends ReadChunkAlignedSeriesCompactionExecutor {
        public FirstBatchedReadChunkAlignedSeriesCompactionExecutor(IDeviceID device, TsFileResource targetResource, LinkedList<Pair<TsFileSequenceReader, List<AlignedChunkMetadata>>> readerAndChunkMetadataList, CompactionTsFileWriter writer, CompactionTaskSummary summary, IMeasurementSchema timeSchema, List<IMeasurementSchema> valueSchemaList, boolean ignoreAllNullRows) {
            super(device, targetResource, readerAndChunkMetadataList, writer, summary, timeSchema, valueSchemaList, ignoreAllNullRows);
            int compactionFileLevel = Integer.parseInt(this.targetResource.getTsFile().getName().split("-")[2]);
            this.flushController = new FirstBatchReadChunkAlignedSeriesCompactionFlushController(compactionFileLevel);
        }

        @Override
        protected AlignedChunkWriterImpl constructAlignedChunkWriter() {
            return new FirstBatchCompactionAlignedChunkWriter(this.timeSchema, this.schemaList);
        }

        @Override
        protected void compactAlignedChunkByFlush(ChunkLoader timeChunk, List<ChunkLoader> valueChunks) throws IOException {
            ChunkMetadata timeChunkMetadata = timeChunk.getChunkMetadata();
            BatchedReadChunkAlignedSeriesCompactionExecutor.this.batchCompactionPlan.recordCompactedChunk(new CompactChunkPlan(timeChunkMetadata.getStartTime(), timeChunkMetadata.getEndTime()));
            super.compactAlignedChunkByFlush(timeChunk, valueChunks);
        }

        @Override
        protected boolean isAllValuePageEmpty(PageLoader timePage, List<PageLoader> valuePages) {
            long startTime = timePage.getHeader().getStartTime();
            long endTime = timePage.getHeader().getEndTime();
            String file = timePage.getFile();
            ChunkMetadata timeChunkMetadata = timePage.getChunkMetadata();
            List alignedChunkMetadataList = Collections.emptyList();
            for (Object pair : BatchedReadChunkAlignedSeriesCompactionExecutor.this.originReaderAndChunkMetadataList) {
                TsFileSequenceReader reader = (TsFileSequenceReader)pair.getLeft();
                if (!reader.getFileName().equals(file)) continue;
                alignedChunkMetadataList = (List)pair.getRight();
                break;
            }
            AlignedChunkMetadata originAlignedChunkMetadata = null;
            for (AlignedChunkMetadata alignedChunkMetadata : alignedChunkMetadataList) {
                if (alignedChunkMetadata.getOffsetOfChunkHeader() != timeChunkMetadata.getOffsetOfChunkHeader()) continue;
                originAlignedChunkMetadata = alignedChunkMetadata;
                break;
            }
            ModifiedStatus modifiedStatus = AlignedSeriesBatchCompactionUtils.calculateAlignedPageModifiedStatus(startTime, endTime, originAlignedChunkMetadata, this.ignoreAllNullRows);
            BatchedReadChunkAlignedSeriesCompactionExecutor.this.batchCompactionPlan.recordPageModifiedStatus(file, new TimeRange(startTime, endTime), modifiedStatus);
            return modifiedStatus == ModifiedStatus.ALL_DELETED;
        }

        @Override
        protected ChunkLoader getChunkLoader(TsFileSequenceReader reader, ChunkMetadata chunkMetadata) throws IOException {
            ChunkLoader chunkLoader = super.getChunkLoader(reader, chunkMetadata);
            if (!chunkLoader.isEmpty() && AlignedSeriesBatchCompactionUtils.isTimeChunk(chunkMetadata)) {
                BatchedReadChunkAlignedSeriesCompactionExecutor.this.batchCompactionPlan.addTimeChunkToCache(reader.getFileName(), chunkMetadata.getOffsetOfChunkHeader(), chunkLoader.getChunk());
            }
            return chunkLoader;
        }

        @Override
        protected void flushCurrentChunkWriter() throws IOException {
            this.chunkWriter.sealCurrentPage();
            if (!this.chunkWriter.isEmpty()) {
                CompactChunkPlan compactChunkPlan = ((FirstBatchCompactionAlignedChunkWriter)this.chunkWriter).getCompactedChunkRecord();
                BatchedReadChunkAlignedSeriesCompactionExecutor.this.batchCompactionPlan.recordCompactedChunk(compactChunkPlan);
            }
            this.writer.writeChunk((IChunkWriter)this.chunkWriter);
        }

        @Override
        protected IPointReader getPointReader(TimePageReader timePageReader, List<ValuePageReader> valuePageReaders) throws IOException {
            return new CompactionAlignedPageLazyLoadPointReader(timePageReader, valuePageReaders, false);
        }

        private class FirstBatchReadChunkAlignedSeriesCompactionFlushController
        extends ReadChunkAlignedSeriesCompactionExecutor.ReadChunkAlignedSeriesCompactionFlushController {
            public FirstBatchReadChunkAlignedSeriesCompactionFlushController(int compactionFileLevel) {
                super(FirstBatchedReadChunkAlignedSeriesCompactionExecutor.this, compactionFileLevel);
            }

            @Override
            public boolean canCompactCurrentChunkByDirectlyFlush(ChunkLoader timeChunk, List<ChunkLoader> valueChunks) throws IOException {
                return !timeChunk.getChunkMetadata().isModified() && super.canCompactCurrentChunkByDirectlyFlush(timeChunk, valueChunks);
            }
        }
    }

    public class FollowingBatchedReadChunkAlignedSeriesGroupCompactionExecutor
    extends ReadChunkAlignedSeriesCompactionExecutor {
        private int currentCompactChunk;

        public FollowingBatchedReadChunkAlignedSeriesGroupCompactionExecutor(IDeviceID device, TsFileResource targetResource, LinkedList<Pair<TsFileSequenceReader, List<AlignedChunkMetadata>>> readerAndChunkMetadataList, CompactionTsFileWriter writer, CompactionTaskSummary summary, IMeasurementSchema timeSchema, List<IMeasurementSchema> valueSchemaList, boolean ignoreAllNullRows) {
            super(device, targetResource, readerAndChunkMetadataList, writer, summary, timeSchema, valueSchemaList, ignoreAllNullRows);
            this.currentCompactChunk = 0;
            this.flushController = new FollowingBatchReadChunkAlignedSeriesCompactionFlushController();
            this.chunkWriter = new FollowingBatchCompactionAlignedChunkWriter(timeSchema, this.schemaList, BatchedReadChunkAlignedSeriesCompactionExecutor.this.batchCompactionPlan.getCompactChunkPlan(0));
        }

        @Override
        protected ChunkLoader getChunkLoader(TsFileSequenceReader reader, ChunkMetadata chunkMetadata) throws IOException {
            if (chunkMetadata != null && AlignedSeriesBatchCompactionUtils.isTimeChunk(chunkMetadata)) {
                Chunk timeChunk = BatchedReadChunkAlignedSeriesCompactionExecutor.this.batchCompactionPlan.getTimeChunkFromCache(reader, chunkMetadata);
                return new InstantChunkLoader(reader.getFileName(), chunkMetadata, timeChunk);
            }
            return super.getChunkLoader(reader, chunkMetadata);
        }

        @Override
        protected void flushCurrentChunkWriter() throws IOException {
            if (this.chunkWriter.isEmpty() || this.currentCompactChunk >= BatchedReadChunkAlignedSeriesCompactionExecutor.this.batchCompactionPlan.compactedChunkNum()) {
                return;
            }
            super.flushCurrentChunkWriter();
            this.nextChunk();
        }

        private void nextChunk() {
            ++this.currentCompactChunk;
            if (this.currentCompactChunk < BatchedReadChunkAlignedSeriesCompactionExecutor.this.batchCompactionPlan.compactedChunkNum()) {
                CompactChunkPlan chunkRecord = BatchedReadChunkAlignedSeriesCompactionExecutor.this.batchCompactionPlan.getCompactChunkPlan(this.currentCompactChunk);
                ((FollowingBatchCompactionAlignedChunkWriter)this.chunkWriter).setCompactChunkPlan(chunkRecord);
            }
        }

        @Override
        protected boolean isAllValuePageEmpty(PageLoader timePage, List<PageLoader> valuePages) {
            long startTime = timePage.getHeader().getStartTime();
            long endTime = timePage.getHeader().getEndTime();
            String file = timePage.getFile();
            return BatchedReadChunkAlignedSeriesCompactionExecutor.this.batchCompactionPlan.getAlignedPageModifiedStatus(file, new TimeRange(startTime, endTime)) == ModifiedStatus.ALL_DELETED;
        }

        @Override
        protected void compactAlignedChunkByFlush(ChunkLoader timeChunk, List<ChunkLoader> valueChunks) throws IOException {
            this.writer.markStartingWritingAligned();
            this.checkAndUpdatePreviousTimestamp(timeChunk.getChunkMetadata().getStartTime());
            this.checkAndUpdatePreviousTimestamp(timeChunk.getChunkMetadata().getEndTime());
            timeChunk.clear();
            int nonEmptyChunkNum = 0;
            for (int i = 0; i < valueChunks.size(); ++i) {
                ChunkLoader valueChunk = valueChunks.get(i);
                if (valueChunk.isEmpty()) {
                    IMeasurementSchema schema = (IMeasurementSchema)this.schemaList.get(i);
                    this.writer.writeEmptyValueChunk(schema.getMeasurementName(), schema.getCompressor(), schema.getType(), schema.getEncodingType(), (Statistics<? extends Serializable>)Statistics.getStatsByType((TSDataType)schema.getType()));
                    continue;
                }
                ++nonEmptyChunkNum;
                this.writer.writeChunk(valueChunk.getChunk(), valueChunk.getChunkMetadata());
                valueChunk.clear();
            }
            this.summary.increaseDirectlyFlushChunkNum(nonEmptyChunkNum);
            this.writer.markEndingWritingAligned();
            this.nextChunk();
        }

        @Override
        protected IPointReader getPointReader(TimePageReader timePageReader, List<ValuePageReader> valuePageReaders) throws IOException {
            return new CompactionAlignedPageLazyLoadPointReader(timePageReader, valuePageReaders, false);
        }

        private class FollowingBatchReadChunkAlignedSeriesCompactionFlushController
        extends ReadChunkAlignedSeriesCompactionExecutor.ReadChunkAlignedSeriesCompactionFlushController {
            public FollowingBatchReadChunkAlignedSeriesCompactionFlushController() {
                super(FollowingBatchedReadChunkAlignedSeriesGroupCompactionExecutor.this, 0);
            }

            @Override
            public boolean canCompactCurrentChunkByDirectlyFlush(ChunkLoader timeChunk, List<ChunkLoader> valueChunks) throws IOException {
                CompactChunkPlan compactChunkPlan = BatchedReadChunkAlignedSeriesCompactionExecutor.this.batchCompactionPlan.getCompactChunkPlan(FollowingBatchedReadChunkAlignedSeriesGroupCompactionExecutor.this.currentCompactChunk);
                boolean isCurrentChunkCompactedByDirectlyFlush = compactChunkPlan.isCompactedByDirectlyFlush();
                if (isCurrentChunkCompactedByDirectlyFlush && timeChunk.getChunkMetadata().getStartTime() != compactChunkPlan.getTimeRange().getMin()) {
                    throw new BatchCompactionCannotAlignedException((IChunkMetadata)timeChunk.getChunkMetadata(), compactChunkPlan, BatchedReadChunkAlignedSeriesCompactionExecutor.this.batchCompactionPlan);
                }
                return isCurrentChunkCompactedByDirectlyFlush;
            }

            @Override
            protected boolean canFlushCurrentChunkWriter() {
                return FollowingBatchedReadChunkAlignedSeriesGroupCompactionExecutor.this.chunkWriter.checkIsChunkSizeOverThreshold(0L, 0L, true);
            }

            @Override
            protected boolean canCompactCurrentPageByDirectlyFlush(PageLoader timePage, List<PageLoader> valuePages) {
                int currentPage = ((FollowingBatchCompactionAlignedChunkWriter)FollowingBatchedReadChunkAlignedSeriesGroupCompactionExecutor.this.chunkWriter).getCurrentPage();
                for (int i = 0; i < valuePages.size(); ++i) {
                    PageLoader currentValuePage = valuePages.get(i);
                    if (currentValuePage.isEmpty()) continue;
                    if (currentValuePage.getCompressionType() != ((IMeasurementSchema)FollowingBatchedReadChunkAlignedSeriesGroupCompactionExecutor.this.schemaList.get(i)).getCompressor() || currentValuePage.getEncoding() != ((IMeasurementSchema)FollowingBatchedReadChunkAlignedSeriesGroupCompactionExecutor.this.schemaList.get(i)).getEncodingType()) {
                        return false;
                    }
                    if (currentValuePage.getModifiedStatus() != ModifiedStatus.PARTIAL_DELETED) continue;
                    return false;
                }
                return BatchedReadChunkAlignedSeriesCompactionExecutor.this.batchCompactionPlan.getCompactChunkPlan(FollowingBatchedReadChunkAlignedSeriesGroupCompactionExecutor.this.currentCompactChunk).getPageRecords().get(currentPage).isCompactedByDirectlyFlush();
            }
        }
    }
}

