/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.service;

import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.stream.Collectors;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupId;
import org.apache.iotdb.common.rpc.thrift.TDataNodeLocation;
import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.common.rpc.thrift.TRegionMaintainTaskStatus;
import org.apache.iotdb.common.rpc.thrift.TRegionMigrateFailedType;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.concurrent.IoTDBThreadPoolFactory;
import org.apache.iotdb.commons.concurrent.ThreadName;
import org.apache.iotdb.commons.consensus.ConsensusGroupId;
import org.apache.iotdb.commons.consensus.DataRegionId;
import org.apache.iotdb.commons.consensus.SchemaRegionId;
import org.apache.iotdb.commons.exception.StartupException;
import org.apache.iotdb.commons.service.IService;
import org.apache.iotdb.commons.service.ServiceType;
import org.apache.iotdb.consensus.common.Peer;
import org.apache.iotdb.consensus.exception.ConsensusException;
import org.apache.iotdb.consensus.exception.ConsensusGroupNotExistException;
import org.apache.iotdb.consensus.exception.PeerAlreadyInConsensusGroupException;
import org.apache.iotdb.consensus.exception.PeerNotInConsensusGroupException;
import org.apache.iotdb.db.consensus.DataRegionConsensusImpl;
import org.apache.iotdb.db.consensus.SchemaRegionConsensusImpl;
import org.apache.iotdb.db.protocol.thrift.impl.DataNodeRegionManager;
import org.apache.iotdb.mpp.rpc.thrift.TMaintainPeerReq;
import org.apache.iotdb.mpp.rpc.thrift.TRegionMigrateResult;
import org.apache.iotdb.mpp.rpc.thrift.TResetPeerListReq;
import org.apache.iotdb.rpc.TSStatusCode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegionMigrateService
implements IService {
    private static final Logger LOGGER = LoggerFactory.getLogger(RegionMigrateService.class);
    public static final String REGION_MIGRATE_PROCESS = "[REGION_MIGRATE_PROCESS]";
    private static final int MAX_RETRY_NUM = 5;
    private static final int SLEEP_MILLIS = 5000;
    private ExecutorService regionMigratePool;
    private static final ConcurrentHashMap<Long, TRegionMigrateResult> taskResultMap = new ConcurrentHashMap();
    private static final TRegionMigrateResult unfinishedResult = new TRegionMigrateResult();

    private RegionMigrateService() {
    }

    public static RegionMigrateService getInstance() {
        return Holder.INSTANCE;
    }

    public synchronized boolean submitAddRegionPeerTask(TMaintainPeerReq req) {
        boolean submitSucceed = true;
        try {
            if (!this.addToTaskResultMap(req.getTaskId())) {
                LOGGER.warn("{} The AddRegionPeerTask {} has already been submitted and will not be submitted again.", (Object)REGION_MIGRATE_PROCESS, (Object)req.getTaskId());
                return true;
            }
            this.regionMigratePool.submit(new AddRegionPeerTask(req.getTaskId(), req.getRegionId(), req.getDestNode()));
        }
        catch (Exception e) {
            LOGGER.error("{}, Submit AddRegionPeerTask error for Region: {}", new Object[]{REGION_MIGRATE_PROCESS, req.getRegionId(), e});
            submitSucceed = false;
        }
        return submitSucceed;
    }

    public synchronized boolean submitRemoveRegionPeerTask(TMaintainPeerReq req) {
        boolean submitSucceed = true;
        try {
            if (!this.addToTaskResultMap(req.getTaskId())) {
                LOGGER.warn("{} The RemoveRegionPeer {} has already been submitted and will not be submitted again.", (Object)REGION_MIGRATE_PROCESS, (Object)req.getTaskId());
                return true;
            }
            this.regionMigratePool.submit(new RemoveRegionPeerTask(req.getTaskId(), req.getRegionId(), req.getDestNode()));
        }
        catch (Exception e) {
            LOGGER.error("{}, Submit RemoveRegionPeer task error for Region: {}", new Object[]{REGION_MIGRATE_PROCESS, req.getRegionId(), e});
            submitSucceed = false;
        }
        return submitSucceed;
    }

    public synchronized boolean submitDeleteOldRegionPeerTask(TMaintainPeerReq req) {
        boolean submitSucceed = true;
        try {
            if (!this.addToTaskResultMap(req.getTaskId())) {
                LOGGER.warn("{} The DeleteOldRegionPeerTask {} has already been submitted and will not be submitted again.", (Object)REGION_MIGRATE_PROCESS, (Object)req.getTaskId());
                return true;
            }
            this.regionMigratePool.submit(new DeleteOldRegionPeerTask(req.getTaskId(), req.getRegionId(), req.getDestNode()));
        }
        catch (Exception e) {
            LOGGER.error("{}, Submit DeleteOldRegionPeerTask error for Region: {}", new Object[]{REGION_MIGRATE_PROCESS, req.getRegionId(), e});
            submitSucceed = false;
        }
        return submitSucceed;
    }

    public synchronized TSStatus resetPeerList(TResetPeerListReq req) {
        List correctPeers = req.getCorrectLocations().stream().map(location -> Peer.valueOf((TConsensusGroupId)req.getRegionId(), (TDataNodeLocation)location)).collect(Collectors.toList());
        ConsensusGroupId regionId = ConsensusGroupId.Factory.createFromTConsensusGroupId((TConsensusGroupId)req.getRegionId());
        try {
            if (regionId instanceof DataRegionId) {
                DataRegionConsensusImpl.getInstance().resetPeerList(regionId, correctPeers);
            } else {
                SchemaRegionConsensusImpl.getInstance().resetPeerList(regionId, correctPeers);
            }
        }
        catch (ConsensusGroupNotExistException e) {
            LOGGER.warn("Reset peer list fail, this DataNode not contains peer of consensus group {}. Maybe caused by create local peer failure.", (Object)regionId, (Object)e);
        }
        catch (ConsensusException e) {
            LOGGER.error("reset peer list fail", (Throwable)e);
            return new TSStatus(TSStatusCode.EXECUTE_STATEMENT_ERROR.getStatusCode());
        }
        return new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode());
    }

    private boolean addToTaskResultMap(long taskId) {
        return taskResultMap.putIfAbsent(taskId, unfinishedResult) == null;
    }

    public void start() throws StartupException {
        this.regionMigratePool = IoTDBThreadPoolFactory.newCachedThreadPool((String)ThreadName.REGION_MIGRATE.getName());
        LOGGER.info("Region migrate service start");
    }

    public void stop() {
        if (this.regionMigratePool != null) {
            this.regionMigratePool.shutdown();
        }
        LOGGER.info("Region migrate service stop");
    }

    public ServiceType getID() {
        return ServiceType.DATA_NODE_REGION_MIGRATE_SERVICE;
    }

    private static void taskSucceed(long taskId, TConsensusGroupId tRegionId, String migrateState) {
        TSStatus status = new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode());
        status.setMessage(String.format("Region: %s, state: %s, executed succeed", tRegionId, migrateState));
        TRegionMigrateResult req = new TRegionMigrateResult(TRegionMaintainTaskStatus.SUCCESS);
        req.setRegionId(tRegionId).setMigrateResult(status);
        taskResultMap.put(taskId, req);
    }

    private static void taskFail(long taskId, TConsensusGroupId tRegionId, TDataNodeLocation failedNode, TRegionMigrateFailedType failedType, TSStatus status) {
        HashMap<TDataNodeLocation, TRegionMigrateFailedType> failedNodeAndReason = new HashMap<TDataNodeLocation, TRegionMigrateFailedType>();
        failedNodeAndReason.put(failedNode, failedType);
        TRegionMigrateResult req = new TRegionMigrateResult(TRegionMaintainTaskStatus.FAIL);
        req.setRegionId(tRegionId).setMigrateResult(status);
        req.setFailedNodeAndReason(failedNodeAndReason);
        taskResultMap.put(taskId, req);
    }

    public TRegionMigrateResult getRegionMaintainResult(Long taskId) {
        TRegionMigrateResult result = new TRegionMigrateResult();
        if (!taskResultMap.containsKey(taskId)) {
            result.setTaskStatus(TRegionMaintainTaskStatus.TASK_NOT_EXIST);
        } else if (taskResultMap.get(taskId) == unfinishedResult) {
            result.setTaskStatus(TRegionMaintainTaskStatus.PROCESSING);
        } else {
            result = taskResultMap.get(taskId);
        }
        return result;
    }

    public static boolean isSucceed(TSStatus status) {
        return status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode();
    }

    public static boolean isFailed(TSStatus status) {
        return !RegionMigrateService.isSucceed(status);
    }

    private static TEndPoint getConsensusEndPoint(TDataNodeLocation nodeLocation, ConsensusGroupId regionId) {
        if (regionId instanceof DataRegionId) {
            return nodeLocation.getDataRegionConsensusEndPoint();
        }
        return nodeLocation.getSchemaRegionConsensusEndPoint();
    }

    private static class Holder {
        private static final RegionMigrateService INSTANCE = new RegionMigrateService();

        private Holder() {
        }
    }

    private static class AddRegionPeerTask
    implements Runnable {
        private static final Logger taskLogger = LoggerFactory.getLogger(AddRegionPeerTask.class);
        private final long taskId;
        private final TConsensusGroupId tRegionId;
        private final TDataNodeLocation destDataNode;

        public AddRegionPeerTask(long taskId, TConsensusGroupId tRegionId, TDataNodeLocation destDataNode) {
            this.taskId = taskId;
            this.tRegionId = tRegionId;
            this.destDataNode = destDataNode;
        }

        @Override
        public void run() {
            TSStatus runResult = this.addPeer();
            if (RegionMigrateService.isFailed(runResult)) {
                RegionMigrateService.taskFail(this.taskId, this.tRegionId, this.destDataNode, TRegionMigrateFailedType.AddPeerFailed, runResult);
                return;
            }
            RegionMigrateService.taskSucceed(this.taskId, this.tRegionId, "AddPeer");
        }

        private TSStatus addPeer() {
            taskLogger.info("{}, Start to addPeer {} for region {}", new Object[]{RegionMigrateService.REGION_MIGRATE_PROCESS, this.destDataNode, this.tRegionId});
            ConsensusGroupId regionId = ConsensusGroupId.Factory.createFromTConsensusGroupId((TConsensusGroupId)this.tRegionId);
            TSStatus status = new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode());
            TEndPoint destEndpoint = RegionMigrateService.getConsensusEndPoint(this.destDataNode, regionId);
            boolean addPeerSucceed = true;
            Throwable throwable = null;
            try {
                this.addRegionPeer(regionId, new Peer(regionId, this.destDataNode.getDataNodeId(), destEndpoint));
            }
            catch (PeerAlreadyInConsensusGroupException peerAlreadyInConsensusGroupException) {
            }
            catch (ConsensusException e) {
                addPeerSucceed = false;
                throwable = e;
                taskLogger.error("{}, executed addPeer {} for region {} error", new Object[]{RegionMigrateService.REGION_MIGRATE_PROCESS, destEndpoint, regionId, e});
            }
            catch (Exception e) {
                addPeerSucceed = false;
                throwable = e;
                taskLogger.warn("Unexpected exception", (Throwable)e);
            }
            if (!addPeerSucceed) {
                String errorMsg = String.format("%s, AddPeer for region error, peerId: %s, regionId: %s", RegionMigrateService.REGION_MIGRATE_PROCESS, destEndpoint, regionId);
                taskLogger.error(errorMsg, throwable);
                status.setCode(TSStatusCode.MIGRATE_REGION_ERROR.getStatusCode());
                status.setMessage(errorMsg);
                return status;
            }
            taskLogger.info("{}, Succeed to addPeer {} for region {}", new Object[]{RegionMigrateService.REGION_MIGRATE_PROCESS, destEndpoint, regionId});
            status.setCode(TSStatusCode.SUCCESS_STATUS.getStatusCode());
            status.setMessage("addPeer " + destEndpoint + " for region " + regionId + " succeed");
            return status;
        }

        private void addRegionPeer(ConsensusGroupId regionId, Peer newPeer) throws ConsensusException {
            if (regionId instanceof DataRegionId) {
                DataRegionConsensusImpl.getInstance().addRemotePeer(regionId, newPeer);
            } else {
                SchemaRegionConsensusImpl.getInstance().addRemotePeer(regionId, newPeer);
            }
        }
    }

    private static class RemoveRegionPeerTask
    implements Runnable {
        private static final Logger taskLogger = LoggerFactory.getLogger(RemoveRegionPeerTask.class);
        private final long taskId;
        private final TConsensusGroupId tRegionId;
        private final TDataNodeLocation destDataNode;

        public RemoveRegionPeerTask(long taskId, TConsensusGroupId tRegionId, TDataNodeLocation destDataNode) {
            this.taskId = taskId;
            this.tRegionId = tRegionId;
            this.destDataNode = destDataNode;
        }

        @Override
        public void run() {
            TSStatus runResult = this.removePeer();
            if (RegionMigrateService.isSucceed(runResult)) {
                RegionMigrateService.taskSucceed(this.taskId, this.tRegionId, "RemovePeer");
            } else {
                RegionMigrateService.taskFail(this.taskId, this.tRegionId, this.destDataNode, TRegionMigrateFailedType.RemovePeerFailed, runResult);
            }
        }

        private TSStatus removePeer() {
            ConsensusGroupId regionId = ConsensusGroupId.Factory.createFromTConsensusGroupId((TConsensusGroupId)this.tRegionId);
            TSStatus status = new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode());
            TEndPoint destEndPoint = RegionMigrateService.getConsensusEndPoint(this.destDataNode, regionId);
            taskLogger.info("{}, Start to removePeer {} for region {}", new Object[]{RegionMigrateService.REGION_MIGRATE_PROCESS, destEndPoint, regionId});
            Throwable throwable = null;
            boolean removePeerSucceed = true;
            for (int i = 0; i < 5; ++i) {
                try {
                    if (!removePeerSucceed) {
                        Thread.sleep(5000L);
                    }
                    this.removeRegionPeer(regionId, new Peer(regionId, this.destDataNode.getDataNodeId(), destEndPoint));
                    removePeerSucceed = true;
                }
                catch (PeerNotInConsensusGroupException e) {
                    removePeerSucceed = true;
                }
                catch (InterruptedException e) {
                    throwable = e;
                    Thread.currentThread().interrupt();
                }
                catch (ConsensusException e) {
                    removePeerSucceed = false;
                    throwable = e;
                    taskLogger.error("{}, executed removePeer {} for region {} error, retry times: {}", new Object[]{RegionMigrateService.REGION_MIGRATE_PROCESS, destEndPoint, regionId, i, e});
                }
                catch (Exception e) {
                    removePeerSucceed = false;
                    throwable = e;
                    taskLogger.warn("Unexpected exception", (Throwable)e);
                }
                if (removePeerSucceed || throwable instanceof InterruptedException) break;
            }
            if (!removePeerSucceed) {
                String errorMsg = String.format("%s, RemovePeer for region error after max retry times, peerId: %s, regionId: %s", RegionMigrateService.REGION_MIGRATE_PROCESS, destEndPoint, regionId);
                taskLogger.error(errorMsg, throwable);
                status.setCode(TSStatusCode.MIGRATE_REGION_ERROR.getStatusCode());
                status.setMessage(errorMsg);
                return status;
            }
            taskLogger.info("{}, Succeed to removePeer {} for region {}", new Object[]{RegionMigrateService.REGION_MIGRATE_PROCESS, destEndPoint, regionId});
            status.setCode(TSStatusCode.SUCCESS_STATUS.getStatusCode());
            status.setMessage("removePeer " + destEndPoint + " for region " + regionId + " succeed");
            return status;
        }

        private void removeRegionPeer(ConsensusGroupId regionId, Peer oldPeer) throws ConsensusException {
            if (regionId instanceof DataRegionId) {
                DataRegionConsensusImpl.getInstance().removeRemotePeer(regionId, oldPeer);
            } else {
                SchemaRegionConsensusImpl.getInstance().removeRemotePeer(regionId, oldPeer);
            }
        }
    }

    private static class DeleteOldRegionPeerTask
    implements Runnable {
        private static final Logger taskLogger = LoggerFactory.getLogger(DeleteOldRegionPeerTask.class);
        private final long taskId;
        private final TConsensusGroupId tRegionId;
        private final TDataNodeLocation originalDataNode;

        public DeleteOldRegionPeerTask(long taskId, TConsensusGroupId tRegionId, TDataNodeLocation originalDataNode) {
            this.taskId = taskId;
            this.tRegionId = tRegionId;
            this.originalDataNode = originalDataNode;
        }

        @Override
        public void run() {
            TSStatus runResult = this.deletePeer();
            if (RegionMigrateService.isFailed(runResult)) {
                RegionMigrateService.taskFail(this.taskId, this.tRegionId, this.originalDataNode, TRegionMigrateFailedType.RemoveConsensusGroupFailed, runResult);
            }
            if (RegionMigrateService.isFailed(runResult = this.deleteRegion())) {
                RegionMigrateService.taskFail(this.taskId, this.tRegionId, this.originalDataNode, TRegionMigrateFailedType.DeleteRegionFailed, runResult);
            }
            RegionMigrateService.taskSucceed(this.taskId, this.tRegionId, "DeletePeer");
        }

        private TSStatus deletePeer() {
            taskLogger.info("{}, Start to deletePeer {} for region {}", new Object[]{RegionMigrateService.REGION_MIGRATE_PROCESS, this.originalDataNode, this.tRegionId});
            ConsensusGroupId regionId = ConsensusGroupId.Factory.createFromTConsensusGroupId((TConsensusGroupId)this.tRegionId);
            TSStatus status = new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode());
            try {
                if (regionId instanceof DataRegionId) {
                    DataRegionConsensusImpl.getInstance().deleteLocalPeer(regionId);
                } else {
                    SchemaRegionConsensusImpl.getInstance().deleteLocalPeer(regionId);
                }
            }
            catch (ConsensusException e) {
                String errorMsg = String.format("deletePeer error, regionId: %s, errorMessage: %s", regionId, e.getMessage());
                taskLogger.error(errorMsg);
                status.setCode(TSStatusCode.MIGRATE_REGION_ERROR.getStatusCode());
                status.setMessage(errorMsg);
                return status;
            }
            catch (Exception e) {
                taskLogger.error("{}, deletePeer error, regionId: {}", new Object[]{RegionMigrateService.REGION_MIGRATE_PROCESS, regionId, e});
                status.setCode(TSStatusCode.MIGRATE_REGION_ERROR.getStatusCode());
                status.setMessage("deletePeer for region: " + regionId + " error. exception: " + e.getMessage());
                return status;
            }
            taskLogger.info("{}, Succeed to deletePeer {} from consensus group", (Object)RegionMigrateService.REGION_MIGRATE_PROCESS, (Object)regionId);
            status.setMessage("deletePeer from consensus group " + regionId + "succeed");
            return status;
        }

        private TSStatus deleteRegion() {
            taskLogger.info("{}, Start to deleteRegion {} for datanode {}", new Object[]{RegionMigrateService.REGION_MIGRATE_PROCESS, this.tRegionId, this.originalDataNode});
            TSStatus status = new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode());
            ConsensusGroupId regionId = ConsensusGroupId.Factory.createFromTConsensusGroupId((TConsensusGroupId)this.tRegionId);
            try {
                if (regionId instanceof DataRegionId) {
                    DataNodeRegionManager.getInstance().deleteDataRegion((DataRegionId)regionId);
                } else {
                    DataNodeRegionManager.getInstance().deleteSchemaRegion((SchemaRegionId)regionId);
                }
            }
            catch (Exception e) {
                taskLogger.error("{}, deleteRegion {} error", new Object[]{RegionMigrateService.REGION_MIGRATE_PROCESS, regionId, e});
                status.setCode(TSStatusCode.DELETE_REGION_ERROR.getStatusCode());
                status.setMessage("deleteRegion " + regionId + " error, " + e.getMessage());
                return status;
            }
            status.setMessage("deleteRegion " + regionId + " succeed");
            taskLogger.info("{}, Succeed to deleteRegion {}", (Object)RegionMigrateService.REGION_MIGRATE_PROCESS, (Object)regionId);
            return status;
        }
    }
}

