/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.schemaengine.schemaregion.utils;

import java.io.IOException;
import java.util.List;
import org.apache.iotdb.commons.path.AlignedFullPath;
import org.apache.iotdb.commons.path.IFullPath;
import org.apache.iotdb.commons.path.NonAlignedFullPath;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.queryengine.execution.fragment.QueryContext;
import org.apache.iotdb.db.schemaengine.schemaregion.utils.AlignedResourceByPathUtils;
import org.apache.iotdb.db.schemaengine.schemaregion.utils.MeasurementResourceByPathUtils;
import org.apache.iotdb.db.storageengine.dataregion.memtable.IMemTable;
import org.apache.iotdb.db.storageengine.dataregion.memtable.ReadOnlyMemChunk;
import org.apache.iotdb.db.storageengine.dataregion.modification.ModEntry;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResource;
import org.apache.tsfile.file.metadata.IChunkMetadata;
import org.apache.tsfile.file.metadata.ITimeSeriesMetadata;
import org.apache.tsfile.utils.Pair;
import org.apache.tsfile.write.writer.RestorableTsFileIOWriter;

public abstract class ResourceByPathUtils {
    public static ResourceByPathUtils getResourceInstance(IFullPath path) {
        if (path instanceof AlignedFullPath) {
            return new AlignedResourceByPathUtils(path);
        }
        if (path instanceof NonAlignedFullPath) {
            return new MeasurementResourceByPathUtils(path);
        }
        throw new UnsupportedOperationException("Should call exact sub class!");
    }

    public abstract ITimeSeriesMetadata generateTimeSeriesMetadata(List<ReadOnlyMemChunk> var1, List<IChunkMetadata> var2) throws IOException;

    public abstract ReadOnlyMemChunk getReadOnlyMemChunkFromMemTable(QueryContext var1, IMemTable var2, List<Pair<ModEntry, IMemTable>> var3, long var4) throws QueryProcessException, IOException;

    public abstract List<IChunkMetadata> getVisibleMetadataListFromWriter(RestorableTsFileIOWriter var1, TsFileResource var2, QueryContext var3, long var4);
}

