/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.statement.metadata;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.auth.entity.PrivilegeType;
import org.apache.iotdb.commons.path.MeasurementPath;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.auth.AuthorityChecker;
import org.apache.iotdb.db.queryengine.plan.statement.Statement;
import org.apache.iotdb.db.queryengine.plan.statement.StatementType;
import org.apache.iotdb.db.queryengine.plan.statement.StatementVisitor;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.file.metadata.enums.CompressionType;
import org.apache.tsfile.file.metadata.enums.TSEncoding;

public class CreateTimeSeriesStatement
extends Statement {
    private MeasurementPath path;
    private String alias;
    private TSDataType dataType;
    private TSEncoding encoding;
    private CompressionType compressor;
    private Map<String, String> props = null;
    private Map<String, String> attributes = null;
    private Map<String, String> tags = null;

    public CreateTimeSeriesStatement() {
        this.statementType = StatementType.CREATE_TIME_SERIES;
    }

    public List<PartialPath> getPaths() {
        return Collections.singletonList(this.path);
    }

    @Override
    public TSStatus checkPermissionBeforeProcess(String userName) {
        if (AuthorityChecker.SUPER_USER.equals(userName)) {
            return new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode());
        }
        return AuthorityChecker.getTSStatus(AuthorityChecker.checkFullPathPermission(userName, (PartialPath)this.path, PrivilegeType.WRITE_SCHEMA.ordinal()), PrivilegeType.WRITE_SCHEMA);
    }

    public MeasurementPath getPath() {
        return this.path;
    }

    public void setPath(MeasurementPath path) {
        this.path = path;
    }

    public TSDataType getDataType() {
        return this.dataType;
    }

    public void setDataType(TSDataType dataType) {
        this.dataType = dataType;
    }

    public TSEncoding getEncoding() {
        return this.encoding;
    }

    public void setEncoding(TSEncoding encoding) {
        this.encoding = encoding;
    }

    public void setCompressor(CompressionType compressor) {
        this.compressor = compressor;
    }

    public CompressionType getCompressor() {
        return this.compressor;
    }

    public Map<String, String> getProps() {
        return this.props;
    }

    public void setProps(Map<String, String> props) {
        this.props = props;
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Map<String, String> attributes) {
        this.attributes = attributes;
    }

    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public void setTags(Map<String, String> tags) {
        this.tags = tags;
    }

    @Override
    public <R, C> R accept(StatementVisitor<R, C> visitor, C context) {
        return visitor.visitCreateTimeseries(this, context);
    }
}

