/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.sql.ast;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupType;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.AstVisitor;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Node;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.NodeLocation;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Statement;

public class ShowRegions
extends Statement {
    private final TConsensusGroupType regionType;
    private final List<PartialPath> databases;
    private final List<Integer> nodeIds;

    public ShowRegions(TConsensusGroupType regionType, List<PartialPath> databases, List<Integer> nodeIds) {
        super(null);
        this.regionType = regionType;
        this.databases = databases;
        this.nodeIds = nodeIds;
    }

    public ShowRegions(NodeLocation location, TConsensusGroupType regionType, List<PartialPath> storageGroups, List<Integer> nodeIds) {
        super(Objects.requireNonNull(location, "location is null"));
        this.regionType = regionType;
        this.databases = Objects.requireNonNull(storageGroups, "databases is null");
        this.nodeIds = Objects.requireNonNull(nodeIds, "nodeIds is null");
    }

    public TConsensusGroupType getRegionType() {
        return this.regionType;
    }

    public List<PartialPath> getDatabases() {
        return this.databases;
    }

    public List<Integer> getNodeIds() {
        return this.nodeIds;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitShowRegions(this, context);
    }

    public List<Node> getChildren() {
        return ImmutableList.of();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ShowRegions that = (ShowRegions)o;
        return this.regionType == that.regionType && Objects.equals(this.databases, that.databases) && Objects.equals(this.nodeIds, that.nodeIds);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.regionType, this.databases, this.nodeIds);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("regionType", (Object)this.regionType).add("databases", this.databases).add("nodeIds", this.nodeIds).toString();
    }
}

