/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.sql.ast;

import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.iotdb.commons.schema.column.ColumnHeader;
import org.apache.iotdb.db.queryengine.common.header.DatasetHeader;
import org.apache.iotdb.db.queryengine.execution.operator.schema.source.TableDeviceQuerySource;
import org.apache.iotdb.db.queryengine.plan.relational.analyzer.Analysis;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.AbstractQueryDeviceWithCache;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.AstVisitor;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Expression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Node;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.NodeLocation;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Offset;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Table;
import org.apache.tsfile.read.common.block.TsBlock;
import org.apache.tsfile.read.common.block.TsBlockBuilder;

public class ShowDevice
extends AbstractQueryDeviceWithCache {
    private Offset offset;
    private Node limit;

    public ShowDevice(NodeLocation location, Table table, Expression rawExpression, Offset offset, Node limit) {
        super(location, table, rawExpression);
        this.offset = offset;
        this.limit = limit;
    }

    public ShowDevice(String database, String tableName) {
        super(database, tableName);
    }

    public Offset getOffset() {
        return this.offset;
    }

    public Node getLimit() {
        return this.limit;
    }

    @Override
    public DatasetHeader getDataSetHeader() {
        return new DatasetHeader(this.columnHeaderList, true);
    }

    @Override
    public TsBlock getTsBlock(Analysis analysis) {
        long limitLong;
        TsBlockBuilder tsBlockBuilder = new TsBlockBuilder(this.columnHeaderList.stream().map(ColumnHeader::getColumnType).collect(Collectors.toList()));
        int startIndex = Objects.nonNull(this.offset) ? Math.min(analysis.getOffset(this.offset) > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)analysis.getOffset(this.offset), this.results.size()) : 0;
        int endIndex = Objects.nonNull(this.limit) ? ((limitLong = analysis.getLimit(this.limit).orElse(-1L)) < 0L || (long)startIndex + limitLong > (long)this.results.size() ? this.results.size() : (int)(limitLong + (long)startIndex)) : this.results.size();
        this.results.subList(startIndex, endIndex).forEach(result -> TableDeviceQuerySource.transformToTsBlockColumns(result, tsBlockBuilder, this.database, this.tableName, this.columnHeaderList, 1));
        return tsBlockBuilder.build();
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitShowDevice(this, context);
    }

    @Override
    public String toString() {
        return "ShowDevice" + this.toStringContent();
    }
}

