/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.sql.ast;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.schema.column.ColumnHeader;
import org.apache.iotdb.commons.schema.filter.SchemaFilter;
import org.apache.iotdb.commons.schema.table.TsTable;
import org.apache.iotdb.db.queryengine.common.SessionInfo;
import org.apache.iotdb.db.queryengine.execution.operator.schema.source.DeviceBlackListConstructor;
import org.apache.iotdb.db.queryengine.execution.operator.schema.source.TableDeviceQuerySource;
import org.apache.iotdb.db.queryengine.execution.relational.ColumnTransformerBuilder;
import org.apache.iotdb.db.queryengine.plan.analyze.AnalyzeUtils;
import org.apache.iotdb.db.queryengine.plan.analyze.TypeProvider;
import org.apache.iotdb.db.queryengine.plan.planner.LocalExecutionPlanner;
import org.apache.iotdb.db.queryengine.plan.planner.plan.parameter.InputLocation;
import org.apache.iotdb.db.queryengine.plan.relational.metadata.Metadata;
import org.apache.iotdb.db.queryengine.plan.relational.planner.Symbol;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.AbstractTraverseDevice;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.AstVisitor;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Expression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.NodeLocation;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Table;
import org.apache.iotdb.db.queryengine.transformation.dag.column.ColumnTransformer;
import org.apache.iotdb.db.queryengine.transformation.dag.column.leaf.LeafColumnTransformer;
import org.apache.iotdb.db.schemaengine.rescon.MemSchemaRegionStatistics;
import org.apache.iotdb.db.storageengine.dataregion.modification.ModEntry;
import org.apache.iotdb.db.storageengine.dataregion.modification.TableDeletionEntry;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.read.common.type.TypeFactory;
import org.apache.tsfile.utils.Binary;
import org.apache.tsfile.utils.ReadWriteIOUtils;

public class DeleteDevice
extends AbstractTraverseDevice {
    private List<TableDeletionEntry> modEntries;

    public DeleteDevice(NodeLocation location, Table table, Expression where) {
        super(location, table, where);
    }

    public void parseModEntries(TsTable table) {
        this.modEntries = AnalyzeUtils.parseExpressions2ModEntries(this.where, table);
    }

    public void serializeModEntries(DataOutputStream stream) throws IOException {
        if (Objects.nonNull(this.modEntries)) {
            ReadWriteIOUtils.write((int)this.modEntries.size(), (OutputStream)stream);
            for (TableDeletionEntry modEntry : this.modEntries) {
                modEntry.serialize(stream);
            }
        }
    }

    public void serializePatternInfo(DataOutputStream stream) throws IOException {
        ReadWriteIOUtils.write((int)this.getIdDeterminedFilterList().size(), (OutputStream)stream);
        for (List filterList : this.idDeterminedFilterList) {
            ReadWriteIOUtils.write((int)filterList.size(), (OutputStream)stream);
            for (SchemaFilter filter : filterList) {
                SchemaFilter.serialize((SchemaFilter)filter, (DataOutputStream)stream);
            }
        }
    }

    public void serializeFilterInfo(DataOutputStream stream, SessionInfo sessionInfo) throws IOException {
        ReadWriteIOUtils.write((byte)(this.idFuzzyPredicate == null ? (byte)0 : 1), (OutputStream)stream);
        if (this.idFuzzyPredicate != null) {
            Expression.serialize(this.idFuzzyPredicate, stream);
        }
        ReadWriteIOUtils.write((int)this.columnHeaderList.size(), (OutputStream)stream);
        for (ColumnHeader columnHeader : this.columnHeaderList) {
            columnHeader.serialize(stream);
        }
        ReadWriteIOUtils.write((Boolean)Objects.nonNull(sessionInfo), (OutputStream)stream);
        if (Objects.nonNull(sessionInfo)) {
            sessionInfo.serialize(stream);
        }
    }

    public static List<TableDeletionEntry> constructModEntries(byte[] modInfo) {
        ByteBuffer buffer = ByteBuffer.wrap(modInfo);
        int size = ReadWriteIOUtils.readInt((ByteBuffer)buffer);
        ArrayList<TableDeletionEntry> modEntries = new ArrayList<TableDeletionEntry>(size);
        for (int i = 0; i < size; ++i) {
            modEntries.add((TableDeletionEntry)ModEntry.createFrom(buffer));
        }
        return modEntries;
    }

    public static List<PartialPath> constructPaths(String database, String tableName, byte[] patternInfo) {
        ByteBuffer buffer = ByteBuffer.wrap(patternInfo);
        int size = ReadWriteIOUtils.readInt((ByteBuffer)buffer);
        ArrayList<List<SchemaFilter>> idDeterminedFilterList = new ArrayList<List<SchemaFilter>>(size);
        for (int i = 0; i < size; ++i) {
            int singleSize = ReadWriteIOUtils.readInt((ByteBuffer)buffer);
            idDeterminedFilterList.add(new ArrayList(singleSize));
            for (int k = 0; k < singleSize; ++k) {
                ((List)idDeterminedFilterList.get(i)).add(SchemaFilter.deserialize((ByteBuffer)buffer));
            }
        }
        return TableDeviceQuerySource.getDevicePatternList(database, tableName, idDeterminedFilterList);
    }

    public static DeviceBlackListConstructor constructDevicePredicateUpdater(String database, String tableName, byte[] filterInfo, BiFunction<Integer, String, Binary> attributeProvider, MemSchemaRegionStatistics regionStatistics) {
        ByteBuffer buffer = ByteBuffer.wrap(filterInfo);
        Expression predicate = null;
        if (buffer.get() == 1) {
            predicate = Expression.deserialize(buffer);
        }
        int size = ReadWriteIOUtils.readInt((ByteBuffer)buffer);
        ArrayList<ColumnHeader> columnHeaderList = new ArrayList<ColumnHeader>(size);
        for (int i = 0; i < size; ++i) {
            columnHeaderList.add(ColumnHeader.deserialize((ByteBuffer)buffer));
        }
        SessionInfo sessionInfo = null;
        if (ReadWriteIOUtils.readBool((ByteBuffer)buffer)) {
            sessionInfo = SessionInfo.deserializeFrom(buffer);
        }
        AtomicInteger valueColumnIndex = new AtomicInteger(0);
        Map<Symbol, List<InputLocation>> inputLocations = columnHeaderList.stream().collect(Collectors.toMap(columnHeader -> new Symbol(columnHeader.getColumnName()), columnHeader -> Collections.singletonList(new InputLocation(0, valueColumnIndex.getAndIncrement()))));
        TypeProvider mockTypeProvider = new TypeProvider(columnHeaderList.stream().collect(Collectors.toMap(columnHeader -> new Symbol(columnHeader.getColumnName()), columnHeader -> TypeFactory.getType((TSDataType)columnHeader.getColumnType()))));
        Metadata metadata = LocalExecutionPlanner.getInstance().metadata;
        ArrayList<LeafColumnTransformer> filterLeafColumnTransformerList = new ArrayList<LeafColumnTransformer>();
        HashMap<Expression, ColumnTransformer> filterExpressionColumnTransformerMap = new HashMap<Expression, ColumnTransformer>();
        ColumnTransformerBuilder visitor = new ColumnTransformerBuilder();
        ColumnTransformer filterOutputTransformer = Objects.nonNull(predicate) ? (ColumnTransformer)visitor.process(predicate, new ColumnTransformerBuilder.Context(sessionInfo, filterLeafColumnTransformerList, inputLocations, filterExpressionColumnTransformerMap, (Map<Expression, ColumnTransformer>)ImmutableMap.of(), (List<ColumnTransformer>)ImmutableList.of(), (List<TSDataType>)ImmutableList.of(), 0, mockTypeProvider, metadata)) : null;
        return new DeviceBlackListConstructor(filterLeafColumnTransformerList, filterOutputTransformer, database, tableName, columnHeaderList, attributeProvider, regionStatistics);
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitDeleteDevice(this, context);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this) + " - " + super.toStringContent();
    }
}

