/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.planner.distribute;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import org.apache.iotdb.common.rpc.thrift.TDataNodeLocation;
import org.apache.iotdb.common.rpc.thrift.TRegionReplicaSet;
import org.apache.iotdb.commons.partition.DataPartition;
import org.apache.iotdb.commons.partition.SchemaPartition;
import org.apache.iotdb.commons.schema.table.column.TsTableColumnCategory;
import org.apache.iotdb.commons.udf.builtin.relational.TableBuiltinScalarFunction;
import org.apache.iotdb.db.queryengine.common.MPPQueryContext;
import org.apache.iotdb.db.queryengine.common.QueryId;
import org.apache.iotdb.db.queryengine.plan.planner.TableOperatorGenerator;
import org.apache.iotdb.db.queryengine.plan.planner.distribution.NodeDistribution;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanVisitor;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.WritePlanNode;
import org.apache.iotdb.db.queryengine.plan.relational.analyzer.Analysis;
import org.apache.iotdb.db.queryengine.plan.relational.metadata.AlignedDeviceEntry;
import org.apache.iotdb.db.queryengine.plan.relational.metadata.ColumnSchema;
import org.apache.iotdb.db.queryengine.plan.relational.metadata.DeviceEntry;
import org.apache.iotdb.db.queryengine.plan.relational.planner.OrderingScheme;
import org.apache.iotdb.db.queryengine.plan.relational.planner.SortOrder;
import org.apache.iotdb.db.queryengine.plan.relational.planner.Symbol;
import org.apache.iotdb.db.queryengine.plan.relational.planner.SymbolAllocator;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.AggregationNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.AggregationTableScanNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.AggregationTreeDeviceViewScanNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.CollectNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.DeviceTableScanNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.EnforceSingleRowNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.ExplainAnalyzeNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.FillNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.FilterNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.GapFillNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.InformationSchemaTableScanNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.JoinNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.LimitNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.MergeSortNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.OffsetNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.OutputNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.ProjectNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.SortNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.StreamSortNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.TopKNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.TreeAlignedDeviceViewScanNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.TreeDeviceViewScanNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.TreeNonAlignedDeviceViewScanNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.ValueFillNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.schema.AbstractTableDeviceQueryNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.schema.TableDeviceFetchNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.schema.TableDeviceQueryCountNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.schema.TableDeviceQueryScanNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.optimizations.DataNodeLocationSupplierFactory;
import org.apache.iotdb.db.queryengine.plan.relational.planner.optimizations.PushPredicateIntoTableScan;
import org.apache.iotdb.db.queryengine.plan.relational.planner.optimizations.TransformSortToStreamSort;
import org.apache.iotdb.db.queryengine.plan.relational.planner.optimizations.Util;
import org.apache.iotdb.db.queryengine.plan.statement.component.Ordering;
import org.apache.tsfile.common.conf.TSFileConfig;
import org.apache.tsfile.file.metadata.IDeviceID;
import org.apache.tsfile.utils.Pair;
import org.apache.tsfile.utils.Preconditions;

public class TableDistributedPlanGenerator
extends PlanVisitor<List<PlanNode>, PlanContext> {
    private static final String PUSH_DOWN_DATE_BIN_SYMBOL_NAME = TableBuiltinScalarFunction.DATE_BIN.getFunctionName() + "$" + "gid";
    private final QueryId queryId;
    private final Analysis analysis;
    private final SymbolAllocator symbolAllocator;
    private final Map<PlanNodeId, OrderingScheme> nodeOrderingMap = new HashMap<PlanNodeId, OrderingScheme>();
    private final DataNodeLocationSupplierFactory.DataNodeLocationSupplier dataNodeLocationSupplier;

    public TableDistributedPlanGenerator(MPPQueryContext queryContext, Analysis analysis, SymbolAllocator symbolAllocator, DataNodeLocationSupplierFactory.DataNodeLocationSupplier dataNodeLocationSupplier) {
        this.queryId = queryContext.getQueryId();
        this.analysis = analysis;
        this.symbolAllocator = symbolAllocator;
        this.dataNodeLocationSupplier = dataNodeLocationSupplier;
    }

    public List<PlanNode> genResult(PlanNode node, PlanContext context) {
        List<PlanNode> res = node.accept(this, context);
        if (res.size() == 1) {
            return res;
        }
        if (res.size() > 1) {
            CollectNode collectNode = new CollectNode(this.queryId.genPlanNodeId(), res.get(0).getOutputSymbols());
            res.forEach(collectNode::addChild);
            return Collections.singletonList(collectNode);
        }
        throw new IllegalStateException("List<PlanNode>.size should >= 1, but now is 0");
    }

    @Override
    public List<PlanNode> visitPlan(PlanNode node, PlanContext context) {
        if (node instanceof WritePlanNode) {
            return Collections.singletonList(node);
        }
        List children = (List)node.getChildren().stream().map(child -> child.accept(this, context)).collect(ImmutableList.toImmutableList());
        PlanNode newNode = node.clone();
        for (List planNodes : children) {
            planNodes.forEach(newNode::addChild);
        }
        return Collections.singletonList(newNode);
    }

    @Override
    public List<PlanNode> visitExplainAnalyze(ExplainAnalyzeNode node, PlanContext context) {
        List<PlanNode> children = this.genResult(node.getChild(), context);
        node.setChild(children.get(0));
        return Collections.singletonList(node);
    }

    @Override
    public List<PlanNode> visitOutput(OutputNode node, PlanContext context) {
        List<PlanNode> childrenNodes = node.getChild().accept(this, context);
        OrderingScheme childOrdering = this.nodeOrderingMap.get(childrenNodes.get(0).getPlanNodeId());
        if (childOrdering != null) {
            this.nodeOrderingMap.put(node.getPlanNodeId(), childOrdering);
        }
        node.setChild(this.mergeChildrenViaCollectOrMergeSort(childOrdering, childrenNodes));
        return Collections.singletonList(node);
    }

    @Override
    public List<PlanNode> visitFill(FillNode node, PlanContext context) {
        List<PlanNode> childrenNodes;
        OrderingScheme childOrdering;
        if (!(node instanceof ValueFillNode)) {
            context.clearExpectedOrderingScheme();
        }
        if ((childOrdering = this.nodeOrderingMap.get((childrenNodes = node.getChild().accept(this, context)).get(0).getPlanNodeId())) != null) {
            this.nodeOrderingMap.put(node.getPlanNodeId(), childOrdering);
        }
        node.setChild(this.mergeChildrenViaCollectOrMergeSort(childOrdering, childrenNodes));
        return Collections.singletonList(node);
    }

    @Override
    public List<PlanNode> visitGapFill(GapFillNode node, PlanContext context) {
        context.clearExpectedOrderingScheme();
        List<PlanNode> childrenNodes = node.getChild().accept(this, context);
        OrderingScheme childOrdering = this.nodeOrderingMap.get(childrenNodes.get(0).getPlanNodeId());
        if (childOrdering != null) {
            this.nodeOrderingMap.put(node.getPlanNodeId(), childOrdering);
        }
        node.setChild(this.mergeChildrenViaCollectOrMergeSort(childOrdering, childrenNodes));
        return Collections.singletonList(node);
    }

    @Override
    public List<PlanNode> visitLimit(LimitNode node, PlanContext context) {
        List<PlanNode> childrenNodes = node.getChild().accept(this, context);
        OrderingScheme childOrdering = this.nodeOrderingMap.get(childrenNodes.get(0).getPlanNodeId());
        if (childOrdering != null) {
            this.nodeOrderingMap.put(node.getPlanNodeId(), childOrdering);
        }
        node.setChild(this.mergeChildrenViaCollectOrMergeSort(childOrdering, childrenNodes));
        return Collections.singletonList(node);
    }

    @Override
    public List<PlanNode> visitOffset(OffsetNode node, PlanContext context) {
        List<PlanNode> childrenNodes = node.getChild().accept(this, context);
        OrderingScheme childOrdering = this.nodeOrderingMap.get(childrenNodes.get(0).getPlanNodeId());
        if (childOrdering != null) {
            this.nodeOrderingMap.put(node.getPlanNodeId(), childOrdering);
        }
        node.setChild(this.mergeChildrenViaCollectOrMergeSort(childOrdering, childrenNodes));
        return Collections.singletonList(node);
    }

    @Override
    public List<PlanNode> visitProject(ProjectNode node, PlanContext context) {
        List<PlanNode> childrenNodes = node.getChild().accept(this, context);
        OrderingScheme childOrdering = this.nodeOrderingMap.get(childrenNodes.get(0).getPlanNodeId());
        if (childOrdering != null) {
            this.nodeOrderingMap.put(node.getPlanNodeId(), childOrdering);
        }
        if (childrenNodes.size() == 1) {
            node.setChild(childrenNodes.get(0));
            return Collections.singletonList(node);
        }
        boolean canCopyThis = true;
        if (childOrdering != null) {
            canCopyThis = ImmutableSet.copyOf(node.getOutputSymbols()).containsAll(childOrdering.getOrderBy());
        }
        boolean bl = canCopyThis = canCopyThis && node.getAssignments().getMap().values().stream().noneMatch(PushPredicateIntoTableScan::containsDiffFunction);
        if (!canCopyThis) {
            node.setChild(this.mergeChildrenViaCollectOrMergeSort(childOrdering, childrenNodes));
            return Collections.singletonList(node);
        }
        ArrayList<PlanNode> resultNodeList = new ArrayList<PlanNode>();
        for (int i = 0; i < childrenNodes.size(); ++i) {
            PlanNode child = childrenNodes.get(i);
            ProjectNode subProjectNode = new ProjectNode(this.queryId.genPlanNodeId(), child, node.getAssignments());
            resultNodeList.add(subProjectNode);
            if (i != 0) continue;
            this.nodeOrderingMap.put(subProjectNode.getPlanNodeId(), childOrdering);
        }
        return resultNodeList;
    }

    @Override
    public List<PlanNode> visitTopK(TopKNode node, PlanContext context) {
        context.setExpectedOrderingScheme(node.getOrderingScheme());
        this.nodeOrderingMap.put(node.getPlanNodeId(), node.getOrderingScheme());
        Preconditions.checkArgument((node.getChildren().size() == 1 ? 1 : 0) != 0, (String)"Size of TopKNode can only be 1 in logical plan.");
        List<PlanNode> childrenNodes = node.getChildren().get(0).accept(this, context);
        if (childrenNodes.size() == 1) {
            node.setChildren(Collections.singletonList(childrenNodes.get(0)));
            return Collections.singletonList(node);
        }
        TopKNode newTopKNode = (TopKNode)node.clone();
        for (int i = 0; i < childrenNodes.size(); ++i) {
            PlanNode child = childrenNodes.get(i);
            TopKNode subTopKNode = new TopKNode(this.queryId.genPlanNodeId(), Collections.singletonList(child), node.getOrderingScheme(), node.getCount(), node.getOutputSymbols(), node.isChildrenDataInOrder());
            newTopKNode.addChild(subTopKNode);
        }
        this.nodeOrderingMap.put(newTopKNode.getPlanNodeId(), newTopKNode.getOrderingScheme());
        return Collections.singletonList(newTopKNode);
    }

    @Override
    public List<PlanNode> visitSort(SortNode node, PlanContext context) {
        context.setExpectedOrderingScheme(node.getOrderingScheme());
        this.nodeOrderingMap.put(node.getPlanNodeId(), node.getOrderingScheme());
        List<PlanNode> childrenNodes = node.getChild().accept(this, context);
        if (childrenNodes.size() == 1) {
            if (this.canSortEliminated(node.getOrderingScheme(), this.nodeOrderingMap.get(childrenNodes.get(0).getPlanNodeId()))) {
                return childrenNodes;
            }
            node.setChild(childrenNodes.get(0));
            return Collections.singletonList(node);
        }
        MergeSortNode mergeSortNode = new MergeSortNode(this.queryId.genPlanNodeId(), node.getOrderingScheme(), node.getOutputSymbols());
        for (PlanNode child : childrenNodes) {
            if (this.canSortEliminated(node.getOrderingScheme(), this.nodeOrderingMap.get(child.getPlanNodeId()))) {
                mergeSortNode.addChild(child);
                continue;
            }
            SortNode subSortNode = new SortNode(this.queryId.genPlanNodeId(), child, node.getOrderingScheme(), false, false);
            mergeSortNode.addChild(subSortNode);
        }
        this.nodeOrderingMap.put(mergeSortNode.getPlanNodeId(), mergeSortNode.getOrderingScheme());
        return Collections.singletonList(mergeSortNode);
    }

    private boolean canSortEliminated(@Nonnull OrderingScheme sortOrderingSchema, OrderingScheme childOrderingSchema) {
        if (childOrderingSchema == null) {
            return false;
        }
        List<Symbol> symbolsOfSort = sortOrderingSchema.getOrderBy();
        List<Symbol> symbolsOfChild = childOrderingSchema.getOrderBy();
        if (symbolsOfSort.size() > symbolsOfChild.size()) {
            return false;
        }
        int size = symbolsOfSort.size();
        for (int i = 0; i < size; ++i) {
            Symbol symbolOfSort = symbolsOfSort.get(i);
            SortOrder sortOrderOfSortNode = sortOrderingSchema.getOrdering(symbolOfSort);
            Symbol symbolOfChild = symbolsOfChild.get(i);
            SortOrder sortOrderOfChild = childOrderingSchema.getOrdering(symbolOfChild);
            if (symbolOfSort.equals(symbolOfChild) && sortOrderOfSortNode == sortOrderOfChild) continue;
            return false;
        }
        return true;
    }

    @Override
    public List<PlanNode> visitStreamSort(StreamSortNode node, PlanContext context) {
        context.setExpectedOrderingScheme(node.getOrderingScheme());
        this.nodeOrderingMap.put(node.getPlanNodeId(), node.getOrderingScheme());
        List<PlanNode> childrenNodes = node.getChild().accept(this, context);
        if (childrenNodes.size() == 1) {
            if (this.canSortEliminated(node.getOrderingScheme(), this.nodeOrderingMap.get(childrenNodes.get(0).getPlanNodeId()))) {
                return childrenNodes;
            }
            node.setChild(childrenNodes.get(0));
            return Collections.singletonList(node);
        }
        MergeSortNode mergeSortNode = new MergeSortNode(this.queryId.genPlanNodeId(), node.getOrderingScheme(), node.getOutputSymbols());
        for (PlanNode child : childrenNodes) {
            if (this.canSortEliminated(node.getOrderingScheme(), this.nodeOrderingMap.get(child.getPlanNodeId()))) {
                mergeSortNode.addChild(child);
                continue;
            }
            StreamSortNode subSortNode = new StreamSortNode(this.queryId.genPlanNodeId(), child, node.getOrderingScheme(), false, node.isOrderByAllIdsAndTime(), node.getStreamCompareKeyEndIndex());
            mergeSortNode.addChild(subSortNode);
        }
        this.nodeOrderingMap.put(mergeSortNode.getPlanNodeId(), mergeSortNode.getOrderingScheme());
        return Collections.singletonList(mergeSortNode);
    }

    @Override
    public List<PlanNode> visitFilter(FilterNode node, PlanContext context) {
        List<PlanNode> childrenNodes = node.getChild().accept(this, context);
        OrderingScheme childOrdering = this.nodeOrderingMap.get(childrenNodes.get(0).getPlanNodeId());
        if (childOrdering != null) {
            this.nodeOrderingMap.put(node.getPlanNodeId(), childOrdering);
        }
        if (childrenNodes.size() == 1) {
            node.setChild(childrenNodes.get(0));
            return Collections.singletonList(node);
        }
        if (PushPredicateIntoTableScan.containsDiffFunction(node.getPredicate())) {
            node.setChild(this.mergeChildrenViaCollectOrMergeSort(childOrdering, childrenNodes));
            return Collections.singletonList(node);
        }
        ArrayList<PlanNode> resultNodeList = new ArrayList<PlanNode>();
        for (int i = 0; i < childrenNodes.size(); ++i) {
            PlanNode child = childrenNodes.get(i);
            FilterNode subFilterNode = new FilterNode(this.queryId.genPlanNodeId(), child, node.getPredicate());
            resultNodeList.add(subFilterNode);
            if (i != 0) continue;
            this.nodeOrderingMap.put(subFilterNode.getPlanNodeId(), childOrdering);
        }
        return resultNodeList;
    }

    @Override
    public List<PlanNode> visitJoin(JoinNode node, PlanContext context) {
        List<PlanNode> leftChildrenNodes = node.getLeftChild().accept(this, context);
        List<PlanNode> rightChildrenNodes = node.getRightChild().accept(this, context);
        if (!node.isCrossJoin()) {
            Preconditions.checkArgument((leftChildrenNodes.size() == 1 ? 1 : 0) != 0, (String)"The size of left children node of JoinNode should be 1");
            Preconditions.checkArgument((rightChildrenNodes.size() == 1 ? 1 : 0) != 0, (String)"The size of right children node of JoinNode should be 1");
        }
        node.setLeftChild(this.mergeChildrenViaCollectOrMergeSort(this.nodeOrderingMap.get(node.getLeftChild().getPlanNodeId()), leftChildrenNodes));
        node.setRightChild(this.mergeChildrenViaCollectOrMergeSort(this.nodeOrderingMap.get(node.getRightChild().getPlanNodeId()), rightChildrenNodes));
        return Collections.singletonList(node);
    }

    @Override
    public List<PlanNode> visitDeviceTableScan(DeviceTableScanNode node, PlanContext context) {
        HashMap<TRegionReplicaSet, DeviceTableScanNode> tableScanNodeMap = new HashMap<TRegionReplicaSet, DeviceTableScanNode>();
        for (DeviceEntry deviceEntry : node.getDeviceEntries()) {
            List<TRegionReplicaSet> regionReplicaSets = this.analysis.getDataRegionReplicaSetWithTimeFilter(node.getQualifiedObjectName().getDatabaseName(), deviceEntry.getDeviceID(), node.getTimeFilter());
            for (TRegionReplicaSet regionReplicaSet : regionReplicaSets) {
                DeviceTableScanNode deviceTableScanNode = tableScanNodeMap.computeIfAbsent(regionReplicaSet, k -> {
                    DeviceTableScanNode scanNode = new DeviceTableScanNode(this.queryId.genPlanNodeId(), node.getQualifiedObjectName(), node.getOutputSymbols(), node.getAssignments(), new ArrayList<DeviceEntry>(), node.getIdAndAttributeIndexMap(), node.getScanOrder(), node.getTimePredicate().orElse(null), node.getPushDownPredicate(), node.getPushDownLimit(), node.getPushDownOffset(), node.isPushLimitToEachDevice(), node.containsNonAlignedDevice());
                    scanNode.setRegionReplicaSet(regionReplicaSet);
                    return scanNode;
                });
                deviceTableScanNode.appendDeviceEntry(deviceEntry);
            }
        }
        if (tableScanNodeMap.isEmpty()) {
            node.setRegionReplicaSet(DataPartition.NOT_ASSIGNED);
            return Collections.singletonList(node);
        }
        ArrayList<PlanNode> resultTableScanNodeList = new ArrayList<PlanNode>();
        TRegionReplicaSet mostUsedDataRegion = null;
        int maxDeviceEntrySizeOfTableScan = 0;
        for (Map.Entry entry : tableScanNodeMap.entrySet()) {
            DeviceTableScanNode subDeviceTableScanNode = (DeviceTableScanNode)entry.getValue();
            resultTableScanNodeList.add(subDeviceTableScanNode);
            if (mostUsedDataRegion != null && subDeviceTableScanNode.getDeviceEntries().size() <= maxDeviceEntrySizeOfTableScan) continue;
            mostUsedDataRegion = (TRegionReplicaSet)entry.getKey();
            maxDeviceEntrySizeOfTableScan = subDeviceTableScanNode.getDeviceEntries().size();
        }
        context.mostUsedRegion = mostUsedDataRegion;
        if (!context.hasSortProperty) {
            return resultTableScanNodeList;
        }
        this.processSortProperty(node, resultTableScanNodeList, context);
        return resultTableScanNodeList;
    }

    @Override
    public List<PlanNode> visitTreeDeviceViewScan(TreeDeviceViewScanNode node, PlanContext context) {
        Pair pair;
        HashMap<TRegionReplicaSet, Pair> tableScanNodeMap = new HashMap<TRegionReplicaSet, Pair>();
        for (DeviceEntry deviceEntry : node.getDeviceEntries()) {
            List<TRegionReplicaSet> regionReplicaSets = this.analysis.getDataRegionReplicaSetWithTimeFilter(node.getTreeDBName(), deviceEntry.getDeviceID(), node.getTimeFilter());
            for (TRegionReplicaSet regionReplicaSet : regionReplicaSets) {
                TreeDeviceViewScanNode scanNode;
                boolean aligned = deviceEntry instanceof AlignedDeviceEntry;
                pair = (Pair)tableScanNodeMap.get(regionReplicaSet);
                if (pair == null) {
                    pair = new Pair(null, null);
                    tableScanNodeMap.put(regionReplicaSet, pair);
                }
                if (pair.left == null && aligned) {
                    scanNode = new TreeAlignedDeviceViewScanNode(this.queryId.genPlanNodeId(), node.getQualifiedObjectName(), node.getOutputSymbols(), node.getAssignments(), new ArrayList<DeviceEntry>(), node.getIdAndAttributeIndexMap(), node.getScanOrder(), node.getTimePredicate().orElse(null), node.getPushDownPredicate(), node.getPushDownLimit(), node.getPushDownOffset(), node.isPushLimitToEachDevice(), node.containsNonAlignedDevice(), node.getTreeDBName(), node.getMeasurementColumnNameMap());
                    scanNode.setRegionReplicaSet(regionReplicaSet);
                    pair.left = scanNode;
                }
                if (pair.right == null && !aligned) {
                    scanNode = new TreeNonAlignedDeviceViewScanNode(this.queryId.genPlanNodeId(), node.getQualifiedObjectName(), node.getOutputSymbols(), node.getAssignments(), new ArrayList<DeviceEntry>(), node.getIdAndAttributeIndexMap(), node.getScanOrder(), node.getTimePredicate().orElse(null), node.getPushDownPredicate(), node.getPushDownLimit(), node.getPushDownOffset(), node.isPushLimitToEachDevice(), node.containsNonAlignedDevice(), node.getTreeDBName(), node.getMeasurementColumnNameMap());
                    scanNode.setRegionReplicaSet(regionReplicaSet);
                    pair.right = scanNode;
                }
                if (aligned) {
                    ((TreeAlignedDeviceViewScanNode)pair.left).appendDeviceEntry(deviceEntry);
                    continue;
                }
                ((TreeNonAlignedDeviceViewScanNode)pair.right).appendDeviceEntry(deviceEntry);
            }
        }
        if (tableScanNodeMap.isEmpty()) {
            node.setRegionReplicaSet(DataPartition.NOT_ASSIGNED);
            return Collections.singletonList(node);
        }
        ArrayList<PlanNode> resultTableScanNodeList = new ArrayList<PlanNode>();
        TRegionReplicaSet mostUsedDataRegion = null;
        int maxDeviceEntrySizeOfTableScan = 0;
        for (Map.Entry entry : tableScanNodeMap.entrySet()) {
            TRegionReplicaSet regionReplicaSet = (TRegionReplicaSet)entry.getKey();
            pair = (Pair)entry.getValue();
            int currentDeviceEntrySize = 0;
            if (pair.left != null) {
                currentDeviceEntrySize += ((TreeAlignedDeviceViewScanNode)pair.left).getDeviceEntries().size();
                resultTableScanNodeList.add((PlanNode)pair.left);
            }
            if (pair.right != null) {
                currentDeviceEntrySize += ((TreeNonAlignedDeviceViewScanNode)pair.right).getDeviceEntries().size();
                resultTableScanNodeList.add((PlanNode)pair.right);
            }
            if (mostUsedDataRegion != null && currentDeviceEntrySize <= maxDeviceEntrySizeOfTableScan) continue;
            mostUsedDataRegion = regionReplicaSet;
            maxDeviceEntrySizeOfTableScan = currentDeviceEntrySize;
        }
        context.mostUsedRegion = mostUsedDataRegion;
        if (!context.hasSortProperty) {
            return resultTableScanNodeList;
        }
        this.processSortProperty(node, resultTableScanNodeList, context);
        return resultTableScanNodeList;
    }

    @Override
    public List<PlanNode> visitInformationSchemaTableScan(InformationSchemaTableScanNode node, PlanContext context) {
        List<TDataNodeLocation> dataNodeLocations = this.dataNodeLocationSupplier.getDataNodeLocations(node.getQualifiedObjectName().getObjectName());
        Preconditions.checkArgument((!dataNodeLocations.isEmpty() ? 1 : 0) != 0, (String)"DataNodeLocations shouldn't be empty");
        ArrayList<PlanNode> resultTableScanNodeList = new ArrayList<PlanNode>();
        dataNodeLocations.forEach(dataNodeLocation -> resultTableScanNodeList.add(new InformationSchemaTableScanNode(this.queryId.genPlanNodeId(), node.getQualifiedObjectName(), node.getOutputSymbols(), node.getAssignments(), node.getPushDownPredicate(), node.getPushDownLimit(), node.getPushDownOffset(), new TRegionReplicaSet(null, (List)ImmutableList.of((Object)dataNodeLocation)))));
        return resultTableScanNodeList;
    }

    @Override
    public List<PlanNode> visitAggregation(AggregationNode node, PlanContext context) {
        List<PlanNode> childrenNodes;
        OrderingScheme childOrdering;
        if (node.isStreamable()) {
            OrderingScheme expectedOrderingSchema = TableDistributedPlanGenerator.constructOrderingSchema(node.getPreGroupedSymbols());
            context.setExpectedOrderingScheme(expectedOrderingSchema);
        }
        if ((childOrdering = this.nodeOrderingMap.get((childrenNodes = node.getChild().accept(this, context)).get(0).getPlanNodeId())) != null) {
            this.nodeOrderingMap.put(node.getPlanNodeId(), childOrdering);
        }
        if (childrenNodes.size() == 1) {
            node.setChild(childrenNodes.get(0));
            return Collections.singletonList(node);
        }
        Pair<AggregationNode, AggregationNode> splitResult = Util.split(node, this.symbolAllocator, this.queryId);
        AggregationNode intermediate = (AggregationNode)splitResult.right;
        childrenNodes = childrenNodes.stream().map(child -> {
            PlanNodeId planNodeId = this.queryId.genPlanNodeId();
            AggregationNode aggregationNode = new AggregationNode(planNodeId, (PlanNode)child, intermediate.getAggregations(), intermediate.getGroupingSets(), intermediate.getPreGroupedSymbols(), intermediate.getStep(), intermediate.getHashSymbol(), intermediate.getGroupIdSymbol());
            if (node.isStreamable()) {
                this.nodeOrderingMap.put(planNodeId, childOrdering);
            }
            return aggregationNode;
        }).collect(Collectors.toList());
        ((AggregationNode)splitResult.left).setChild(this.mergeChildrenViaCollectOrMergeSort(this.nodeOrderingMap.get(childrenNodes.get(0).getPlanNodeId()), childrenNodes));
        return Collections.singletonList((PlanNode)splitResult.left);
    }

    @Override
    public List<PlanNode> visitAggregationTableScan(AggregationTableScanNode node, PlanContext context) {
        boolean needSplit = false;
        ArrayList<List<TRegionReplicaSet>> regionReplicaSetsList = new ArrayList();
        Iterator<DeviceEntry> iterator = node.getDeviceEntries().iterator();
        while (iterator.hasNext()) {
            DeviceEntry deviceEntry;
            List<TRegionReplicaSet> regionReplicaSets = this.analysis.getDataRegionReplicaSetWithTimeFilter(node instanceof AggregationTreeDeviceViewScanNode ? ((AggregationTreeDeviceViewScanNode)node).getTreeDBName() : node.getQualifiedObjectName().getDatabaseName(), (deviceEntry = iterator.next()).getDeviceID(), node.getTimeFilter());
            if (regionReplicaSets.size() > 1) {
                needSplit = true;
            }
            regionReplicaSetsList.add(regionReplicaSets);
        }
        if (regionReplicaSetsList.isEmpty()) {
            regionReplicaSetsList = Collections.singletonList(Collections.singletonList(DataPartition.NOT_ASSIGNED));
        }
        HashMap<TRegionReplicaSet, AggregationTableScanNode> regionNodeMap = new HashMap<TRegionReplicaSet, AggregationTableScanNode>();
        needSplit = needSplit && node.getStep() == AggregationNode.Step.SINGLE;
        AggregationNode finalAggregation = null;
        if (needSplit) {
            Pair<AggregationNode, AggregationTableScanNode> splitResult = Util.split(node, this.symbolAllocator, this.queryId);
            finalAggregation = (AggregationNode)splitResult.left;
            AggregationTableScanNode partialAggregation = (AggregationTableScanNode)splitResult.right;
            if (!context.hasSortProperty && finalAggregation.isStreamable()) {
                OrderingScheme expectedOrderingSchema = TableDistributedPlanGenerator.constructOrderingSchema(node.getPreGroupedSymbols());
                context.setExpectedOrderingScheme(expectedOrderingSchema);
            }
            this.buildRegionNodeMap(node, regionReplicaSetsList, regionNodeMap, partialAggregation);
        } else {
            this.buildRegionNodeMap(node, regionReplicaSetsList, regionNodeMap, node);
        }
        List<PlanNode> resultTableScanNodeList = new ArrayList<PlanNode>();
        TRegionReplicaSet mostUsedDataRegion = null;
        int maxDeviceEntrySizeOfTableScan = 0;
        for (Map.Entry entry : regionNodeMap.entrySet()) {
            DeviceTableScanNode subDeviceTableScanNode = (DeviceTableScanNode)entry.getValue();
            resultTableScanNodeList.add(subDeviceTableScanNode);
            if (mostUsedDataRegion != null && subDeviceTableScanNode.getDeviceEntries().size() <= maxDeviceEntrySizeOfTableScan) continue;
            mostUsedDataRegion = (TRegionReplicaSet)entry.getKey();
            maxDeviceEntrySizeOfTableScan = subDeviceTableScanNode.getDeviceEntries().size();
        }
        context.mostUsedRegion = mostUsedDataRegion;
        if (context.hasSortProperty) {
            this.processSortProperty(node, resultTableScanNodeList, context);
        }
        if (needSplit) {
            if (resultTableScanNodeList.size() == 1) {
                finalAggregation.setChild((PlanNode)resultTableScanNodeList.get(0));
            } else if (resultTableScanNodeList.size() > 1) {
                OrderingScheme childOrdering = this.nodeOrderingMap.get(((PlanNode)resultTableScanNodeList.get(0)).getPlanNodeId());
                finalAggregation.setChild(this.mergeChildrenViaCollectOrMergeSort(childOrdering, resultTableScanNodeList));
            } else {
                throw new IllegalStateException("List<PlanNode>.size should >= 1, but now is 0");
            }
            resultTableScanNodeList = Collections.singletonList(finalAggregation);
        }
        return resultTableScanNodeList;
    }

    @Override
    public List<PlanNode> visitEnforceSingleRow(EnforceSingleRowNode node, PlanContext context) {
        List<PlanNode> childrenNodes = node.getChild().accept(this, context);
        OrderingScheme childOrdering = this.nodeOrderingMap.get(childrenNodes.get(0).getPlanNodeId());
        if (childOrdering != null) {
            this.nodeOrderingMap.put(node.getPlanNodeId(), childOrdering);
        }
        node.setChild(this.mergeChildrenViaCollectOrMergeSort(childOrdering, childrenNodes));
        return Collections.singletonList(node);
    }

    private void buildRegionNodeMap(AggregationTableScanNode originalAggTableScanNode, List<List<TRegionReplicaSet>> regionReplicaSetsList, Map<TRegionReplicaSet, AggregationTableScanNode> regionNodeMap, AggregationTableScanNode partialAggTableScanNode) {
        AggregationTreeDeviceViewScanNode aggregationTreeDeviceViewScanNode = originalAggTableScanNode instanceof AggregationTreeDeviceViewScanNode ? (AggregationTreeDeviceViewScanNode)originalAggTableScanNode : null;
        for (int i = 0; i < regionReplicaSetsList.size(); ++i) {
            for (TRegionReplicaSet regionReplicaSet : regionReplicaSetsList.get(i)) {
                AggregationTableScanNode aggregationTableScanNode = regionNodeMap.computeIfAbsent(regionReplicaSet, k -> {
                    AggregationTableScanNode scanNode = aggregationTreeDeviceViewScanNode == null ? new AggregationTableScanNode(this.queryId.genPlanNodeId(), partialAggTableScanNode.getQualifiedObjectName(), partialAggTableScanNode.getOutputSymbols(), partialAggTableScanNode.getAssignments(), new ArrayList<DeviceEntry>(), partialAggTableScanNode.getIdAndAttributeIndexMap(), partialAggTableScanNode.getScanOrder(), partialAggTableScanNode.getTimePredicate().orElse(null), partialAggTableScanNode.getPushDownPredicate(), partialAggTableScanNode.getPushDownLimit(), partialAggTableScanNode.getPushDownOffset(), partialAggTableScanNode.isPushLimitToEachDevice(), partialAggTableScanNode.containsNonAlignedDevice(), partialAggTableScanNode.getProjection(), partialAggTableScanNode.getAggregations(), partialAggTableScanNode.getGroupingSets(), partialAggTableScanNode.getPreGroupedSymbols(), partialAggTableScanNode.getStep(), partialAggTableScanNode.getGroupIdSymbol()) : new AggregationTreeDeviceViewScanNode(this.queryId.genPlanNodeId(), partialAggTableScanNode.getQualifiedObjectName(), partialAggTableScanNode.getOutputSymbols(), partialAggTableScanNode.getAssignments(), new ArrayList<DeviceEntry>(), partialAggTableScanNode.getIdAndAttributeIndexMap(), partialAggTableScanNode.getScanOrder(), partialAggTableScanNode.getTimePredicate().orElse(null), partialAggTableScanNode.getPushDownPredicate(), partialAggTableScanNode.getPushDownLimit(), partialAggTableScanNode.getPushDownOffset(), partialAggTableScanNode.isPushLimitToEachDevice(), partialAggTableScanNode.containsNonAlignedDevice(), partialAggTableScanNode.getProjection(), partialAggTableScanNode.getAggregations(), partialAggTableScanNode.getGroupingSets(), partialAggTableScanNode.getPreGroupedSymbols(), partialAggTableScanNode.getStep(), partialAggTableScanNode.getGroupIdSymbol(), aggregationTreeDeviceViewScanNode.getTreeDBName(), aggregationTreeDeviceViewScanNode.getMeasurementColumnNameMap());
                    scanNode.setRegionReplicaSet(regionReplicaSet);
                    return scanNode;
                });
                if (originalAggTableScanNode.getDeviceEntries().size() <= i || originalAggTableScanNode.getDeviceEntries().get(i) == null) continue;
                aggregationTableScanNode.appendDeviceEntry(originalAggTableScanNode.getDeviceEntries().get(i));
            }
        }
    }

    private static OrderingScheme constructOrderingSchema(List<Symbol> symbols) {
        HashMap<Symbol, SortOrder> orderings = new HashMap<Symbol, SortOrder>();
        symbols.forEach(symbol -> orderings.put((Symbol)symbol, SortOrder.ASC_NULLS_LAST));
        return new OrderingScheme(symbols, orderings);
    }

    private PlanNode mergeChildrenViaCollectOrMergeSort(OrderingScheme childOrdering, List<PlanNode> childrenNodes) {
        Preconditions.checkArgument((!childrenNodes.isEmpty() ? 1 : 0) != 0, (String)"childrenNodes should not be empty");
        if (childrenNodes.size() == 1) {
            return childrenNodes.get(0);
        }
        PlanNode firstChild = childrenNodes.get(0);
        if (childOrdering != null) {
            MergeSortNode mergeSortNode = new MergeSortNode(this.queryId.genPlanNodeId(), childOrdering, firstChild.getOutputSymbols());
            childrenNodes.forEach(mergeSortNode::addChild);
            this.nodeOrderingMap.put(mergeSortNode.getPlanNodeId(), childOrdering);
            return mergeSortNode;
        }
        CollectNode collectNode = new CollectNode(this.queryId.genPlanNodeId(), firstChild.getOutputSymbols());
        childrenNodes.forEach(collectNode::addChild);
        return collectNode;
    }

    private void processSortProperty(DeviceTableScanNode deviceTableScanNode, List<PlanNode> resultTableScanNodeList, PlanContext context) {
        ArrayList<Symbol> newOrderingSymbols = new ArrayList<Symbol>();
        ArrayList<SortOrder> newSortOrders = new ArrayList<SortOrder>();
        OrderingScheme expectedOrderingScheme = context.expectedOrderingScheme;
        boolean lastIsTimeRelated = false;
        for (Symbol symbol : expectedOrderingScheme.getOrderBy()) {
            if (this.timeRelatedSymbol(symbol, deviceTableScanNode)) {
                if (!expectedOrderingScheme.getOrderings().get(symbol).isAscending()) {
                    resultTableScanNodeList.forEach(node -> ((DeviceTableScanNode)node).setScanOrder(Ordering.DESC));
                }
                newOrderingSymbols.add(symbol);
                newSortOrders.add(expectedOrderingScheme.getOrdering(symbol));
                lastIsTimeRelated = true;
                break;
            }
            if (!deviceTableScanNode.getIdAndAttributeIndexMap().containsKey(symbol)) break;
            newOrderingSymbols.add(symbol);
            newSortOrders.add(expectedOrderingScheme.getOrdering(symbol));
        }
        if (newOrderingSymbols.isEmpty()) {
            return;
        }
        Optional<IDeviceID.TreeDeviceIdColumnValueExtractor> extractor = this.createTreeDeviceIdColumnValueExtractor(deviceTableScanNode);
        ArrayList<Function<DeviceEntry, String>> orderingRules = new ArrayList<Function<DeviceEntry, String>>();
        for (Symbol symbol : newOrderingSymbols) {
            Integer idx = deviceTableScanNode.getIdAndAttributeIndexMap().get(symbol);
            if (idx == null) break;
            if (deviceTableScanNode.getAssignments().get(symbol).getColumnCategory() == TsTableColumnCategory.TAG) {
                Function iDColumnFunction = extractor.map(treeDeviceIdColumnValueExtractor -> deviceEntry -> (String)treeDeviceIdColumnValueExtractor.extract(deviceEntry.getDeviceID(), idx.intValue())).orElseGet(() -> deviceEntry -> (String)deviceEntry.getNthSegment(idx + 1));
                orderingRules.add(iDColumnFunction);
                continue;
            }
            orderingRules.add(deviceEntry -> deviceEntry.getAttributeColumnValues().get(idx) == null ? null : deviceEntry.getAttributeColumnValues().get(idx).getStringValue(TSFileConfig.STRING_CHARSET));
        }
        Comparator comparator = null;
        if (!orderingRules.isEmpty()) {
            comparator = ((SortOrder)((Object)newSortOrders.get(0))).isNullsFirst() ? (((SortOrder)((Object)newSortOrders.get(0))).isAscending() ? Comparator.comparing((Function)orderingRules.get(0), Comparator.nullsFirst(Comparator.naturalOrder())) : Comparator.comparing((Function)orderingRules.get(0), Comparator.nullsFirst(Comparator.naturalOrder())).reversed()) : (((SortOrder)((Object)newSortOrders.get(0))).isAscending() ? Comparator.comparing((Function)orderingRules.get(0), Comparator.nullsLast(Comparator.naturalOrder())) : Comparator.comparing((Function)orderingRules.get(0), Comparator.nullsLast(Comparator.naturalOrder())).reversed());
            for (int i = 1; i < orderingRules.size(); ++i) {
                Comparator thenComparator = ((SortOrder)((Object)newSortOrders.get(i))).isNullsFirst() ? (((SortOrder)((Object)newSortOrders.get(i))).isAscending() ? Comparator.comparing((Function)orderingRules.get(i), Comparator.nullsFirst(Comparator.naturalOrder())) : Comparator.comparing((Function)orderingRules.get(i), Comparator.nullsFirst(Comparator.naturalOrder())).reversed()) : (((SortOrder)((Object)newSortOrders.get(i))).isAscending() ? Comparator.comparing((Function)orderingRules.get(i), Comparator.nullsLast(Comparator.naturalOrder())) : Comparator.comparing((Function)orderingRules.get(i), Comparator.nullsLast(Comparator.naturalOrder())).reversed());
                comparator = comparator.thenComparing(thenComparator);
            }
        }
        Optional<OrderingScheme> newOrderingScheme = this.tableScanOrderingSchema(this.analysis.getTableColumnSchema(deviceTableScanNode.getQualifiedObjectName()), newOrderingSymbols, newSortOrders, lastIsTimeRelated, deviceTableScanNode.getDeviceEntries().size() == 1);
        for (PlanNode planNode : resultTableScanNodeList) {
            DeviceTableScanNode scanNode = (DeviceTableScanNode)planNode;
            newOrderingScheme.ifPresent(orderingScheme -> this.nodeOrderingMap.put(scanNode.getPlanNodeId(), (OrderingScheme)orderingScheme));
            if (comparator == null) continue;
            scanNode.getDeviceEntries().sort(comparator);
        }
    }

    private Optional<IDeviceID.TreeDeviceIdColumnValueExtractor> createTreeDeviceIdColumnValueExtractor(DeviceTableScanNode node) {
        if (node instanceof TreeDeviceViewScanNode) {
            return Optional.of(TableOperatorGenerator.createTreeDeviceIdColumnValueExtractor(((TreeDeviceViewScanNode)node).getTreeDBName()));
        }
        if (node instanceof AggregationTreeDeviceViewScanNode) {
            return Optional.of(TableOperatorGenerator.createTreeDeviceIdColumnValueExtractor(((AggregationTreeDeviceViewScanNode)node).getTreeDBName()));
        }
        return Optional.empty();
    }

    private Optional<OrderingScheme> tableScanOrderingSchema(Map<Symbol, ColumnSchema> tableColumnSchema, List<Symbol> newOrderingSymbols, List<SortOrder> newSortOrders, boolean lastIsTimeRelated, boolean isSingleDevice) {
        if (isSingleDevice || !lastIsTimeRelated) {
            return Optional.of(new OrderingScheme(newOrderingSymbols, IntStream.range(0, newOrderingSymbols.size()).boxed().collect(Collectors.toMap(newOrderingSymbols::get, newSortOrders::get))));
        }
        int size = newOrderingSymbols.size();
        if (size == 1) {
            return Optional.empty();
        }
        OrderingScheme orderingScheme = new OrderingScheme(newOrderingSymbols.subList(0, size - 1), IntStream.range(0, size - 1).boxed().collect(Collectors.toMap(newOrderingSymbols::get, newSortOrders::get)));
        if (TransformSortToStreamSort.isOrderByAllIdsAndTime(tableColumnSchema, orderingScheme, size - 2)) {
            return Optional.of(new OrderingScheme(newOrderingSymbols, IntStream.range(0, newOrderingSymbols.size()).boxed().collect(Collectors.toMap(newOrderingSymbols::get, newSortOrders::get))));
        }
        return Optional.of(orderingScheme);
    }

    private boolean timeRelatedSymbol(Symbol symbol, DeviceTableScanNode deviceTableScanNode) {
        return deviceTableScanNode.isTimeColumn(symbol) || PUSH_DOWN_DATE_BIN_SYMBOL_NAME.equals(symbol.getName());
    }

    @Override
    public List<PlanNode> visitTableDeviceQueryScan(TableDeviceQueryScanNode node, PlanContext context) {
        return this.visitAbstractTableDeviceQuery(node, context);
    }

    @Override
    public List<PlanNode> visitTableDeviceQueryCount(TableDeviceQueryCountNode node, PlanContext context) {
        return this.visitAbstractTableDeviceQuery(node, context);
    }

    private List<PlanNode> visitAbstractTableDeviceQuery(AbstractTableDeviceQueryNode node, PlanContext context) {
        HashSet schemaRegionSet = new HashSet();
        ((Map)this.analysis.getSchemaPartitionInfo().getSchemaPartitionMap().get(node.getDatabase())).forEach((deviceGroupId, schemaRegionReplicaSet) -> schemaRegionSet.add(schemaRegionReplicaSet));
        context.mostUsedRegion = (TRegionReplicaSet)schemaRegionSet.iterator().next();
        if (schemaRegionSet.size() == 1) {
            node.setRegionReplicaSet((TRegionReplicaSet)schemaRegionSet.iterator().next());
            return Collections.singletonList(node);
        }
        ArrayList<PlanNode> res = new ArrayList<PlanNode>(schemaRegionSet.size());
        for (TRegionReplicaSet schemaRegion : schemaRegionSet) {
            AbstractTableDeviceQueryNode clonedChild = (AbstractTableDeviceQueryNode)node.clone();
            clonedChild.setPlanNodeId(this.queryId.genPlanNodeId());
            clonedChild.setRegionReplicaSet(schemaRegion);
            res.add(clonedChild);
        }
        return res;
    }

    @Override
    public List<PlanNode> visitTableDeviceFetch(TableDeviceFetchNode node, PlanContext context) {
        String database = node.getDatabase();
        HashSet schemaRegionSet = new HashSet();
        SchemaPartition schemaPartition = this.analysis.getSchemaPartitionInfo();
        Map databaseMap = (Map)schemaPartition.getSchemaPartitionMap().get(database);
        databaseMap.forEach((deviceGroupId, schemaRegionReplicaSet) -> schemaRegionSet.add(schemaRegionReplicaSet));
        if (schemaRegionSet.size() == 1) {
            context.mostUsedRegion = (TRegionReplicaSet)schemaRegionSet.iterator().next();
            node.setRegionReplicaSet(context.mostUsedRegion);
            return Collections.singletonList(node);
        }
        HashMap<TRegionReplicaSet, TableDeviceFetchNode> tableDeviceFetchMap = new HashMap<TRegionReplicaSet, TableDeviceFetchNode>();
        List<IDeviceID> partitionKeyList = node.getPartitionKeyList();
        List<Object[]> deviceIDArray = node.getDeviceIdList();
        for (int i = 0; i < node.getPartitionKeyList().size(); ++i) {
            TRegionReplicaSet regionReplicaSet = (TRegionReplicaSet)databaseMap.get(schemaPartition.calculateDeviceGroupId(partitionKeyList.get(i)));
            if (!Objects.nonNull(regionReplicaSet)) continue;
            tableDeviceFetchMap.computeIfAbsent(regionReplicaSet, k -> {
                TableDeviceFetchNode clonedNode = (TableDeviceFetchNode)node.cloneForDistribution();
                clonedNode.setPlanNodeId(this.queryId.genPlanNodeId());
                clonedNode.setRegionReplicaSet(regionReplicaSet);
                return clonedNode;
            }).addDeviceId(deviceIDArray.get(i));
        }
        ArrayList<PlanNode> res = new ArrayList<PlanNode>();
        TRegionReplicaSet mostUsedSchemaRegion = null;
        int maxDeviceEntrySizeOfTableScan = 0;
        for (Map.Entry entry : tableDeviceFetchMap.entrySet()) {
            TRegionReplicaSet regionReplicaSet = (TRegionReplicaSet)entry.getKey();
            TableDeviceFetchNode subTableDeviceFetchNode = (TableDeviceFetchNode)entry.getValue();
            res.add(subTableDeviceFetchNode);
            if (subTableDeviceFetchNode.getDeviceIdList().size() <= maxDeviceEntrySizeOfTableScan) continue;
            mostUsedSchemaRegion = regionReplicaSet;
            maxDeviceEntrySizeOfTableScan = subTableDeviceFetchNode.getDeviceIdList().size();
        }
        context.mostUsedRegion = mostUsedSchemaRegion;
        return res;
    }

    public static class PlanContext {
        final Map<PlanNodeId, NodeDistribution> nodeDistributionMap = new HashMap<PlanNodeId, NodeDistribution>();
        boolean hasExchangeNode = false;
        boolean hasSortProperty = false;
        OrderingScheme expectedOrderingScheme;
        TRegionReplicaSet mostUsedRegion;

        public NodeDistribution getNodeDistribution(PlanNodeId nodeId) {
            return this.nodeDistributionMap.get(nodeId);
        }

        public void clearExpectedOrderingScheme() {
            this.expectedOrderingScheme = null;
            this.hasSortProperty = false;
        }

        public void setExpectedOrderingScheme(OrderingScheme expectedOrderingScheme) {
            this.expectedOrderingScheme = expectedOrderingScheme;
            this.hasSortProperty = true;
        }
    }
}

