/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.planner;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.iotdb.commons.partition.SchemaPartition;
import org.apache.iotdb.commons.schema.column.ColumnHeader;
import org.apache.iotdb.commons.utils.TestOnly;
import org.apache.iotdb.db.queryengine.common.MPPQueryContext;
import org.apache.iotdb.db.queryengine.common.QueryId;
import org.apache.iotdb.db.queryengine.common.SessionInfo;
import org.apache.iotdb.db.queryengine.common.header.DatasetHeader;
import org.apache.iotdb.db.queryengine.execution.warnings.WarningCollector;
import org.apache.iotdb.db.queryengine.metric.QueryPlanCostMetricSet;
import org.apache.iotdb.db.queryengine.plan.planner.plan.LogicalQueryPlan;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.WritePlanNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.metadata.read.CountSchemaMergeNode;
import org.apache.iotdb.db.queryengine.plan.relational.analyzer.Analysis;
import org.apache.iotdb.db.queryengine.plan.relational.analyzer.Field;
import org.apache.iotdb.db.queryengine.plan.relational.analyzer.NodeRef;
import org.apache.iotdb.db.queryengine.plan.relational.analyzer.RelationType;
import org.apache.iotdb.db.queryengine.plan.relational.execution.querystats.PlanOptimizersStatsCollector;
import org.apache.iotdb.db.queryengine.plan.relational.metadata.Metadata;
import org.apache.iotdb.db.queryengine.plan.relational.planner.PlannerContext;
import org.apache.iotdb.db.queryengine.plan.relational.planner.RelationPlan;
import org.apache.iotdb.db.queryengine.plan.relational.planner.RelationPlanner;
import org.apache.iotdb.db.queryengine.plan.relational.planner.Symbol;
import org.apache.iotdb.db.queryengine.plan.relational.planner.SymbolAllocator;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.ExplainAnalyzeNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.FilterNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.LimitNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.OffsetNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.OutputNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.schema.CreateOrUpdateTableDeviceNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.schema.TableDeviceAttributeUpdateNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.schema.TableDeviceFetchNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.schema.TableDeviceQueryCountNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.schema.TableDeviceQueryScanNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.optimizations.LogicalOptimizeFactory;
import org.apache.iotdb.db.queryengine.plan.relational.planner.optimizations.PlanOptimizer;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.AbstractQueryDeviceWithCache;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.AbstractTraverseDevice;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.CountDevice;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.CreateOrUpdateDevice;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Delete;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Explain;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.ExplainAnalyze;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.FetchDevice;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.LoadTsFile;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Node;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.PipeEnriched;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Query;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.ShowDevice;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Statement;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Table;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Update;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.WrappedStatement;
import org.apache.iotdb.db.queryengine.plan.relational.type.InternalTypeManager;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.read.common.type.LongType;
import org.apache.tsfile.read.common.type.StringType;
import org.apache.tsfile.read.common.type.Type;
import org.apache.tsfile.read.common.type.TypeFactory;

public class TableLogicalPlanner {
    private final MPPQueryContext queryContext;
    private final SessionInfo sessionInfo;
    private final SymbolAllocator symbolAllocator;
    private final List<PlanOptimizer> planOptimizers;
    private final Metadata metadata;
    private final WarningCollector warningCollector;

    @TestOnly
    public TableLogicalPlanner(MPPQueryContext queryContext, Metadata metadata, SessionInfo sessionInfo, SymbolAllocator symbolAllocator, WarningCollector warningCollector) {
        this(queryContext, metadata, sessionInfo, symbolAllocator, warningCollector, new LogicalOptimizeFactory(new PlannerContext(metadata, new InternalTypeManager())).getPlanOptimizers());
    }

    public TableLogicalPlanner(MPPQueryContext queryContext, Metadata metadata, SessionInfo sessionInfo, SymbolAllocator symbolAllocator, WarningCollector warningCollector, List<PlanOptimizer> planOptimizers) {
        this.queryContext = queryContext;
        this.metadata = metadata;
        this.sessionInfo = Objects.requireNonNull(sessionInfo, "session is null");
        this.symbolAllocator = Objects.requireNonNull(symbolAllocator, "symbolAllocator is null");
        this.warningCollector = Objects.requireNonNull(warningCollector, "warningCollector is null");
        this.planOptimizers = planOptimizers;
    }

    public LogicalQueryPlan plan(Analysis analysis) {
        long startTime = System.nanoTime();
        Statement statement = analysis.getStatement();
        PlanNode planNode = this.planStatement(analysis, statement);
        if (analysis.isQuery()) {
            long logicalPlanCostTime = System.nanoTime() - startTime;
            QueryPlanCostMetricSet.getInstance().recordPlanCost("table", "logical_planner", logicalPlanCostTime);
            this.queryContext.setLogicalPlanCost(logicalPlanCostTime);
            startTime = System.nanoTime();
            for (PlanOptimizer optimizer : this.planOptimizers) {
                planNode = optimizer.optimize(planNode, new PlanOptimizer.Context(this.sessionInfo, analysis, this.metadata, this.queryContext, this.symbolAllocator, this.queryContext.getQueryId(), this.warningCollector, PlanOptimizersStatsCollector.createPlanOptimizersStatsCollector()));
            }
            long logicalOptimizationCost = System.nanoTime() - startTime - this.queryContext.getFetchPartitionCost() - this.queryContext.getFetchSchemaCost();
            this.queryContext.setLogicalOptimizationCost(logicalOptimizationCost);
            QueryPlanCostMetricSet.getInstance().recordPlanCost("table", "logical_plan_optimize", logicalOptimizationCost);
        }
        return new LogicalQueryPlan(this.queryContext, planNode);
    }

    private PlanNode planStatement(Analysis analysis, Statement statement) {
        if (statement instanceof CreateOrUpdateDevice) {
            return this.planCreateOrUpdateDevice((CreateOrUpdateDevice)statement, analysis);
        }
        if (statement instanceof FetchDevice) {
            return this.planFetchDevice((FetchDevice)statement, analysis);
        }
        if (statement instanceof ShowDevice) {
            return this.planShowDevice((ShowDevice)statement, analysis);
        }
        if (statement instanceof CountDevice) {
            return this.planCountDevice((CountDevice)statement, analysis);
        }
        if (statement instanceof Update) {
            return this.planUpdate((Update)statement, analysis);
        }
        return this.createOutputPlan(this.planStatementWithoutOutput(analysis, statement), analysis);
    }

    private RelationPlan planStatementWithoutOutput(Analysis analysis, Statement statement) {
        if (statement instanceof Query) {
            return this.createRelationPlan(analysis, (Query)statement);
        }
        if (statement instanceof Explain) {
            return this.createRelationPlan(analysis, (Query)((Explain)statement).getStatement());
        }
        if (statement instanceof WrappedStatement) {
            return this.createRelationPlan(analysis, (WrappedStatement)statement);
        }
        if (statement instanceof LoadTsFile) {
            return this.createRelationPlan(analysis, (LoadTsFile)statement);
        }
        if (statement instanceof PipeEnriched) {
            return this.createRelationPlan(analysis, (PipeEnriched)statement);
        }
        if (statement instanceof Delete) {
            return this.createRelationPlan(analysis, (Delete)statement);
        }
        if (statement instanceof ExplainAnalyze) {
            return this.planExplainAnalyze((ExplainAnalyze)statement, analysis);
        }
        throw new IllegalStateException("Unsupported statement type: " + statement.getClass().getSimpleName());
    }

    private PlanNode createOutputPlan(RelationPlan plan, Analysis analysis) {
        if (plan.getRoot() instanceof WritePlanNode) {
            return plan.getRoot();
        }
        ImmutableList.Builder outputs = ImmutableList.builder();
        ImmutableList.Builder names = ImmutableList.builder();
        ArrayList<ColumnHeader> columnHeaders = new ArrayList<ColumnHeader>();
        int columnNumber = 0;
        if (this.queryContext.isExplainAnalyze()) {
            outputs.add((Object)new Symbol("Explain Analyze"));
            names.add((Object)"Explain Analyze");
            columnHeaders.add(new ColumnHeader("Explain Analyze", TSDataType.TEXT));
        } else {
            RelationType outputDescriptor = analysis.getOutputDescriptor();
            for (Field field : outputDescriptor.getVisibleFields()) {
                String name = field.getName().orElse("_col" + columnNumber);
                names.add((Object)name);
                int fieldIndex = outputDescriptor.indexOf(field);
                Symbol symbol = plan.getSymbol(fieldIndex);
                outputs.add((Object)symbol);
                columnHeaders.add(new ColumnHeader(name, InternalTypeManager.getTSDataType(field.getType())));
                ++columnNumber;
            }
        }
        OutputNode outputNode = new OutputNode(this.queryContext.getQueryId().genPlanNodeId(), plan.getRoot(), (List<String>)names.build(), (List<Symbol>)outputs.build());
        DatasetHeader respDatasetHeader = new DatasetHeader(columnHeaders, true);
        analysis.setRespDatasetHeader(respDatasetHeader);
        return outputNode;
    }

    private RelationPlan createRelationPlan(Analysis analysis, WrappedStatement statement) {
        return (RelationPlan)this.getRelationPlanner(analysis).process(statement, null);
    }

    private RelationPlan createRelationPlan(Analysis analysis, LoadTsFile loadTsFile) {
        return (RelationPlan)this.getRelationPlanner(analysis).process(loadTsFile, null);
    }

    private RelationPlan createRelationPlan(Analysis analysis, PipeEnriched pipeEnriched) {
        return (RelationPlan)this.getRelationPlanner(analysis).process(pipeEnriched, null);
    }

    private RelationPlan createRelationPlan(Analysis analysis, Query query) {
        return (RelationPlan)this.getRelationPlanner(analysis).process(query, null);
    }

    private RelationPlan createRelationPlan(Analysis analysis, Table table) {
        return (RelationPlan)this.getRelationPlanner(analysis).process(table, null);
    }

    private RelationPlan createRelationPlan(Analysis analysis, Delete statement) {
        return (RelationPlan)this.getRelationPlanner(analysis).process(statement, null);
    }

    private RelationPlanner getRelationPlanner(Analysis analysis) {
        return new RelationPlanner(analysis, this.symbolAllocator, this.queryContext, Optional.empty(), this.sessionInfo, (Map<NodeRef<Node>, RelationPlan>)ImmutableMap.of());
    }

    private PlanNode planCreateOrUpdateDevice(CreateOrUpdateDevice statement, Analysis analysis) {
        CreateOrUpdateTableDeviceNode node = new CreateOrUpdateTableDeviceNode(this.queryContext.getQueryId().genPlanNodeId(), statement.getDatabase(), statement.getTable(), statement.getDeviceIdList(), statement.getAttributeNameList(), statement.getAttributeValueList());
        analysis.setStatement(statement);
        SchemaPartition partition = this.metadata.getOrCreateSchemaPartition(statement.getDatabase(), node.getPartitionKeyList(), this.queryContext.getSession().getUserName());
        analysis.setSchemaPartitionInfo(partition);
        return node;
    }

    private PlanNode planFetchDevice(FetchDevice statement, Analysis analysis) {
        List<ColumnHeader> columnHeaderList = ShowDevice.getDeviceColumnHeaderList(statement.getDatabase(), statement.getTableName());
        analysis.setRespDatasetHeader(new DatasetHeader(columnHeaderList, true));
        TableDeviceFetchNode fetchNode = new TableDeviceFetchNode(this.queryContext.getQueryId().genPlanNodeId(), statement.getDatabase(), statement.getTableName(), statement.getDeviceIdList(), statement.getPartitionKeyList(), columnHeaderList, null);
        SchemaPartition schemaPartition = this.metadata.getSchemaPartition(statement.getDatabase(), statement.getPartitionKeyList());
        analysis.setSchemaPartitionInfo(schemaPartition);
        if (schemaPartition.isEmpty()) {
            analysis.setFinishQueryAfterAnalyze();
        }
        return fetchNode;
    }

    private PlanNode planShowDevice(ShowDevice statement, Analysis analysis) {
        long pushDownLimit;
        this.planQueryDevice(statement, analysis);
        QueryId queryId = this.queryContext.getQueryId();
        long l = pushDownLimit = Objects.nonNull(statement.getLimit()) ? analysis.getLimit(statement.getLimit()).orElse(-1L) : -1L;
        if (pushDownLimit > -1L && Objects.nonNull(statement.getOffset())) {
            pushDownLimit += analysis.getOffset(statement.getOffset());
        }
        PlanNode currentNode = new TableDeviceQueryScanNode(queryId.genPlanNodeId(), statement.getDatabase(), statement.getTableName(), statement.getIdDeterminedFilterList(), null, statement.getColumnHeaderList(), null, Objects.isNull(statement.getIdFuzzyPredicate()) ? pushDownLimit : -1L);
        statement.getColumnHeaderList().forEach(columnHeader -> this.symbolAllocator.newSymbol(columnHeader.getColumnName(), TypeFactory.getType((TSDataType)columnHeader.getColumnType())));
        if (Objects.nonNull(statement.getIdFuzzyPredicate())) {
            currentNode = new FilterNode(queryId.genPlanNodeId(), currentNode, statement.getIdFuzzyPredicate());
        }
        if (pushDownLimit > -1L) {
            currentNode = new LimitNode(queryId.genPlanNodeId(), currentNode, pushDownLimit, Optional.empty());
        }
        return Objects.nonNull(statement.getOffset()) ? new OffsetNode(queryId.genPlanNodeId(), currentNode, analysis.getOffset(statement.getOffset())) : currentNode;
    }

    private PlanNode planCountDevice(CountDevice statement, Analysis analysis) {
        this.planQueryDevice(statement, analysis);
        TableDeviceQueryCountNode node = new TableDeviceQueryCountNode(this.queryContext.getQueryId().genPlanNodeId(), statement.getDatabase(), statement.getTableName(), statement.getIdDeterminedFilterList(), statement.getIdFuzzyPredicate(), statement.getColumnHeaderList());
        statement.getColumnHeaderList().forEach(columnHeader -> this.symbolAllocator.newSymbol(columnHeader.getColumnName(), TypeFactory.getType((TSDataType)columnHeader.getColumnType())));
        this.symbolAllocator.newSymbol("count(devices)", (Type)LongType.INT64);
        CountSchemaMergeNode countMergeNode = new CountSchemaMergeNode(this.queryContext.getQueryId().genPlanNodeId());
        countMergeNode.addChild(node);
        return countMergeNode;
    }

    private void planQueryDevice(AbstractQueryDeviceWithCache statement, Analysis analysis) {
        this.planTraverseDevice(statement, analysis);
        if (!analysis.isFailed()) {
            analysis.setRespDatasetHeader(statement.getDataSetHeader());
        }
    }

    private PlanNode planUpdate(Update statement, Analysis analysis) {
        this.planTraverseDevice(statement, analysis);
        return new TableDeviceAttributeUpdateNode(this.queryContext.getQueryId().genPlanNodeId(), statement.getDatabase(), statement.getTableName(), statement.getIdDeterminedFilterList(), statement.getIdFuzzyPredicate(), statement.getColumnHeaderList(), null, statement.getAssignments(), this.queryContext.getSession());
    }

    private void planTraverseDevice(AbstractTraverseDevice statement, Analysis analysis) {
        String database = statement.getDatabase();
        SchemaPartition schemaPartition = statement.isIdDetermined() ? this.metadata.getSchemaPartition(database, statement.getPartitionKeyList()) : this.metadata.getSchemaPartition(database);
        analysis.setSchemaPartitionInfo(schemaPartition);
        if (schemaPartition.isEmpty()) {
            analysis.setFinishQueryAfterAnalyze();
        }
    }

    private RelationPlan planExplainAnalyze(ExplainAnalyze statement, Analysis analysis) {
        RelationPlan originalQueryPlan = this.createRelationPlan(analysis, (Query)statement.getStatement());
        Symbol symbol = this.symbolAllocator.newSymbol("Explain Analyze", (Type)StringType.getInstance());
        ExplainAnalyzeNode newRoot = new ExplainAnalyzeNode(this.queryContext.getQueryId().genPlanNodeId(), originalQueryPlan.getRoot(), statement.isVerbose(), this.queryContext.getLocalQueryId(), this.queryContext.getTimeOut(), symbol);
        return new RelationPlan(newRoot, originalQueryPlan.getScope(), originalQueryPlan.getFieldMappings(), Optional.empty());
    }

    private static enum Stage {
        CREATED,
        OPTIMIZED,
        OPTIMIZED_AND_VALIDATED;

    }
}

