/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.planner.plan.node.write;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.iotdb.common.rpc.thrift.TDataNodeLocation;
import org.apache.iotdb.common.rpc.thrift.TRegionReplicaSet;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.common.rpc.thrift.TTimePartitionSlot;
import org.apache.iotdb.commons.consensus.index.ProgressIndex;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.utils.StatusUtils;
import org.apache.iotdb.commons.utils.TimePartitionUtils;
import org.apache.iotdb.db.queryengine.plan.analyze.IAnalysis;
import org.apache.iotdb.db.queryengine.plan.analyze.cache.schema.DataNodeDevicePathCache;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeType;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanVisitor;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.WritePlanNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.InsertNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.InsertRowNode;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.exception.NotImplementedException;
import org.apache.tsfile.utils.ReadWriteIOUtils;

public class InsertRowsOfOneDeviceNode
extends InsertNode {
    private List<Integer> insertRowNodeIndexList;
    private List<InsertRowNode> insertRowNodeList;
    private Map<Integer, TSStatus> results = new HashMap<Integer, TSStatus>();

    public InsertRowsOfOneDeviceNode(PlanNodeId id) {
        super(id);
        this.insertRowNodeIndexList = new ArrayList<Integer>();
        this.insertRowNodeList = new ArrayList<InsertRowNode>();
    }

    public InsertRowsOfOneDeviceNode(PlanNodeId id, List<Integer> insertRowNodeIndexList, List<InsertRowNode> insertRowNodeList) {
        super(id);
        this.insertRowNodeIndexList = insertRowNodeIndexList;
        this.insertRowNodeList = insertRowNodeList;
    }

    public Map<Integer, TSStatus> getResults() {
        return this.results;
    }

    public void clearResults() {
        this.results.clear();
    }

    @Override
    public void setSearchIndex(long index) {
        this.searchIndex = index;
        this.insertRowNodeList.forEach(plan -> plan.setSearchIndex(index));
    }

    public TSStatus[] getFailingStatus() {
        return StatusUtils.getFailingStatus(this.results, (int)this.insertRowNodeList.size());
    }

    public List<Integer> getInsertRowNodeIndexList() {
        return this.insertRowNodeIndexList;
    }

    public void setInsertRowNodeIndexList(List<Integer> insertRowNodeIndexList) {
        this.insertRowNodeIndexList = insertRowNodeIndexList;
    }

    public List<InsertRowNode> getInsertRowNodeList() {
        return this.insertRowNodeList;
    }

    public void setInsertRowNodeList(List<InsertRowNode> insertRowNodeList) {
        this.insertRowNodeList = insertRowNodeList;
        if (insertRowNodeList == null || insertRowNodeList.isEmpty()) {
            return;
        }
        this.targetPath = insertRowNodeList.get(0).getTargetPath();
        this.isAligned = insertRowNodeList.get((int)0).isAligned;
        this.storeMeasurementsAndDataType();
    }

    @Override
    public void addChild(PlanNode child) {
    }

    @Override
    public PlanNodeType getType() {
        return PlanNodeType.INSERT_ROWS_OF_ONE_DEVICE;
    }

    @Override
    public PlanNode clone() {
        throw new NotImplementedException("clone of Insert is not implemented");
    }

    @Override
    public int allowedChildCount() {
        return 0;
    }

    @Override
    public List<String> getOutputColumnNames() {
        return null;
    }

    @Override
    public List<WritePlanNode> splitByPartition(IAnalysis analysis) {
        ArrayList<WritePlanNode> result = new ArrayList<WritePlanNode>();
        HashMap<TRegionReplicaSet, Map> splitMap = new HashMap<TRegionReplicaSet, Map>();
        HashMap<TRegionReplicaSet, Map> splitMapForIndex = new HashMap<TRegionReplicaSet, Map>();
        for (int i = 0; i < this.insertRowNodeList.size(); ++i) {
            InsertRowNode insertRowNode = this.insertRowNodeList.get(i);
            TTimePartitionSlot timePartitionSlot = TimePartitionUtils.getTimePartitionSlot((long)insertRowNode.getTime());
            TRegionReplicaSet dataRegionReplicaSet = analysis.getDataPartitionInfo().getDataRegionReplicaSetForWriting(this.targetPath.getIDeviceIDAsFullDevice(), timePartitionSlot, analysis.getDatabaseName());
            Map tmpMap = splitMap.computeIfAbsent(dataRegionReplicaSet, k -> new HashMap());
            Map tmpIndexMap = splitMapForIndex.computeIfAbsent(dataRegionReplicaSet, k -> new HashMap());
            List tmpList = tmpMap.computeIfAbsent(timePartitionSlot, k -> new ArrayList());
            List tmpIndexList = tmpIndexMap.computeIfAbsent(timePartitionSlot, k -> new ArrayList());
            tmpList.add(insertRowNode);
            tmpIndexList.add(this.insertRowNodeIndexList.get(i));
            if (i != this.insertRowNodeList.size() - 1) continue;
            analysis.setRedirectNodeList(Collections.singletonList(((TDataNodeLocation)dataRegionReplicaSet.getDataNodeLocations().get(0)).getClientRpcEndPoint()));
        }
        for (Map.Entry entry1 : splitMap.entrySet()) {
            for (Map.Entry entry : ((Map)entry1.getValue()).entrySet()) {
                InsertRowsOfOneDeviceNode reducedNode = new InsertRowsOfOneDeviceNode(this.getPlanNodeId());
                reducedNode.setInsertRowNodeList((List)entry.getValue());
                reducedNode.setInsertRowNodeIndexList((List)((Map)splitMapForIndex.get(entry1.getKey())).get(entry.getKey()));
                reducedNode.setDataRegionReplicaSet((TRegionReplicaSet)entry1.getKey());
                result.add(reducedNode);
            }
        }
        return result;
    }

    private void storeMeasurementsAndDataType() {
        HashSet<String> measurementSet = new HashSet<String>();
        ArrayList<TSDataType> dataTypeList = new ArrayList<TSDataType>();
        ArrayList<String> measurementList = new ArrayList<String>();
        for (InsertRowNode insertRowNode : this.insertRowNodeList) {
            String[] measurements = insertRowNode.getMeasurements();
            TSDataType[] dataTypes = insertRowNode.getDataTypes();
            for (int i = 0; i < measurements.length; ++i) {
                if (measurementSet.contains(measurements[i])) continue;
                measurementList.add(measurements[i]);
                dataTypeList.add(dataTypes[i]);
                measurementSet.add(measurements[i]);
            }
        }
        this.measurements = measurementList.toArray(new String[0]);
        this.dataTypes = dataTypeList.toArray(new TSDataType[0]);
    }

    public static InsertRowsOfOneDeviceNode deserialize(ByteBuffer byteBuffer) {
        int i;
        PartialPath devicePath;
        ArrayList<InsertRowNode> insertRowNodeList = new ArrayList<InsertRowNode>();
        ArrayList<Integer> insertRowNodeIndex = new ArrayList<Integer>();
        try {
            devicePath = DataNodeDevicePathCache.getInstance().getPartialPath(ReadWriteIOUtils.readString((ByteBuffer)byteBuffer));
        }
        catch (IllegalPathException e) {
            throw new IllegalArgumentException("Cannot deserialize InsertRowsOfOneDeviceNode", e);
        }
        int size = byteBuffer.getInt();
        for (i = 0; i < size; ++i) {
            InsertRowNode insertRowNode = new InsertRowNode(new PlanNodeId(""));
            insertRowNode.setTargetPath(devicePath);
            insertRowNode.setTime(byteBuffer.getLong());
            insertRowNode.deserializeMeasurementsAndValues(byteBuffer);
            insertRowNodeList.add(insertRowNode);
        }
        for (i = 0; i < size; ++i) {
            insertRowNodeIndex.add(byteBuffer.getInt());
        }
        PlanNodeId planNodeId = PlanNodeId.deserialize(byteBuffer);
        for (InsertRowNode insertRowNode : insertRowNodeList) {
            insertRowNode.setPlanNodeId(planNodeId);
        }
        InsertRowsOfOneDeviceNode insertRowsOfOneDeviceNode = new InsertRowsOfOneDeviceNode(planNodeId);
        insertRowsOfOneDeviceNode.setInsertRowNodeList(insertRowNodeList);
        insertRowsOfOneDeviceNode.setInsertRowNodeIndexList(insertRowNodeIndex);
        insertRowsOfOneDeviceNode.setTargetPath(devicePath);
        return insertRowsOfOneDeviceNode;
    }

    @Override
    protected void serializeAttributes(ByteBuffer byteBuffer) {
        PlanNodeType.INSERT_ROWS_OF_ONE_DEVICE.serialize(byteBuffer);
        ReadWriteIOUtils.write((String)this.targetPath.getFullPath(), (ByteBuffer)byteBuffer);
        ReadWriteIOUtils.write((int)this.insertRowNodeList.size(), (ByteBuffer)byteBuffer);
        for (InsertRowNode node : this.insertRowNodeList) {
            ReadWriteIOUtils.write((long)node.getTime(), (ByteBuffer)byteBuffer);
            node.serializeMeasurementsAndValues(byteBuffer);
        }
        for (Integer index : this.insertRowNodeIndexList) {
            ReadWriteIOUtils.write((int)index, (ByteBuffer)byteBuffer);
        }
    }

    @Override
    protected void serializeAttributes(DataOutputStream stream) throws IOException {
        PlanNodeType.INSERT_ROWS_OF_ONE_DEVICE.serialize(stream);
        ReadWriteIOUtils.write((String)this.targetPath.getFullPath(), (OutputStream)stream);
        ReadWriteIOUtils.write((int)this.insertRowNodeList.size(), (OutputStream)stream);
        for (InsertRowNode node : this.insertRowNodeList) {
            ReadWriteIOUtils.write((long)node.getTime(), (OutputStream)stream);
            node.serializeMeasurementsAndValues(stream);
        }
        for (Integer index : this.insertRowNodeIndexList) {
            ReadWriteIOUtils.write((int)index, (OutputStream)stream);
        }
    }

    @Override
    public void markAsGeneratedByPipe() {
        this.isGeneratedByPipe = true;
        this.insertRowNodeList.forEach(PlanNode::markAsGeneratedByPipe);
    }

    @Override
    public void markAsGeneratedByRemoteConsensusLeader() {
        super.markAsGeneratedByRemoteConsensusLeader();
        this.insertRowNodeList.forEach(InsertNode::markAsGeneratedByRemoteConsensusLeader);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        InsertRowsOfOneDeviceNode that = (InsertRowsOfOneDeviceNode)o;
        return Objects.equals(this.insertRowNodeIndexList, that.insertRowNodeIndexList) && Objects.equals(this.insertRowNodeList, that.insertRowNodeList);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.insertRowNodeIndexList, this.insertRowNodeList);
    }

    @Override
    public <R, C> R accept(PlanVisitor<R, C> visitor, C context) {
        return visitor.visitInsertRowsOfOneDevice(this, context);
    }

    @Override
    public long getMinTime() {
        throw new NotImplementedException();
    }

    @Override
    public void setProgressIndex(ProgressIndex progressIndex) {
        this.progressIndex = progressIndex;
        this.insertRowNodeList.forEach(insertRowNode -> insertRowNode.setProgressIndex(progressIndex));
    }
}

