/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.planner.plan;

import com.google.common.base.Preconditions;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Objects;
import org.apache.iotdb.common.rpc.thrift.TDataNodeLocation;
import org.apache.iotdb.common.rpc.thrift.TRegionReplicaSet;
import org.apache.iotdb.commons.partition.DataPartition;
import org.apache.iotdb.db.queryengine.common.PlanFragmentId;
import org.apache.iotdb.db.queryengine.plan.analyze.TypeProvider;
import org.apache.iotdb.db.queryengine.plan.planner.SubPlanTypeExtractor;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.IPartitionRelatedNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeType;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.source.AlignedSeriesAggregationScanNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.source.AlignedSeriesScanNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.source.VirtualSourceNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.distribute.TableModelTypeProviderExtractor;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.InformationSchemaTableScanNode;
import org.apache.tsfile.utils.ReadWriteIOUtils;

public class PlanFragment {
    private final PlanFragmentId id;
    private PlanNode planNodeTree;
    private TypeProvider typeProvider;
    private boolean isRoot;

    public PlanFragment(PlanFragmentId id, PlanNode planNodeTree) {
        this.id = id;
        this.planNodeTree = planNodeTree;
        this.isRoot = false;
    }

    public PlanFragmentId getId() {
        return this.id;
    }

    public PlanNode getPlanNodeTree() {
        return this.planNodeTree;
    }

    public void setPlanNodeTree(PlanNode planNodeTree) {
        this.planNodeTree = planNodeTree;
    }

    public TypeProvider getTypeProvider() {
        return this.typeProvider;
    }

    public void setTypeProvider(TypeProvider typeProvider) {
        this.typeProvider = typeProvider;
    }

    public void generateTypeProvider(TypeProvider allTypes) {
        this.typeProvider = SubPlanTypeExtractor.extractor(this.planNodeTree, allTypes);
    }

    public void generateTableModelTypeProvider(TypeProvider allTypes) {
        this.typeProvider = TableModelTypeProviderExtractor.extractor(this.planNodeTree, allTypes);
    }

    public boolean isRoot() {
        return this.isRoot;
    }

    public void setRoot(boolean root) {
        this.isRoot = root;
    }

    public String toString() {
        return String.format("PlanFragment-%s", this.getId());
    }

    public TRegionReplicaSet getTargetRegion() {
        return this.getNodeRegion(this.planNodeTree);
    }

    public TDataNodeLocation getTargetLocation() {
        return this.getNodeLocation(this.planNodeTree);
    }

    private TRegionReplicaSet getNodeRegion(PlanNode root) {
        if (root instanceof IPartitionRelatedNode) {
            return ((IPartitionRelatedNode)((Object)root)).getRegionReplicaSet();
        }
        for (PlanNode child : root.getChildren()) {
            TRegionReplicaSet result = this.getNodeRegion(child);
            if (result == null || result == DataPartition.NOT_ASSIGNED) continue;
            return result;
        }
        return null;
    }

    private TDataNodeLocation getNodeLocation(PlanNode root) {
        if (root instanceof VirtualSourceNode) {
            return ((VirtualSourceNode)root).getDataNodeLocation();
        }
        if (root instanceof InformationSchemaTableScanNode) {
            TRegionReplicaSet regionReplicaSet = ((InformationSchemaTableScanNode)root).getRegionReplicaSet();
            Preconditions.checkArgument((regionReplicaSet != null ? 1 : 0) != 0, (Object)"InformationSchemaTableScanNode must have regionReplicaSet");
            Preconditions.checkArgument((regionReplicaSet.getDataNodeLocations().size() == 1 ? 1 : 0) != 0, (Object)"each InformationSchemaTableScanNode have only one DataNodeLocation");
            return (TDataNodeLocation)regionReplicaSet.getDataNodeLocations().get(0);
        }
        for (PlanNode child : root.getChildren()) {
            TDataNodeLocation result = this.getNodeLocation(child);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public void serialize(ByteBuffer byteBuffer) {
        this.id.serialize(byteBuffer);
        this.planNodeTree.serialize(byteBuffer);
        if (this.typeProvider == null) {
            ReadWriteIOUtils.write((byte)0, (ByteBuffer)byteBuffer);
        } else {
            ReadWriteIOUtils.write((byte)1, (ByteBuffer)byteBuffer);
            this.typeProvider.serialize(byteBuffer);
        }
    }

    public void serialize(DataOutputStream stream) throws IOException {
        this.id.serialize(stream);
        if (this.typeProvider == null) {
            ReadWriteIOUtils.write((byte)0, (OutputStream)stream);
        } else {
            ReadWriteIOUtils.write((byte)1, (OutputStream)stream);
            if (this.typeProvider.getTemplatedInfo() != null) {
                this.typeProvider.serialize(stream);
                this.planNodeTree.serializeUseTemplate(stream, this.typeProvider);
                return;
            }
            this.typeProvider.serialize(stream);
        }
        this.planNodeTree.serialize(stream);
    }

    public static PlanFragment deserialize(ByteBuffer byteBuffer) {
        PlanFragmentId planFragmentId = PlanFragmentId.deserialize(byteBuffer);
        byte hasTypeProvider = ReadWriteIOUtils.readByte((ByteBuffer)byteBuffer);
        TypeProvider typeProvider = null;
        if (hasTypeProvider == 1) {
            typeProvider = TypeProvider.deserialize(byteBuffer);
        }
        PlanFragment planFragment = new PlanFragment(planFragmentId, PlanFragment.deserializeHelper(byteBuffer, typeProvider));
        planFragment.setTypeProvider(typeProvider);
        return planFragment;
    }

    public static PlanNode deserializeHelper(ByteBuffer byteBuffer, TypeProvider typeProvider) {
        PlanNode root;
        if (typeProvider != null && typeProvider.getTemplatedInfo() != null) {
            root = PlanNodeType.deserializeWithTemplate(byteBuffer, typeProvider);
            if (root instanceof AlignedSeriesScanNode || root instanceof AlignedSeriesAggregationScanNode) {
                return root;
            }
        } else {
            root = PlanNodeType.deserialize(byteBuffer);
        }
        int childrenCount = byteBuffer.getInt();
        for (int i = 0; i < childrenCount; ++i) {
            root.addChild(PlanFragment.deserializeHelper(byteBuffer, typeProvider));
        }
        return root;
    }

    public void clearUselessField() {
        this.planNodeTree = null;
        this.typeProvider = null;
    }

    public void clearTypeProvider() {
        this.typeProvider = null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PlanFragment that = (PlanFragment)o;
        return Objects.equals(this.id, that.id) && Objects.equals(this.planNodeTree, that.planNodeTree);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.planNodeTree);
    }
}

