/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.planner;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.iotdb.commons.path.IFullPath;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.protocol.session.IClientSession;
import org.apache.iotdb.db.queryengine.common.DeviceContext;
import org.apache.iotdb.db.queryengine.exception.MemoryNotEnoughException;
import org.apache.iotdb.db.queryengine.execution.driver.DataDriverContext;
import org.apache.iotdb.db.queryengine.execution.fragment.DataNodeQueryContext;
import org.apache.iotdb.db.queryengine.execution.fragment.FragmentInstanceContext;
import org.apache.iotdb.db.queryengine.execution.fragment.FragmentInstanceStateMachine;
import org.apache.iotdb.db.queryengine.execution.operator.Operator;
import org.apache.iotdb.db.queryengine.metric.QueryRelatedResourceMetricSet;
import org.apache.iotdb.db.queryengine.plan.analyze.TypeProvider;
import org.apache.iotdb.db.queryengine.plan.planner.LocalExecutionPlanContext;
import org.apache.iotdb.db.queryengine.plan.planner.OperatorTreeGenerator;
import org.apache.iotdb.db.queryengine.plan.planner.PipelineDriverFactory;
import org.apache.iotdb.db.queryengine.plan.planner.TableOperatorGenerator;
import org.apache.iotdb.db.queryengine.plan.planner.memory.PipelineMemoryEstimator;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.queryengine.plan.relational.metadata.Metadata;
import org.apache.iotdb.db.queryengine.plan.relational.metadata.TableMetadataImpl;
import org.apache.iotdb.db.schemaengine.schemaregion.ISchemaRegion;
import org.apache.iotdb.db.storageengine.dataregion.read.QueryDataSourceType;
import org.apache.iotdb.db.utils.SetThreadName;
import org.apache.tsfile.file.metadata.IDeviceID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalExecutionPlanner {
    private static final Logger LOGGER = LoggerFactory.getLogger(LocalExecutionPlanner.class);
    private static final long ALLOCATE_MEMORY_FOR_OPERATORS;
    private static final long MIN_REST_MEMORY_FOR_QUERY_AFTER_LOAD;
    public final Metadata metadata = new TableMetadataImpl();
    private long freeMemoryForOperators = ALLOCATE_MEMORY_FOR_OPERATORS;

    public long getFreeMemoryForOperators() {
        return this.freeMemoryForOperators;
    }

    public long getFreeMemoryForLoadTsFile() {
        return this.freeMemoryForOperators - MIN_REST_MEMORY_FOR_QUERY_AFTER_LOAD;
    }

    public static LocalExecutionPlanner getInstance() {
        return InstanceHolder.INSTANCE;
    }

    public List<PipelineDriverFactory> plan(PlanNode plan, TypeProvider types, FragmentInstanceContext instanceContext, DataNodeQueryContext dataNodeQueryContext) throws MemoryNotEnoughException {
        LocalExecutionPlanContext context = new LocalExecutionPlanContext(types, instanceContext, dataNodeQueryContext);
        Operator root = this.generateOperator(instanceContext, context, plan);
        PipelineMemoryEstimator memoryEstimator = context.constructPipelineMemoryEstimator(root, null, plan, -1);
        context.invalidateParentPlanNodeIdToMemoryEstimator();
        long estimatedMemorySize = this.checkMemory(memoryEstimator, instanceContext.getStateMachine());
        context.addPipelineDriverFactory(root, context.getDriverContext(), estimatedMemorySize);
        instanceContext.setSourcePaths(this.collectSourcePaths(context));
        instanceContext.setDevicePathsToContext(this.collectDevicePathsToContext(context));
        instanceContext.setQueryDataSourceType(this.getQueryDataSourceType((DataDriverContext)context.getDriverContext()));
        context.getTimePartitions().ifPresent(instanceContext::setTimePartitions);
        context.setMaxBytesOneHandleCanReserve();
        return context.getPipelineDriverFactories();
    }

    public List<PipelineDriverFactory> plan(PlanNode plan, TypeProvider types, FragmentInstanceContext instanceContext, ISchemaRegion schemaRegion) throws MemoryNotEnoughException {
        LocalExecutionPlanContext context = new LocalExecutionPlanContext(types, instanceContext, schemaRegion);
        Operator root = this.generateOperator(instanceContext, context, plan);
        PipelineMemoryEstimator memoryEstimator = context.constructPipelineMemoryEstimator(root, null, plan, -1);
        context.invalidateParentPlanNodeIdToMemoryEstimator();
        this.checkMemory(memoryEstimator, instanceContext.getStateMachine());
        context.addPipelineDriverFactory(root, context.getDriverContext(), 0L);
        context.setMaxBytesOneHandleCanReserve();
        return context.getPipelineDriverFactories();
    }

    private Operator generateOperator(FragmentInstanceContext instanceContext, LocalExecutionPlanContext context, PlanNode node) {
        Operator root;
        IClientSession.SqlDialect sqlDialect = instanceContext.getSessionInfo() == null ? IClientSession.SqlDialect.TREE : instanceContext.getSessionInfo().getSqlDialect();
        switch (sqlDialect) {
            case TREE: {
                instanceContext.setIgnoreAllNullRows(true);
                root = node.accept(new OperatorTreeGenerator(), context);
                break;
            }
            case TABLE: {
                instanceContext.setIgnoreAllNullRows(false);
                root = node.accept(new TableOperatorGenerator(this.metadata), context);
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("Unknown sql dialect: %s", new Object[]{sqlDialect}));
            }
        }
        return root;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long checkMemory(PipelineMemoryEstimator memoryEstimator, FragmentInstanceStateMachine stateMachine) throws MemoryNotEnoughException {
        if (!IoTDBDescriptor.getInstance().getConfig().isEnableQueryMemoryEstimation() && !IoTDBDescriptor.getInstance().getConfig().isQuotaEnable()) {
            return 0L;
        }
        long estimatedMemorySize = memoryEstimator.getEstimatedMemoryUsageInBytes();
        QueryRelatedResourceMetricSet.getInstance().updateEstimatedMemory(estimatedMemorySize);
        LocalExecutionPlanner localExecutionPlanner = this;
        synchronized (localExecutionPlanner) {
            if (estimatedMemorySize > this.freeMemoryForOperators) {
                throw new MemoryNotEnoughException(String.format("There is not enough memory to execute current fragment instance, current remaining free memory is %dB, estimated memory usage for current fragment instance is %dB", this.freeMemoryForOperators, estimatedMemorySize));
            }
            this.freeMemoryForOperators -= estimatedMemorySize;
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("[ConsumeMemory] consume: {}, current remaining memory: {}", (Object)estimatedMemorySize, (Object)this.freeMemoryForOperators);
            }
        }
        stateMachine.addStateChangeListener(newState -> {
            if (newState.isDone()) {
                try (SetThreadName fragmentInstanceName = new SetThreadName(stateMachine.getFragmentInstanceId().getFullId());){
                    LocalExecutionPlanner localExecutionPlanner = this;
                    synchronized (localExecutionPlanner) {
                        this.freeMemoryForOperators += estimatedMemorySize;
                        if (LOGGER.isDebugEnabled()) {
                            LOGGER.debug("[ReleaseMemory] release: {}, current remaining memory: {}", (Object)estimatedMemorySize, (Object)this.freeMemoryForOperators);
                        }
                    }
                }
            }
        });
        return estimatedMemorySize;
    }

    private QueryDataSourceType getQueryDataSourceType(DataDriverContext dataDriverContext) {
        return dataDriverContext.getQueryDataSourceType().orElse(QueryDataSourceType.SERIES_SCAN);
    }

    private Map<IDeviceID, DeviceContext> collectDevicePathsToContext(LocalExecutionPlanContext context) {
        DataDriverContext dataDriverContext = (DataDriverContext)context.getDriverContext();
        Map<IDeviceID, DeviceContext> deviceContextMap = dataDriverContext.getDeviceIDToContext();
        dataDriverContext.clearDeviceIDToContext();
        return deviceContextMap;
    }

    private List<IFullPath> collectSourcePaths(LocalExecutionPlanContext context) {
        ArrayList<IFullPath> sourcePaths = new ArrayList<IFullPath>();
        context.getPipelineDriverFactories().forEach(pipeline -> {
            DataDriverContext dataDriverContext = (DataDriverContext)pipeline.getDriverContext();
            sourcePaths.addAll(dataDriverContext.getPaths());
            dataDriverContext.clearPaths();
        });
        return sourcePaths;
    }

    public synchronized boolean forceAllocateFreeMemoryForOperators(long memoryInBytes) {
        if (this.freeMemoryForOperators - memoryInBytes <= MIN_REST_MEMORY_FOR_QUERY_AFTER_LOAD) {
            return false;
        }
        this.freeMemoryForOperators -= memoryInBytes;
        return true;
    }

    public synchronized long tryAllocateFreeMemoryForOperators(long memoryInBytes) {
        if (this.freeMemoryForOperators - memoryInBytes <= MIN_REST_MEMORY_FOR_QUERY_AFTER_LOAD) {
            long result = this.freeMemoryForOperators - MIN_REST_MEMORY_FOR_QUERY_AFTER_LOAD;
            this.freeMemoryForOperators = MIN_REST_MEMORY_FOR_QUERY_AFTER_LOAD;
            return result;
        }
        this.freeMemoryForOperators -= memoryInBytes;
        return memoryInBytes;
    }

    public synchronized void reserveFromFreeMemoryForOperators(long memoryInBytes, long reservedBytes, String queryId, String contextHolder) {
        if (memoryInBytes > this.freeMemoryForOperators) {
            throw new MemoryNotEnoughException(String.format("There is not enough memory for Query %s, the contextHolder is %s,current remaining free memory is %dB, already reserved memory for this context in total is %dB, the memory requested this time is %dB", queryId, contextHolder, this.freeMemoryForOperators, reservedBytes, memoryInBytes));
        }
        this.freeMemoryForOperators -= memoryInBytes;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("[ConsumeMemory] consume: {}, current remaining memory: {}", (Object)memoryInBytes, (Object)this.freeMemoryForOperators);
        }
    }

    public synchronized void releaseToFreeMemoryForOperators(long memoryInBytes) {
        this.freeMemoryForOperators += memoryInBytes;
        if (this.freeMemoryForOperators > ALLOCATE_MEMORY_FOR_OPERATORS) {
            LOGGER.error("The free memory {} is more than allocated memory {}, last released memory: {}", new Object[]{this.freeMemoryForOperators, ALLOCATE_MEMORY_FOR_OPERATORS, memoryInBytes});
            this.freeMemoryForOperators = ALLOCATE_MEMORY_FOR_OPERATORS;
        }
    }

    public long getAllocateMemoryForOperators() {
        return ALLOCATE_MEMORY_FOR_OPERATORS;
    }

    static {
        IoTDBConfig CONFIG = IoTDBDescriptor.getInstance().getConfig();
        ALLOCATE_MEMORY_FOR_OPERATORS = CONFIG.getAllocateMemoryForOperators();
        MIN_REST_MEMORY_FOR_QUERY_AFTER_LOAD = (long)((double)ALLOCATE_MEMORY_FOR_OPERATORS * (1.0 - CONFIG.getMaxAllocateMemoryRatioForLoad()));
    }

    private static class InstanceHolder {
        private static final LocalExecutionPlanner INSTANCE = new LocalExecutionPlanner();

        private InstanceHolder() {
        }
    }
}

