/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.planner;

import com.google.common.base.Preconditions;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.queryengine.common.FragmentInstanceId;
import org.apache.iotdb.db.queryengine.execution.driver.DataDriverContext;
import org.apache.iotdb.db.queryengine.execution.driver.DriverContext;
import org.apache.iotdb.db.queryengine.execution.driver.SchemaDriverContext;
import org.apache.iotdb.db.queryengine.execution.exchange.sink.ISink;
import org.apache.iotdb.db.queryengine.execution.fragment.DataNodeQueryContext;
import org.apache.iotdb.db.queryengine.execution.fragment.FragmentInstanceContext;
import org.apache.iotdb.db.queryengine.execution.operator.Operator;
import org.apache.iotdb.db.queryengine.execution.operator.source.ExchangeOperator;
import org.apache.iotdb.db.queryengine.plan.analyze.TemplatedInfo;
import org.apache.iotdb.db.queryengine.plan.analyze.TypeProvider;
import org.apache.iotdb.db.queryengine.plan.planner.PipelineDriverFactory;
import org.apache.iotdb.db.queryengine.plan.planner.memory.PipelineMemoryEstimator;
import org.apache.iotdb.db.queryengine.plan.planner.memory.PipelineMemoryEstimatorFactory;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.schemaengine.schemaregion.ISchemaRegion;
import org.apache.tsfile.common.conf.TSFileConfig;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.file.metadata.IDeviceID;
import org.apache.tsfile.read.TimeValuePair;
import org.apache.tsfile.read.filter.basic.Filter;
import org.apache.tsfile.utils.Binary;
import org.apache.tsfile.utils.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalExecutionPlanContext {
    private static final Logger LOGGER = LoggerFactory.getLogger(LocalExecutionPlanContext.class);
    private final DriverContext driverContext;
    private final AtomicInteger nextOperatorId;
    private final TypeProvider typeProvider;
    private final Map<IDeviceID, Set<String>> allSensorsMap;
    private int degreeOfParallelism = IoTDBDescriptor.getInstance().getConfig().getDegreeOfParallelism();
    private AtomicInteger nextPipelineId;
    private List<PipelineDriverFactory> pipelineDriverFactories;
    private List<ExchangeOperator> exchangeOperatorList = new ArrayList<ExchangeOperator>();
    private int exchangeSumNum = 0;
    private List<TSDataType> cachedDataTypes;
    private List<Pair<TimeValuePair, Binary>> cachedLastValueAndPathList;
    private boolean needUpdateLastCache;
    private boolean needUpdateNullEntry;
    public final DataNodeQueryContext dataNodeQueryContext;
    private AtomicReference<List<Long>> timePartitions = new AtomicReference();
    private Map<PlanNodeId, List<PipelineMemoryEstimator>> parentPlanNodeIdToMemoryEstimator = new ConcurrentHashMap<PlanNodeId, List<PipelineMemoryEstimator>>();

    public LocalExecutionPlanContext(TypeProvider typeProvider, FragmentInstanceContext instanceContext, DataNodeQueryContext dataNodeQueryContext) {
        this.typeProvider = typeProvider;
        this.allSensorsMap = new ConcurrentHashMap<IDeviceID, Set<String>>();
        this.nextOperatorId = new AtomicInteger(0);
        this.nextPipelineId = new AtomicInteger(0);
        this.driverContext = new DataDriverContext(instanceContext, this.getNextPipelineId());
        this.pipelineDriverFactories = new ArrayList<PipelineDriverFactory>();
        this.dataNodeQueryContext = dataNodeQueryContext;
    }

    public LocalExecutionPlanContext(LocalExecutionPlanContext parentContext) {
        this.nextOperatorId = parentContext.nextOperatorId;
        this.typeProvider = parentContext.typeProvider;
        this.allSensorsMap = parentContext.allSensorsMap;
        this.nextPipelineId = parentContext.nextPipelineId;
        this.pipelineDriverFactories = parentContext.pipelineDriverFactories;
        this.degreeOfParallelism = parentContext.degreeOfParallelism;
        this.exchangeSumNum = parentContext.exchangeSumNum;
        this.exchangeOperatorList = parentContext.exchangeOperatorList;
        this.cachedDataTypes = parentContext.cachedDataTypes;
        this.driverContext = parentContext.getDriverContext().createSubDriverContext(this.getNextPipelineId());
        this.dataNodeQueryContext = parentContext.dataNodeQueryContext;
        this.timePartitions = parentContext.timePartitions;
        this.parentPlanNodeIdToMemoryEstimator = parentContext.parentPlanNodeIdToMemoryEstimator;
    }

    public LocalExecutionPlanContext(TypeProvider typeProvider, FragmentInstanceContext instanceContext, ISchemaRegion schemaRegion) {
        this.allSensorsMap = new ConcurrentHashMap<IDeviceID, Set<String>>();
        this.typeProvider = typeProvider;
        this.nextOperatorId = new AtomicInteger(0);
        this.nextPipelineId = new AtomicInteger(0);
        this.driverContext = new SchemaDriverContext(instanceContext, schemaRegion, this.getNextPipelineId());
        this.pipelineDriverFactories = new ArrayList<PipelineDriverFactory>();
        this.dataNodeQueryContext = null;
    }

    public void addPipelineDriverFactory(Operator operation, DriverContext driverContext, long estimatedMemorySize) {
        this.pipelineDriverFactories.add(new PipelineDriverFactory(operation, driverContext, estimatedMemorySize));
    }

    public PipelineMemoryEstimator constructPipelineMemoryEstimator(Operator operation, @Nullable PlanNodeId parentPlanNodeId, PlanNode root, int dependencyPipelineIndex) {
        PipelineMemoryEstimator currentPipelineMemoryEstimator = PipelineMemoryEstimatorFactory.createPipelineMemoryEstimator(operation, root, dependencyPipelineIndex);
        List<PipelineMemoryEstimator> childrenMemoryEstimators = this.parentPlanNodeIdToMemoryEstimator.get(root.getPlanNodeId());
        if (childrenMemoryEstimators != null) {
            currentPipelineMemoryEstimator.addChildren(childrenMemoryEstimators);
        }
        if (parentPlanNodeId != null) {
            this.parentPlanNodeIdToMemoryEstimator.computeIfAbsent(parentPlanNodeId, k -> new LinkedList()).add(currentPipelineMemoryEstimator);
        }
        return currentPipelineMemoryEstimator;
    }

    public LocalExecutionPlanContext createSubContext() {
        return new LocalExecutionPlanContext(this);
    }

    public FragmentInstanceId getFragmentInstanceId() {
        return this.driverContext.getFragmentInstanceContext().getId();
    }

    public List<PipelineDriverFactory> getPipelineDriverFactories() {
        return this.pipelineDriverFactories;
    }

    public PipelineDriverFactory getCurrentPipelineDriverFactory() {
        return this.pipelineDriverFactories.get(this.pipelineDriverFactories.size() - 1);
    }

    public int getPipelineNumber() {
        return this.pipelineDriverFactories.size();
    }

    public DriverContext getDriverContext() {
        return this.driverContext;
    }

    public int getDegreeOfParallelism() {
        return this.degreeOfParallelism;
    }

    public void setDegreeOfParallelism(int degreeOfParallelism) {
        this.degreeOfParallelism = degreeOfParallelism;
    }

    private int getNextPipelineId() {
        return this.nextPipelineId.getAndIncrement();
    }

    public boolean isInputDriver() {
        return this.driverContext.isInputDriver();
    }

    public int getNextOperatorId() {
        return this.nextOperatorId.getAndIncrement();
    }

    public int getExchangeSumNum() {
        return this.exchangeSumNum;
    }

    public void setExchangeSumNum(int exchangeSumNum) {
        this.exchangeSumNum = exchangeSumNum;
    }

    public long getMaxBytesOneHandleCanReserve() {
        long maxBytesPerFI = IoTDBDescriptor.getInstance().getConfig().getMaxBytesPerFragmentInstance();
        return this.exchangeSumNum == 0 ? maxBytesPerFI : maxBytesPerFI / (long)this.exchangeSumNum;
    }

    public void addExchangeSumNum(int addValue) {
        this.exchangeSumNum += addValue;
    }

    public void addExchangeOperator(ExchangeOperator exchangeOperator) {
        this.exchangeOperatorList.add(exchangeOperator);
    }

    public void setMaxBytesOneHandleCanReserve() {
        long maxBytesOneHandleCanReserve = this.getMaxBytesOneHandleCanReserve();
        LOGGER.debug("MaxBytesOneHandleCanReserve for ExchangeOperator is {}, exchangeSumNum is {}.", (Object)maxBytesOneHandleCanReserve, (Object)this.exchangeSumNum);
        this.exchangeOperatorList.forEach(exchangeOperator -> exchangeOperator.getSourceHandle().setMaxBytesCanReserve(maxBytesOneHandleCanReserve));
    }

    public Set<String> getAllSensors(IDeviceID deviceId, String sensorId) {
        Set allSensors = this.allSensorsMap.computeIfAbsent(deviceId, k -> new HashSet());
        allSensors.add(sensorId);
        return allSensors;
    }

    public void setNeedUpdateLastCache(boolean needUpdateLastCache) {
        this.needUpdateLastCache = needUpdateLastCache;
    }

    public void addCachedLastValue(TimeValuePair timeValuePair, String fullPath) {
        if (this.cachedLastValueAndPathList == null) {
            this.cachedLastValueAndPathList = new ArrayList<Pair<TimeValuePair, Binary>>();
        }
        this.cachedLastValueAndPathList.add((Pair<TimeValuePair, Binary>)new Pair((Object)timeValuePair, (Object)new Binary(fullPath, TSFileConfig.STRING_CHARSET)));
    }

    public List<Pair<TimeValuePair, Binary>> getCachedLastValueAndPathList() {
        return this.cachedLastValueAndPathList;
    }

    public void setISink(ISink sink) {
        Objects.requireNonNull(sink, "sink is null");
        Preconditions.checkArgument((this.driverContext.getSink() == null ? 1 : 0) != 0, (Object)"There must be at most one SinkNode");
        this.driverContext.setSink(sink);
    }

    public void setCachedDataTypes(List<TSDataType> cachedDataTypes) {
        this.cachedDataTypes = cachedDataTypes;
    }

    public List<TSDataType> getCachedDataTypes() {
        return this.cachedDataTypes;
    }

    public TypeProvider getTypeProvider() {
        return this.typeProvider;
    }

    public FragmentInstanceContext getInstanceContext() {
        return this.driverContext.getFragmentInstanceContext();
    }

    public boolean isNeedUpdateLastCache() {
        return this.needUpdateLastCache;
    }

    public boolean isNeedUpdateNullEntry() {
        return this.needUpdateNullEntry;
    }

    public void setNeedUpdateNullEntry(boolean needUpdateNullEntry) {
        this.needUpdateNullEntry = needUpdateNullEntry;
    }

    public Filter getGlobalTimeFilter() {
        return this.driverContext.getFragmentInstanceContext().getGlobalTimeFilter();
    }

    public Optional<List<Long>> getTimePartitions() {
        return Optional.ofNullable(this.timePartitions.get());
    }

    public void setTimePartitions(List<Long> timePartitions) {
        this.timePartitions.set(timePartitions);
    }

    public ZoneId getZoneId() {
        return this.driverContext.getFragmentInstanceContext().getSessionInfo().getZoneId();
    }

    public boolean isBuildPlanUseTemplate() {
        return this.typeProvider.getTemplatedInfo() != null;
    }

    public TemplatedInfo getTemplatedInfo() {
        return this.typeProvider.getTemplatedInfo();
    }

    public Map<PlanNodeId, List<PipelineMemoryEstimator>> getParentPlanNodeIdToMemoryEstimator() {
        return this.parentPlanNodeIdToMemoryEstimator;
    }

    public void invalidateParentPlanNodeIdToMemoryEstimator() {
        this.parentPlanNodeIdToMemoryEstimator = null;
    }
}

