/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.analyze.load;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.io.FileUtils;
import org.apache.iotdb.commons.auth.AuthException;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.exception.load.LoadAnalyzeException;
import org.apache.iotdb.db.exception.load.LoadAnalyzeTypeMismatchException;
import org.apache.iotdb.db.exception.load.LoadEmptyFileException;
import org.apache.iotdb.db.exception.sql.SemanticException;
import org.apache.iotdb.db.queryengine.common.MPPQueryContext;
import org.apache.iotdb.db.queryengine.plan.analyze.IAnalysis;
import org.apache.iotdb.db.queryengine.plan.analyze.load.LoadTsFileAnalyzer;
import org.apache.iotdb.db.queryengine.plan.analyze.load.TreeSchemaAutoCreatorAndVerifier;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.LoadTsFile;
import org.apache.iotdb.db.queryengine.plan.statement.crud.LoadTsFileStatement;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResource;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResourceStatus;
import org.apache.iotdb.db.storageengine.dataregion.utils.TsFileResourceUtils;
import org.apache.iotdb.db.utils.TimestampPrecisionUtils;
import org.apache.iotdb.rpc.RpcUtils;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.tsfile.encrypt.EncryptParameter;
import org.apache.tsfile.encrypt.EncryptUtils;
import org.apache.tsfile.read.TsFileSequenceReader;
import org.apache.tsfile.read.TsFileSequenceReaderTimeseriesMetadataIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoadTsFileToTreeModelAnalyzer
extends LoadTsFileAnalyzer {
    private static final Logger LOGGER = LoggerFactory.getLogger(LoadTsFileToTreeModelAnalyzer.class);
    private final TreeSchemaAutoCreatorAndVerifier schemaAutoCreatorAndVerifier = new TreeSchemaAutoCreatorAndVerifier(this);

    public LoadTsFileToTreeModelAnalyzer(LoadTsFileStatement loadTsFileStatement, boolean isGeneratedByPipe, MPPQueryContext context) {
        super(loadTsFileStatement, isGeneratedByPipe, context);
    }

    public LoadTsFileToTreeModelAnalyzer(LoadTsFile loadTsFileTableStatement, boolean isGeneratedByPipe, MPPQueryContext context) {
        super(loadTsFileTableStatement, isGeneratedByPipe, context);
    }

    @Override
    public IAnalysis analyzeFileByFile(IAnalysis analysis) {
        this.checkBeforeAnalyzeFileByFile(analysis);
        if (analysis.isFinishQueryAfterAnalyze()) {
            return analysis;
        }
        if (!this.doAnalyzeFileByFile(analysis)) {
            return analysis;
        }
        try {
            this.schemaAutoCreatorAndVerifier.flush();
        }
        catch (AuthException e) {
            this.setFailAnalysisForAuthException(analysis, e);
            return analysis;
        }
        catch (LoadAnalyzeException e) {
            this.executeTabletConversion(analysis, e);
            return analysis;
        }
        catch (Exception e) {
            String exceptionMessage = String.format("Auto create or verify schema error when executing statement %s. Detail: %s.", this.getStatementString(), e.getMessage() == null ? e.getClass().getName() : e.getMessage());
            LOGGER.warn(exceptionMessage, (Throwable)e);
            analysis.setFinishQueryAfterAnalyze(true);
            analysis.setFailStatus(RpcUtils.getStatus((TSStatusCode)TSStatusCode.LOAD_FILE_ERROR, (String)exceptionMessage));
            return analysis;
        }
        LOGGER.info("Load - Analysis Stage: all tsfiles have been analyzed.");
        this.setRealStatement(analysis);
        return analysis;
    }

    @Override
    protected void analyzeSingleTsFile(File tsFile) throws IOException, AuthException, LoadAnalyzeTypeMismatchException {
        block14: {
            try (TsFileSequenceReader reader = new TsFileSequenceReader(tsFile.getAbsolutePath());){
                boolean isAutoCreateSchemaOrVerifySchemaEnabled;
                TsFileSequenceReaderTimeseriesMetadataIterator timeseriesMetadataIterator = new TsFileSequenceReaderTimeseriesMetadataIterator(reader, true, 1);
                if (!timeseriesMetadataIterator.hasNext()) {
                    throw new LoadEmptyFileException(tsFile.getAbsolutePath());
                }
                EncryptParameter param = reader.getEncryptParam();
                if (!Objects.equals(param.getType(), EncryptUtils.encryptParam.getType()) || !Arrays.equals(param.getKey(), EncryptUtils.encryptParam.getKey())) {
                    throw new SemanticException("The encryption way of the TsFile is not supported.");
                }
                Map tableSchemaMap = reader.getTableSchemaMap();
                if (Objects.nonNull(tableSchemaMap) && !tableSchemaMap.isEmpty()) {
                    throw new SemanticException("Attempted to load a table-model TsFile into tree-model.");
                }
                TsFileResource tsFileResource = this.constructTsFileResource(reader, tsFile);
                this.schemaAutoCreatorAndVerifier.setCurrentModificationsAndTimeIndex(tsFileResource, reader);
                long writePointCount = 0L;
                boolean bl = isAutoCreateSchemaOrVerifySchemaEnabled = IoTDBDescriptor.getInstance().getConfig().isAutoCreateSchemaEnabled() || this.isVerifySchema();
                while (timeseriesMetadataIterator.hasNext()) {
                    Map device2TimeseriesMetadata = timeseriesMetadataIterator.next();
                    if (isAutoCreateSchemaOrVerifySchemaEnabled) {
                        this.schemaAutoCreatorAndVerifier.autoCreateAndVerify(reader, device2TimeseriesMetadata);
                    }
                    if (!tsFileResource.resourceFileExists()) {
                        TsFileResourceUtils.updateTsFileResource(device2TimeseriesMetadata, tsFileResource);
                    }
                    writePointCount += this.getWritePointCount(device2TimeseriesMetadata);
                }
                if (isAutoCreateSchemaOrVerifySchemaEnabled) {
                    this.schemaAutoCreatorAndVerifier.flushAndClearDeviceIsAlignedCacheIfNecessary();
                }
                TimestampPrecisionUtils.checkTimestampPrecision(tsFileResource.getFileEndTime());
                tsFileResource.setStatus(TsFileResourceStatus.NORMAL);
                this.addTsFileResource(tsFileResource);
                this.addWritePointCount(writePointCount);
            }
            catch (LoadEmptyFileException loadEmptyFileException) {
                LOGGER.warn("Failed to load empty file: {}", (Object)tsFile.getAbsolutePath());
                if (!this.isDeleteAfterLoad) break block14;
                FileUtils.deleteQuietly((File)tsFile);
            }
        }
    }

    @Override
    public void close() throws Exception {
        this.schemaAutoCreatorAndVerifier.close();
    }
}

