/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.analyze.cache.schema;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;

public class DataNodeDevicePathCache {
    private static final IoTDBConfig config = IoTDBDescriptor.getInstance().getConfig();
    private final Cache<String, PartialPath> devicePathCache = Caffeine.newBuilder().maximumWeight((long)((double)config.getAllocateMemoryForStorageEngine() * config.getWriteProportionForMemtable() * config.getDevicePathCacheProportion())).weigher((key, val) -> PartialPath.estimateSize((PartialPath)val) + 32).build();

    private DataNodeDevicePathCache() {
    }

    public static DataNodeDevicePathCache getInstance() {
        return DataNodeDevicePathCacheHolder.INSTANCE;
    }

    public PartialPath getPartialPath(String deviceId) throws IllegalPathException {
        try {
            return (PartialPath)this.devicePathCache.get((Object)deviceId, path -> {
                try {
                    return new PartialPath(path);
                }
                catch (IllegalPathException e) {
                    try {
                        return PartialPath.getDatabasePath((String)path);
                    }
                    catch (IllegalPathException e1) {
                        throw new IllegalArgumentException(e1);
                    }
                }
            });
        }
        catch (IllegalArgumentException e) {
            throw new IllegalPathException(deviceId);
        }
    }

    public String getDeviceId(String deviceId) {
        try {
            return this.getPartialPath(deviceId).getFullPath();
        }
        catch (IllegalPathException e) {
            return deviceId;
        }
    }

    public void cleanUp() {
        this.devicePathCache.cleanUp();
    }

    private static class DataNodeDevicePathCacheHolder {
        private static final DataNodeDevicePathCache INSTANCE = new DataNodeDevicePathCache();

        private DataNodeDevicePathCacheHolder() {
        }
    }
}

