/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.operator.source.relational.aggregation.grouped;

import com.google.common.base.Preconditions;
import java.util.Collections;
import org.apache.iotdb.db.queryengine.execution.operator.source.relational.aggregation.grouped.GroupedAccumulator;
import org.apache.iotdb.db.queryengine.execution.operator.source.relational.aggregation.grouped.array.BinaryBigArray;
import org.apache.iotdb.db.queryengine.execution.operator.source.relational.aggregation.grouped.array.BooleanBigArray;
import org.apache.iotdb.db.queryengine.execution.operator.source.relational.aggregation.grouped.array.DoubleBigArray;
import org.apache.iotdb.db.queryengine.execution.operator.source.relational.aggregation.grouped.array.FloatBigArray;
import org.apache.iotdb.db.queryengine.execution.operator.source.relational.aggregation.grouped.array.IntBigArray;
import org.apache.iotdb.db.queryengine.execution.operator.source.relational.aggregation.grouped.array.LongBigArray;
import org.apache.tsfile.block.column.Column;
import org.apache.tsfile.block.column.ColumnBuilder;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.read.common.block.TsBlockBuilder;
import org.apache.tsfile.read.common.block.column.BinaryColumn;
import org.apache.tsfile.read.common.block.column.BinaryColumnBuilder;
import org.apache.tsfile.read.common.block.column.RunLengthEncodedColumn;
import org.apache.tsfile.utils.Binary;
import org.apache.tsfile.utils.BytesUtils;
import org.apache.tsfile.utils.RamUsageEstimator;
import org.apache.tsfile.write.UnSupportedDataTypeException;

public abstract class GroupedMaxMinByBaseAccumulator
implements GroupedAccumulator {
    private static final long INSTANCE_SIZE = RamUsageEstimator.shallowSizeOfInstance(GroupedAccumulator.class);
    private final TSDataType xDataType;
    private final TSDataType yDataType;
    private final BooleanBigArray inits = new BooleanBigArray();
    private LongBigArray xLongValues;
    private IntBigArray xIntValues;
    private FloatBigArray xFloatValues;
    private DoubleBigArray xDoubleValues;
    private BinaryBigArray xBinaryValues;
    private BooleanBigArray xBooleanValues;
    private LongBigArray yLongValues;
    private IntBigArray yIntValues;
    private FloatBigArray yFloatValues;
    private DoubleBigArray yDoubleValues;
    private BinaryBigArray yBinaryValues;
    private BooleanBigArray yBooleanValues;
    private final BooleanBigArray xNulls = new BooleanBigArray(true);

    protected GroupedMaxMinByBaseAccumulator(TSDataType xDataType, TSDataType yDataType) {
        this.xDataType = xDataType;
        this.yDataType = yDataType;
        switch (xDataType) {
            case INT32: 
            case DATE: {
                this.xIntValues = new IntBigArray();
                break;
            }
            case INT64: 
            case TIMESTAMP: {
                this.xLongValues = new LongBigArray();
                break;
            }
            case FLOAT: {
                this.xFloatValues = new FloatBigArray();
                break;
            }
            case DOUBLE: {
                this.xDoubleValues = new DoubleBigArray();
                break;
            }
            case TEXT: 
            case BLOB: 
            case STRING: {
                this.xBinaryValues = new BinaryBigArray();
                break;
            }
            case BOOLEAN: {
                this.xBooleanValues = new BooleanBigArray();
                break;
            }
            default: {
                throw new UnSupportedDataTypeException(String.format("Unsupported data type : %s", xDataType));
            }
        }
        switch (yDataType) {
            case INT32: 
            case DATE: {
                this.yIntValues = new IntBigArray();
                break;
            }
            case INT64: 
            case TIMESTAMP: {
                this.yLongValues = new LongBigArray();
                break;
            }
            case FLOAT: {
                this.yFloatValues = new FloatBigArray();
                break;
            }
            case DOUBLE: {
                this.yDoubleValues = new DoubleBigArray();
                break;
            }
            case TEXT: 
            case BLOB: 
            case STRING: {
                this.yBinaryValues = new BinaryBigArray();
                break;
            }
            case BOOLEAN: {
                this.yBooleanValues = new BooleanBigArray();
                break;
            }
            default: {
                throw new UnSupportedDataTypeException(String.format("Unsupported data type : %s", yDataType));
            }
        }
    }

    @Override
    public long getEstimatedSize() {
        long valuesSize = 0L;
        switch (this.xDataType) {
            case INT32: 
            case DATE: {
                valuesSize += this.xIntValues.sizeOf();
                break;
            }
            case INT64: 
            case TIMESTAMP: {
                valuesSize += this.xLongValues.sizeOf();
                break;
            }
            case FLOAT: {
                valuesSize += this.xFloatValues.sizeOf();
                break;
            }
            case DOUBLE: {
                valuesSize += this.xDoubleValues.sizeOf();
                break;
            }
            case TEXT: 
            case BLOB: 
            case STRING: {
                valuesSize += this.xBinaryValues.sizeOf();
                break;
            }
            case BOOLEAN: {
                valuesSize += this.xBooleanValues.sizeOf();
                break;
            }
            default: {
                throw new UnSupportedDataTypeException(String.format("Unsupported data type in : %s", this.xDataType));
            }
        }
        switch (this.yDataType) {
            case INT32: 
            case DATE: {
                valuesSize += this.yIntValues.sizeOf();
                break;
            }
            case INT64: 
            case TIMESTAMP: {
                valuesSize += this.yLongValues.sizeOf();
                break;
            }
            case FLOAT: {
                valuesSize += this.yFloatValues.sizeOf();
                break;
            }
            case DOUBLE: {
                valuesSize += this.yDoubleValues.sizeOf();
                break;
            }
            case TEXT: 
            case BLOB: 
            case STRING: {
                valuesSize += this.yBinaryValues.sizeOf();
                break;
            }
            case BOOLEAN: {
                valuesSize += this.yBooleanValues.sizeOf();
                break;
            }
            default: {
                throw new UnSupportedDataTypeException(String.format("Unsupported data type in : %s", this.xDataType));
            }
        }
        return INSTANCE_SIZE + valuesSize + this.inits.sizeOf() + this.xNulls.sizeOf();
    }

    @Override
    public void setGroupCount(long groupCount) {
        this.inits.ensureCapacity(groupCount);
        this.xNulls.ensureCapacity(groupCount);
        switch (this.xDataType) {
            case INT32: 
            case DATE: {
                this.xIntValues.ensureCapacity(groupCount);
                break;
            }
            case INT64: 
            case TIMESTAMP: {
                this.xLongValues.ensureCapacity(groupCount);
                break;
            }
            case FLOAT: {
                this.xFloatValues.ensureCapacity(groupCount);
                break;
            }
            case DOUBLE: {
                this.xDoubleValues.ensureCapacity(groupCount);
                break;
            }
            case TEXT: 
            case BLOB: 
            case STRING: {
                this.xBinaryValues.ensureCapacity(groupCount);
                break;
            }
            case BOOLEAN: {
                this.xBooleanValues.ensureCapacity(groupCount);
                break;
            }
            default: {
                throw new UnSupportedDataTypeException(String.format("Unsupported data type in : %s", this.xDataType));
            }
        }
        switch (this.yDataType) {
            case INT32: 
            case DATE: {
                this.yIntValues.ensureCapacity(groupCount);
                break;
            }
            case INT64: 
            case TIMESTAMP: {
                this.yLongValues.ensureCapacity(groupCount);
                break;
            }
            case FLOAT: {
                this.yFloatValues.ensureCapacity(groupCount);
                break;
            }
            case DOUBLE: {
                this.yDoubleValues.ensureCapacity(groupCount);
                break;
            }
            case TEXT: 
            case BLOB: 
            case STRING: {
                this.yBinaryValues.ensureCapacity(groupCount);
                break;
            }
            case BOOLEAN: {
                this.yBooleanValues.ensureCapacity(groupCount);
                break;
            }
            default: {
                throw new UnSupportedDataTypeException(String.format("Unsupported data type in : %s", this.xDataType));
            }
        }
    }

    @Override
    public void prepareFinal() {
    }

    @Override
    public void reset() {
        this.inits.reset();
        this.xNulls.reset();
        switch (this.xDataType) {
            case INT32: 
            case DATE: {
                this.xIntValues.reset();
                break;
            }
            case INT64: 
            case TIMESTAMP: {
                this.xLongValues.reset();
                break;
            }
            case FLOAT: {
                this.xFloatValues.reset();
                break;
            }
            case DOUBLE: {
                this.xDoubleValues.reset();
                break;
            }
            case TEXT: 
            case BLOB: 
            case STRING: {
                this.xBinaryValues.reset();
                break;
            }
            case BOOLEAN: {
                this.xBooleanValues.reset();
                break;
            }
            default: {
                throw new UnSupportedDataTypeException(String.format("Unsupported data type : %s", this.xDataType));
            }
        }
        switch (this.yDataType) {
            case INT32: 
            case DATE: {
                this.yIntValues.reset();
                break;
            }
            case INT64: 
            case TIMESTAMP: {
                this.yLongValues.reset();
                break;
            }
            case FLOAT: {
                this.yFloatValues.reset();
                break;
            }
            case DOUBLE: {
                this.yDoubleValues.reset();
                break;
            }
            case TEXT: 
            case BLOB: 
            case STRING: {
                this.yBinaryValues.reset();
                break;
            }
            case BOOLEAN: {
                this.yBooleanValues.reset();
                break;
            }
            default: {
                throw new UnSupportedDataTypeException(String.format("Unsupported data type : %s", this.yDataType));
            }
        }
    }

    @Override
    public void addInput(int[] groupIds, Column[] arguments) {
        switch (this.yDataType) {
            case INT32: 
            case DATE: {
                this.addIntInput(groupIds, arguments);
                return;
            }
            case INT64: 
            case TIMESTAMP: {
                this.addLongInput(groupIds, arguments);
                return;
            }
            case FLOAT: {
                this.addFloatInput(groupIds, arguments);
                return;
            }
            case DOUBLE: {
                this.addDoubleInput(groupIds, arguments);
                return;
            }
            case TEXT: 
            case BLOB: 
            case STRING: {
                this.addBinaryInput(groupIds, arguments);
                return;
            }
            case BOOLEAN: {
                this.addBooleanInput(groupIds, arguments);
                return;
            }
        }
        throw new UnSupportedDataTypeException(String.format("Unsupported data type : %s", this.yDataType));
    }

    @Override
    public void addIntermediate(int[] groupIds, Column argument) {
        Preconditions.checkArgument((argument instanceof BinaryColumn || argument instanceof RunLengthEncodedColumn && ((RunLengthEncodedColumn)argument).getValue() instanceof BinaryColumn ? 1 : 0) != 0, (Object)"intermediate input and output of MaxBy or MinBy should be BinaryColumn");
        for (int i = 0; i < groupIds.length; ++i) {
            if (argument.isNull(i)) continue;
            byte[] bytes = argument.getBinary(i).getValues();
            this.updateFromBytesIntermediateInput(groupIds[i], bytes);
        }
    }

    @Override
    public void evaluateIntermediate(int groupId, ColumnBuilder columnBuilder) {
        Preconditions.checkArgument((boolean)(columnBuilder instanceof BinaryColumnBuilder), (Object)"intermediate input and output of Mode should be BinaryColumn");
        if (!this.inits.get(groupId)) {
            columnBuilder.appendNull();
            return;
        }
        columnBuilder.writeBinary(new Binary(this.serialize(groupId)));
    }

    @Override
    public void evaluateFinal(int groupId, ColumnBuilder columnBuilder) {
        if (!this.inits.get(groupId)) {
            columnBuilder.appendNull();
            return;
        }
        this.writeX(groupId, columnBuilder);
    }

    private void addIntInput(int[] groupIds, Column[] arguments) {
        for (int i = 0; i < groupIds.length; ++i) {
            if (arguments[1].isNull(i)) continue;
            this.updateIntResult(groupIds[i], arguments[1].getInt(i), arguments[0], i);
        }
    }

    private void updateIntResult(int groupId, int yValue, Column xColumn, int xIndex) {
        if (!this.inits.get(groupId) || this.check(yValue, this.yIntValues.get(groupId))) {
            this.inits.set(groupId, true);
            this.yIntValues.set(groupId, yValue);
            this.updateX(groupId, xColumn, xIndex);
        }
    }

    private void addLongInput(int[] groupIds, Column[] arguments) {
        for (int i = 0; i < groupIds.length; ++i) {
            if (arguments[1].isNull(i)) continue;
            this.updateLongResult(groupIds[i], arguments[1].getLong(i), arguments[0], i);
        }
    }

    private void updateLongResult(int groupId, long yValue, Column xColumn, int xIndex) {
        if (!this.inits.get(groupId) || this.check(yValue, this.yLongValues.get(groupId))) {
            this.inits.set(groupId, true);
            this.yLongValues.set(groupId, yValue);
            this.updateX(groupId, xColumn, xIndex);
        }
    }

    private void addFloatInput(int[] groupIds, Column[] arguments) {
        for (int i = 0; i < groupIds.length; ++i) {
            if (arguments[1].isNull(i)) continue;
            this.updateFloatResult(groupIds[i], arguments[1].getFloat(i), arguments[0], i);
        }
    }

    private void updateFloatResult(int groupId, float yValue, Column xColumn, int xIndex) {
        if (!this.inits.get(groupId) || this.check(yValue, this.yFloatValues.get(groupId))) {
            this.inits.set(groupId, true);
            this.yFloatValues.set(groupId, yValue);
            this.updateX(groupId, xColumn, xIndex);
        }
    }

    private void addDoubleInput(int[] groupIds, Column[] arguments) {
        for (int i = 0; i < groupIds.length; ++i) {
            if (arguments[1].isNull(i)) continue;
            this.updateDoubleResult(groupIds[i], arguments[1].getDouble(i), arguments[0], i);
        }
    }

    private void updateDoubleResult(int groupId, double yValue, Column xColumn, int xIndex) {
        if (!this.inits.get(groupId) || this.check(yValue, this.yDoubleValues.get(groupId))) {
            this.inits.set(groupId, true);
            this.yDoubleValues.set(groupId, yValue);
            this.updateX(groupId, xColumn, xIndex);
        }
    }

    private void addBinaryInput(int[] groupIds, Column[] arguments) {
        for (int i = 0; i < groupIds.length; ++i) {
            if (arguments[1].isNull(i)) continue;
            this.updateBinaryResult(groupIds[i], arguments[1].getBinary(i), arguments[0], i);
        }
    }

    private void updateBinaryResult(int groupId, Binary yValue, Column xColumn, int xIndex) {
        if (!this.inits.get(groupId) || this.check(yValue, this.yBinaryValues.get(groupId))) {
            this.inits.set(groupId, true);
            this.yBinaryValues.set(groupId, yValue);
            this.updateX(groupId, xColumn, xIndex);
        }
    }

    private void addBooleanInput(int[] groupIds, Column[] arguments) {
        for (int i = 0; i < groupIds.length; ++i) {
            if (arguments[1].isNull(i)) continue;
            this.updateBooleanResult(groupIds[i], arguments[1].getBoolean(i), arguments[0], i);
        }
    }

    private void updateBooleanResult(int groupId, boolean yValue, Column xColumn, int xIndex) {
        if (!this.inits.get(groupId) || this.check(yValue, this.yBooleanValues.get(groupId))) {
            this.inits.set(groupId, true);
            this.yBooleanValues.set(groupId, yValue);
            this.updateX(groupId, xColumn, xIndex);
        }
    }

    private void writeX(int groupId, ColumnBuilder columnBuilder) {
        if (this.xNulls.get(groupId)) {
            columnBuilder.appendNull();
            return;
        }
        switch (this.xDataType) {
            case INT32: 
            case DATE: {
                columnBuilder.writeInt(this.xIntValues.get(groupId));
                break;
            }
            case INT64: 
            case TIMESTAMP: {
                columnBuilder.writeLong(this.xLongValues.get(groupId));
                break;
            }
            case FLOAT: {
                columnBuilder.writeFloat(this.xFloatValues.get(groupId));
                break;
            }
            case DOUBLE: {
                columnBuilder.writeDouble(this.xDoubleValues.get(groupId));
                break;
            }
            case TEXT: 
            case BLOB: 
            case STRING: {
                columnBuilder.writeBinary(this.xBinaryValues.get(groupId));
                break;
            }
            case BOOLEAN: {
                columnBuilder.writeBoolean(this.xBooleanValues.get(groupId));
                break;
            }
            default: {
                throw new UnSupportedDataTypeException(String.format("Unsupported data type : %s", this.xDataType));
            }
        }
    }

    private void updateX(int groupId, Column xColumn, int xIndex) {
        if (xColumn.isNull(xIndex)) {
            this.xNulls.set(groupId, true);
        } else {
            this.xNulls.set(groupId, false);
            switch (this.xDataType) {
                case INT32: 
                case DATE: {
                    this.xIntValues.set(groupId, xColumn.getInt(xIndex));
                    break;
                }
                case INT64: 
                case TIMESTAMP: {
                    this.xLongValues.set(groupId, xColumn.getLong(xIndex));
                    break;
                }
                case FLOAT: {
                    this.xFloatValues.set(groupId, xColumn.getFloat(xIndex));
                    break;
                }
                case DOUBLE: {
                    this.xDoubleValues.set(groupId, xColumn.getDouble(xIndex));
                    break;
                }
                case TEXT: 
                case BLOB: 
                case STRING: {
                    this.xBinaryValues.set(groupId, xColumn.getBinary(xIndex));
                    break;
                }
                case BOOLEAN: {
                    this.xBooleanValues.set(groupId, xColumn.getBoolean(xIndex));
                }
                default: {
                    throw new UnSupportedDataTypeException(String.format("Unsupported data type : %s", this.xDataType));
                }
            }
        }
    }

    private byte[] serialize(int groupId) {
        boolean xNull = this.xNulls.get(groupId);
        int yLength = this.calculateValueLength(groupId, this.yDataType, false);
        int length = yLength + 1 + (xNull ? 0 : this.calculateValueLength(groupId, this.xDataType, true));
        byte[] bytes = new byte[length];
        this.writeIntermediate(groupId, false, this.yDataType, bytes, 0);
        BytesUtils.boolToBytes((boolean)xNull, (byte[])bytes, (int)yLength);
        if (!xNull) {
            this.writeIntermediate(groupId, true, this.xDataType, bytes, yLength + 1);
        }
        return bytes;
    }

    private void writeIntermediate(int groupId, boolean isX, TSDataType dataType, byte[] bytes, int offset) {
        switch (dataType) {
            case INT32: 
            case DATE: {
                if (isX) {
                    BytesUtils.intToBytes((int)this.xIntValues.get(groupId), (byte[])bytes, (int)offset);
                    break;
                }
                BytesUtils.intToBytes((int)this.yIntValues.get(groupId), (byte[])bytes, (int)offset);
                break;
            }
            case INT64: 
            case TIMESTAMP: {
                if (isX) {
                    BytesUtils.longToBytes((long)this.xLongValues.get(groupId), (byte[])bytes, (int)offset);
                    break;
                }
                BytesUtils.longToBytes((long)this.yLongValues.get(groupId), (byte[])bytes, (int)offset);
                break;
            }
            case FLOAT: {
                if (isX) {
                    BytesUtils.floatToBytes((float)this.xFloatValues.get(groupId), (byte[])bytes, (int)offset);
                    break;
                }
                BytesUtils.floatToBytes((float)this.yFloatValues.get(groupId), (byte[])bytes, (int)offset);
                break;
            }
            case DOUBLE: {
                if (isX) {
                    BytesUtils.doubleToBytes((double)this.xDoubleValues.get(groupId), (byte[])bytes, (int)offset);
                    break;
                }
                BytesUtils.doubleToBytes((double)this.yDoubleValues.get(groupId), (byte[])bytes, (int)offset);
                break;
            }
            case TEXT: 
            case BLOB: 
            case STRING: {
                byte[] values = isX ? this.xBinaryValues.get(groupId).getValues() : this.yBinaryValues.get(groupId).getValues();
                BytesUtils.intToBytes((int)values.length, (byte[])bytes, (int)offset);
                System.arraycopy(values, 0, bytes, offset + 4, values.length);
                break;
            }
            case BOOLEAN: {
                if (isX) {
                    BytesUtils.boolToBytes((boolean)this.yBooleanValues.get(groupId), (byte[])bytes, (int)offset);
                    break;
                }
                BytesUtils.boolToBytes((boolean)this.yBooleanValues.get(groupId), (byte[])bytes, (int)offset);
                break;
            }
            default: {
                throw new UnSupportedDataTypeException(String.format("Unsupported data type : %s", dataType));
            }
        }
    }

    private int calculateValueLength(int groupId, TSDataType dataType, boolean isX) {
        switch (dataType) {
            case INT32: 
            case DATE: {
                return 4;
            }
            case INT64: 
            case TIMESTAMP: {
                return 8;
            }
            case FLOAT: {
                return 4;
            }
            case DOUBLE: {
                return 8;
            }
            case TEXT: 
            case BLOB: 
            case STRING: {
                return 4 + (isX ? this.xBinaryValues.get(groupId).getValues().length : this.yBinaryValues.get(groupId).getValues().length);
            }
            case BOOLEAN: {
                return 1;
            }
        }
        throw new UnSupportedDataTypeException(String.format("Unsupported data type: %s", dataType));
    }

    private void updateFromBytesIntermediateInput(int groupId, byte[] bytes) {
        int offset = 0;
        TsBlockBuilder builder = new TsBlockBuilder(Collections.singletonList(this.xDataType));
        ColumnBuilder columnBuilder = builder.getValueColumnBuilders()[0];
        switch (this.yDataType) {
            case INT32: 
            case DATE: {
                int intMaxVal = BytesUtils.bytesToInt((byte[])bytes, (int)offset);
                this.readXFromBytesIntermediateInput(bytes, offset += 4, columnBuilder);
                this.updateIntResult(groupId, intMaxVal, columnBuilder.build(), 0);
                break;
            }
            case INT64: 
            case TIMESTAMP: {
                long longMaxVal = BytesUtils.bytesToLongFromOffset((byte[])bytes, (int)8, (int)offset);
                this.readXFromBytesIntermediateInput(bytes, offset += 8, columnBuilder);
                this.updateLongResult(groupId, longMaxVal, columnBuilder.build(), 0);
                break;
            }
            case FLOAT: {
                float floatMaxVal = BytesUtils.bytesToFloat((byte[])bytes, (int)offset);
                this.readXFromBytesIntermediateInput(bytes, offset += 4, columnBuilder);
                this.updateFloatResult(groupId, floatMaxVal, columnBuilder.build(), 0);
                break;
            }
            case DOUBLE: {
                double doubleMaxVal = BytesUtils.bytesToDouble((byte[])bytes, (int)offset);
                this.readXFromBytesIntermediateInput(bytes, offset += 8, columnBuilder);
                this.updateDoubleResult(groupId, doubleMaxVal, columnBuilder.build(), 0);
                break;
            }
            case TEXT: 
            case BLOB: 
            case STRING: {
                int length = BytesUtils.bytesToInt((byte[])bytes, (int)offset);
                Binary binaryMaxVal = new Binary(BytesUtils.subBytes((byte[])bytes, (int)(offset += 4), (int)length));
                this.readXFromBytesIntermediateInput(bytes, offset += length, columnBuilder);
                this.updateBinaryResult(groupId, binaryMaxVal, columnBuilder.build(), 0);
                break;
            }
            case BOOLEAN: {
                boolean booleanVal = BytesUtils.bytesToBool((byte[])bytes, (int)offset);
                this.readXFromBytesIntermediateInput(bytes, ++offset, columnBuilder);
                this.updateBooleanResult(groupId, booleanVal, columnBuilder.build(), 0);
                break;
            }
            default: {
                throw new UnSupportedDataTypeException(String.format("Unsupported data type : %s", this.yDataType));
            }
        }
    }

    private void readXFromBytesIntermediateInput(byte[] bytes, int offset, ColumnBuilder columnBuilder) {
        boolean isXNull = BytesUtils.bytesToBool((byte[])bytes, (int)offset);
        ++offset;
        if (isXNull) {
            columnBuilder.appendNull();
        } else {
            switch (this.xDataType) {
                case INT32: 
                case DATE: {
                    columnBuilder.writeInt(BytesUtils.bytesToInt((byte[])bytes, (int)offset));
                    break;
                }
                case INT64: 
                case TIMESTAMP: {
                    columnBuilder.writeLong(BytesUtils.bytesToLongFromOffset((byte[])bytes, (int)8, (int)offset));
                    break;
                }
                case FLOAT: {
                    columnBuilder.writeFloat(BytesUtils.bytesToFloat((byte[])bytes, (int)offset));
                    break;
                }
                case DOUBLE: {
                    columnBuilder.writeDouble(BytesUtils.bytesToDouble((byte[])bytes, (int)offset));
                    break;
                }
                case TEXT: 
                case BLOB: 
                case STRING: {
                    int length = BytesUtils.bytesToInt((byte[])bytes, (int)offset);
                    columnBuilder.writeBinary(new Binary(BytesUtils.subBytes((byte[])bytes, (int)(offset += 4), (int)length)));
                    break;
                }
                case BOOLEAN: {
                    columnBuilder.writeBoolean(BytesUtils.bytesToBool((byte[])bytes, (int)offset));
                    break;
                }
                default: {
                    throw new UnSupportedDataTypeException(String.format("Unsupported data type : %s", this.xDataType));
                }
            }
        }
    }

    protected abstract boolean check(int var1, int var2);

    protected abstract boolean check(long var1, long var3);

    protected abstract boolean check(float var1, float var2);

    protected abstract boolean check(double var1, double var3);

    protected abstract boolean check(Binary var1, Binary var2);

    protected abstract boolean check(boolean var1, boolean var2);
}

