/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.operator.source.relational;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.iotdb.db.queryengine.execution.operator.AbstractOperator;
import org.apache.iotdb.db.queryengine.execution.operator.Operator;
import org.apache.iotdb.db.queryengine.execution.operator.OperatorContext;
import org.apache.iotdb.db.queryengine.execution.operator.process.join.merge.comparator.JoinKeyComparator;
import org.apache.iotdb.db.queryengine.execution.operator.source.relational.TableScanOperator;
import org.apache.iotdb.db.queryengine.plan.planner.memory.MemoryReservationManager;
import org.apache.tsfile.block.column.Column;
import org.apache.tsfile.block.column.ColumnBuilder;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.read.common.block.TsBlock;
import org.apache.tsfile.read.common.block.TsBlockBuilder;
import org.apache.tsfile.read.common.block.column.RunLengthEncodedColumn;

public abstract class AbstractMergeSortJoinOperator
extends AbstractOperator {
    protected boolean leftFinished;
    protected final Operator leftChild;
    protected TsBlock leftBlock;
    protected int leftIndex;
    protected final int[] leftJoinKeyPositions;
    protected final int[] leftOutputSymbolIdx;
    protected boolean rightFinished;
    protected final Operator rightChild;
    protected List<TsBlock> rightBlockList = new ArrayList<TsBlock>();
    protected final int[] rightJoinKeyPositions;
    protected int rightBlockListIdx;
    protected int rightIndex;
    protected final int[] rightOutputSymbolIdx;
    protected TsBlock cachedNextRightBlock;
    protected boolean rightConsumedUp = false;
    protected final List<JoinKeyComparator> comparators;
    protected final TsBlockBuilder resultBuilder;
    protected final MemoryReservationManager memoryReservationManager;
    protected long maxUsedMemory;
    protected long usedMemory;

    protected AbstractMergeSortJoinOperator(OperatorContext operatorContext, Operator leftChild, int[] leftJoinKeyPositions, int[] leftOutputSymbolIdx, Operator rightChild, int[] rightJoinKeyPositions, int[] rightOutputSymbolIdx, List<JoinKeyComparator> comparators, List<TSDataType> dataTypes) {
        this.operatorContext = operatorContext;
        this.leftChild = leftChild;
        this.leftJoinKeyPositions = leftJoinKeyPositions;
        this.leftOutputSymbolIdx = leftOutputSymbolIdx;
        this.rightChild = rightChild;
        this.rightJoinKeyPositions = rightJoinKeyPositions;
        this.rightOutputSymbolIdx = rightOutputSymbolIdx;
        this.comparators = comparators;
        this.memoryReservationManager = operatorContext.getDriverContext().getFragmentInstanceContext().getMemoryReservationContext();
        this.resultBuilder = new TsBlockBuilder(dataTypes);
    }

    protected abstract boolean prepareInput() throws Exception;

    protected abstract boolean processFinished();

    protected abstract void recordsWhenDataMatches();

    @Override
    public ListenableFuture<?> isBlocked() {
        ListenableFuture rightBlocked;
        ListenableFuture<?> leftBlocked = this.leftBlockNotEmpty() ? NOT_BLOCKED : this.leftChild.isBlocked();
        ListenableFuture listenableFuture = rightBlocked = this.rightBlockNotEmpty() && this.gotNextRightBlock() ? NOT_BLOCKED : this.rightChild.isBlocked();
        if (leftBlocked.isDone()) {
            return rightBlocked;
        }
        if (rightBlocked.isDone()) {
            return leftBlocked;
        }
        return Futures.successfulAsList((ListenableFuture[])new ListenableFuture[]{leftBlocked, rightBlocked});
    }

    @Override
    public boolean isFinished() throws Exception {
        return !this.hasNext();
    }

    @Override
    public TsBlock next() throws Exception {
        long maxRuntime = this.operatorContext.getMaxRunTime().roundTo(TimeUnit.NANOSECONDS);
        long start = System.nanoTime();
        if (this.retainedTsBlock != null) {
            return this.getResultFromRetainedTsBlock();
        }
        if (!this.prepareInput()) {
            return null;
        }
        while (!this.resultBuilder.isFull() && !this.processFinished() && System.nanoTime() - start <= maxRuntime) {
        }
        if (this.resultBuilder.isEmpty()) {
            return null;
        }
        this.buildResultTsBlock();
        return this.checkTsBlockSizeAndGetResult();
    }

    protected boolean leftBlockNotEmpty() {
        return this.leftBlock != null && this.leftIndex < this.leftBlock.getPositionCount();
    }

    protected boolean rightBlockNotEmpty() {
        return !this.rightBlockList.isEmpty() && this.rightBlockListIdx < this.rightBlockList.size() && this.rightIndex < this.rightBlockList.get(this.rightBlockListIdx).getPositionCount() || this.cachedNextRightBlock != null;
    }

    protected boolean gotNextRightBlock() {
        return this.cachedNextRightBlock != null || this.rightConsumedUp;
    }

    protected void resetLeftBlock() {
        this.leftBlock = null;
        this.leftIndex = 0;
    }

    protected void resetRightBlockList() {
        for (TsBlock tsBlock : this.rightBlockList) {
            long size = tsBlock.getRetainedSizeInBytes();
            this.usedMemory -= size;
            this.memoryReservationManager.releaseMemoryCumulatively(size);
        }
        this.rightBlockList.clear();
        this.rightBlockListIdx = 0;
        this.rightIndex = 0;
    }

    protected boolean currentLeftHasNullValue() {
        for (int leftJoinKeyPosition : this.leftJoinKeyPositions) {
            if (!this.leftBlock.getColumn(leftJoinKeyPosition).isNull(this.leftIndex)) continue;
            return true;
        }
        return false;
    }

    protected boolean currentRightHasNullValue() {
        for (int rightJoinKeyPosition : this.rightJoinKeyPositions) {
            if (!this.rightBlockList.get(this.rightBlockListIdx).getColumn(rightJoinKeyPosition).isNull(this.rightIndex)) continue;
            return true;
        }
        return false;
    }

    protected boolean allRightLessThanLeft() {
        return this.lessThan(this.rightBlockList.get(this.rightBlockList.size() - 1), this.rightJoinKeyPositions, this.rightBlockList.get(this.rightBlockList.size() - 1).getPositionCount() - 1, this.leftBlock, this.leftJoinKeyPositions, this.leftIndex);
    }

    protected boolean allLeftLessThanRight() {
        return this.lessThan(this.leftBlock, this.leftJoinKeyPositions, this.leftBlock.getPositionCount() - 1, this.rightBlockList.get(this.rightBlockListIdx), this.rightJoinKeyPositions, this.rightIndex);
    }

    protected boolean currentRoundNeedStop() {
        if (this.lessThan(this.rightBlockList.get(0), this.rightJoinKeyPositions, this.rightBlockList.get(0).getPositionCount() - 1, this.rightBlockList.get(this.rightBlockListIdx), this.rightJoinKeyPositions, this.rightIndex) || this.lessThan(this.rightBlockList.get(0), this.rightJoinKeyPositions, this.rightBlockList.get(0).getPositionCount() - 1, this.leftBlock, this.leftJoinKeyPositions, this.leftIndex)) {
            for (int i = 0; i < this.rightBlockListIdx; ++i) {
                long size = this.rightBlockList.get(i).getRetainedSizeInBytes();
                this.usedMemory -= size;
                this.memoryReservationManager.releaseMemoryCumulatively(size);
            }
            this.rightBlockList = this.rightBlockList.subList(this.rightBlockListIdx, this.rightBlockList.size());
            this.rightBlockListIdx = 0;
            return true;
        }
        return false;
    }

    protected boolean leftFinishedWithIncIndex() {
        ++this.leftIndex;
        if (this.leftIndex >= this.leftBlock.getPositionCount()) {
            this.resetLeftBlock();
            return true;
        }
        return false;
    }

    protected boolean rightFinishedWithIncIndex() {
        ++this.rightIndex;
        if (this.rightIndex >= this.rightBlockList.get(this.rightBlockListIdx).getPositionCount()) {
            ++this.rightBlockListIdx;
            this.rightIndex = 0;
        }
        if (this.rightBlockListIdx >= this.rightBlockList.size()) {
            this.resetRightBlockList();
            return true;
        }
        return false;
    }

    protected void gotCandidateBlocks() throws Exception {
        if (!this.leftBlockNotEmpty()) {
            if (this.leftChild.hasNextWithTimer()) {
                this.leftBlock = this.leftChild.nextWithTimer();
                this.leftIndex = 0;
            } else {
                this.leftFinished = true;
            }
        }
        if (this.rightBlockList.isEmpty()) {
            if (this.cachedNextRightBlock != null) {
                this.addRightBlockWithMemoryReservation(this.cachedNextRightBlock);
                this.cachedNextRightBlock = null;
                this.tryCacheNextRightTsBlock();
            } else if (this.rightChild.hasNextWithTimer()) {
                TsBlock block = this.rightChild.nextWithTimer();
                if (block != null && !block.isEmpty()) {
                    this.addRightBlockWithMemoryReservation(block);
                }
            } else {
                this.rightFinished = true;
            }
        } else if (this.cachedNextRightBlock == null) {
            this.tryCacheNextRightTsBlock();
        }
    }

    protected void tryCacheNextRightTsBlock() throws Exception {
        if (!this.rightConsumedUp && this.rightChild.hasNextWithTimer()) {
            TsBlock block = this.rightChild.nextWithTimer();
            if (block != null && !block.isEmpty()) {
                if (this.equalsTo(block, this.rightJoinKeyPositions, 0, this.rightBlockList.get(0), this.rightJoinKeyPositions, this.rightBlockList.get(0).getPositionCount() - 1)) {
                    this.addRightBlockWithMemoryReservation(block);
                } else {
                    this.cachedNextRightBlock = block;
                }
            }
        } else {
            this.rightConsumedUp = true;
            this.cachedNextRightBlock = null;
        }
    }

    protected void addRightBlockWithMemoryReservation(TsBlock block) {
        this.reserveMemory(block.getRetainedSizeInBytes());
        this.rightBlockList.add(block);
    }

    protected void reserveMemory(long size) {
        this.usedMemory += size;
        this.memoryReservationManager.reserveMemoryCumulatively(size);
        if (this.usedMemory > this.maxUsedMemory) {
            this.maxUsedMemory = this.usedMemory;
            this.operatorContext.recordSpecifiedInfo("MaxReservedMemory", Long.toString(this.maxUsedMemory));
        }
    }

    protected void appendValueToResultWhenMatches(int tmpRightBlockListIdx, int tmpRightIndex) {
        this.appendLeftBlockData(this.leftOutputSymbolIdx, this.resultBuilder, this.leftBlock, this.leftIndex);
        this.appendRightBlockData(this.rightBlockList, tmpRightBlockListIdx, tmpRightIndex, this.leftOutputSymbolIdx, this.rightOutputSymbolIdx, this.resultBuilder);
        this.resultBuilder.declarePosition();
    }

    protected boolean hasMatchedRightValueToProbeLeft() {
        int tmpBlockIdx = this.rightBlockListIdx;
        int tmpIdx = this.rightIndex;
        boolean hasMatched = false;
        while (this.equalsTo(this.leftBlock, this.leftJoinKeyPositions, this.leftIndex, this.rightBlockList.get(tmpBlockIdx), this.rightJoinKeyPositions, tmpIdx)) {
            hasMatched = true;
            this.recordsWhenDataMatches();
            this.appendValueToResultWhenMatches(tmpBlockIdx, tmpIdx);
            if (++tmpIdx >= this.rightBlockList.get(tmpBlockIdx).getPositionCount()) {
                tmpIdx = 0;
                ++tmpBlockIdx;
            }
            if (tmpBlockIdx < this.rightBlockList.size()) continue;
            break;
        }
        return hasMatched;
    }

    protected boolean lessThan(TsBlock leftBlock, int[] leftPositions, int lIndex, TsBlock rightBlock, int[] rightPositions, int rIndex) {
        return this.examineLessThan(leftBlock, leftPositions, lIndex, rightBlock, rightPositions, rIndex);
    }

    protected boolean examineLessThan(TsBlock leftBlock, int[] leftPositions, int lIndex, TsBlock rightBlock, int[] rightPositions, int rIndex) {
        for (int i = 0; i < this.comparators.size(); ++i) {
            if (this.comparators.get(i).lessThan(leftBlock, leftPositions[i], lIndex, rightBlock, rightPositions[i], rIndex).orElse(false).booleanValue()) {
                return true;
            }
            if (this.comparators.get(i).equalsTo(leftBlock, leftPositions[i], lIndex, rightBlock, rightPositions[i], rIndex).orElse(false).booleanValue()) continue;
            return false;
        }
        return false;
    }

    protected boolean equalsTo(TsBlock leftBlock, int[] leftPositions, int lIndex, TsBlock rightBlock, int[] rightPositions, int rIndex) {
        for (int i = 0; i < this.comparators.size(); ++i) {
            if (this.comparators.get(i).equalsTo(leftBlock, leftPositions[i], lIndex, rightBlock, rightPositions[i], rIndex).orElse(false).booleanValue()) continue;
            return false;
        }
        return true;
    }

    protected void appendLeftBlockData(int[] leftOutputSymbolIdx, TsBlockBuilder resultBuilder, TsBlock leftBlock, int leftIndex) {
        for (int i = 0; i < leftOutputSymbolIdx.length; ++i) {
            int idx = leftOutputSymbolIdx[i];
            ColumnBuilder columnBuilder = resultBuilder.getColumnBuilder(i);
            if (leftBlock.getColumn(idx).isNull(leftIndex)) {
                columnBuilder.appendNull();
                continue;
            }
            columnBuilder.write(leftBlock.getColumn(idx), leftIndex);
        }
    }

    protected void appendRightBlockData(List<TsBlock> rightBlockList, int rightBlockListIdx, int rightIndex, int[] leftOutputSymbolIdxArray, int[] rightOutputSymbolIdxArray, TsBlockBuilder resultBuilder) {
        for (int i = 0; i < rightOutputSymbolIdxArray.length; ++i) {
            ColumnBuilder columnBuilder = resultBuilder.getColumnBuilder(leftOutputSymbolIdxArray.length + i);
            if (rightBlockList.get(rightBlockListIdx).getColumn(rightOutputSymbolIdxArray[i]).isNull(rightIndex)) {
                columnBuilder.appendNull();
                continue;
            }
            columnBuilder.write(rightBlockList.get(rightBlockListIdx).getColumn(rightOutputSymbolIdxArray[i]), rightIndex);
        }
    }

    protected void appendLeftWithEmptyRight() {
        while (this.leftIndex < this.leftBlock.getPositionCount()) {
            this.appendLeftBlockData(this.leftOutputSymbolIdx, this.resultBuilder, this.leftBlock, this.leftIndex);
            for (int i = 0; i < this.rightOutputSymbolIdx.length; ++i) {
                ColumnBuilder columnBuilder = this.resultBuilder.getColumnBuilder(this.leftOutputSymbolIdx.length + i);
                columnBuilder.appendNull();
            }
            this.resultBuilder.declarePosition();
            ++this.leftIndex;
        }
    }

    protected void appendOneRightRowWithEmptyLeft() {
        for (int i = 0; i < this.leftOutputSymbolIdx.length; ++i) {
            ColumnBuilder columnBuilder = this.resultBuilder.getColumnBuilder(i);
            columnBuilder.appendNull();
        }
        this.appendRightBlockData(this.rightBlockList, this.rightBlockListIdx, this.rightIndex, this.leftOutputSymbolIdx, this.rightOutputSymbolIdx, this.resultBuilder);
        this.resultBuilder.declarePosition();
    }

    protected void appendOneLeftRowWithEmptyRight() {
        this.appendLeftBlockData(this.leftOutputSymbolIdx, this.resultBuilder, this.leftBlock, this.leftIndex);
        for (int i = 0; i < this.rightOutputSymbolIdx.length; ++i) {
            ColumnBuilder columnBuilder = this.resultBuilder.getColumnBuilder(this.leftOutputSymbolIdx.length + i);
            columnBuilder.appendNull();
        }
        this.resultBuilder.declarePosition();
    }

    protected void buildResultTsBlock() {
        this.resultTsBlock = this.resultBuilder.build((Column)new RunLengthEncodedColumn((Column)TableScanOperator.TIME_COLUMN_TEMPLATE, this.resultBuilder.getPositionCount()));
        this.resultBuilder.reset();
    }

    @Override
    public void close() throws Exception {
        if (this.leftChild != null) {
            this.leftChild.close();
        }
        if (this.rightChild != null) {
            this.rightChild.close();
        }
        if (!this.rightBlockList.isEmpty()) {
            for (TsBlock block : this.rightBlockList) {
                this.memoryReservationManager.releaseMemoryCumulatively(block.getRetainedSizeInBytes());
            }
        }
    }

    @Override
    public long calculateMaxPeekMemory() {
        return Math.max(Math.max(this.leftChild.calculateMaxPeekMemoryWithCounter(), this.rightChild.calculateMaxPeekMemoryWithCounter()), this.calculateRetainedSizeAfterCallingNext() + this.calculateMaxReturnSize());
    }

    @Override
    public long calculateMaxReturnSize() {
        return this.maxReturnSize;
    }

    @Override
    public long calculateRetainedSizeAfterCallingNext() {
        return this.leftChild.calculateMaxReturnSize() + this.leftChild.calculateRetainedSizeAfterCallingNext() + this.rightChild.calculateMaxReturnSize() + this.rightChild.calculateRetainedSizeAfterCallingNext() + this.maxReturnSize;
    }
}

